/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.content.html;

import jp.co.nri.ridual.r2.analyzerobo.content.html.EventHtmlAttributeUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.HtmlAttributeUnit;
import jp.co.nri.ridual.r2.analyzerobo.content.html.UriHtmlAttributeUnit;
import jp.co.nri.ridual.r2.common.lowermap.LowerMap;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.resource.RidualResource;

class HtmlAttributeUnitMap
extends LowerMap {
    private static final String[] events = Patterns.SP_PATTERN.split(RidualResource.ANALYZEROBO_PROPERTIES.getString("HTML.EventAttributes"));
    private static final String[] uris = Patterns.SP_PATTERN.split(RidualResource.ANALYZEROBO_PROPERTIES.getString("HTML.UriAttributes.Get"));
    private static final String[] custom = Patterns.SP_PATTERN.split(RidualResource.ANALYZEROBO_PROPERTIES.getString("HTML.CustomAttributeUnits"));

    public HtmlAttributeUnitMap() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.entry(uris, new UriHtmlAttributeUnit());
        this.entry(events, new EventHtmlAttributeUnit());
        this.entryCustom(custom);
    }

    private void entry(String[] names, HtmlAttributeUnit unit) {
        int i = names.length - 1;
        while (i >= 0) {
            super.putLower(names[i], unit);
            --i;
        }
    }

    private void entryCustom(String[] vals) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        int i = vals.length - 1;
        while (i >= 0) {
            String[] val = Patterns.COLON_PATTERN.split(vals[i]);
            String classname = val[0];
            if (classname.length() > 0) {
                HtmlAttributeUnit instance = (HtmlAttributeUnit)Class.forName(classname).newInstance();
                super.putLower(val[1], instance);
            }
            --i;
        }
    }

    public HtmlAttributeUnit getHtmlAttributeUnit(String attr) {
        return (HtmlAttributeUnit)super.getLower(attr);
    }
}

