/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.analyzerobo.protocol.http;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import jp.co.nri.ridual.r2.analyzerobo.RidualAuthenticator;
import jp.co.nri.ridual.r2.common.instancemap.ForInstanceMap;
import jp.co.nri.ridual.r2.db.bean.project.ContentsBean;
import jp.co.nri.ridual.r2.db.bean.project.ContentsVariationBean;
import jp.co.nri.ridual.r2.resource.RidualResource;

abstract class AbstractHttpUnit
implements ForInstanceMap {
    protected static final String HTTP_HEADER_SET_COOKIE = "Set-Cookie";
    private static final String HTTP_HEADER_COOKIE = "Cookie";
    private static final long INTERVAL_LOCK_CONNECT = Long.parseLong(RidualResource.ANALYZEROBO_PROPERTIES.getString("robo.interval.lock.connect"));

    AbstractHttpUnit() {
    }

    public String[] getKeys() {
        return new String[]{"http"};
    }

    public HttpURLConnection connect(ContentsBean content, ContentsVariationBean variation) throws MalformedURLException, IOException, URISyntaxException, ConnectException, UnknownHostException, Throwable {
        String method = variation.getMethod();
        String cookie = variation.getCookie();
        if (method.equalsIgnoreCase("POST")) {
            HttpURLConnection connection = (HttpURLConnection)content.buildURLNoQuery(variation).openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("POST");
            if (cookie != null) {
                connection.setRequestProperty(HTTP_HEADER_COOKIE, cookie);
            }
            connection.connect();
            BufferedOutputStream os = new BufferedOutputStream(connection.getOutputStream());
            PrintStream ps = new PrintStream(os);
            ps.print(variation.getUrlQuery());
            ps.close();
            return connection;
        }
        HttpURLConnection connection = (HttpURLConnection)content.buildURL(variation).openConnection();
        connection.setRequestMethod(method);
        if (cookie != null) {
            connection.setRequestProperty(HTTP_HEADER_COOKIE, cookie);
        }
        connection.connect();
        return connection;
    }

    protected void lockConnect(URL url, PasswordAuthentication auth) {
        while (!RidualAuthenticator.instance.entryAnaSite(url, auth)) {
            try {
                Thread.sleep(INTERVAL_LOCK_CONNECT);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

