/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.common.encodingmap;

import java.nio.charset.Charset;
import jp.co.nri.ridual.r2.common.lowermap.LowerMap;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.resource.RidualResource;

public class EncodingMap
extends LowerMap {
    public static final EncodingMap instance = new EncodingMap();

    private EncodingMap() {
        String encmap = RidualResource.ANALYZEROBO_PROPERTIES.getString("robo.encoding.replace");
        if (encmap == null || encmap.length() <= 0) {
            return;
        }
        String[] texts = Patterns.SP_PATTERN.split(encmap);
        int i = texts.length - 1;
        while (i >= 0) {
            String[] strs = Patterns.COLON_PATTERN.split(texts[i]);
            super.putLower(strs[0], strs[1]);
            --i;
        }
    }

    public Charset buildCharset(String encoding) {
        Charset charset = this.charsetForName(encoding);
        if (charset != null) {
            return charset;
        }
        String enc = (String)super.getLower(encoding);
        return enc == null ? null : this.charsetForName(enc);
    }

    public boolean isSupported(String encoding) {
        if (Charset.isSupported(encoding)) {
            return true;
        }
        String enc = (String)super.getLower(encoding);
        return enc != null && Charset.isSupported(enc);
    }

    private Charset charsetForName(String encoding) {
        return Charset.isSupported(encoding) ? Charset.forName(encoding) : null;
    }
}

