/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.common.uri;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import jp.co.nri.ridual.r2.common.pattern.Patterns;
import jp.co.nri.ridual.r2.common.uri.URIOperator;

class DefaultURIOperator
implements URIOperator {
    DefaultURIOperator() {
    }

    private URI newURI(String uri) throws URISyntaxException {
        return new URI(uri);
    }

    private URI newPathURI(String path) throws URISyntaxException {
        return new URI(null, null, path, null);
    }

    private URI newURI(URL url) throws URISyntaxException {
        return new URI(url.toExternalForm());
    }

    public boolean isInner(URL parent, URL child) {
        return parent.getPort() == child.getPort() && this.equalsIgnoreCase(parent.getProtocol(), child.getProtocol()) && this.equals(parent.getHost(), child.getHost()) && this.startsWith(parent.getPath(), child.getPath());
    }

    public boolean equalsHostName(String hostname1, String hostname2) {
        return hostname1 == null || hostname2 == null ? false : hostname1.equalsIgnoreCase(hostname2);
    }

    public String extractExtensionFromPath(String path) {
        if ('/' == path.charAt(path.length() - 1)) {
            return "";
        }
        String[] spPath = Patterns.SLASH_PATTERN.split(path);
        int spPathLen = spPath.length;
        if (spPathLen <= 0) {
            return "";
        }
        String file = spPath[spPathLen - 1];
        if ('.' == file.charAt(file.length() - 1)) {
            return ".";
        }
        String[] spFile = Patterns.DOT_PATTERN.split(file);
        int spFileLen = spFile.length;
        return 1 < spFileLen ? String.valueOf('.') + spFile[spFileLen - 1] : "";
    }

    public String extractExtensionFromFilename(String filename) {
        if ('.' == filename.charAt(filename.length() - 1)) {
            return ".";
        }
        String[] spFile = Patterns.DOT_PATTERN.split(filename);
        int spFileLen = spFile.length;
        return 1 < spFileLen ? String.valueOf('.') + spFile[spFileLen - 1] : "";
    }

    public String toURIPath(String path) throws URISyntaxException {
        return this.newPathURI(path).getPath();
    }

    public URL normalize(String url) throws MalformedURLException, URISyntaxException {
        return this.normalize(this.newURI(url));
    }

    public URL normalize(URL url) throws MalformedURLException, URISyntaxException {
        return this.normalize(this.newURI(url));
    }

    public URL resolve(String url, String dir) throws MalformedURLException, URISyntaxException {
        return this.resolve(this.newURI(url), dir);
    }

    public URL resolve(URL url, String dir) throws MalformedURLException, URISyntaxException {
        return this.resolve(this.newURI(url), dir);
    }

    public URL buildURL4Auth(String protocol, String host, int port) throws MalformedURLException {
        return protocol == null || host == null ? null : new URL(protocol, host, port, "");
    }

    public String decodeHTTP(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    public String encodeHTTP(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception e) {
            return str;
        }
    }

    private URL normalize(URI uri) throws MalformedURLException {
        String str = uri.normalize().toString();
        return new URL(this.decodeHTTP(str));
    }

    private URL resolve(URI uri, String dir) throws MalformedURLException {
        return this.normalize(uri.resolve(dir));
    }

    private boolean equalsIgnoreCase(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : a.equalsIgnoreCase(b);
    }

    private boolean equals(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return b == null ? false : a.equals(b);
    }

    private boolean startsWith(String a, String b) {
        if (a == null) {
            return true;
        }
        return b == null ? false : b.startsWith(a);
    }
}

