/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean;

import java.text.DateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractNodable {
    protected void buildTextAttribute(Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        parent.setAttribute(name, value);
    }

    protected void buildIntAttribute(Element parent, String name, int value) {
        parent.setAttribute(name, Integer.toString(value));
    }

    protected void buildHexAttribute(Element parent, String name, int value) {
        parent.setAttribute(name, Integer.toHexString(value));
    }

    protected void buildDateAttribute(Element parent, String name, Date value) {
        if (value == null) {
            return;
        }
        parent.setAttribute(name, DateFormat.getDateTimeInstance().format(value));
    }

    protected void buildAttribute(Element parent, String name, Object value) {
        if (value == null) {
            return;
        }
        parent.setAttribute(name, value.toString());
    }

    protected void buildTextElement(Element parent, String name, String value) {
        if (value == null) {
            return;
        }
        Document doc = parent.getOwnerDocument();
        Element elm = doc.createElement(name);
        elm.appendChild(doc.createTextNode(value));
        parent.appendChild(elm);
    }

    protected void buildTextsElement(Element parent, String name, String[] value) {
        if (value == null) {
            return;
        }
        int len = value.length;
        int i = 0;
        while (i < len) {
            this.buildTextElement(parent, name, value[i]);
            ++i;
        }
    }

    protected void buildIntElement(Element parent, String name, int value) {
        this.buildTextElement(parent, name, Integer.toString(value));
    }

    protected void buildLongElement(Element parent, String name, long value) {
        this.buildTextElement(parent, name, Long.toString(value));
    }

    protected void buildDateElement(Element parent, String name, Date value) {
        if (value == null) {
            return;
        }
        this.buildTextElement(parent, name, DateFormat.getDateTimeInstance().format(value));
    }

    protected void buildBooleanElement(Element parent, String name, boolean value) {
        this.buildTextElement(parent, name, Boolean.toString(value));
    }

    protected void buildDoubleElement(Element parent, String name, double value) {
        this.buildTextElement(parent, name, Double.toString(value));
    }

    protected void buildElement(Element parent, String name, Object value) {
        if (value == null) {
            return;
        }
        this.buildTextElement(parent, name, value.toString());
    }
}

