/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.map;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.bean.project.ContentsRelationBean;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.map.CircleParentSelector;
import jp.co.nri.ridual.r2.map.MapContents;
import jp.co.nri.ridual.r2.map.ParentSelector;
import jp.co.nri.ridual.r2.map.SiteHierParentSelector;

class ContentsStructureBuilder {
    private final HashMap contentsHash = new HashMap();
    private final ParentSelector selector;

    public ContentsStructureBuilder(int mode) {
        switch (mode) {
            default: {
                this.selector = new SiteHierParentSelector();
                break;
            }
            case 2: {
                this.selector = new CircleParentSelector();
            }
        }
    }

    public void setContentsParent(MapContents contents, Map pageHash, Integer projectId) throws Throwable {
        this.setContentsParent(contents, pageHash, projectId, new HashSet());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setContentsParent(MapContents contents, Map pageHash, Integer projectId, HashSet antiLoopMap) throws Throwable {
        Integer variationId = contents.getPage().variation.getId();
        antiLoopMap.add(variationId);
        try {
            pageHash.remove(variationId);
            this.contentsHash.put(variationId, contents);
            ContentsRelationBean[] relations = ContentsRelationDAO.instance.findByParentVariationId(projectId, variationId);
            int len = relations.length;
            int i = 0;
            while (i < len) {
                Integer childVariationId = relations[i].getChildVariationId();
                MapContents childContents = (MapContents)this.contentsHash.get(childVariationId);
                if (childContents != null) {
                    if (!antiLoopMap.contains(childVariationId)) {
                        this.selector.selectParent(contents, childContents);
                    }
                } else {
                    ContentsAndVariationContainer childContentsBean = (ContentsAndVariationContainer)pageHash.get(childVariationId);
                    if (childContentsBean != null) {
                        childContents = new MapContents(childContentsBean, contents);
                        this.setContentsParent(childContents, pageHash, projectId, antiLoopMap);
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            antiLoopMap.remove(variationId);
            throw throwable;
        }
        {
            Object var12_14 = null;
            antiLoopMap.remove(variationId);
        }
    }

    public void setContentsChildren() {
        MapContents[] contents = this.contentsHash.values().toArray(new MapContents[0]);
        int len = contents.length;
        int i = 0;
        while (i < len) {
            MapContents content = contents[i];
            MapContents parent = content.getParent();
            if (parent != null) {
                parent.addChild(content);
            }
            ++i;
        }
    }
}

