/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.map;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import jp.co.nri.ridual.r2.common.messageformat.MessageFormatter;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.bean.project.AbstractProjectNodable;
import jp.co.nri.ridual.r2.db.bean.project.ContentsAndVariationContainer;
import jp.co.nri.ridual.r2.db.xsltview.TransformerMap;
import jp.co.nri.ridual.r2.map.ContentsStructureBuilder;
import jp.co.nri.ridual.r2.map.MapContents;
import jp.co.nri.ridual.r2.resource.RidualResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MapCraft
extends AbstractProjectNodable {
    public static final int MODE_SITE = 0;
    public static final int MODE_HIER = 1;
    public static final int MODE_CIRCLE = 2;
    private static final String[] MODES = new String[]{"site", "hier", "circle"};
    private static final String ELEMENT_NAME_ROOT = "map";
    private static final String ATTRIBUTE_NAME_TARGET = "target";
    private static final String ATTRIBUTE_NAME_DATE = "date";
    private static final String ATTRIBUTE_NAME_TYPE = "type";
    private static final String ATTRIBUTE_NAME_GENERATOR = "generator";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_NAME_DIVISION = "division";
    private static final String ATTRIBUTE_NAME_HISTORY = "history";
    private static final String ATTRIBUTE_GENERATOR = "Ridual";
    private final Vector contentsList = new Vector();
    private final ContentsStructureBuilder contentsStructureBuilder;
    private final int mode;

    public MapCraft(int mode) {
        this.mode = mode;
        this.contentsStructureBuilder = new ContentsStructureBuilder(this.mode);
    }

    public Document build(Integer projectId, AnalyzeSiteConfigBean site, AnalyzeHistoryBean history, ContentsAndVariationContainer topCavc, ContentsAndVariationContainer[] pages) throws Throwable {
        HashMap<Integer, ContentsAndVariationContainer> pageListMap = new HashMap<Integer, ContentsAndVariationContainer>();
        int i = pages.length - 1;
        while (i >= 0) {
            ContentsAndVariationContainer page = pages[i];
            pageListMap.put(page.variation.getId(), page);
            --i;
        }
        this.build(projectId, topCavc, pageListMap);
        Iterator iter = pageListMap.values().iterator();
        while (iter.hasNext()) {
            ContentsAndVariationContainer cavc = (ContentsAndVariationContainer)iter.next();
            this.build(projectId, cavc, pageListMap);
            iter = pageListMap.values().iterator();
        }
        this.contentsStructureBuilder.setContentsChildren();
        Document doc = TransformerMap.instance.buildDOMDocument(11, projectId, new AbstractProjectNodable[]{this});
        Element root = doc.getDocumentElement();
        super.buildTextAttribute(root, ATTRIBUTE_NAME_TYPE, MODES[this.mode]);
        super.buildTextAttribute(root, ATTRIBUTE_NAME_GENERATOR, ATTRIBUTE_GENERATOR);
        super.buildTextAttribute(root, ATTRIBUTE_NAME_VERSION, MessageFormatter.instance.formatVersion());
        super.buildTextAttribute(root, ATTRIBUTE_NAME_DIVISION, RidualResource.RIDUAL_RESOURCE_VER);
        super.buildTextAttribute(root, ATTRIBUTE_NAME_TARGET, site.getStartURIs());
        super.buildAttribute(root, ATTRIBUTE_NAME_HISTORY, history.getId());
        super.buildDateAttribute(root, ATTRIBUTE_NAME_DATE, history.getTimestampBegin());
        return doc;
    }

    private void build(Integer projectId, ContentsAndVariationContainer cavc, Map pageListMap) throws Throwable {
        MapContents mapContents = new MapContents(cavc, null);
        this.contentsStructureBuilder.setContentsParent(mapContents, pageListMap, projectId);
        this.contentsList.add(mapContents);
    }

    public Node buildNode(Integer projectId, int md, Document doc) throws Throwable {
        return doc.createElement(ELEMENT_NAME_ROOT);
    }

    public AbstractNodable[] loadChild(Integer projectId, int md) throws Throwable {
        return this.contentsList.toArray(new MapContents[0]);
    }
}

