/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots;

import java.io.IOException;
import jp.co.nri.ridual.r2.db.bean.common.RobotsBean;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.db.dao.RobotsDAO;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;
import jp.co.nri.ridual.r2.resource.RidualResource;

public abstract class AbstractRidualRobo
extends Thread {
    private static final int PRIORITY = Integer.parseInt(RidualResource.ANALYZEROBO_PROPERTIES.getString("ridual.robots.thread.priority"));
    protected final Integer id;
    protected Boolean isCancel = Boolean.FALSE;

    public AbstractRidualRobo(String type) throws Throwable {
        RobotsBean bean = RobotsDAO.instance.save(type);
        this.id = bean.getId();
        super.setName(this.id + bean.getType());
        super.setPriority(PRIORITY);
    }

    public void run() {
        try {
            RobotsDAO.instance.updateTimestampBegin(this.id);
            this.play();
            RobotsDAO.instance.updateTimestampComplete(this.id);
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("Robo.*", e);
        }
    }

    public void cancel() {
        this.isCancel = Boolean.TRUE;
    }

    protected abstract void play();

    protected String getServerName() throws IOException {
        return RidualServerConfigProperties.getInstance().getString("ridual.server.name");
    }
}

