/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.buildreportrobo;

import java.io.File;
import java.util.ArrayList;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.AbstractBuildDocumentTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.AbstractMultiTransformAdapter;
import jp.co.nri.ridual.r2.robots.buildreportrobo.SimpleTransformFiles;
import jp.co.nri.ridual.r2.robots.buildreportrobo.SimpleXSLTTransformRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.TransformFiles;
import jp.co.nri.ridual.r2.robots.buildreportrobo.XMLTransformRobo;
import jp.co.nri.ridual.r2.robots.buildreportrobo.XSLTTransformRobo;
import org.w3c.dom.Document;

class TransformRobo
extends AbstractRidualRobo {
    public final Document document;
    private final Integer projectId;
    private final Integer historyId;
    private final TransformFiles[] files;
    private final SimpleTransformFiles[] simplefiles;
    private final String name;

    public TransformRobo(AbstractBuildDocumentTransformAdapter adapter) throws Throwable {
        super(adapter.getRoboType());
        this.projectId = adapter.projectId;
        this.historyId = adapter.historyId;
        this.document = adapter.buildDocumentNoCache();
        this.files = adapter.files;
        this.simplefiles = adapter.simplefiles;
        this.name = null;
    }

    public TransformRobo(AbstractMultiTransformAdapter madapter, Document document, String name) throws Throwable {
        super(madapter.getRoboType());
        this.projectId = madapter.projectId;
        this.historyId = madapter.historyId;
        this.document = document;
        this.files = madapter.files;
        this.simplefiles = null;
        this.name = name;
    }

    protected void play() {
        try {
            int i;
            System.gc();
            SimpleXSLTTransformRobo[] robots = this.transformSimple();
            if (this.files != null) {
                i = this.files.length - 1;
                while (i >= 0) {
                    TransformFiles fls = this.files[i];
                    if (this.name == null) {
                        this.transform(fls.mode, fls.xmlfile, fls.htmlfile, fls.csvfile);
                    } else {
                        this.transform(fls.mode, fls.buildXmlFile(this.name), fls.buildHtmlFile(this.name), fls.buildCsvFile(this.name));
                    }
                    --i;
                }
            }
            if (robots != null) {
                i = robots.length - 1;
                while (i >= 0) {
                    robots[i].join();
                    --i;
                }
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport.transform", "BuildReportRobo.transform", this.historyId, null, t);
        }
    }

    private void transform(int mode, File xml, File html, File csv) {
        try {
            if (this.isCancel.booleanValue()) {
                return;
            }
            AbstractRidualRobo[] robots = new AbstractRidualRobo[]{new XMLTransformRobo(this.document, xml), new XSLTTransformRobo(0, mode, this.document, html), new XSLTTransformRobo(2, mode, this.document, csv)};
            int len = robots.length;
            int i = 0;
            while (i < len) {
                if (this.isCancel.booleanValue()) {
                    return;
                }
                robots[i].start();
                ++i;
            }
            i = 0;
            while (i < len) {
                robots[i].join();
                ++i;
            }
        }
        catch (Throwable t) {
            ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport.transform", "BuildReportRobo.transform", this.historyId, new Object[]{html, csv, xml}, t);
        }
    }

    private SimpleXSLTTransformRobo[] transformSimple() {
        if (this.simplefiles == null) {
            return null;
        }
        ArrayList<SimpleXSLTTransformRobo> list = new ArrayList<SimpleXSLTTransformRobo>();
        int i = this.simplefiles.length - 1;
        while (i >= 0) {
            SimpleTransformFiles fls = this.simplefiles[i];
            try {
                SimpleXSLTTransformRobo robo = new SimpleXSLTTransformRobo(fls.mode, this.document, fls.file);
                robo.start();
                list.add(robo);
            }
            catch (Throwable t) {
                ProjectLogDAO.instance.recordIssueHistory(this.projectId, "buildReport.transform", "BuildReportRobo.transform", this.historyId, new Object[]{fls.file}, t);
            }
            --i;
        }
        return list.toArray(new SimpleXSLTTransformRobo[0]);
    }
}

