/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.robots.recoverrobo.analyzequeue;

import jp.co.nri.ridual.r2.analyzequeue.AnalyzeQueue;
import jp.co.nri.ridual.r2.analyzequeue.AnalyzeTarget;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeSiteConfigBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeSiteConfigDAO;
import jp.co.nri.ridual.r2.db.dao.CSSNodesDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsRelationDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsSupplementDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsVariationDAO;
import jp.co.nri.ridual.r2.db.dao.HtmlNodesDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import jp.co.nri.ridual.r2.robots.AbstractRidualRobo;

public class AnalyzeQueueRecoverRobo
extends AbstractRidualRobo {
    private final AnalyzeQueue queue;

    public AnalyzeQueueRecoverRobo(AnalyzeQueue queue) throws Throwable {
        super("recoverAnalyzeQueue");
        this.queue = queue;
    }

    protected void play() {
        try {
            String servername = super.getServerName();
            Integer[] historyIdArray = this.queue.getHistoryIdArray();
            int i = historyIdArray.length - 1;
            while (i >= 0) {
                if (this.isCancel.booleanValue()) {
                    return;
                }
                this.recover(historyIdArray[i], servername);
                --i;
            }
        }
        catch (Throwable e) {
            RidualServerLogDAO.getInstance().record("Robo.AnalyzeQueueRecoverRobo", e);
        }
    }

    private void recover(Integer historyId, String servername) throws Throwable {
        AnalyzeSiteConfigBean siteBean = AnalyzeSiteConfigDAO.instance.findByHistoryId(historyId);
        Integer projectId = siteBean.getProjectId();
        AnalyzeTarget[] targets = this.queue.findAnalyzing(historyId, servername);
        int i = targets.length - 1;
        while (i >= 0) {
            if (this.isCancel.booleanValue()) {
                return;
            }
            AnalyzeTarget target = targets[i];
            Integer variationId = target.getVariationID();
            CSSNodesDAO.instance.deleteConditionByVariationId(projectId, variationId);
            CSSNodesDAO.instance.deleteSelectorByVariationId(projectId, variationId);
            CSSNodesDAO.instance.deleteSupplementsByVariationId(projectId, variationId);
            CSSNodesDAO.instance.deleteNodesByVariationId(projectId, variationId);
            HtmlNodesDAO.instance.deleteNodesByVariationId(projectId, variationId);
            ContentsSupplementDAO.instance.deleteByVariationId(projectId, variationId);
            ContentsRelationDAO.instance.deleteByVariationId(projectId, variationId);
            ContentsVariationDAO.instance.recover(projectId, variationId);
            target.setHistoryId(historyId);
            this.queue.markingReserve(target);
            --i;
        }
    }
}

