/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.servletutil.parameter;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jp.co.nri.ridual.r2.common.lowermap.LowerMap;
import jp.co.nri.ridual.r2.servletutil.parameter.DisparameterMap;
import jp.co.nri.ridual.r2.servletutil.parameter.IntegerServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.IntegersServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.ServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.SetServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.StringServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.StringsServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.ErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.MustErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.NoConfigErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameterconfig.FileFormatServletParameterConfig;
import jp.co.nri.ridual.r2.servletutil.parameterconfig.ServletParameterConfig;

public class ServletParameterMap
extends LowerMap {
    private static final ServletParameterConfig[] PUBLIC_CONFIGS = new ServletParameterConfig[]{new FileFormatServletParameterConfig()};
    public final ArrayList errors = new ArrayList();
    public final ArrayList errorsHandInput = new ArrayList();
    private final String method;

    public ServletParameterMap(ServletParameterConfig[] configs, HttpServletRequest request, String method) {
        this.method = method;
        LowerMap configmap = new LowerMap();
        this.entry(configs, configmap);
        this.entry(PUBLIC_CONFIGS, configmap);
        Map reqmap = request.getParameterMap();
        String[] names = reqmap.keySet().toArray(new String[0]);
        int i = names.length - 1;
        while (i >= 0) {
            String name = names[i];
            String[] vals = (String[])reqmap.get(name);
            this.decodeParameter(vals);
            ServletParameterConfig config = (ServletParameterConfig)configmap.removeLower(name);
            if (config == null) {
                if (!DisparameterMap.instance.containsLower(name)) {
                    this.errors.add(new NoConfigErrorServletParameter(name, vals));
                }
            } else {
                ServletParameter para = config.getServletParameter(vals);
                if (para == null) {
                    if (config.isMust) {
                        (config.isMechanical ? this.errors : this.errorsHandInput).add(new MustErrorServletParameter(config.name));
                    }
                } else if (para instanceof ErrorServletParameter) {
                    (config.isMechanical ? this.errors : this.errorsHandInput).add(para);
                } else {
                    super.putLower(name, para);
                }
            }
            --i;
        }
        if (!configmap.isEmpty()) {
            ServletParameterConfig[] odds = configmap.values().toArray(new ServletParameterConfig[0]);
            int i2 = odds.length - 1;
            while (i2 >= 0) {
                ServletParameterConfig odd = odds[i2];
                if (odd.isMust) {
                    (odd.isMechanical ? this.errors : this.errorsHandInput).add(new MustErrorServletParameter(odd.name));
                }
                --i2;
            }
        }
    }

    public ServletParameter getServletParameter(String name) {
        return (ServletParameter)super.getByLowerKey(name);
    }

    public Integer getIntegerValue(String name) {
        IntegerServletParameter para = (IntegerServletParameter)this.getServletParameter(name);
        return para == null ? null : para.value;
    }

    public String getStringValue(String name) {
        StringServletParameter para = (StringServletParameter)this.getServletParameter(name);
        return para == null ? null : para.value;
    }

    public String[] getStringsValue(String name) {
        StringsServletParameter para = (StringsServletParameter)this.getServletParameter(name);
        return para == null ? null : para.value;
    }

    public Integer[] getIntegersValue(String name) {
        IntegersServletParameter para = (IntegersServletParameter)this.getServletParameter(name);
        return para == null ? null : para.value;
    }

    public Set getSetValue(String name) {
        SetServletParameter para = (SetServletParameter)this.getServletParameter(name);
        return para == null ? null : para.value;
    }

    public ErrorServletParameter[] errorsToArray() {
        return this.errors.toArray(new ErrorServletParameter[0]);
    }

    public void errorsToRidualServerLog() {
        ErrorServletParameter[] eps = this.errorsToArray();
        int len = eps.length;
        int i = 0;
        while (i < len) {
            eps[i].saveRidualServerLog(this.method);
            ++i;
        }
    }

    private void entry(ServletParameterConfig[] configs, LowerMap map) {
        int i = configs.length - 1;
        while (i >= 0) {
            ServletParameterConfig config = configs[i];
            config.entryMap(map);
            --i;
        }
    }

    private void decodeParameter(String[] vals) {
        int i = vals.length - 1;
        while (i >= 0) {
            try {
                vals[i] = new String(vals[i].getBytes("8859_1"), "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            --i;
        }
    }
}

