/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.servletutil.parameterconfig;

import jp.co.nri.ridual.r2.common.lowermap.LowerMap;
import jp.co.nri.ridual.r2.servletutil.parameter.ServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.FewValuesErrorServletParameter;
import jp.co.nri.ridual.r2.servletutil.parameter.error.OverfullValuesErrorServletParameter;

public abstract class ServletParameterConfig {
    public static final String NAME_MESSAGE = "mes";
    public static final String NAME_FILE_FORMAT = "f";
    public static final String NAME_PROJECT_ID = "p";
    public static final String NAME_SITE_ID = "sid";
    public static final String NAME_HISTORY_ID = "h";
    public static final String NAME_LOCAL_HISTORY_ID = "lh";
    public static final String NAME_ROBO_COUNT = "c";
    public static final String NAME_PROFILE_ID = "pro";
    public static final String NAME_PROFILE_NAME = "proname";
    public static final String NAME_RATING_ID = "rid";
    public static final String NAME_RATING_CLASS = "rclass";
    public static final String NAME_RATING_EXECUTION = "rexec";
    public static final String NAME_RATING_WEIGHT = "rwt";
    public static final String NAME_SWITCH = "sw";
    public static final String NAME_DEPTH = "depth";
    public static final String NAME_FILES = "files";
    public static final String NAME_START = "start";
    public static final String NAME_INNER_SITE = "sitedir";
    public static final String NAME_MAIL = "mail";
    public static final String NAME_LOGIN_USER = "loginid";
    public static final String NAME_LOGIN_PASSWORD = "loginpw";
    public static final String NAME_THUMBNAIL_ID = "tid";
    public static final String NAME_LICENSE_NAME = "admin";
    public static final String NAME_LICENSE_MAIL = "adminmail";
    public static final String NAME_SMTP_HOST = "shost";
    public static final String NAME_SMTP_PORT = "sport";
    public static final String NAME_SMTP_USER = "suser";
    public static final String NAME_SMTP_PASSWORD = "spass";
    public static final String NAME_MAIL_FROM = "mfrom";
    public static final String NAME_PROXY_HOST = "phost";
    public static final String NAME_PROXY_PORT = "pport";
    public static final String NAME_PROXY_USER = "puser";
    public static final String NAME_PROXY_PASSWORD = "ppass";
    public static final String NAME_NON_PROXY_HOST = "nphost";
    public static final String NAME_CONNECTION_DBMS = "cdbms";
    public static final String NAME_CONNECTION_HOST = "chost";
    public static final String NAME_CONNECTION_PORT = "cport";
    public static final String NAME_CONNECTION_DBNAME = "cdbname";
    public static final String NAME_CONNECTION_USERNAME = "cuser";
    public static final String NAME_CONNECTION_PASSWORD = "cpass";
    public static final String NAME_STATIC_DIR = "staticdir";
    public static final String NAME_RIDUAL_SERVER_NAME = "rsname";
    public final String name;
    public final boolean isMust;
    private final int countMin;
    private final int countMax;
    public final boolean isMechanical;

    public ServletParameterConfig(String name, int countMin, int countMax, boolean isMust, boolean isMechanical) {
        this.name = name;
        this.isMust = isMust;
        this.countMin = 1 < countMin ? countMin : 1;
        this.countMax = countMax > 0 ? countMax : 0;
        this.isMechanical = isMechanical;
    }

    public ServletParameterConfig(String name, int countMin, int countMax, boolean isMust) {
        this(name, countMin, countMax, isMust, true);
    }

    public ServletParameterConfig(String name, boolean isMust, boolean isMechanical) {
        this(name, 1, 1, isMust, isMechanical);
    }

    public ServletParameterConfig(String name, boolean isMust) {
        this(name, 1, 1, isMust, true);
    }

    protected abstract ServletParameter buildServletParameter(String[] var1);

    public ServletParameter getServletParameter(String[] vals) {
        int count = vals.length;
        if (count < this.countMin) {
            return new FewValuesErrorServletParameter(this.name, vals);
        }
        if (this.countMax > 0 && this.countMax < count) {
            return new OverfullValuesErrorServletParameter(this.name, vals);
        }
        return this.buildServletParameter(vals);
    }

    public void entryMap(LowerMap map) {
        map.putLower(this.name, this);
    }
}

