/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.client.common;

import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import jp.co.nri.ridual.r2.db.dao.SessionFactoryController;
import jp.co.nri.ridual.r2.properties.RidualServerConfigProperties;

public class ConfigTableModel
implements TableModel {
    private final ConfigItem[] config = new ConfigItem[]{new ConfigItem("DBMS", "db.dbms", false), new ConfigItem("host", "db.host", false), new ConfigItem("port", "db.port", false), new ConfigItem("db name", "db.dbname", false), new ConfigItem("user", "hibernate.connection.username", false), new ConfigItem("password", "hibernate.connection.password", true)};
    private static final String[] COLNAMES = new String[]{"DB\u63a5\u7d9a\u8a2d\u5b9a", "value"};
    private final int rows = this.config.length;
    private final String[] values = new String[this.rows];
    static /* synthetic */ Class class$0;

    public ConfigTableModel() throws IOException {
        RidualServerConfigProperties rscp;
        RidualServerConfigProperties ridualServerConfigProperties = rscp = RidualServerConfigProperties.getInstance();
        synchronized (ridualServerConfigProperties) {
            int i = this.rows - 1;
            while (i >= 0) {
                ConfigItem citem = this.config[i];
                this.values[i] = citem.secure ? rscp.getStringS(citem.key) : rscp.getString(citem.key);
                --i;
            }
        }
    }

    public void save() throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        RidualServerConfigProperties rscp;
        RidualServerConfigProperties ridualServerConfigProperties = rscp = RidualServerConfigProperties.getInstance();
        synchronized (ridualServerConfigProperties) {
            int i = this.rows - 1;
            while (i >= 0) {
                ConfigItem citem = this.config[i];
                if (citem.secure) {
                    rscp.setPropertyS(citem.key, this.values[i]);
                } else {
                    rscp.setProperty(citem.key, this.values[i]);
                }
                --i;
            }
            SessionFactoryController.rebuildInstance();
            rscp.store();
        }
    }

    public int getColumnCount() {
        return 2;
    }

    public int getRowCount() {
        return this.rows;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 1;
    }

    public Class getColumnClass(int col) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public Object getValueAt(int row, int col) {
        if (this.rows <= row) {
            return null;
        }
        switch (col) {
            case 0: {
                return this.config[row].name;
            }
            case 1: {
                return this.values[row];
            }
        }
        return null;
    }

    public void setValueAt(Object obj, int row, int col) {
        if (1 == col) {
            this.values[row] = obj.toString();
        }
    }

    public String getColumnName(int col) {
        try {
            return COLNAMES[col];
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void addTableModelListener(TableModelListener arg0) {
    }

    public void removeTableModelListener(TableModelListener arg0) {
    }

    private class ConfigItem {
        public final String name;
        public final String key;
        public final boolean secure;

        public ConfigItem(String name, String key, boolean secure) {
            this.name = name;
            this.key = key;
            this.secure = secure;
        }
    }
}

