/*
 * Decompiled with CFR 0.152.
 */
package jp.co.nri.ridual.r2.db.bean.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import jp.co.nri.ridual.r2.common.cipher.RidualCipher;
import jp.co.nri.ridual.r2.db.bean.AbstractNodable;
import jp.co.nri.ridual.r2.db.bean.common.AbstractCommonNodable;
import jp.co.nri.ridual.r2.db.bean.common.AnalyzeHistoryBean;
import jp.co.nri.ridual.r2.db.dao.AnalyzeHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ContentsAndVariationDAO;
import jp.co.nri.ridual.r2.db.dao.LocalHistoryDAO;
import jp.co.nri.ridual.r2.db.dao.ProjectLogDAO;
import jp.co.nri.ridual.r2.db.dao.RatingProfileDAO;
import jp.co.nri.ridual.r2.db.dao.RidualServerLogDAO;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalyzeSiteConfigBean
extends AbstractCommonNodable {
    public static final int ANALYZE_OPTION_FLAG_HTML_LINK = 1;
    public static final int ANALYZE_OPTION_FLAG_CSS_LINK = 2;
    public static final int ANALYZE_OPTION_FLAG_FLASH_LINK = 4;
    public static final int ANALYZE_OPTION_FLAG_HTML_NODE = 8;
    public static final int ANALYZE_OPTION_FLAG_CSS_NODE = 16;
    public static final int ANALYZE_OPTION_FLAG_HTML_THUM = 32;
    public static final int ANALYZE_OPTION_FLAG_IMAGE_THUM = 64;
    public static final int ANALYZE_OPTION_FLAG_FLASH_THUM = 128;
    public static final int ANALYZE_OPTION_FLAG_IMAGE = 256;
    public static final int ANALYZE_OPTION_FLAG_NO_DETAIL = 512;
    public static final int ANALYZE_OPTION_FLAG_NO_DETAIL_TOO_MANY = 1024;
    public static final int ANALYZE_OPTION_FLAG_NOTIFY_MAIL = 2048;
    public static final int ANALYZE_OPTION_FLAG_ZIP4MAIL = 4096;
    public static final String HQL_QUERY_NAME_FIND_BY_PROJECT_ID = "siteConfig.findByProjectId";
    public static final String HQL_QUERY_NAME_FIND_BY_HISTORY_ID = "siteConfig.findByHistoryId";
    public static final String HQL_QUERY_NAME_FIND_ALL = "siteConfig.findAll";
    public static final String HQL_QUERY_NAME_LOAD_ACTIVE = "siteConfig.loadActive";
    private static final String ELEMENT_NAME_ROOT = "ANALYZE_SITE_CONFIG";
    private static final String ELEMENT_NAME_ID = "ID";
    private static final String ELEMENT_NAME_INNER_SITE_PATHS = "INNER_SITE_PATHS";
    private static final String ELEMENT_NAME_START_URIS = "START_URIS";
    private static final String ELEMENT_NAME_MAIL_ADDRESSES = "MAIL_ADDRESSES";
    private static final String ELEMENT_NAME_FILE_COUNT_LIMIT = "FILE_COUNT_LIMIT";
    private static final String ELEMENT_NAME_DEPTH_LIMIT = "DEPTH_LIMIT";
    private Integer id;
    private Integer projectId;
    private String innerSitePaths;
    private String startURIs;
    private String loginUser = null;
    private String loginPassword = null;
    private Integer ratingProfileId;
    private String addresses;
    private int depthLimit = 0;
    private int fileCountLimit = 0;
    private int analyzeOptionFlags = 0;
    private boolean deleted = false;
    private int nestTableLimit = 0;

    public Node buildNode(int mode, Document doc) {
        Element elm = doc.createElement(ELEMENT_NAME_ROOT);
        super.buildElement(elm, ELEMENT_NAME_ID, this.id);
        super.buildTextElement(elm, ELEMENT_NAME_INNER_SITE_PATHS, this.innerSitePaths);
        super.buildTextElement(elm, ELEMENT_NAME_START_URIS, this.startURIs);
        super.buildIntElement(elm, ELEMENT_NAME_DEPTH_LIMIT, this.depthLimit);
        super.buildIntElement(elm, ELEMENT_NAME_FILE_COUNT_LIMIT, this.fileCountLimit);
        super.buildTextElement(elm, ELEMENT_NAME_MAIL_ADDRESSES, this.addresses);
        return elm;
    }

    public AbstractNodable[] loadChild(int mode) throws Throwable {
        switch (mode) {
            case 1: {
                List list = AnalyzeHistoryDAO.instance.findBySiteId(this.id);
                list.addAll(LocalHistoryDAO.instance.findDetachedBySiteId(this.id));
                if (this.ratingProfileId != null) {
                    list.add(RatingProfileDAO.instance.load(this.ratingProfileId));
                }
                return list.toArray(new AbstractNodable[0]);
            }
            case 2: {
                AbstractNodable[] abstractNodableArray;
                if (this.ratingProfileId == null) {
                    abstractNodableArray = null;
                } else {
                    AbstractNodable[] abstractNodableArray2 = new AbstractNodable[1];
                    abstractNodableArray = abstractNodableArray2;
                    abstractNodableArray2[0] = RatingProfileDAO.instance.load(this.ratingProfileId);
                }
                return abstractNodableArray;
            }
            case 9: {
                return AnalyzeHistoryDAO.instance.findBySiteId(this.id).toArray(new AbstractNodable[0]);
            }
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.id.toString()) + ": " + this.startURIs;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }

    public String getInnerSitePaths() {
        return this.innerSitePaths;
    }

    public void setInnerSitePaths(String innerSitePaths) {
        this.innerSitePaths = innerSitePaths;
    }

    public String getStartURIs() {
        return this.startURIs;
    }

    public void setStartURIs(String startURIs) {
        this.startURIs = startURIs;
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String loginUser) {
        this.loginUser = loginUser;
    }

    public String getLoginPassword() {
        return this.loginPassword;
    }

    public void setLoginPassword(String loginPassword) {
        this.loginPassword = loginPassword;
    }

    public String getDecodedLoginPassword() {
        try {
            return RidualCipher.instance.de(this.loginPassword);
        }
        catch (Exception e) {
            RidualServerLogDAO.getInstance().record("DB.Site", "DB.Site.Error.getLoginPasswordSecure", null, e);
            ProjectLogDAO.instance.recordIssueProject(this.projectId, "DB.Site", "DB.Site.getLoginPasswordSecure", new Object[]{this.id}, e);
            return null;
        }
    }

    public void setEncoding2LoginPassword(String loginPassword) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        this.loginPassword = RidualCipher.instance.en(loginPassword);
    }

    public Integer getRatingProfile() {
        return this.ratingProfileId;
    }

    public void setRatingProfile(Integer ratingProfileId) {
        this.ratingProfileId = ratingProfileId;
    }

    public int getDepthLimit() {
        return this.depthLimit;
    }

    public void setDepthLimit(int depthLimit) {
        this.depthLimit = depthLimit;
    }

    public int getNestTableLimit() {
        return this.nestTableLimit;
    }

    public void setNestTableLimit(int nestTableLimit) {
        this.nestTableLimit = nestTableLimit;
    }

    public int getFileCountLimit() {
        return this.fileCountLimit;
    }

    public void setFileCountLimit(int fileCountLimit) {
        this.fileCountLimit = fileCountLimit;
    }

    public String getMailAddresses() {
        return this.addresses;
    }

    public void setMailAddresses(String addresses) {
        this.addresses = addresses;
    }

    public int getAnalyzeOptionFlags() {
        return this.analyzeOptionFlags;
    }

    public void setAnalyzeOptionFlags(int analyzeOptionFlags) {
        this.analyzeOptionFlags = analyzeOptionFlags;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isOutputDetail(Integer historyId) throws Throwable {
        int pages;
        AnalyzeHistoryBean bean = AnalyzeHistoryDAO.instance.load(historyId);
        if (bean.getLicense() != 2) {
            return false;
        }
        if ((this.analyzeOptionFlags & 0x400) != 0 && 50 <= (pages = ContentsAndVariationDAO.instance.countInnerPagesByHistoryId(this.projectId, historyId))) {
            return false;
        }
        return (this.analyzeOptionFlags & 0x200) == 0;
    }
}

