<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<xsl:template match="PARENT_CONTENTS_AND_VARIATION">
<xsl:param name="url"/>
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$url"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="URL"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="CONTENTS">
	<xsl:apply-templates select="PARENT_CONTENTS_AND_VARIATION">
		<xsl:with-param name="url" select="URL"/>
	</xsl:apply-templates>
</xsl:template>

<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportFormAction"/>
</xsl:template>

<xsl:template match="RidualReportFormAction">
	<xsl:text>"URL","parameter","from"
</xsl:text>
	<xsl:apply-templates select="CONTENTS"/>
</xsl:template>

</xsl:stylesheet>
