<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="text" encoding="Shift_JIS"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="formattime">
<xsl:param name="ms"/>
	<xsl:value-of select="floor($ms div 3600000)"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 60000) mod 60 )"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 1000) mod 60 )"/>
</xsl:template>

<xsl:template name="tranDQ">
<xsl:param name="str"/>
	<xsl:choose>
	
	<xsl:when test="contains($str,'&quot;')">
		<xsl:value-of select="substring-before($str,'&quot;')"/>
		<xsl:text>&quot;&quot;</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="substring-after($str,'&quot;')"/>
		</xsl:call-template>
	</xsl:when>
	
	<xsl:otherwise>
		<xsl:value-of select="$str"/>
	</xsl:otherwise>
	
	</xsl:choose>

</xsl:template>

<!-- RATING -->
<xsl:template match="RATING">
<xsl:param name="category"/>
<xsl:param name="group"/>
	
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$category"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$group"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="CAPTION"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="WEIGHT"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="PAGE"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="RATE"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>
</xsl:template>

<xsl:template match="GLOBAL_RATING">
<xsl:param name="category"/>
<xsl:param name="group"/>
	
	<xsl:variable name="val">
		<xsl:choose>
			<xsl:when test="'code'=TYPE">
				<xsl:choose>
					<xsl:when test="VALUE=''">
						<xsl:text>unknown</xsl:text>
					</xsl:when>
					<xsl:when test="VALUE!='NULL'">
						<xsl:value-of select="VALUE"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>none</xsl:text>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="'text'=TYPE">
				<xsl:value-of select="VALUE"/>
			</xsl:when>
			<xsl:when test="'int'=TYPE">
				<xsl:value-of select="VALUE"/>
			</xsl:when>
			<xsl:when test="'date'=TYPE">
				<xsl:value-of select="VALUE"/>
			</xsl:when>
			<xsl:when test="'ratio'=TYPE">
				<xsl:value-of select="COUNT"/>/<xsl:value-of select="ALL"/>
			</xsl:when>
			<xsl:when test="'time'=TYPE">
				<xsl:call-template name="formattime">
					<xsl:with-param name="ms" select="number(VALUE)"/>
				</xsl:call-template>
			</xsl:when>
		</xsl:choose>
	</xsl:variable>
	
	<xsl:text>"</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$category"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="CAPTION"/>
		</xsl:call-template>
	<xsl:text>","</xsl:text>
		<xsl:call-template name="tranDQ">
			<xsl:with-param name="str" select="$val"/>
		</xsl:call-template>
	<xsl:text>"
</xsl:text>

</xsl:template>

<!-- GROUP -->
<xsl:template match="GROUP">
<xsl:param name="category"/>
	<xsl:apply-templates select="RATING">
		<xsl:with-param name="category" select="$category"/>
		<xsl:with-param name="group" select="CAPTION"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="GLOBAL_GROUP">
<xsl:param name="category"/>
	<xsl:apply-templates select="GLOBAL_RATING">
		<xsl:with-param name="category" select="$category"/>
		<xsl:with-param name="group" select="CAPTION"/>
	</xsl:apply-templates>
</xsl:template>

<!-- CATEGORY -->
<xsl:template match="CATEGORY">
	<xsl:apply-templates select="GROUP">
		<xsl:with-param name="category" select="CAPTION"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="GLOBAL_CATEGORY">
	<xsl:apply-templates select="GLOBAL_GROUP">
		<xsl:with-param name="category" select="CAPTION"/>
	</xsl:apply-templates>
</xsl:template>

<!--
 本文はここから
-->
<xsl:template match="/">
	<xsl:apply-templates select="RidualReportReport"/>
</xsl:template>

<xsl:template match="RidualReportReport">
	<xsl:text>"大分類","中分類","値"
</xsl:text>
	<xsl:apply-templates select="GLOBAL_CATEGORY"/>
	<xsl:text>"大分類","中分類","小分類","重み","ページ数","対総項比率"
</xsl:text>
	<xsl:apply-templates select="CATEGORY"/>
</xsl:template>

</xsl:stylesheet>
