<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- 1件についての情報 -->
<xsl:template match="RATING_PROFILE">
	<option value="{ID}"><xsl:value-of select="NAME"/></option>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Check Item Profile Edit</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="proedit">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualRatingProfileConfig"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualRatingProfileConfig">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	
	</div>
	<!-- #header -->

	<hr/>

	<!-- #content -->
	<div id="content">

	<!-- #msgbox -->
	<div id="msgbox">

	<!-- #remake -->
	<div id="remake">

	<!-- .ms -->
	<div class="ms">
		<form action="editprof" method="post">
		
		<h1>確認(参照)</h1>
		<p>設定を確認するプロファイルを選択してください</p>
		<span class="control"> 
			<select name="pro">
				<xsl:if test="not(RATING_PROFILE)">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:if>
				
				<xsl:apply-templates select="RATING_PROFILE"/>
			</select>
		</span>
		
		<input type="image" src="img/btn_ref.gif" id="profref" alt="参照">
			<xsl:if test="not(RATING_PROFILE)">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
		</input>
		
		</form>
	</div>
	<!-- /.ms -->
	
	<!-- .ms -->
	<div class="ms">
		<form action="newprof" method="post">
		
		<h1>新規作成</h1>
		<p>新規にプロファイルを作成する場合は、こちらを：</p>
		
		<input type="image" src="img/btn_regist.gif" id="profnew" alt="新規作成"/>
		
		</form>
	</div>
	<!-- /.ms -->
	
	<!-- .ms -->
	<div class="ms">
		<form action="delprof" method="post">
		
		<h1>削除</h1>
		<p>既存のプロファイルを削除する場合は、こちらを：</p>
		<span class="control"> 
			<select name="pro">
				<xsl:if test="not(RATING_PROFILE)">
					<xsl:attribute name="disabled">disabled</xsl:attribute>
				</xsl:if>
			
				<xsl:apply-templates select="RATING_PROFILE"/>
			</select>
		</span>
		
		<input type="image" src="img/btn_del.gif" id="profdel" alt="削除">
			<xsl:if test="not(RATING_PROFILE)">
				<xsl:attribute name="disabled">disabled</xsl:attribute>
			</xsl:if>
		</input>
		
		</form>
	</div>
	<!-- /.ms -->
	
	<br class="clear"/>
	</div>
	<!-- /#remake -->
	
	</div>
	<!-- /#msgbox -->
	
	</div>
	<!-- /#content -->
</xsl:template>

</xsl:stylesheet>
