<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- CONTENTS_CSS_CONDITION群 -->
<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='#']">
	<span class="cssid">#<xsl:value-of select="VALUE"/></span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='.']">
	<span class="cssclass">.<xsl:value-of select="VALUE"/></span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE=':']">
	:<xsl:value-of select="VALUE"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='And']">
	<xsl:apply-templates select="COMBINATOR_FIRST/CONTENTS_CSS_CONDITION"/>
	<xsl:apply-templates select="COMBINATOR_SECOND/CONTENTS_CSS_CONDITION"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Lang']">
	:lang(<xsl:value-of select="LANG"/>)
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Attribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>
	<xsl:if test="VALUE!='NULL'">
		=<xsl:value-of select="VALUE"/>
	</xsl:if>
	]</span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='OneOfAttribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>~=<xsl:value-of select="VALUE"/>]</span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='BeginHyphenAttribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>|=<xsl:value-of select="VALUE"/>]</span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION">
	[未対応condition:<xsl:value-of select="NAME"/>]
</xsl:template>

<!-- CONTENTS_CSS_SELECTOR群 -->
<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='ElementNode']">
	<span class="csshtml"><xsl:value-of select="NAME"/></span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Conditional']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR"/>
	<xsl:apply-templates select="CONTENTS_CSS_CONDITION"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Descendant']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>
	<xsl:text> </xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='>']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>

	<xsl:choose>
		<xsl:when test="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple' and TYPE!='PseudoElement']">
			<xsl:text>&gt;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>:</xsl:text>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='+']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='selector']"/>
	<xsl:text>+</xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='sibling']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='PseudoElement']">
	<xsl:value-of select="NAME"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR">
	[未対応selector:<xsl:value-of select="NAME"/>]
</xsl:template>

<!-- CSS_NODE_SUPPLEMENT -->
<xsl:template match="CSS_NODE_SUPPLEMENT[NAME='importStyle.media']">
	<xsl:value-of select="VALUE"/>
</xsl:template>

<!-- CONTENTS_CSS_NODES群 -->
<xsl:template match="CONTENTS_CSS_NODES[TYPE='importStyle']">
	<li>
	@import "<xsl:value-of select="VALUE"/>"
	<xsl:apply-templates select="CSS_NODE_SUPPLEMENT[NAME='importStyle.media']"/>
	</li>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES[TYPE='media']">
	<li>
	@media "<xsl:value-of select="VALUE"/>"
	</li>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES[TYPE='property']">
	<xsl:choose>
		<xsl:when test="VALUE='position'">
			<span class="cssmark"><xsl:value-of select="VALUE"/></span>;
		</xsl:when>
		<xsl:when test="VALUE='float'">
			<span class="cssmark"><xsl:value-of select="VALUE"/></span>;
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="VALUE"/>;
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES">
	<li>
	<xsl:for-each select="CONTENTS_CSS_SELECTOR">
		
		<xsl:if test="1!=position()">,
		</xsl:if>
		
		<xsl:apply-templates select="."/>
	</xsl:for-each>
	{
	<xsl:apply-templates select="CONTENTS_CSS_NODES[TYPE='property']"/>
	}
	</li>
</xsl:template>

<!-- Style属性 -->
<xsl:template match="HTML_ATTRIBUTE_WITH_TAG">
	<li>
		&lt;<xsl:value-of select="TAG"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;&gt;
	</li>
</xsl:template>

<!-- <style> -->
<xsl:template match="HTML_ELEMENT">
	<li>
		&lt;<xsl:value-of select="NAME"/><xsl:apply-templates select="HTML_ATTRIBUTE"/>&gt;
	</li>
</xsl:template>

<xsl:template match="HTML_ATTRIBUTE">
	<xsl:text> </xsl:text>
	<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;
</xsl:template>

<!-- 1件分のデータ -->
<xsl:template match="CONTENTS_AND_VARIATION">
	<li>
		<xsl:choose>
			<xsl:when test="TYPE=273">
				<img alt="detail" src="../../img/detail.gif" height="22" width="22"/>
			</xsl:when>
			<xsl:otherwise>
				<img alt="CSS" src="../../img/css.gif"/>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text> </xsl:text>

		<a href="{URL}"><xsl:value-of select="URL"/></a>
		(<xsl:value-of select="LAST_MODIFIED"/>)
		<xsl:value-of select="SIZE"/>byte
		http-status:<xsl:value-of select="HTTP_STATUS"/>
		http-ContentType:<xsl:value-of select="HTTP_CONTENT_TYPE"/>
		<ul>
			<xsl:apply-templates select="CONTENTS_CSS_NODES"/>
		</ul>
	
		<!-- <style> -->
		<ul>
			<xsl:apply-templates select="HTML_ELEMENT"/>
		</ul>
		
		<!-- style属性 -->
		<ul>
			<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG"/>
		</ul>
	</li>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：CSS</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="css">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportCSS"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportCSS">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->
		
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>CSS</h1>
		<p class="xmlicon"><a href="xml/css.xml">XML</a></p>
		<p class="csvicon"><a href="csv/css.csv">CSV</a></p>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
	
<!--
	<h2> Style(css)ファイル一覧(check date : 2004/12/15 15:20)</h2>
-->

	<!-- #switch -->
	<div id="switch">
		<p class="description">CSS files list</p>
		<br/>
	</div>
	<!-- /#switch -->

	<!-- .box -->
	<div class="box">
		<ol>
			<xsl:apply-templates select="CONTENTS_AND_VARIATION"/>
		</ol>
	</div>
	<!-- /.box -->
	
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
