<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template match="PARENT_CONTENTS_AND_VARIATION">
<xsl:param name="isOutputDetail"/>
	<li>
		<p><span class="from">from :</span>
		<xsl:if test="'true'=$isOutputDetail">
			<a href="detail/{VARIATION_ID}.html">
			<img alt="detail" src="../../img/detail.gif" height="22" width="22"/>
			</a>
		</xsl:if>
		<xsl:text> </xsl:text>
		<a href="{URL}" title="link to real-page">
			<xsl:value-of select="URL"/>
		</a>
		</p>
	</li>
</xsl:template>

<xsl:template match="PARAMETER_PATTERN">
<xsl:param name="isOutputDetail"/>
	<li><xsl:value-of select="PATTERN"/>
	<div class="boxscrl">
		<ol>
		<xsl:apply-templates select="PARENT_CONTENTS_AND_VARIATION">
			<xsl:with-param name="isOutputDetail" select="$isOutputDetail"/>
		</xsl:apply-templates>
		</ol>
	</div>
	</li>
</xsl:template>


<xsl:template match="CONTENTS">
<xsl:param name="isOutputDetail"/>
	<li>
		<a href="{URL}"  target="_blank">
			<xsl:value-of select="URL"/>
		</a>
		<ol type="a">
			<xsl:apply-templates select="PARAMETER_PATTERN">
				<xsl:with-param name="isOutputDetail" select="$isOutputDetail"/>
			</xsl:apply-templates>
		</ol>
	</li>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Form</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
								type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="form">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportFormAction"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportFormAction">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Form</h1>
		<p class="xmlicon"><a href="xml/form.act.xml">XML</a></p>
		<p class="csvicon"><a href="csv/form.act.csv">CSV</a></p>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

		<!-- #switch -->
		<div id="switch">
			<p class="form"><a href="form.html">Form</a></p>  
<!--
			<p><xsl:value-of select="count(CONTENTS)"/></p>
-->
			<p class="description">Form action list</p>
<!--
			<p><xsl:value-of select="count(CONTENTS_AND_VARIATION)"/></p>
-->
			<br/>
		</div>
		<!-- /#switch -->
		
		<div class="box">
			<ol>
			<xsl:variable name="sw" select="ANALYZE_HISTORY/IS_OUTPUT_DETAIL"/>
			<xsl:apply-templates select="CONTENTS">
				<xsl:with-param name="isOutputDetail" select="$sw"/>
			</xsl:apply-templates>
			</ol>
		</div>
		
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
