<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<title>Ridual：Sitemap</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="sitemap">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportMap"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportMap">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<p class="plink"><a href="sitemap.html">Sitemap</a></p>
		<p>&gt;</p>
		<h1><a href="sitemap.html">Circlemap</a></h1>
		<p class="xmlicon"><a href="rmap_c.xml">XML</a></p>
		<p class="htmlicon"><a href="map/rmap_c.html">HTML</a></p>
<!--
		<p class="countn">count = 0 <span class="cdate">( checked on 2005/08/29 05:20:40 )</span></p>
-->
		<p class="countn">count = 
			<xsl:choose>
				<xsl:when test="count(ANALYZE_HISTORY/SUM_EXTENSION/COUNT_AND_SIZE[@key='.html'])!=0">
					<xsl:value-of select="number(ANALYZE_HISTORY/SUM_EXTENSION/COUNT_AND_SIZE[@key='.html']/@countAll)"/>
				</xsl:when>
				<xsl:otherwise>
					0
				</xsl:otherwise>
			</xsl:choose>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

		<!-- #switch -->
<!--		
		<div id="switch">
			<p class="description">Visual Sitemaps</p>
			<br/>
		</div>
-->

		<!-- /#switch -->
<!--		
		<div id="circlem">
			<ul>
				<li class="circlem"><a href="sitemap.html">Circlemap</a></li>
				<li class="sitem"><a href="sitemap.html">Sitemap</a></li>
				<li class="hierm"><a href="sitemap.html">Hiermap</a></li>
			</ul>
		</div>
-->

		<div class="sitemapswf">
		<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" 
				codebase="http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0"
				width="750" height="500"
				id="sitemap12"
				align="middle">
				<param name="allowScriptAccess" value="sameDomain" />
				<param name="movie" value="../../swf/circle.swf" />
				<param name="quality" value="high" />
				<param name="bgcolor" value="#ffffff" />
				<embed	src="../../swf/circle.swf"
						quality="high" bgcolor="#ffffff"
						width="750" height="500"
						name="sitemap12"
						align="middle"
						allowScriptAccess="sameDomain"
						type="application/x-shockwave-flash"
						pluginspage="http://www.macromedia.com/go/getflashplayer" />
		</object>
		</div>
		<div class="getfp">
		<a href="http://www.macromedia.com/jp/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash?Lang=Japanese"
		target="_blank" 
		title="Get FlashPlayer">Get FlashPlayer</a>
		</div>
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
