<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
★page以外のものを12種類に分類して表示する
	01) http-contentType : image/jpeg
	02) http-contentType : image/gif
	03) http-contentType : image/png
	04) http-contentType : image/(the others)
	05) http-contentType : application/x-javascript
	06) http-contentType : application/x-shockwave-flash
	07) http-contentType : application/pdf
	08) http-contentType : application/(the others)
	09) http-contentType : video/(all)
	10) http-contentType : text/css
	11) http-contentType : ( the others + unknown ) <-text/htmlも含む
★表の中では、images/jpeg,gif,png以外はthumbnailなし、width/heightなし
★thumbnailの大きさは、80x50(固定)
★dateを右寄せにしています：td class=lt->rt
★表によってcontenttypeが表示されたりされなかったりしています
★thumbnailがなければ、no-img.gifを表示したい
★thumnailを常に取得する
★thumbnailはthumb/r/*.jpgの形でhistory配下に保存したい
-->


<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- thumbnail -->
<xsl:template match="THUMBNAIL_ID">
	<img src="./thumb/{.}.jpg" alt="image"/>
</xsl:template>

<!-- 1件分のデータ -->
<xsl:template match="CONTENTS_AND_VARIATION" mode="simple">
	<xsl:variable name="pos" select="position()"/>
	
	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>

	<td class="ct"><xsl:value-of select="$pos"/></td>
	<td class="lt"><a href="{URL}"><xsl:value-of select="URL"/></a></td>
	<td class="rt"><xsl:value-of select="SIZE"/></td>
	<td class="rt"><xsl:value-of select="LAST_MODIFIED"/></td>
	<td>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	</td>
	</tr>
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION" mode="image">
	<xsl:variable name="pos" select="position()"/>
	
	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>

	<td class="ct"><xsl:value-of select="$pos"/></td>
	<td class="lt">
		<xsl:apply-templates select="THUMBNAIL_ID"/>
	</td>
	<td class="lt"><a href="{URL}"><xsl:value-of select="URL"/></a></td>
	<td><xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='IMAGE.width']/VALUE"/></td>
	<td><xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='IMAGE.height']/VALUE"/></td>
	<td class="rt"><xsl:value-of select="SIZE"/></td>
	<td class="rt"><xsl:value-of select="LAST_MODIFIED"/></td>
	<td>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	</td>
	</tr>
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION" mode="withContentType">
	<xsl:variable name="pos" select="position()"/>
	
	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>

	<td class="ct"><xsl:value-of select="$pos"/></td>
	<td class="lt"><xsl:value-of select="HTTP_CONTENT_TYPE"/></td>
	<td class="lt"><a href="{URL}"><xsl:value-of select="URL"/></a></td>
	<td class="rt"><xsl:value-of select="SIZE"/></td>
	<td class="rt"><xsl:value-of select="LAST_MODIFIED"/></td>
	<td>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	</td>
	</tr>
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION" mode="withThumbnail">
	<xsl:variable name="pos" select="position()"/>
	
	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>

	<td class="ct"><xsl:value-of select="$pos"/></td>
	<td class="lt">
		<xsl:apply-templates select="THUMBNAIL_ID"/>
	</td>
	<td class="lt"><a href="{URL}"><xsl:value-of select="URL"/></a></td>
	<td class="rt"><xsl:value-of select="SIZE"/></td>
	<td class="rt"><xsl:value-of select="LAST_MODIFIED"/></td>
	<td>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	</td>
	</tr>
</xsl:template>

<!-- <table>の<th>行 -->
<xsl:template name="THeadSimple">
	<tr class="th1">
		<th class="cellnum">#</th>
		<th class="cellname2">name</th>
		<th class="cellsize">size</th>
		<th class="celldate">date</th>
		<th class="cellstatus">status</th>
	</tr>
</xsl:template>

<xsl:template name="THeadWithContentType">
	<tr class="th1">
		<th class="cellnum">#</th>
		<th class="cellctpye">http-contentType</th>
		<th class="cellname3">name</th>
		<th class="cellsize">size</th>
		<th class="celldate">date</th>
		<th class="cellstatus">status</th>
	</tr>
</xsl:template>

<xsl:template name="THead4Image">
	<tr class="th1">
		<th class="cellnum">#</th>
		<th class="cellimg">img</th>
		<th class="cellname1">name</th>
		<th class="cellwidth">width</th>
		<th class="cellheight">height</th>
		<th class="cellsize">size</th>
		<th class="celldate">date</th>
		<th class="cellstatus">status</th>
	</tr>
</xsl:template>

<xsl:template name="THeadWithThumbnail">
	<tr class="th1">
		<th class="cellnum">#</th>
		<th class="cellimg">thumbnail</th>
		<th class="cellname2">name</th>
		<th class="cellsize">size</th>
		<th class="celldate">date</th>
		<th class="cellstatus">status</th>
	</tr>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Resources</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="resources">
	<a name="top"/>
	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportResources"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportResources">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="../../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->
		
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Resources</h1>
		<p class="xmlicon"><a href="xml/resources.xml">XML</a></p>
		<p class="csvicon"><a href="csv/resources.csv">CSV</a></p>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
	
	<!-- #switch -->
	<div id="switch">
		<p class="description">Resources List without thumbnails</p>
		<br/>
	</div>
	<!-- /#switch -->
	
	<!-- #ctype -->
	<div class="ctype">
		<ol>
			<li class="ctypename">
				<a name="type1"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">image/</span>
				<span class="ctypename3">jpeg</span>
				<span class="tonext">
					<a href="#type2">
						<img src="../../img/next.gif" width="16" height="16"
													 alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														 alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/jpeg']">
					<div class="box">
						<table class="noborder">
							<caption>image/jpeg</caption>
							<xsl:call-template name="THead4Image"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/jpeg']" mode="image"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type2"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">image/</span>
				<span class="ctypename3">gif</span>
				<span class="tonext">
					<a href="#type3">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/gif']">
					<div class="box">
						<table class="noborder">
							<caption>image/gif</caption>
							<xsl:call-template name="THead4Image"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/gif']" mode="image"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type3"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">image/</span>
				<span class="ctypename3">png</span>
				<span class="tonext">
					<a href="#type4">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/png']">
					<div class="box">
						<table class="noborder">
							<caption>image/png</caption>
							<xsl:call-template name="THead4Image"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='image/png']" mode="image"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type4"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">image/</span>
				<span class="ctypename3">(the others)</span>
				<span class="tonext">
					<a href="#type5">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'image/') and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='jpeg' and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='gif' and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='png']">
					<div class="box">
						<table class="noborder">
							<caption>image/(the others)</caption>
							<xsl:call-template name="THeadWithContentType"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'image/') and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='jpeg' and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='gif' and substring-after(RIDUAL_CONTENT_TYPE, 'image/')!='png']" mode="withContentType"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type5"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">application/</span>
				<span class="ctypename3">x-javascript</span>,
				<span class="ctypename2">application/</span>
				<span class="ctypename3">javascript</span>,
				<span class="ctypename2">text/</span>
				<span class="ctypename3">javascript</span>
				<span class="tonext">
					<a href="#type6">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/javascript' or RIDUAL_CONTENT_TYPE='application/x-javascript' or RIDUAL_CONTENT_TYPE='text/javascript']">
					<div class="box">
						<table class="noborder">
							<caption>application/x-javascript, application/javascript, text/javascript</caption>
							<xsl:call-template name="THeadSimple"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/javascript' or RIDUAL_CONTENT_TYPE='application/x-javascript' or RIDUAL_CONTENT_TYPE='text/javascript']" mode="simple"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type6"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">application/</span>
				<span class="ctypename3">x-shockwave-flash</span>
				<span class="tonext">
					<a href="#type7">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
													alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/x-shockwave-flash']">
					<div class="box">
						<table class="noborder">
							<caption>application/x-shockwave-flash</caption>
							<xsl:call-template name="THeadWithThumbnail"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/x-shockwave-flash']" mode="withThumbnail"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type7"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">application/</span>
				<span class="ctypename3">pdf</span>
				<span class="tonext">
					<a href="#type8">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop"><a href="#top"><img src="../../img/up.gif" width="16" height="16" alt="Top" title="Top"/></a></span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/pdf']">
					<div class="box">
						<table class="noborder">
							<caption>application/pdf</caption>
							<xsl:call-template name="THeadSimple"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/pdf']" mode="simple"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type8"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">application/</span>
				<span class="ctypename3">(the others)</span>
				<span class="tonext">
					<a href="#type9">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'application/') and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='x-javascript' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='javascript' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='x-shockwave-flash' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='pdf']">
					<div class="box">
						<table class="noborder">
							<caption>application/(the others)</caption>
							<xsl:call-template name="THeadWithContentType"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'application/') and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='x-javascript' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='javascript' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='x-shockwave-flash' and substring-after(RIDUAL_CONTENT_TYPE, 'application/')!='pdf']" mode="withContentType"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type9"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">video/</span>
				<span class="ctypename3">(all)</span>
				<span class="tonext">
					<a href="#type10">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
													alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'video/')]">
					<div class="box">
						<table class="noborder">
							<caption>video/(all)</caption>
							<xsl:call-template name="THeadWithContentType"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'video/')]" mode="withContentType"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type10"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename2">text/</span>
				<span class="ctypename3">css</span>
				<span class="tonext">
					<a href="#type11">
						<img src="../../img/next.gif" width="16" height="16"
													alt="Next" title="Next"/>
					</a>
				</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='text/css']">
					<div class="box">
						<table class="noborder">
							<caption>text/css</caption>
							<xsl:call-template name="THeadSimple"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='text/css']" mode="simple"/>
						</table>
					</div>
				</xsl:if>
			</li>
			<li class="ctypename">
				<a name="type11"/>
				<span class="ctypename1">http-contentType : </span>
				<span class="ctypename3">( the others + unknown )</span>
				<span class="totop">
					<a href="#top">
						<img src="../../img/up.gif" width="16" height="16"
														alt="Top" title="Top"/>
					</a>
				</span>
				<xsl:if test="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'image/')=false and starts-with(RIDUAL_CONTENT_TYPE, 'application/')=false and starts-with(RIDUAL_CONTENT_TYPE, 'video/')=false and RIDUAL_CONTENT_TYPE!='text/javascript' and RIDUAL_CONTENT_TYPE!='text/css']">
					<div class="box">
						<table class="noborder">
							<caption>( the others + unknown )</caption>
							<xsl:call-template name="THeadWithContentType"/>
							<xsl:apply-templates select="CONTENTS_AND_VARIATION[starts-with(RIDUAL_CONTENT_TYPE, 'image/')=false and starts-with(RIDUAL_CONTENT_TYPE, 'application/')=false and starts-with(RIDUAL_CONTENT_TYPE, 'video/')=false and RIDUAL_CONTENT_TYPE!='text/javascript' and RIDUAL_CONTENT_TYPE!='text/css']" mode="withContentType"/>
						</table>
					</div>
				</xsl:if>
			</li>
		</ol>
	</div>
	<!-- /#ctype -->
	
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a href="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a href="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
