<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>


<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="formattime">
<xsl:param name="ms"/>
	<xsl:value-of select="floor($ms div 3600000)"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 60000) mod 60 )"/>
	<xsl:text>:</xsl:text>
	<xsl:value-of select="floor( ($ms div 1000) mod 60 )"/>
</xsl:template>

<xsl:template name="timestamp">
<!--
	<xsl:param name="mes"/>
	<xsl:param name="license"/>
-->
	<xsl:value-of select="TIMESTAMP_BEGIN"/>
	<xsl:choose>
		<xsl:when test="TIMESTAMP_COMPLETE">
			(解析所要時間=<xsl:call-template name="formattime">
				<xsl:with-param name="ms" select="number(TIME_DISTANCE)"/>
			</xsl:call-template>,
			解析link数=<xsl:value-of select="COUNT_RELATIONS"/>,
			ページ数=<xsl:value-of select="COUNT_PAGES"/>p)
<!--
			<xsl:if test="$mes=' HTML generating... '">
				<span class="ing">
					<a href="history/{ID}/index.html"><xsl:value-of select="$mes"/></a>
				</span>
			</xsl:if>

			<xsl:if test="$license=0">
				<a href="help/help.html#license" class="license"> [ demo ] </a>
			</xsl:if>
-->

		</xsl:when>
		<xsl:otherwise>
			(<xsl:value-of select="COUNT_COMPLETE"/>/<xsl:value-of select="COUNT_ALL"/>)
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="htmlgen">
	<xsl:param name="mes"/>
	<xsl:param name="license"/>

	<xsl:if test="TIMESTAMP_COMPLETE">
		<xsl:if test="$mes=' HTML generating... '">
			<span class="ing">
				<a href="history/{ID}/index.html"><xsl:value-of select="$mes"/></a>
			</span>
		</xsl:if>
		<xsl:if test="$license=0">
			<span class="demogen">
				<a href="help/help.html#license" class="license"> [ demo ] </a>
			</span>
		</xsl:if>
	</xsl:if>

</xsl:template>

<!-- LOCAL HISTORY 1件についての情報 -->
<xsl:template match="LOCAL_HISTORY">
	<li>
		<div class="lhistoryblock">
			<form action="dlgdel" method="post">
				<input name="lh" type="hidden" value="{ID}"/>
				<input type="image" src="img/idelete.gif" alt="消去"/>
			</form>
			<form action="lmapping" method="post">
				<input name="lh" type="hidden" value="{ID}"/>
				<input type="image" src="img/iedit.gif" alt="編集"/>
			</form>
			<span class="hisinfo">
			<a href="loverview?lh={ID}">
				<xsl:value-of select="TIMESTAMP"/>
			</a>
			</span>
			<br class="lhclear"/>
		</div>
	</li>
</xsl:template>

<!-- HISTORY 1件についての情報 -->
<xsl:template match="ANALYZE_HISTORY[READY='true' and RECHECKING='false' and THUMBNAIL_REFRESHING='false']">
	<li>
		<!--.historyblock-->
		<div class="historyblock">
			<!--.dlgrebuild-->
				<form method="post" action="dlgrebuild">
				<input name="h" type="hidden" value="{ID}"/>
				<input alt="再生成" src="img/iredeploy.gif" type="image"/>
				</form>
			<!--.dlgrebuild-->

			<!--.dlgdel-->
				<form method="post" action="dlgdel">
				<input name="h" type="hidden" value="{ID}"/>
				<input alt="消去" src="img/idelete.gif" type="image"/>
				</form>
			<!--/.dlgdel-->

			<!--.dtailblock-->
				<span class="hisinfo">
				<a href="history/{ID}/index.html">
					<xsl:call-template name="timestamp"/>
				</a>
				</span>
				<xsl:call-template name="htmlgen">
					<xsl:with-param name="license" select="LICENSE"/>
				</xsl:call-template>
				<span class="btnoutlink">
					<a href="recheck?h={ID}">
						<img title="Outlink Re-checking" alt="Outlink Re-checking" height="16" width="60" src="img/outlink.gif"/>
					</a>
				</span>
				<span class="btncapture">
					<a href="refreshthumb?h={ID}">
						<img title="Refresh Capture" alt="Refresh Capture" height="16" width="60" src="img/capture.gif"/>
					</a>
				</span>
			<!--/.dtailblock-->
		</div>
		<!--/.historyblock-->
		
		<!-- .lhistory -->
		<ul class="lhistory">
			<xsl:apply-templates select="LOCAL_HISTORY"/>
		</ul>
		<!-- /.history -->

	</li>			
</xsl:template>

<xsl:template match="ANALYZE_HISTORY[READY='false']">
	<li>
		<!--.historyblock-->
		<div class="historyblock">

			<!--.dlgrebuild-->
			<!--.dlgrebuild-->
			
			<!--.dlgdel-->
				<form method="post" action="dlgdel">
				<input name="h" type="hidden" value="{ID}"/>
				<input alt="消去" src="img/idelete.gif" type="image"/>
				</form>
			<!--/.dlgdel-->

			<!--.dtailblock-->
				<span class="hisinfo">
					<xsl:call-template name="timestamp"/>
				</span>
				<xsl:call-template name="htmlgen">
					<xsl:with-param name="mes" select="' HTML generating... '"/>
					<xsl:with-param name="license" select="LICENSE"/>
				</xsl:call-template>
			<!--/.dtailblock-->
		</div>
		<!--/.historyblock-->

		<!-- .lhistory -->
		<ul class="lhistory">
			<xsl:apply-templates select="LOCAL_HISTORY"/>
		</ul>
		<!-- /.lhistory -->

	</li>			
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<li>
		<div class="historyblock">

			<!--.dlgrebuild-->
			<!--/.dlgrebuild-->

			<!--.dlgdel-->
				<form method="post" action="dlgdel">
				<input name="h" type="hidden" value="{ID}"/>
				<input alt="消去" src="img/idelete.gif" type="image"/>
				</form>
			<!--/.dlgdel-->

			<!--.dtailblock-->
				<span class="hisinfo">
					<xsl:call-template name="timestamp"/>
				</span>
				<xsl:call-template name="htmlgen">
					<xsl:with-param name="license" select="LICENSE"/>
				</xsl:call-template>

				<xsl:choose>
					<xsl:when test="RECHECKING='true'">
						<span class="ing"><a href="history/{ID}/index.html">Outlink Re-Checking...</a></span>
					</xsl:when>
					<xsl:when test="THUMBNAIL_REFRESHING='true'">
						<span class="ing"><a href="history/{ID}/index.html">Refresh Capture...</a></span>
					</xsl:when>
				</xsl:choose>
			<!--/.dtailblock-->
		</div>

		<!-- .lhistory -->
		<ul class="lhistory">
			<xsl:apply-templates select="LOCAL_HISTORY"/>
		</ul>
		<!-- /.history -->

	</li>			
</xsl:template>
			
<!-- サイト1件についての情報 -->
<xsl:template match="ANALYZE_SITE_CONFIG">
<xsl:param name="pid"/>
	<!-- .box -->
	<li class="box">
		<!--.site-->
		<div class="site">

			<!--.reana-->
				<form method="post" action="reana">
				<input name="sid" type="hidden" value="{ID}"/>
				<input type="image" src="img/reana.gif" alt="re-analyze"/>
				</form>
			<!--/.reana-->

			<!--.sitedelete-->
				<form method="post" action="dlgdelsite">
				<input name="sid" type="hidden" value="{ID}"/>
				<input alt="消去" src="img/sitedelete.gif" type="image"/>
				</form>
			<!--/.sitedelete-->

			<div class="block">
				<h3>
					<a href="{START_URIS}"><xsl:value-of select="START_URIS"/></a>
				</h3>
				<p>
					Depth-limit : <xsl:value-of select="DEPTH_LIMIT"/>,
					File-count-limit : <xsl:value-of select="FILE_COUNT_LIMIT"/>,
					Profile : <xsl:value-of select="RATING_PROFILE/NAME"/>
					<span class="sitelog">
						<a href="sitelog?p={$pid}"><img title="log" alt="log" height="16" width="35" src="img/log.gif"/></a>
					</span>
				</p>
			</div>

		</div>
		<!--/.site-->

		<!-- .lhistory -->
		<ul class="lhistory">
			<xsl:apply-templates select="LOCAL_HISTORY"/>
		</ul>
		<!-- /.lhistory -->

		<!-- .history -->
		<ul class="history">
			<xsl:apply-templates select="ANALYZE_HISTORY"/>
		</ul>
		<!-- /.history -->
	</li>
	<!-- /.box -->
</xsl:template>

<!-- プロジェクト情報 -->
<xsl:template match="PROJECT_CONFIG">
	<!-- ul top -->
	<ul>
		<xsl:apply-templates select="ANALYZE_SITE_CONFIG">
			<xsl:with-param name="pid" select="ID"/>
		</xsl:apply-templates>
	</ul>
	<!-- /ul top -->
</xsl:template>

<xsl:template match="RIDUAL_SERVER_MESSAGE">
	<p><xsl:value-of select="."/></p>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	
	<head>
		<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
		<title>Ridual：Sitelist</title>
		<link href="mailto:ridual@nri.co.jp" rev="made"/>
		<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
		<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="sitelist">
		<!-- #layout -->
		<div id="layout">
			<xsl:apply-templates select="RidualSiteList"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->
	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualSiteList">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
															src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>

			<ul>
				<li class="analyzer"><a href="index.html">Analyzer</a></li>
				<li class="sitelist"><a href="sitelist">Sitelist</a></li>
				<li class="admin"><a href="admin/setup">Admin</a></li>
				<li class="help"><a href="help/help.html">Help</a></li>
			</ul>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<p><a href="sitelist" class="reload">Reload</a></p>
		</div>
		<!-- /#line -->

		<!-- #menu -->
		<div id="menu">
			<h1>SiteList</h1>
			<p class="xmlicon"><a href="sitelist?f=xml">XML</a></p>
			<br class="clear"/>
		</div>
		<!-- /#menu -->
		
		<div>
			<xsl:apply-templates select="RIDUAL_SERVER_MESSAGE"/>
		</div>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #content -->
	<div id="content">
		<h2>Network(http)</h2>
		<xsl:apply-templates select="PROJECT_CONFIG"/>
	</div>
	<!-- /#content -->

</xsl:template>

</xsl:stylesheet>
