<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="unit">
	<li>
	<a href="{@path}"><xsl:value-of select="@path"/></a>
	<xsl:value-of select="@title"/>
	(
	<xsl:call-template name="httpstatus">
		<xsl:with-param name="status" select="@status"/>
	</xsl:call-template>,
	<xsl:value-of select="@size"/>byte,
	<xsl:value-of select="@date"/>,
	<xsl:value-of select="@charset"/>
	)
	<ul>
	<xsl:apply-templates select="unit"/>
	</ul>
	</li>
</xsl:template>

<xsl:template name="typename">
<xsl:param name="type"/>
	<xsl:choose>
		<xsl:when test="$type='circle'">circlemap</xsl:when>
		<xsl:when test="$type='hier'">hiermap</xsl:when>
		<xsl:when test="$type='site'">sitemap</xsl:when>
	</xsl:choose>
</xsl:template>


<xsl:template match="/">
	<html lang="ja">
	
	<head>
	<title>Ridual：Sitemap</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../../../css/import_style.css" rel="stylesheet"
										type="text/css" media="screen,print"/>
	<link href="../../../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="sitemap">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="Structure"/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../../../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	
	</html>
</xsl:template>

<xsl:template match="Structure">

	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
											src="../../../img/R_logo.gif"/>
				</a>
				<span class="version">
					<xsl:value-of select="@version"/>
					<xsl:value-of select="@division"/>
				</span>
			</div>

			<ul>
				<li class="analyzer"><a href="../../../index.html">Analyzer</a></li>
				<li class="sitelist"><a href="../../../sitelist">Sitelist</a></li>
				<li class="admin"><a href="../../../admin/setup">Admin</a></li>
				<li class="help"><a href="../../../help/help.html">Help</a></li>
			</ul>

		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p>
			<a target="_blank" href="{@target}">
			<xsl:value-of select="@target"/>
			</a>
			</p>
		</div>
		<!-- /#line -->

		<!-- #menu -->
		<div id="menu">
			<ul>
				<li class="overview"><a href="../index.html">Overview</a></li>
				<li class="sitemap"><a href="../sitemap.html">Sitemap</a></li>
				<li class="pages"><a href="../pages.html">Pages</a></li>
				<li class="resources"><a href="../resources.html">Resources</a></li>
				<li class="outlink"><a href="../outlink.html">OutLink</a></li>
				<li class="form"><a href="../form.html">Form</a></li>
				<li class="script"><a href="../script.html">Script</a></li>
				<li class="css"><a href="../css.html">CSS</a></li>
				<li class="objects"><a href="../objects.html">Objects</a></li>
				<li class="lost"><a href="../lost.html">Lost</a></li>
				<li class="quality"><a href="../quality.html">Quality</a></li>
				<li class="report"><a href="../report.html">Report</a></li>
				<li class="datalist"><a href="../data.html">Data</a></li>
			</ul>
		</div>
		<!-- /#menu -->

	</div>
	<!-- #header -->

	<hr/>
	
	<!-- #path -->
	<div id="path">
		<p class="plink"><a href="../sitemap.html">Sitemap</a></p>
		<p>&gt;</p>
		<h1>
			Site Structure
			<xsl:call-template name="typename">
				<xsl:with-param name="type" select="@type"/>
			</xsl:call-template>
			/ HTML version
		</h1>
	</div>
	<!-- /#path -->

	<!--#content-->
	<div id="content">
	
	<ul>
	<xsl:apply-templates select="map/unit"/>
	</ul>
	
	</div>
	<!--/#content-->
</xsl:template>

</xsl:stylesheet>
