<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- CHILD_CONTENTS_AND_VARIATION -->
<xsl:template match="CHILD_CONTENTS_AND_VARIATION" mode="tolink">
<xsl:param name="hid"/>
	<li>
	<xsl:choose>
		<xsl:when test="IS_INNER='true'">
			<a href="{VARIATION_ID}.html">
				<img alt="detail" height="22" width="22" src="../img/detail.gif"/>
			</a>
		</xsl:when>
	</xsl:choose>
	
	[
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	]
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	</li>
</xsl:template>

<xsl:template match="CHILD_CONTENTS_AND_VARIATION" mode="normal">
<xsl:param name="hid"/>
	<li>
	[
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	]
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	</li>
</xsl:template>

<xsl:template match="CHILD_CONTENTS_AND_VARIATION" mode="css">
<xsl:param name="hid"/>
	<li>
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	
	<ul>
	<xsl:apply-templates select="CONTENTS_CSS_NODES"/>
	</ul>
	
	<ul>
	<xsl:apply-templates select="CHILD_WITH_CSS_NODE[RIDUAL_CONTENT_TYPE='text/css']" mode="css"/>
	</ul>
	
	</li>
</xsl:template>

<xsl:template match="CHILD_WITH_CSS_NODE" mode="css">
	<li>
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	
	<ul>
	<xsl:apply-templates select="CONTENTS_CSS_NODES"/>
	</ul>
	
	<ul>
	<xsl:apply-templates select="CHILD_WITH_CSS_NODE[RIDUAL_CONTENT_TYPE='text/css']" mode="css"/>
	</ul>
	
	</li>
</xsl:template>

<xsl:template match="CHILD_CONTENTS_AND_VARIATION" mode="cssres">
	<li>
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	
	<ul>
		<xsl:apply-templates select="CHILD_WITH_CSS_NODE"/>
	</ul>
	</li>
</xsl:template>

<xsl:template match="CHILD_WITH_CSS_NODE">
	<li>
	[ <xsl:value-of select="CSS_NODE"/> / "<xsl:value-of select="RIDUAL_CONTENT_TYPE"/>" /
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	]
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	
	<ul>
		<xsl:apply-templates select="CHILD_WITH_CSS_NODE"/>
	</ul>
	</li>
</xsl:template>

<!-- PARENT_CONTENTS_AND_VARIATION -->
<xsl:template match="PARENT_CONTENTS_AND_VARIATION">
<xsl:param name="hid"/>
	<li>
	<a href="{VARIATION_ID}.html">
		<img alt="detail" height="22" width="22" src="../img/detail.gif"/>
	</a>
	<xsl:text> </xsl:text>
	<a href="{URL}"><xsl:value-of select="URL"/></a>
	</li>
</xsl:template>

<!-- HTML_ELEMENT -->
<xsl:template match="HTML_ELEMENT[NAME='form']">
	<li>
	form
	<xsl:apply-templates select="HTML_ATTRIBUTE"/>
	<ul>
	<li>input
	<div  class="form">
	<ol>
	<xsl:apply-templates select="HTML_ELEMENT[NAME='input']"/>
	</ol>
	</div>
    </li>
	<xsl:apply-templates select="HTML_ELEMENT[NAME='select']"/>
	<xsl:apply-templates select="HTML_ELEMENT[NAME='textarea']"/>
	</ul>
	</li>
</xsl:template>

<xsl:template match="HTML_ATTRIBUTE">
	<xsl:value-of select="NAME"/>="<xsl:value-of select="VALUE"/>"
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='input']">
	<li>input <xsl:apply-templates select="HTML_ATTRIBUTE"/></li>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='select']">
	<li>select <xsl:apply-templates select="HTML_ATTRIBUTE"/>
		<div class="form">
		<ol>
		<xsl:apply-templates select="HTML_ELEMENT[NAME='option']"/>
		</ol>
		</div>
	</li>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='option']">
	<li>option <xsl:apply-templates select="HTML_ATTRIBUTE"/> <xsl:apply-templates select="HTML_TEXT"/></li>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='textarea']">
	<li>textarea <xsl:apply-templates select="HTML_ATTRIBUTE"/></li>
</xsl:template>

<!-- CSS -->
<!-- CONTENTS_CSS_CONDITION群 -->
<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='#']">
	<span class="cssid">#<xsl:value-of select="VALUE"/></span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='.']">
	<span class="cssclass">.<xsl:value-of select="VALUE"/></span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE=':']">:<xsl:value-of select="VALUE"/></xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='And']">
	<xsl:apply-templates select="COMBINATOR_FIRST/CONTENTS_CSS_CONDITION"/>
	<xsl:apply-templates select="COMBINATOR_SECOND/CONTENTS_CSS_CONDITION"/>
</xsl:template>

<!--izuishi 2005/11/22 append -->
<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Lang']">
	:lang(<xsl:value-of select="LANG"/>)
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='Attribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>
	<xsl:if test="VALUE!='NULL'">
		=<xsl:value-of select="VALUE"/>
	</xsl:if>
	]</span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='OneOfAttribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>~=<xsl:value-of select="VALUE"/>]</span>
</xsl:template>

<xsl:template match="CONTENTS_CSS_CONDITION[TYPE='BeginHyphenAttribute']">
	<span class="cssclass">[<xsl:value-of select="NAME"/>|=<xsl:value-of select="VALUE"/>]</span>
</xsl:template>
<!--/izuishi 2005/11/22 append -->

<xsl:template match="CONTENTS_CSS_CONDITION">
	[未対応condition:<xsl:value-of select="NAME"/>]
</xsl:template>

<!-- CONTENTS_CSS_SELECTOR群 -->
<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='ElementNode']"><span class="csshtml"><xsl:value-of select="NAME"/></span></xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Conditional']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR"/><xsl:apply-templates select="CONTENTS_CSS_CONDITION"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='Descendant']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>
	<xsl:text> </xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<!--izuishi 2005/11/22 append -->
<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='>']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='ancestor']"/>

	<xsl:choose>
		<xsl:when test="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple' and TYPE!='PseudoElement']">
			<xsl:text>&gt;</xsl:text>
		</xsl:when>
		<xsl:otherwise>
			<xsl:text>:</xsl:text>
		</xsl:otherwise>
	</xsl:choose>

	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='simple']"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='+']">
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='selector']"/>
	<xsl:text>+</xsl:text>
	<xsl:apply-templates select="CONTENTS_CSS_SELECTOR[RELATIONSHIP='sibling']"/>
</xsl:template>
<!--/izuishi 2005/11/22 append -->

<xsl:template match="CONTENTS_CSS_SELECTOR[TYPE='PseudoElement']">
	<xsl:value-of select="NAME"/>
</xsl:template>

<xsl:template match="CONTENTS_CSS_SELECTOR">
	[未対応selector:<xsl:value-of select="NAME"/>]
</xsl:template>

<!-- CSS_NODE_SUPPLEMENT -->
<xsl:template match="CSS_NODE_SUPPLEMENT[NAME='importStyle.media']">
	<xsl:value-of select="VALUE"/>
</xsl:template>

<!-- CONTENTS_CSS_NODES群 -->
<xsl:template match="CONTENTS_CSS_NODES[TYPE='importStyle']">
	<li>
	@import "<xsl:value-of select="VALUE"/>"
	<xsl:apply-templates select="CSS_NODE_SUPPLEMENT[NAME='importStyle.media']"/>
	</li>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES[TYPE='media']">
	<li>
	@media "<xsl:value-of select="VALUE"/>"
	</li>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES[TYPE='property']">
	<xsl:choose>
		<xsl:when test="VALUE='position'">
			<span class="cssmark"><xsl:value-of select="VALUE"/></span>;
		</xsl:when>
		<xsl:when test="VALUE='float'">
			<span class="cssmark"><xsl:value-of select="VALUE"/></span>;
		</xsl:when>
		<xsl:otherwise>
			<xsl:value-of select="VALUE"/>;
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="CONTENTS_CSS_NODES">
	<li>
	<xsl:for-each select="CONTENTS_CSS_SELECTOR">
		
		<xsl:if test="1!=position()">,
		</xsl:if>
		
		<!-- xsl:value-of select="TEXT"/ -->
		<xsl:apply-templates select="."/>
	</xsl:for-each>
	{
	<xsl:apply-templates select="CONTENTS_CSS_NODES[TYPE='property']"/>
	}
	</li>
</xsl:template>

<!-- message -->
<xsl:template match="PROJECT_LOG">
	<dt><xsl:value-of select="TIMESTAMP"/>,
		type:<xsl:value-of select="TYPE"/>,
		method:<xsl:value-of select="METHOD"/>,
		code:<xsl:value-of select="CODE"/>
	</dt>
	<dd>
		<xsl:value-of select="MESSAGE"/>
		<!-- dl>
			<xsl:apply-templates select="PROJECT_LOG_SUPPLEMENT"/>
		</dl -->
	</dd>
</xsl:template>
	
<!-- xsl:template match="PROJECT_LOG_SUPPLEMENT">
	<dt><xsl:value-of select="NAME"/></dt>
	<dd><pre><xsl:value-of select="VALUE"/></pre></dd>
</xsl:template -->

<!-- id,class -->
<xsl:template match="HTML_ATTRIBUTE_WITH_TAG[NAME='id']">
	<li>
		<span class="cssid">#<xsl:value-of select="VALUE"/></span>
		(&lt;<xsl:value-of select="TAG"/>&gt;)
	</li>
</xsl:template>

<xsl:template match="HTML_ATTRIBUTE_WITH_TAG[NAME='class']">
	<li>
		<span class="cssclass">.<xsl:value-of select="VALUE"/></span>
		(&lt;<xsl:value-of select="TAG"/>&gt;)
	</li>
</xsl:template>

<!-- <script> -->
<xsl:template match="HTML_ELEMENT[NAME='script']">
	<li>
		&lt;<xsl:value-of select="NAME"/><xsl:apply-templates select="HTML_ATTRIBUTE"/>&gt;
	</li>
</xsl:template>

<xsl:template match="HTML_ATTRIBUTE">
	<xsl:text> </xsl:text>
	<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;
</xsl:template>

<!-- event + "javascript:..."リンク , style属性 共通 -->
<xsl:template match="HTML_ATTRIBUTE_WITH_TAG">
	<li>
		&lt;<xsl:value-of select="TAG"/>
		<xsl:text> </xsl:text>
		<xsl:value-of select="NAME"/>=&quot;<xsl:value-of select="VALUE"/>&quot;&gt;
	</li>
</xsl:template>

<!-- resource -->
<xsl:template match="CHILD_WITH_TAG">
	<li>
		[
		&lt;<xsl:value-of select="TAG"/>
			<xsl:text> </xsl:text>
			<xsl:value-of select="ATTRIBUTE"/>&gt;
		<xsl:text> : </xsl:text>
		"<xsl:value-of select="RIDUAL_CONTENT_TYPE"/>"
		<xsl:text> : </xsl:text>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
		]
		<a href="{URL}"><xsl:value-of select="URL"/></a>
	</li>
</xsl:template>

<xsl:template match="CONTENTS_SUPPLEMENT">
	<li><xsl:value-of select="NAME"/> : <xsl:value-of select="VALUE"/></li>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Pages-detail</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="../css/import_style.css" rel="stylesheet"
										type="text/css" media="screen,print"/>
	<link href="../css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="pagesdetail">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportDetail"/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="../img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	
	</html>
</xsl:template>

<xsl:template match="RidualReportDetail">

	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
											src="../img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>
	
	<xsl:apply-templates select="CONTENTS_AND_VARIATION">
		<xsl:with-param name="hid" select="ANALYZE_HISTORY/ID"/>
		<xsl:with-param name="anadate" select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/>
	</xsl:apply-templates>
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="../index.html">Overview</a></li>
			<li class="sitemap"><a name="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="../pages.html">Pages</a></li>
			<li class="resources"><a href="../resources.html">Resources</a></li>
			<li class="outlink"><a href="../outlink.html">OutLink</a></li>
			<li class="form"><a href="../form.html">Form</a></li>
			<li class="script"><a href="../script.html">Script</a></li>
			<li class="css"><a href="../css.html">CSS</a></li>
			<li class="objects"><a href="../objects.html">Objects</a></li>
			<li class="lost"><a href="../lost.html">Lost</a></li>
			<li class="quality"><a href="../quality.html">Quality</a></li>
			<li class="report"><a href="../report.html">Report</a></li>
			<li class="datalist"><a name="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION">
<xsl:param name="hid"/>
<xsl:param name="anadate"/>
	
	<!-- #path -->
	<div id="path">
		<p class="plink"><a href="../pages.html">Pages</a></p>
		<p>&gt;</p>
		<h1><a href="{URL}" target="_blank"><xsl:value-of select="URL"/></a></h1>
		<br/> <!-- for mac IE-->
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

	<ol>

		<li>
		<h2>Overview</h2>

		<!--.boxscrl-->
		<div class="boxscrl">
		
		<!--.ov-->
		<div class="ov">
			<ul>
				<li>path : <a href="{URL}"><xsl:value-of select="URL"/></a></li>
				<li>create date : <xsl:value-of select="LAST_MODIFIED"/></li>
				<li>analyze date : <xsl:value-of select="$anadate"/></li>
				<li>File size : <xsl:value-of select="SIZE"/> Byte</li>
				<li>Title : <xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTML.title']/VALUE"/></li>
				<li>文字セット : <xsl:value-of select="RIDUAL_ENCODING"/>
					<ul>
					<li>HTTP response header Content-Encoding : <xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTTP.contentEncoding']/VALUE"/></li>
					<li>HTTP response header Content-Type : <xsl:value-of select="HTTP_CONTENT_TYPE"/></li>
					<xsl:choose>
					<xsl:when test="RIDUAL_CONTENT_TYPE='text/html'">
						<li>HTML &lt;meta&gt; encoding : <xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTML.encoding']/VALUE"/></li>
					</xsl:when>
					<xsl:when test="RIDUAL_CONTENT_TYPE='text/css'">
						<li>CSS @encoding : <xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='CSS.encoding']/VALUE"/></li>
					</xsl:when>
					</xsl:choose>
					</ul>
				</li>
				<li>HTTP response header
					<ul>
						<xsl:apply-templates select="CONTENTS_SUPPLEMENT[CATEGORY='http.headerFields']"/>
					</ul>
				</li>
			</ul>
		</div>
		<!--/.ov-->
		
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>解析メッセージ</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<dl>
			<xsl:apply-templates select="PROJECT_LOG"/>
			</dl>
		</div>
		<!--/.boxscrl-->
		</li>

		<li>
		<h2> Lost-link : このページから張っているリンクの内、切れているもの</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates
				select="CHILD_CONTENTS_AND_VARIATION[400&lt;=HTTP_STATUS or HTTP_STATUS&lt;-1]"
				 mode="normal"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2> From-link : このページにリンクしているページ一覧</h2>

		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates select="PARENT_CONTENTS_AND_VARIATION">
				<xsl:with-param name="hid" select="$hid"/>
			</xsl:apply-templates>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>To-link : このページからリンクをしているページ一覧(含別ドメイン)</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates
						select="CHILD_CONTENTS_AND_VARIATION[IS_INNER='true']"
						mode="tolink">
				<xsl:with-param name="hid" select="$hid"/>
			</xsl:apply-templates>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Out-link : 指定サイト外へのリンク一覧</h2>

		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates
						select="CHILD_CONTENTS_AND_VARIATION[IS_INNER='false']"
						mode="normal">
				<xsl:with-param name="hid" select="$hid"/>
			</xsl:apply-templates>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Form : このページ内のForm情報</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates select="HTML_ELEMENT[NAME='form']"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>
		
		<li>
		<h2>Script : このページから参照されているScriptファイル一覧</h2>
		
		<!--.boscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates
					select="CHILD_CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='application/x-javascript' or RIDUAL_CONTENT_TYPE='text/javascript']"
					mode="normal">
				<xsl:with-param name="hid" select="$hid"/>
			</xsl:apply-templates>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Script in HTML : このページ内に直接記述されているScript</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
	
			<!-- <script> -->
			<ul>
				<xsl:apply-templates select="HTML_ELEMENT[NAME='script']"/>
			</ul>
			
			<!-- event + "javascript:..."リンク -->
			<ul>
				<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG[NAME!='id' and NAME!='class' and NAME!='style']"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Resources : このページから参照されているリソース一覧</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates select="CHILD_WITH_TAG"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Resources in CSS : 外部CSSファイルから利用されているリソース一覧</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
				<xsl:apply-templates
					select="CHILD_CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='text/css']"
					mode="cssres"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Style on CSS : 参照している外部CSSファイル内の定義一覧</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates
					select="CHILD_CONTENTS_AND_VARIATION[RIDUAL_CONTENT_TYPE='text/css']"
					mode="css">
				<xsl:with-param name="hid" select="$hid"/>
			</xsl:apply-templates>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>Style in HTML : ページ内に直接記述されているStyle一覧</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
			<xsl:apply-templates select="CONTENTS_CSS_NODES"/>
			</ul>
			<ul>
				<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG[NAME='style']"/>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>

		<li>
		<h2>ID,Class in HTML : ページ内に定義されているID,Class一覧</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
			<ul>
				<li>ID
					<ul>
						<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG[NAME='id']"/>
					</ul>
				</li>
				<li>Class
					<ul>
						<xsl:apply-templates select="HTML_ATTRIBUTE_WITH_TAG[NAME='class']"/>
					</ul>
				
				</li>
			</ul>
		</div>
		<!--/.boxscrl-->
		
		</li>
		
		<li>
		<h2>Quality : HTMLの品質チェックメッセージ</h2>
		
		<!--.boxscrl-->
		<div class="boxscrl">
		[unexには未対応]
		<span class="unex">...unexpected...</span>
		<pre>
		<code>
		<xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTML.checkMessages']/VALUE"/>
		</code>
		</pre>
		</div>
		<!--/.boxscrl-->
		</li>
	
	</ol>

	</div>
	<!-- /#content -->
</xsl:template>

</xsl:stylesheet>
