<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->

<!-- <form>タグ内のinput,select(とoption),textarea,form -->
<xsl:template match="HTML_ELEMENT" mode="tr">
	<tr><xsl:apply-templates select="."/></tr>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='input']">
	<td>input( <xsl:value-of select="HTML_ATTRIBUTE[NAME='type']/VALUE"/> )</td>
	<td><xsl:value-of select="HTML_ATTRIBUTE[NAME='name']/VALUE"/></td>
	<td>
		<xsl:choose>
			<xsl:when test="HTML_ATTRIBUTE[NAME='type']/VALUE='radio' or HTML_ATTRIBUTE[NAME='type']/VALUE='checkbox'">
				"<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>"
				<xsl:if test="HTML_ATTRIBUTE[NAME='checked']/VALUE!='NULL'">
					<xsl:text> </xsl:text>
					<xsl:value-of select="HTML_ATTRIBUTE[NAME='checked']/VALUE"/>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>
			</xsl:otherwise>
		</xsl:choose>
<!--
		<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>
		<xsl:if test="HTML_ATTRIBUTE[NAME='checked']/VALUE!='NULL'">
			<xsl:text> </xsl:text>"<xsl:value-of select="HTML_ATTRIBUTE[NAME='checked']/VALUE"/>"
		</xsl:if>
-->
	</td>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='select']">
	<td>select</td>
	<td><xsl:value-of select="HTML_ATTRIBUTE[NAME='name']/VALUE"/></td>
	<td>option=
		<select class="bs">
			<xsl:apply-templates select="HTML_ELEMENT[NAME='option']"/>
		</select>
	</td>
<!--
	<td/>
	<td><xsl:apply-templates select="HTML_ELEMENT[NAME='option']"/></td>
-->
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='option']">
	<option class="fs2">
		<xsl:if test="HTML_ATTRIBUTE[NAME='selected']/VALUE!='NULL'">
			<xsl:attribute name="selected">selected</xsl:attribute>
		</xsl:if>
		"<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>"=
		"<xsl:apply-templates select="HTML_TEXT"/>"<xsl:text> </xsl:text>
		<xsl:value-of select="HTML_ATTRIBUTE[NAME='selected']/VALUE"/>
	</option>
<!--
	<p>
	"<xsl:value-of select="HTML_ATTRIBUTE[NAME='value']/VALUE"/>"=
	"<xsl:apply-templates select="HTML_TEXT"/>"
	</p>
-->
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='textarea']">
	<td>textarea</td>
	<td><xsl:value-of select="HTML_ATTRIBUTE[NAME='name']/VALUE"/></td>
	<td><xsl:value-of select="HTML_TEXT"/></td>
<!--
	<td/>
	<td/>
-->
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='form']">
	<td>form</td>
	<td><xsl:value-of select="HTML_ATTRIBUTE[NAME='name']/VALUE"/></td>
	<td/>
<!--
	<td/>
	<td/>
-->
</xsl:template>

<xsl:template name="formcolumn">
<xsl:param name="rowspan"/>
<xsl:param name="isForm"/>
<xsl:param name="name"/>
<xsl:param name="action"/>
<xsl:param name="method"/>
	<td rowspan="{$rowspan}"><xsl:value-of select="$isForm"/></td>
	<td rowspan="{$rowspan}"><xsl:value-of select="$name"/></td>
	<td rowspan="{$rowspan}"><xsl:value-of select="$action"/></td>
	<td rowspan="{$rowspan}"><xsl:value-of select="$method"/></td>
</xsl:template>

<xsl:template match="HTML_ELEMENT[NAME='form']" mode="root">
	<xsl:variable name="rows" select="count(./HTML_ELEMENT)"/>
	
	<xsl:choose>
	<xsl:when test="0 = $rows">	<!-- input等の無い空の<form> -->
		<!-- <form>情報カラム -->
		<tr>
		<xsl:call-template name="formcolumn">
			<xsl:with-param name="rowspan" select="1"/>
			<xsl:with-param name="isForm" select="*"/>
			<xsl:with-param name="name" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
			<xsl:with-param name="action" select="HTML_ATTRIBUTE[NAME='action']/VALUE"/>
			<xsl:with-param name="method" select="HTML_ATTRIBUTE[NAME='method']/VALUE"/>
		</xsl:call-template>
		<td/><td/><td/>
<!--
		<td/><td/>
-->
		</tr>
	</xsl:when>
	<xsl:otherwise>
		<tr>
		<xsl:call-template name="formcolumn">
			<xsl:with-param name="rowspan" select="$rows"/>
			<xsl:with-param name="isForm" select="*"/>
			<xsl:with-param name="name" select="HTML_ATTRIBUTE[NAME='name']/VALUE"/>
			<xsl:with-param name="action" select="HTML_ATTRIBUTE[NAME='action']/VALUE"/>
			<xsl:with-param name="method" select="HTML_ATTRIBUTE[NAME='method']/VALUE"/>
		</xsl:call-template>
		
		<xsl:apply-templates select="HTML_ELEMENT[1]"/>
		</tr>
		<xsl:apply-templates select="HTML_ELEMENT[1&lt;position()]" mode="tr"/>
	</xsl:otherwise>
	</xsl:choose>
	
</xsl:template>

<xsl:template match="CONTENTS_AND_VARIATION">
<xsl:param name="isOutputDetail"/>
	<li>
	<p>
		<a href="{URL}" title="link to real-page">
			<xsl:value-of select="URL"/>
		</a>
	</p>
	
	<table>
		<caption>ページ内のform情報一覧</caption>
		
		<tr>
        <th class="th1">form</th>
        <th class="th1">name</th>
        <th class="th1">action</th>
        <th class="th1">method</th>
        <th class="th1">[type(*)]</th>
        <th class="th1">[name]</th>
        <th class="th1">[value]</th>
<!--
        <th class="th1">checked</th>
        <th class="th1">value on HTML</th>
-->
		</tr>

		<xsl:apply-templates select="HTML_ELEMENT[NAME!='form']" mode="noform"/>
		<xsl:apply-templates select=".//HTML_ELEMENT[NAME='form']" mode="root"/>
    </table>
	</li>
</xsl:template>

<!-- <form>に入っていない<input>等 -->
<xsl:template match="HTML_ELEMENT" mode="noform">
	<tr>
	<td/><td/><td/><td/>
	<xsl:apply-templates select="."/>
	</tr>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Form</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
								type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="form">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportForm"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportForm">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->

		<!-- menu -->
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Form</h1>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">

		<!-- #switch -->
		<div id="switch">
			<p class="act"><a href="form.act.html">Action</a></p>  
			<p class="description">Form tag list</p>
<!--
			<p><xsl:value-of select="count(CONTENTS_AND_VARIATION[HTML_ELEMENT])"/></p>
-->
			<br/>
		</div>
		<!-- /#switch -->
		
		<div class="box">
			<ol>
			<xsl:variable name="sw" select="ANALYZE_HISTORY/IS_OUTPUT_DETAIL"/>
			<xsl:apply-templates select="CONTENTS_AND_VARIATION">
				<xsl:with-param name="isOutputDetail" select="$sw"/>
			</xsl:apply-templates>
			</ol>
		</div>
		
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a name="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a name="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
