<?xml version="1.0" encoding="UTF-8" standalone="yes"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" version="4.01" encoding="UTF-8"
						doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN"
						doctype-system="http://www.w3.org/TR/html4/loose.dtd"/>
<xsl:strip-space elements="*"/>

<!--
 出現頻度が高いのでパフォーマンス向上のため前へ
-->
<xsl:template name="httpstatus">
<xsl:param name="status"/>
	<xsl:choose>
		<xsl:when test="$status=-1">
			<span class="c0an">未解析</span>
		</xsl:when>
		<xsl:when test="$status=-2">
			unknown-host
		</xsl:when>
		<xsl:when test="$status=-3">
			connect-error
		</xsl:when>
		<xsl:when test="$status=-4">	<!-- mailto,tel 未実装 -->
			<span class="c0in">情報</span>
		</xsl:when>
		<xsl:when test="$status=-5">	<!-- mailto,tel以外 未実装 -->
			<span class="c0uk">不明</span>
		</xsl:when>
		<xsl:when test="(100 &lt;= $status) and ($status &lt; 200)">
			<span class="c100"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(200 &lt;= $status) and ($status &lt; 300)">
			<span class="c200"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(300 &lt;= $status) and ($status &lt; 400)">
			<span class="c300"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(400 &lt;= $status) and ($status &lt; 500)">
			<span class="c400"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="(500 &lt;= $status) and ($status &lt; 600)">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:when test="600 &lt;= $status">
			<span class="c500"><xsl:value-of select="$status"/></span>
		</xsl:when>
		<xsl:otherwise>
			<span class="c5ov"><xsl:value-of select="$status"/></span>
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<!-- 有無アイコン -->
<xsl:template name="icon">
<xsl:param name="exists"/>
<xsl:param name="file"/>
<xsl:param name="tag"/>
<xsl:param name="both"/>
<xsl:param name="alt"/>
	<xsl:choose>
	<xsl:when test="$exists='FILE'">
		<img height="16" width="16" alt="{$alt}" src="{$file}"/>
	</xsl:when>
	<xsl:when test="$exists='TAG'">
		<img height="16" width="16" alt="{$alt}" src="{$tag}"/>
	</xsl:when>
	<xsl:when test="$exists='BOTH'">
		<img height="16" width="16" alt="{$alt}" src="{$both}"/>
	</xsl:when>
	</xsl:choose>
</xsl:template>

<!-- 1件分のデータ -->
<xsl:template match="CONTENTS_AND_VARIATION">
<xsl:param name="isOutputDetail"/>
	<xsl:variable name="pos" select="position()"/>

	<tr>
	<xsl:attribute name="class">
		<xsl:choose>
			<xsl:when test="0 = ($pos mod 2)">tr2</xsl:when>
			<xsl:otherwise>tr1</xsl:otherwise>
		</xsl:choose>
	</xsl:attribute>
	
	<td><xsl:value-of select="$pos"/></td>
	<td class="lt">
		<a href="{URL}"><xsl:value-of select="URL"/></a>
		<div class="pgtitle">
		<xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTML.title']/VALUE"/>
		</div>
	</td>
	<td class="lt"><xsl:value-of select="SIZE"/></td>
	<td>
		<xsl:call-template name="icon">
			<xsl:with-param name="exists" select="EXISTS/STYLE"/>
			<xsl:with-param name="file" select="'img/css.gif'"/>
			<xsl:with-param name="tag" select="'img/tag.gif'"/>
			<xsl:with-param name="both" select="'img/tag_exfile.gif'"/>
			<xsl:with-param name="alt" select="'Style'"/>
		</xsl:call-template>
	</td>
	<td>
		<xsl:call-template name="icon">
			<xsl:with-param name="exists" select="EXISTS/SCRIPT"/>
			<xsl:with-param name="file" select="'img/js.gif'"/>
			<xsl:with-param name="tag" select="'img/tag.gif'"/>
			<xsl:with-param name="both" select="'img/tag_exfile.gif'"/>
			<xsl:with-param name="alt" select="'Script'"/>
		</xsl:call-template>
	</td>
	<td>
		<xsl:if test="EXISTS/FRAMESET">*</xsl:if>
	</td>
	<td>
		<xsl:choose>
			<xsl:when test="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE=''">
				<span class="unknown">unknown</span>
			</xsl:when>
			<xsl:when test="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE!='NULL'">
				<xsl:value-of select="CONTENTS_SUPPLEMENT[NAME='HTML.doctype']/VALUE"/>
			</xsl:when>
			<xsl:otherwise>
				<span class="none">none</span>
			</xsl:otherwise>
		</xsl:choose>
	</td>
	<td>
		<xsl:choose>
			<xsl:when test="RIDUAL_ENCODING=''">
				<span class="unknown">unknown</span>
			</xsl:when>
			<xsl:when test="RIDUAL_ENCODING!='NULL'">
				<xsl:value-of select="RIDUAL_ENCODING"/>
			</xsl:when>
			<xsl:otherwise>
				<span class="none">none</span>
			</xsl:otherwise>
		</xsl:choose>
	</td>
	<td class="lt"><xsl:value-of select="LAST_MODIFIED"/></td>
	<td>
		<xsl:call-template name="httpstatus">
			<xsl:with-param name="status" select="HTTP_STATUS"/>
		</xsl:call-template>
	</td>
	</tr>
</xsl:template>

<xsl:template match="RIDUAL_VERSION">
	<span class="version">
		Ver.<xsl:value-of select="MAJORVER"/>
		.<xsl:value-of select="MINORVER"/>
		.<xsl:value-of select="RELEACEVER"/><xsl:text> </xsl:text>
		<xsl:value-of select="SPECIALBUILD"/>
		BLD<xsl:value-of select="BUILDNO"/><xsl:text> </xsl:text>
		<xsl:value-of select="RESOURCEVER"/>
	</span>
</xsl:template>


<!--
 本文はここから
-->
<xsl:template match="/">
	<html lang="ja">
	<head>
	<!-- meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/ -->
	<title>Ridual：Pages</title>
	<link href="mailto:ridual@nri.co.jp" rev="made"/>
	<link title="Ridual" href="css/import_style.css" rel="stylesheet"
									type="text/css" media="screen,print"/>
	<link href="css/print.css" rel="stylesheet" type="text/css" media="print"/>
	</head>

	<body id="pages">

	<!-- #layout -->
	<div id="layout">
		<xsl:apply-templates select="RidualReportPages"/>

		<hr/>

		<!-- #footer -->
		<div id="footer">
			<p>
				<img alt="Powered by Nomura Research Institute,Ltd."
					title="Powered by Nomura Research Institute,Ltd."
						height="15" width="300" src="img/logo_nri.gif"/>
			</p>
		</div>
		<!--/ #footer -->

	</div>
	<!--/ #layout -->
	
	</body>
	</html>
</xsl:template>

<xsl:template match="RidualReportPages">
	<!-- #header -->
	<div id="header">

		<!-- #logo -->	
		<div id="logo">
			<div class="ridual">
				<a target="_blank" href="http://www.ridual.jp">
					<img alt="Ridual logo" height="30" width="70"
														src="img/R_logo.gif"/>
				</a>
				<xsl:apply-templates select="RIDUAL_VERSION"/>
			</div>
		</div>
		<!-- /#logo -->	

		<!-- #line -->
		<div id="line">
			<!-- URL -->
			<p><xsl:apply-templates select="ANALYZE_SITE_CONFIG"/></p>
		</div>
		<!-- /#line -->
		
		<xsl:apply-templates select="ANALYZE_HISTORY"/>
	</div>
	<!-- #header -->

	<hr/>

	<!-- #path -->
	<div id="path">
		<h1>Pages</h1>
		<p class="countn">count = <xsl:value-of select="count(CONTENTS_AND_VARIATION)"/>
			<span class="cdate">( checked on <xsl:value-of select="ANALYZE_HISTORY/TIMESTAMP_BEGIN"/> )</span>
		</p>
	</div>
	<!-- /#path -->

	<!-- #content -->
	<div id="content">
	
	<!-- #switch -->
	<div id="switch">
<!--
		<p class="thumbon"><a href="pages.icon.html">Thumbnail:ON</a></p>
-->
		<p class="description">Pages List without thumbnails</p>
<!--
		<p>ページ総数：<xsl:value-of select="count(CONTENTS_AND_VARIATION)"/></p>
-->
		<br/>
	</div>
	<!-- /#switch -->

	<!-- .box -->
	<div class="box">

	<table class="noborder">
		<tr>
		<th class="th1">#</th>
		<th class="th1">name/title</th>
		<th class="th1">size</th>
		<th class="th1">style</th>
		<th class="th1">script</th>
		<th class="th1">Frame</th>
		<th class="th1">DOCTYPE</th>
		<th class="th1">charset</th>
		<th class="th1">date</th>
		<th class="th1">status</th>
		</tr>

		<xsl:variable name="sw" select="ANALYZE_HISTORY/IS_OUTPUT_DETAIL"/>
		<xsl:apply-templates select="CONTENTS_AND_VARIATION">
			<xsl:with-param name="isOutputDetail" select="$sw"/>
		</xsl:apply-templates>

	</table>

	</div>
	<!-- /.box -->
	
	</div>
	<!-- /#content -->
</xsl:template>

<xsl:template match="ANALYZE_SITE_CONFIG">
	<a target="_blank" href="{START_URIS}">
		<xsl:value-of select="START_URIS"/>
	</a>
</xsl:template>

<xsl:template match="ANALYZE_HISTORY">
	<!-- #menu -->
	<div id="menu">
		<ul>
			<li class="overview"><a href="index.html">Overview</a></li>
			<li class="sitemap"><a name="sitemap.html">Sitemap</a></li>
			<li class="pages"><a href="pages.html">Pages</a></li>
			<li class="resources"><a href="resources.html">Resources</a></li>
			<li class="outlink"><a href="outlink.html">OutLink</a></li>
			<li class="form"><a href="form.html">Form</a></li>
			<li class="script"><a href="script.html">Script</a></li>
			<li class="css"><a href="css.html">CSS</a></li>
			<li class="objects"><a href="objects.html">Objects</a></li>
			<li class="lost"><a href="lost.html">Lost</a></li>
			<li class="quality"><a href="quality.html">Quality</a></li>
			<li class="report"><a href="report.html">Report</a></li>
			<li class="datalist"><a name="data.html">Data</a></li>
		</ul>
	</div>
	<!-- /#menu -->
</xsl:template>

</xsl:stylesheet>
