﻿class Circle extends MovieClip {
	private static var original_mc:MovieClip;
	private static var circles_array:Array = new Array();
	private function Circle() {
		if (!original_mc) {
			original_mc = this;
		}
	}
	static function drawCircle(level:Number, x_center:Number, y_center:Number, r_max:Number, nDepth:Number):Number {
		if (isNaN(nDepth) || nDepth<0) {
			nDepth = 1;
		}
		for (var i:Number = 1; i<=level; i++) {
			var nRadius:Number = r_max*(level-i+1)/level;
			var _mc:MovieClip = original_mc.duplicateMovieClip("clone"+i, nDepth++);
			circles_array.push(_mc);
			_mc._x = x_center;
			_mc._y = y_center;
			_mc._xscale = nRadius;
			_mc._yscale = nRadius;
		}
		return nDepth;
	}
	static function reset():Void {
		var nLength:Number = circles_array.length;
		for (var i:Number = 0; i<nLength; i++) {
			var _mc:MovieClip = circles_array[i];
			_mc.removeMovieClip();
		}
	}
}
