/* Copyright (c) 2013-2017 Mahmoud Fayed <msfclipper@yahoo.com> */

extern "C" {
	#include "ring.h"
}

#include "gpushbutton.h"
#include "gaction.h"
#include "glineedit.h"
#include "gtextedit.h"
#include "glistwidget.h"
#include "gtreeview.h"
#include "gtreewidget.h"
#include "gcombobox.h"
#include "gtabwidget.h"
#include "gtablewidget.h"
#include "gprogressbar.h"
#include "gspinbox.h"
#include "gslider.h"
#include "gdial.h"
#include "gnetworkaccessmanager.h"
#include "gcheckbox.h"
#include "gradiobutton.h"
#include "gbuttongroup.h"
#include "gvideowidget.h"
#include "gtimer.h"
#include "gtcpserver.h"
#include "giodevice.h"
#include "gabstractsocket.h"
#include "gtcpsocket.h"
#include "gcolordialog.h"
#include "gallevents.h"
#include "gthread.h"
#include "gplaintextedit.h"
#include "gheaderview.h"
#include "gprocess.h"
#include "codeeditor.h"


#include <QApplication>
#include <QObject>
#include <QWidget>
#include <QLabel>
#include <QPixmap>
#include <QIcon>
#include <QSize>
#include <QPushButton>
#include <QMainWindow>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QLineEdit>
#include <QTextEdit>
#include <QListWidget>
#include <QTreeView>
#include <QDir>
#include <QFileSystemModel>
#include <QTreeWidget>
#include <QTreeWidgetItem>
#include <QComboBox>
#include <QVariant>
#include <QMenuBar>
#include <QMenu>
#include <QToolBar>
#include <QMainWindow>
#include <QStatusBar>
#include <QDockWidget>
#include <QTabWidget>
#include <QTableWidget>
#include <QTableWidgetItem>
#include <QSizePolicy>
#include <QFrame>
#include <QAbstractScrollArea>
#include <QAbstractItemView>
#include <QProgressBar>
#include <QSpinBox>
#include <QSlider>
#include <QAbstractSlider>
#include <QDateEdit>
#include <QDateTimeEdit>
#include <QAbstractSpinBox>
#include <QDial>
#include <QUrl>
#include <QCheckBox>
#include <QRadioButton>
#include <QButtonGroup>
#include <QMediaPlayer>
#include <QMediaPlaylist>
#include <QVideoWidget>
#include <QPrinter>
#include <QAction>
#include <QEvent>
#include <QMessageBox>
#include <QTimer>
#include <QFileDialog>
#include <QPainter>
#include <QPicture>
#include <QPen>
#include <QColor>
#include <QPrinter>
#include <QFont>
#include <QBrush>
#include <QByteArray>
#include <QIODevice>
#include <QAbstractSocket>
#include <QTcpSocket>
#include <QTcpServer>
#include <QNetworkProxy>
#include <QHostAddress>
#include <QHostInfo>
#include <QList>
#include <QFileInfo>
#include <QDirModel>
#include <QModelIndex>
#include <QFontDialog>
#include <QDialog>
#include <QTextCursor>
#include <QTextBlock>
#include <QTextDocumentFragment>
#include <QColorDialog>
#include <QHeaderView>
#include <QStringList>
#include <QKeySequence>
#include <QLCDNumber>
#include <QInputDialog>
#include <QDesktopWidget>
#include <QRect>
#include <QTextDocument>
#include <QTime>
#include <QTest>
#include <QListWidgetItem>
#include <QSystemTrayIcon>
#include <QDate>
#include <QTextCodec>
#include <QtSql>
#include <QSqlDatabase>
#include <QSqlDriver>
#include <QSqlQuery>
#include <QSqlError>
#include <QSqlIndex>
#include <QSqlRecord>
#include <QSqlField>
#include <QSqlDriverCreatorBase>
#include <QNetworkRequest>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QPainterPath>
#include <QImage>
#include <QBitmap>
#include <QMediaContent>
#include <QTableView>
#include <QXmlStreamReader>
#include <QXmlStreamWriter>
#include <QXmlStreamNotationDeclaration>
#include <QXmlStreamNamespaceDeclaration>
#include <QXmlStreamEntityResolver>
#include <QXmlStreamEntityDeclaration>
#include <QXmlStreamAttributes>
#include <QXmlStreamAttribute>
#include <QThread>
#include <QThreadPool>
#include <QRegularExpression>
#include <QRegularExpressionMatch>
#include <QRegularExpressionMatchIterator>
#include <QJsonValue>
#include <QJsonParseError>
#include <QJsonObject>
#include <QJsonDocument>
#include <QJsonArray>
#include <iterator>
#include <QPlainTextEdit>
#include <QGridLayout>
#include <QTextCharFormat>
#include <QCameraViewfinder>
#include <QGraphicsVideoItem>
#include <QVideoWidgetControl>
#include <QCamera>
#include <QCameraImageCapture>
#include <QFontMetrics>
#include <QList>
#include <QSplashScreen>
#include <QBoxLayout>
#include <QLayout>
#include <QLinearGradient>
#include <QGradient>
#include <QPointF>
#include <QPoint>
#include <QStyleFactory>
#include <QScrollArea>
#include <QSplitter>
#include <QCompleter>
#include <QString>
#include <QProcess>
#include <QMdiArea>
#include <QMdiSubWindow>
#include <QCursor>
#include "highlighter.h"
#include <QListView>
#include <QUuid>
#include <QDesktopServices>
#include <QToolButton>
#include "gtoolbutton.h"
#include <QStringRef>
#include <QMutex>
#include <QMutexLocker>
#include <QBuffer>
#include <QBluetoothAddress>
#include <QBluetoothDeviceDiscoveryAgent>
#include "gbluetoothdevicediscoveryagent.h"
#include <QBluetoothDeviceInfo>
#include <QBluetoothUuid>
#include <QBluetoothHostInfo>
#include <QBluetoothLocalDevice>
#include "gbluetoothlocaldevice.h"
#include <QBluetoothServer>
#include "gbluetoothserver.h"
#include <QBluetoothServiceDiscoveryAgent>
#include "gbluetoothservicediscoveryagent.h"
#include <QBluetoothServiceInfo>
#include <QBluetoothSocket>
#include "gbluetoothsocket.h"
#include <QBluetoothTransferManager>
#include "gbluetoothtransfermanager.h"
#include <QBluetoothTransferReply>
#include "gbluetoothtransferreply.h"
#include <QBluetoothTransferRequest>
#include <QBluetoothUuid>
#include <QDateTime>
#include <QScreen>
#include <QWindow>
#include "gwindow.h"
#include <QGuiApplication>
#include "gguiapplication.h"
#include <QTextBrowser>
#include "gtextbrowser.h"

extern "C" {

	RING_API void ring_qt_start(RingState *pRingState);

	RING_API void ringlib_init(RingState *pRingState)
	{

		new QApplication(pRingState->argc,pRingState->argv);
	   	ring_qt_start(pRingState) ;
	}

}

RING_FUNC(ring_QApp_quit)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	qApp->quit();
	exit(0);
}

RING_FUNC(ring_QApp_exec)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	qApp->exec();
}

RING_FUNC(ring_QApp_styleWindows)
{
	qApp->setPalette(qApp->style()->standardPalette());
	qApp->setStyle(QStyleFactory::create("windows"));
}

RING_FUNC(ring_QApp_styleWindowsVista)
{
	qApp->setPalette(qApp->style()->standardPalette());
	qApp->setStyle(QStyleFactory::create("windowsvista"));
}

RING_FUNC(ring_QApp_styleFusion)
{
	qApp->setPalette(qApp->style()->standardPalette());
	qApp->setStyle(QStyleFactory::create("fusion"));
}

RING_FUNC(ring_QApp_styleFusionBlack)
{
	qApp->setStyle(QStyleFactory::create("fusion"));
	QPalette palette;
	palette.setColor(QPalette::Window, QColor(53,53,53));
	palette.setColor(QPalette::WindowText, Qt::white);
	palette.setColor(QPalette::Base, QColor(15,15,15));
	palette.setColor(QPalette::AlternateBase, QColor(53,53,53));
	palette.setColor(QPalette::ToolTipBase, Qt::white);
	palette.setColor(QPalette::ToolTipText, Qt::white);
	palette.setColor(QPalette::Text, Qt::white);
	palette.setColor(QPalette::Button, QColor(53,53,53));
	palette.setColor(QPalette::ButtonText, Qt::white);
	palette.setColor(QPalette::BrightText, Qt::red);

	palette.setColor(QPalette::Highlight, QColor(142,45,197).lighter());
	palette.setColor(QPalette::HighlightedText, Qt::black);

	palette.setColor(QPalette::Disabled, QPalette::Text, Qt::darkGray);
	palette.setColor(QPalette::Disabled, QPalette::ButtonText, Qt::darkGray);

	qApp->setPalette(palette);
}

RING_FUNC(ring_QApp_styleFusionCustom)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 12 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	if ( (! RING_API_ISPOINTER(1)) || (! RING_API_ISPOINTER(2)) ||
		(! RING_API_ISPOINTER(3)) || (! RING_API_ISPOINTER(4)) ||
		(! RING_API_ISPOINTER(5)) || (! RING_API_ISPOINTER(6)) ||
		(! RING_API_ISPOINTER(7)) || (! RING_API_ISPOINTER(8)) ||
		(! RING_API_ISPOINTER(9)) || (! RING_API_ISPOINTER(10)) ||
		(! RING_API_ISPOINTER(11)) || (! RING_API_ISPOINTER(12)) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	qApp->setStyle(QStyleFactory::create("fusion"));
	QPalette palette;
	palette.setColor(QPalette::Window, 		* (QColor *) RING_API_GETCPOINTER(1,"QColor") );
	palette.setColor(QPalette::WindowText, 		* (QColor *) RING_API_GETCPOINTER(2,"QColor") );
	palette.setColor(QPalette::Base, 		* (QColor *) RING_API_GETCPOINTER(3,"QColor") );
	palette.setColor(QPalette::AlternateBase, 	* (QColor *) RING_API_GETCPOINTER(4,"QColor") );
	palette.setColor(QPalette::ToolTipBase, 	* (QColor *) RING_API_GETCPOINTER(5,"QColor") );
	palette.setColor(QPalette::ToolTipText, 	* (QColor *) RING_API_GETCPOINTER(6,"QColor") );
	palette.setColor(QPalette::Text,		* (QColor *) RING_API_GETCPOINTER(7,"QColor") );
	palette.setColor(QPalette::Button, 		* (QColor *) RING_API_GETCPOINTER(8,"QColor") );
	palette.setColor(QPalette::ButtonText, 		* (QColor *) RING_API_GETCPOINTER(9,"QColor") );
	palette.setColor(QPalette::BrightText, 		* (QColor *) RING_API_GETCPOINTER(10,"QColor") );
	palette.setColor(QPalette::Highlight, 		* (QColor *) RING_API_GETCPOINTER(11,"QColor") );
	palette.setColor(QPalette::HighlightedText, 	* (QColor *) RING_API_GETCPOINTER(12,"QColor") );
	qApp->setPalette(palette);
}


RING_FUNC(ring_QApp_processEvents)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	qApp->processEvents();
}

RING_FUNC(ring_QApp_closeAllWindows)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	qApp->closeAllWindows();
}

RING_FUNC(ring_QApp_keyboardModifiers)
{
	if ( RING_API_PARACOUNT != 0 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_RETNUMBER( (double) qApp->keyboardModifiers() );
}

RING_FUNC(ring_QDesktopServices_openUrl)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_RETNUMBER(QDesktopServices::openUrl(* (QUrl *) RING_API_GETCPOINTER(1,"QUrl"))) ;
}
RING_FUNC(ring_QDesktopServices_setUrlHandler)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	QDesktopServices::setUrlHandler(RING_API_GETSTRING(1),(QObject *) RING_API_GETCPOINTER(2,"QObject *"),RING_API_GETSTRING(3));
}
RING_FUNC(ring_QDesktopServices_unsetUrlHandler)
{
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	QDesktopServices::unsetUrlHandler(RING_API_GETSTRING(1));
}
RING_FUNC(ring_QTest_qsleep)
{
	QTest::qSleep((int) RING_API_GETNUMBER(1));
}

RING_FUNC(ring_QObject_blockSignals)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->blockSignals( (bool ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QObject_children)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	{
		QObjectList *pValue ; 
		pValue = (QObjectList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QObjectList)) ;
		*pValue = pObject->children();
		RING_API_RETCPOINTER(pValue,"QObjectList");
	}
}


RING_FUNC(ring_QObject_dumpObjectInfo)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->dumpObjectInfo();
}


RING_FUNC(ring_QObject_dumpObjectTree)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->dumpObjectTree();
}


RING_FUNC(ring_QObject_inherits)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->inherits(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QObject_installEventFilter)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->installEventFilter((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_isWidgetType)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETNUMBER(pObject->isWidgetType());
}


RING_FUNC(ring_QObject_killTimer)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->killTimer( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QObject_moveToThread)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveToThread((QThread *) RING_API_GETCPOINTER(2,"QThread"));
}


RING_FUNC(ring_QObject_objectName)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETSTRING(pObject->objectName().toStdString().c_str());
}


RING_FUNC(ring_QObject_parent)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETCPOINTER(pObject->parent(),"QObject");
}


RING_FUNC(ring_QObject_property)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->property(RING_API_GETSTRING(2));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QObject_removeEventFilter)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeEventFilter((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_setObjectName)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setObjectName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QObject_setParent)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setParent((QObject *) RING_API_GETCPOINTER(2,"QObject"));
}


RING_FUNC(ring_QObject_setProperty)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setProperty(RING_API_GETSTRING(2),* (QVariant *) RING_API_GETCPOINTER(3,"QVariant")));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QVariant"));
}


RING_FUNC(ring_QObject_signalsBlocked)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETNUMBER(pObject->signalsBlocked());
}


RING_FUNC(ring_QObject_startTimer)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->startTimer( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QObject_thread)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	RING_API_RETCPOINTER(pObject->thread(),"QThread");
}


RING_FUNC(ring_QObject_deleteLater)
{
	QObject *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QObject *) RING_API_GETCPOINTER(1,"QObject");
	pObject->deleteLater();
}


RING_FUNC(ring_QWidget_acceptDrops)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->acceptDrops());
}


RING_FUNC(ring_QWidget_accessibleDescription)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->accessibleDescription().toStdString().c_str());
}


RING_FUNC(ring_QWidget_accessibleName)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->accessibleName().toStdString().c_str());
}


RING_FUNC(ring_QWidget_activateWindow)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->activateWindow();
}


RING_FUNC(ring_QWidget_addAction)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QWidget_adjustSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->adjustSize();
}


RING_FUNC(ring_QWidget_autoFillBackground)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->autoFillBackground());
}


RING_FUNC(ring_QWidget_backgroundRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->backgroundRole());
}


RING_FUNC(ring_QWidget_baseSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->baseSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_childAt)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->childAt( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QWidget");
}


RING_FUNC(ring_QWidget_childrenRect)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->childrenRect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_childrenRegion)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRegion *pValue ; 
		pValue = (QRegion *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRegion)) ;
		*pValue = pObject->childrenRegion();
		RING_API_RETCPOINTER(pValue,"QRegion");
	}
}


RING_FUNC(ring_QWidget_clearFocus)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->clearFocus();
}


RING_FUNC(ring_QWidget_clearMask)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->clearMask();
}


RING_FUNC(ring_QWidget_contentsMargins)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QMargins *pValue ; 
		pValue = (QMargins *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMargins)) ;
		*pValue = pObject->contentsMargins();
		RING_API_RETCPOINTER(pValue,"QMargins");
	}
}


RING_FUNC(ring_QWidget_contentsRect)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->contentsRect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_contextMenuPolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->contextMenuPolicy());
}


RING_FUNC(ring_QWidget_cursor)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QCursor *pValue ; 
		pValue = new QCursor() ;
		*pValue = pObject->cursor();
		RING_API_RETCPOINTER(pValue,"QCursor");
	}
}


RING_FUNC(ring_QWidget_effectiveWinId)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->effectiveWinId());
}


RING_FUNC(ring_QWidget_ensurePolished)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->ensurePolished();
}


RING_FUNC(ring_QWidget_focusPolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->focusPolicy());
}


RING_FUNC(ring_QWidget_focusProxy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->focusProxy(),"QWidget");
}


RING_FUNC(ring_QWidget_focusWidget)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->focusWidget(),"QWidget");
}


RING_FUNC(ring_QWidget_font)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QWidget_fontInfo)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QFontInfo *pValue ; 
		pValue = (QFontInfo *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFontInfo)) ;
		*pValue = pObject->fontInfo();
		RING_API_RETCPOINTER(pValue,"QFontInfo");
	}
}


RING_FUNC(ring_QWidget_foregroundRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->foregroundRole());
}


RING_FUNC(ring_QWidget_frameGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->frameGeometry();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_frameSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->frameSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_geometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->geometry();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_getContentsMargins)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getContentsMargins(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QWidget_grab)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->grab(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QWidget_grabGesture)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->grabGesture( (Qt::GestureType )  (int) RING_API_GETNUMBER(2), (Qt::GestureFlag )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_grabKeyboard)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->grabKeyboard();
}


RING_FUNC(ring_QWidget_grabMouse)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->grabMouse();
}


RING_FUNC(ring_QWidget_grabShortcut)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->grabShortcut(* (QKeySequence *) RING_API_GETCPOINTER(2,"QKeySequence"), (Qt::ShortcutContext )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QKeySequence"));
}


RING_FUNC(ring_QWidget_graphicsEffect)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->graphicsEffect(),"QGraphicsEffect");
}


RING_FUNC(ring_QWidget_graphicsProxyWidget)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->graphicsProxyWidget(),"QGraphicsProxyWidget");
}


RING_FUNC(ring_QWidget_hasFocus)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->hasFocus());
}


RING_FUNC(ring_QWidget_hasMouseTracking)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->hasMouseTracking());
}


RING_FUNC(ring_QWidget_height)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QWidget_heightForWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->heightForWidth( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QWidget_inputMethodHints)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->inputMethodHints());
}


RING_FUNC(ring_QWidget_inputMethodQuery)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->inputMethodQuery( (Qt::InputMethodQuery )  (int) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QWidget_insertAction)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertAction((QAction *) RING_API_GETCPOINTER(2,"QAction"),(QAction *) RING_API_GETCPOINTER(3,"QAction"));
}


RING_FUNC(ring_QWidget_isActiveWindow)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isActiveWindow());
}


RING_FUNC(ring_QWidget_isAncestorOf)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isAncestorOf((QWidget *) RING_API_GETCPOINTER(2,"QWidget")));
}


RING_FUNC(ring_QWidget_isEnabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isEnabled());
}


RING_FUNC(ring_QWidget_isEnabledTo)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isEnabledTo((QWidget *) RING_API_GETCPOINTER(2,"QWidget")));
}


RING_FUNC(ring_QWidget_isFullScreen)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isFullScreen());
}


RING_FUNC(ring_QWidget_isHidden)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isHidden());
}


RING_FUNC(ring_QWidget_isMaximized)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isMaximized());
}


RING_FUNC(ring_QWidget_isMinimized)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isMinimized());
}


RING_FUNC(ring_QWidget_isModal)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isModal());
}


RING_FUNC(ring_QWidget_isVisible)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isVisible());
}


RING_FUNC(ring_QWidget_isVisibleTo)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isVisibleTo((QWidget *) RING_API_GETCPOINTER(2,"QWidget")));
}


RING_FUNC(ring_QWidget_isWindow)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isWindow());
}


RING_FUNC(ring_QWidget_isWindowModified)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->isWindowModified());
}


RING_FUNC(ring_QWidget_layout)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->layout(),"QLayout");
}


RING_FUNC(ring_QWidget_layoutDirection)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->layoutDirection());
}


RING_FUNC(ring_QWidget_locale)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QLocale *pValue ; 
		pValue = (QLocale *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QLocale)) ;
		*pValue = pObject->locale();
		RING_API_RETCPOINTER(pValue,"QLocale");
	}
}


RING_FUNC(ring_QWidget_mapFrom)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapFrom((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),* (QPoint *) RING_API_GETCPOINTER(3,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mapFromGlobal)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapFromGlobal(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mapFromParent)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapFromParent(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mapTo)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapTo((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),* (QPoint *) RING_API_GETCPOINTER(3,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mapToGlobal)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapToGlobal(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mapToParent)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->mapToParent(* (QPoint  *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_mask)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRegion *pValue ; 
		pValue = (QRegion *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRegion)) ;
		*pValue = pObject->mask();
		RING_API_RETCPOINTER(pValue,"QRegion");
	}
}


RING_FUNC(ring_QWidget_maximumHeight)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->maximumHeight());
}


RING_FUNC(ring_QWidget_maximumSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->maximumSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_maximumWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->maximumWidth());
}


RING_FUNC(ring_QWidget_minimumHeight)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->minimumHeight());
}


RING_FUNC(ring_QWidget_minimumSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_minimumWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->minimumWidth());
}


RING_FUNC(ring_QWidget_move)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->move( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_nativeParentWidget)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->nativeParentWidget(),"QWidget");
}


RING_FUNC(ring_QWidget_nextInFocusChain)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->nextInFocusChain(),"QWidget");
}


RING_FUNC(ring_QWidget_normalGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->normalGeometry();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_overrideWindowFlags)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->overrideWindowFlags( (Qt::WindowType )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_palette)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPalette *pValue ; 
		pValue = (QPalette *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QPalette)) ;
		*pValue = pObject->palette();
		RING_API_RETCPOINTER(pValue,"QPalette");
	}
}


RING_FUNC(ring_QWidget_parentWidget)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->parentWidget(),"QWidget");
}


RING_FUNC(ring_QWidget_pos)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->pos();
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QWidget_previousInFocusChain)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->previousInFocusChain(),"QWidget");
}


RING_FUNC(ring_QWidget_rect)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->rect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QWidget_releaseKeyboard)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->releaseKeyboard();
}


RING_FUNC(ring_QWidget_releaseMouse)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->releaseMouse();
}


RING_FUNC(ring_QWidget_releaseShortcut)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->releaseShortcut( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_removeAction)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QWidget_render)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->render((QPaintDevice *) RING_API_GETCPOINTER(2,"QPaintDevice"),* (QPoint *) RING_API_GETCPOINTER(3,"QPoint"),* (QRegion *) RING_API_GETCPOINTER(4,"QRegion"), (QWidget::RenderFlag)  (int) RING_API_GETNUMBER(5));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QRegion"));
}


RING_FUNC(ring_QWidget_repaint)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->repaint();
}


RING_FUNC(ring_QWidget_resize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_restoreGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->restoreGeometry(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QWidget_saveGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->saveGeometry();
		RING_API_RETCPOINTER(pValue,"QByteArray");
	}
}


RING_FUNC(ring_QWidget_scroll)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scroll( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setAcceptDrops)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAcceptDrops( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setAccessibleDescription)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAccessibleDescription(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setAccessibleName)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAccessibleName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setAttribute)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAttribute( (Qt::WidgetAttribute )  (int) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setAutoFillBackground)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoFillBackground( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setBackgroundRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBackgroundRole( (QPalette::ColorRole )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setBaseSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBaseSize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setContentsMargins)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setContentsMargins( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QWidget_setContextMenuPolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setContextMenuPolicy( (Qt::ContextMenuPolicy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setCursor)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setCursor(* (QCursor *) RING_API_GETCPOINTER(2,"QCursor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QCursor"));
}


RING_FUNC(ring_QWidget_setFixedHeight)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFixedHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setFixedSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFixedSize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setFixedWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFixedWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setFocus)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFocus( (Qt::FocusReason )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setFocusPolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFocusPolicy( (Qt::FocusPolicy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setFocusProxy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFocusProxy((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QWidget_setFont)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setFont(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QWidget_setForegroundRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setForegroundRole( (QPalette::ColorRole )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGeometry( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QWidget_setGraphicsEffect)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGraphicsEffect((QGraphicsEffect *) RING_API_GETCPOINTER(2,"QGraphicsEffect"));
}


RING_FUNC(ring_QWidget_setInputMethodHints)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInputMethodHints( (Qt::InputMethodHint )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setLayout)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLayout((QLayout *) RING_API_GETCPOINTER(2,"QLayout"));
}


RING_FUNC(ring_QWidget_setLayoutDirection)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLayoutDirection( (Qt::LayoutDirection )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setLocale)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setLocale(* (QLocale *) RING_API_GETCPOINTER(2,"QLocale"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QLocale"));
}


RING_FUNC(ring_QWidget_setMask)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setMask(* (QBitmap *) RING_API_GETCPOINTER(2,"QBitmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBitmap"));
}


RING_FUNC(ring_QWidget_setMaximumHeight)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setMaximumSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumSize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setMaximumWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximumWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setMinimumHeight)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumHeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setMinimumSize)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumSize( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setMinimumWidth)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setMouseTracking)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMouseTracking( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setPalette)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setPalette(* (QPalette *) RING_API_GETCPOINTER(2,"QPalette"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPalette"));
}


RING_FUNC(ring_QWidget_setParent)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setParent((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QWidget_setShortcutAutoRepeat)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShortcutAutoRepeat( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setShortcutEnabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShortcutEnabled( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setSizeIncrement)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSizeIncrement( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setSizePolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSizePolicy( (QSizePolicy::Policy )  (int) RING_API_GETNUMBER(2), (QSizePolicy::Policy )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QWidget_setStatusTip)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatusTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setStyle)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle((QStyle *) RING_API_GETCPOINTER(2,"QStyle"));
}


RING_FUNC(ring_QWidget_setToolTip)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setUpdatesEnabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUpdatesEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setWhatsThis)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWhatsThis(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setWindowFilePath)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowFilePath(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setWindowFlags)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowFlags( (Qt::WindowType )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setWindowIcon)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->setWindowIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QWidget_setWindowIconText)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowIconText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setWindowModality)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowModality( (Qt::WindowModality )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setWindowOpacity)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowOpacity( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setWindowRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowRole(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setWindowState)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowState( (Qt::WindowState )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_size)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_sizeIncrement)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeIncrement();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QWidget_sizePolicy)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QSizePolicy *pValue ; 
		pValue = (QSizePolicy *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QSizePolicy)) ;
		*pValue = pObject->sizePolicy();
		RING_API_RETCPOINTER(pValue,"QSizePolicy");
	}
}


RING_FUNC(ring_QWidget_stackUnder)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->stackUnder((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QWidget_statusTip)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->statusTip().toStdString().c_str());
}


RING_FUNC(ring_QWidget_style)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->style(),"QStyle");
}


RING_FUNC(ring_QWidget_styleSheet)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->styleSheet().toStdString().c_str());
}


RING_FUNC(ring_QWidget_testAttribute)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->testAttribute( (Qt::WidgetAttribute )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QWidget_toolTip)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->toolTip().toStdString().c_str());
}


RING_FUNC(ring_QWidget_underMouse)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->underMouse());
}


RING_FUNC(ring_QWidget_ungrabGesture)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->ungrabGesture( (Qt::GestureType )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_unsetCursor)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->unsetCursor();
}


RING_FUNC(ring_QWidget_unsetLayoutDirection)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->unsetLayoutDirection();
}


RING_FUNC(ring_QWidget_unsetLocale)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->unsetLocale();
}


RING_FUNC(ring_QWidget_update)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->update( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QWidget_updateGeometry)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->updateGeometry();
}


RING_FUNC(ring_QWidget_updatesEnabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->updatesEnabled());
}


RING_FUNC(ring_QWidget_visibleRegion)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QRegion *pValue ; 
		pValue = (QRegion *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRegion)) ;
		*pValue = pObject->visibleRegion();
		RING_API_RETCPOINTER(pValue,"QRegion");
	}
}


RING_FUNC(ring_QWidget_whatsThis)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->whatsThis().toStdString().c_str());
}


RING_FUNC(ring_QWidget_width)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QWidget_winId)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->winId());
}


RING_FUNC(ring_QWidget_window)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->window(),"QWidget");
}


RING_FUNC(ring_QWidget_windowFilePath)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->windowFilePath().toStdString().c_str());
}


RING_FUNC(ring_QWidget_windowFlags)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->windowFlags());
}


RING_FUNC(ring_QWidget_windowHandle)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->windowHandle(),"QWindow");
}


RING_FUNC(ring_QWidget_windowIcon)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->windowIcon();
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QWidget_windowIconText)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->windowIconText().toStdString().c_str());
}


RING_FUNC(ring_QWidget_windowModality)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->windowModality());
}


RING_FUNC(ring_QWidget_windowOpacity)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->windowOpacity());
}


RING_FUNC(ring_QWidget_windowRole)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->windowRole().toStdString().c_str());
}


RING_FUNC(ring_QWidget_windowState)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->windowState());
}


RING_FUNC(ring_QWidget_windowTitle)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETSTRING(pObject->windowTitle().toStdString().c_str());
}


RING_FUNC(ring_QWidget_windowType)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->windowType());
}


RING_FUNC(ring_QWidget_x)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->x());
}


RING_FUNC(ring_QWidget_y)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->y());
}


RING_FUNC(ring_QWidget_close)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETNUMBER(pObject->close());
}


RING_FUNC(ring_QWidget_hide)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->hide();
}


RING_FUNC(ring_QWidget_lower)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->lower();
}


RING_FUNC(ring_QWidget_raise)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->raise();
}


RING_FUNC(ring_QWidget_setDisabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDisabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setEnabled)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEnabled( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setHidden)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHidden( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setStyleSheet)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleSheet(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_setWindowModified)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowModified( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QWidget_setWindowTitle)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowTitle(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QWidget_show)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->show();
}


RING_FUNC(ring_QWidget_showFullScreen)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->showFullScreen();
}


RING_FUNC(ring_QWidget_showMaximized)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->showMaximized();
}


RING_FUNC(ring_QWidget_showMinimized)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->showMinimized();
}


RING_FUNC(ring_QWidget_showNormal)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	pObject->showNormal();
}


RING_FUNC(ring_QWidget_find)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->find( (int ) RING_API_GETNUMBER(2)),"QWidget");
}


RING_FUNC(ring_QWidget_keyboardGrabber)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->keyboardGrabber(),"QWidget");
}


RING_FUNC(ring_QWidget_mouseGrabber)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	RING_API_RETCPOINTER(pObject->mouseGrabber(),"QWidget");
}


RING_FUNC(ring_QWidget_setTabOrder)
{
	QWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QWidget *) RING_API_GETCPOINTER(1,"QWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabOrder((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"));
}


RING_FUNC(ring_QLabel_alignment)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->alignment());
}


RING_FUNC(ring_QLabel_buddy)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETCPOINTER(pObject->buddy(),"QWidget");
}


RING_FUNC(ring_QLabel_hasScaledContents)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->hasScaledContents());
}


RING_FUNC(ring_QLabel_hasSelectedText)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->hasSelectedText());
}


RING_FUNC(ring_QLabel_indent)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->indent());
}


RING_FUNC(ring_QLabel_margin)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->margin());
}


RING_FUNC(ring_QLabel_movie)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETCPOINTER(pObject->movie(),"QMovie");
}


RING_FUNC(ring_QLabel_openExternalLinks)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->openExternalLinks());
}


RING_FUNC(ring_QLabel_picture)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETCPOINTER(pObject->picture(),"QPicture");
}


RING_FUNC(ring_QLabel_pixmap)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETCPOINTER(pObject->pixmap(),"QPixmap");
}


RING_FUNC(ring_QLabel_selectedText)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETSTRING(pObject->selectedText().toStdString().c_str());
}


RING_FUNC(ring_QLabel_selectionStart)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->selectionStart());
}


RING_FUNC(ring_QLabel_setAlignment)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlignment( (Qt::AlignmentFlag)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setBuddy)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBuddy((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QLabel_setIndent)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIndent( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setMargin)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMargin( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setOpenExternalLinks)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOpenExternalLinks( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setScaledContents)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setScaledContents( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setSelection)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelection( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLabel_setTextFormat)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextFormat( (Qt::TextFormat)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setTextInteractionFlags)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextInteractionFlags( (Qt::TextInteractionFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setWordWrap)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordWrap( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_text)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QLabel_textFormat)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->textFormat());
}


RING_FUNC(ring_QLabel_textInteractionFlags)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->textInteractionFlags());
}


RING_FUNC(ring_QLabel_wordWrap)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	RING_API_RETNUMBER(pObject->wordWrap());
}


RING_FUNC(ring_QLabel_clear)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	pObject->clear();
}


RING_FUNC(ring_QLabel_setMovie)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMovie((QMovie *) RING_API_GETCPOINTER(2,"QMovie"));
}


RING_FUNC(ring_QLabel_setNum)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNum( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLabel_setPicture)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	pObject->setPicture(* (QPicture *) RING_API_GETCPOINTER(2,"QPicture"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPicture"));
}


RING_FUNC(ring_QLabel_setPixmap)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	pObject->setPixmap(* (QPixmap *) RING_API_GETCPOINTER(2,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPixmap"));
}


RING_FUNC(ring_QLabel_setText)
{
	QLabel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QLabel *) RING_API_GETCPOINTER(1,"QLabel");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPushButton_setText)
{
	GPushButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GPushButton *) RING_API_GETCPOINTER(1,"QPushButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPushButton_setClickEvent)
{
	GPushButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GPushButton *) RING_API_GETCPOINTER(1,"QPushButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClickEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPushButton_setIcon)
{
	GPushButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GPushButton *) RING_API_GETCPOINTER(1,"QPushButton");
	pObject->setIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QPushButton_setIconSize)
{
	GPushButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GPushButton *) RING_API_GETCPOINTER(1,"QPushButton");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QPushButton_getClickEvent)
{
	GPushButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GPushButton *) RING_API_GETCPOINTER(1,"QPushButton");
	RING_API_RETSTRING(pObject->getClickEvent());
}


RING_FUNC(ring_QBitmap_clear)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	pObject->clear();
}


RING_FUNC(ring_QBitmap_swap)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	pObject->swap(* (QBitmap *) RING_API_GETCPOINTER(2,"QBitmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBitmap"));
}


RING_FUNC(ring_QBitmap_transformed)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->transformed(* (QTransform *) RING_API_GETCPOINTER(2,"QTransform"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QBitmap_fromData)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->fromData(* (QSize *) RING_API_GETCPOINTER(2,"QSize"),(uchar *) RING_API_GETCPOINTER(3,"uchar"), (QImage::Format )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QBitmap_fromImage)
{
	QBitmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QBitmap *) RING_API_GETCPOINTER(1,"QBitmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->fromImage(* (QImage *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QPixmap_copy)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->copy( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_scaled)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaled( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(4), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_width)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QPixmap_height)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->height());
}


RING_FUNC(ring_QPixmap_createMaskFromColor)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->createMaskFromColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"), (Qt::MaskMode)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QPixmap_mask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->mask();
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QPixmap_setMask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->setMask(* (QBitmap *) RING_API_GETCPOINTER(2,"QBitmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBitmap"));
}


RING_FUNC(ring_QPixmap_fill)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->fill(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QPixmap_fromImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImage(* (QImage *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_load)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->load(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (Qt::ImageConversionFlags)  (int) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_cacheKey)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->cacheKey());
}


RING_FUNC(ring_QPixmap_convertFromImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->convertFromImage(* (QImage  *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
}


RING_FUNC(ring_QPixmap_copy_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->copy(* (QRect  *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_createHeuristicMask)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBitmap *pValue ; 
		pValue = new QBitmap() ;
		*pValue = pObject->createHeuristicMask( (bool ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QBitmap");
	}
}


RING_FUNC(ring_QPixmap_depth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->depth());
}


RING_FUNC(ring_QPixmap_detach)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->detach();
}


RING_FUNC(ring_QPixmap_devicePixelRatio)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->devicePixelRatio());
}


RING_FUNC(ring_QPixmap_hasAlpha)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->hasAlpha());
}


RING_FUNC(ring_QPixmap_hasAlphaChannel)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->hasAlphaChannel());
}


RING_FUNC(ring_QPixmap_isNull)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPixmap_isQBitmap)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->isQBitmap());
}


RING_FUNC(ring_QPixmap_loadFromData)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->loadFromData((uchar *) RING_API_GETCPOINTER(2,"uchar"),* (uint  *) RING_API_GETCPOINTER(3,"uint"),RING_API_GETSTRING(4), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(5)));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"uint"));
}


RING_FUNC(ring_QPixmap_loadFromData_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->loadFromData(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray"),RING_API_GETSTRING(3), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QPixmap_rect)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->rect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QPixmap_save)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(RING_API_GETSTRING(2),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_save_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save((QIODevice *) RING_API_GETCPOINTER(2,"QIODevice"),RING_API_GETSTRING(3), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QPixmap_scaled_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaled(* (QSize  *) RING_API_GETCPOINTER(2,"QSize"), (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(3), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_scaledToHeight)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaledToHeight( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_scaledToWidth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->scaledToWidth( (int ) RING_API_GETNUMBER(2), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_scroll)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scroll( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7),(QRegion *) RING_API_GETCPOINTER(8,"QRegion"));
}


RING_FUNC(ring_QPixmap_scroll_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scroll( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QRect  *) RING_API_GETCPOINTER(4,"QRect"),(QRegion *) RING_API_GETCPOINTER(5,"QRegion"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QRect"));
}


RING_FUNC(ring_QPixmap_setDevicePixelRatio)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDevicePixelRatio( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPixmap_size)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->size();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QPixmap_swap)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	pObject->swap(* (QPixmap  *) RING_API_GETCPOINTER(2,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPixmap"));
}


RING_FUNC(ring_QPixmap_toImage)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	{
		QImage *pValue ; 
		pValue = new QImage() ;
		*pValue = pObject->toImage();
		RING_API_RETCPOINTER(pValue,"QImage");
	}
}


RING_FUNC(ring_QPixmap_transformed)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->transformed(* (QTransform  *) RING_API_GETCPOINTER(2,"QTransform"), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_transformed_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->transformed(* (QMatrix  *) RING_API_GETCPOINTER(2,"QMatrix"), (Qt::TransformationMode )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_defaultDepth)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	RING_API_RETNUMBER(pObject->defaultDepth());
}


RING_FUNC(ring_QPixmap_fromImage_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImage(* (QImage  *) RING_API_GETCPOINTER(2,"QImage"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QImage"));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_fromImageReader)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->fromImageReader((QImageReader *) RING_API_GETCPOINTER(2,"QImageReader"), (Qt::ImageConversionFlags )  (int) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QPixmap_trueMatrix)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->trueMatrix(* (QTransform  *) RING_API_GETCPOINTER(2,"QTransform"), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
		RING_API_RETCPOINTER(pValue,"QTransform");
	}
}


RING_FUNC(ring_QPixmap_trueMatrix_2)
{
	QPixmap *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPixmap *) RING_API_GETCPOINTER(1,"QPixmap");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QMatrix *pValue ; 
		pValue = (QMatrix *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMatrix)) ;
		*pValue = pObject->trueMatrix(* (QMatrix  *) RING_API_GETCPOINTER(2,"QMatrix"), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QMatrix"));
		RING_API_RETCPOINTER(pValue,"QMatrix");
	}
}


RING_FUNC(ring_QLineEdit_alignment)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->alignment());
}


RING_FUNC(ring_QLineEdit_backspace)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->backspace();
}


RING_FUNC(ring_QLineEdit_completer)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETCPOINTER(pObject->completer(),"QCompleter");
}


RING_FUNC(ring_QLineEdit_createStandardContextMenu)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETCPOINTER(pObject->createStandardContextMenu(),"QMenu");
}


RING_FUNC(ring_QLineEdit_cursorBackward)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->cursorBackward( (bool ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLineEdit_cursorForward)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->cursorForward( (bool ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLineEdit_cursorMoveStyle)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->cursorMoveStyle());
}


RING_FUNC(ring_QLineEdit_cursorPosition)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->cursorPosition());
}


RING_FUNC(ring_QLineEdit_cursorPositionAt)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->cursorPositionAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QLineEdit_cursorWordBackward)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->cursorWordBackward( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_cursorWordForward)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->cursorWordForward( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_del)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->del();
}


RING_FUNC(ring_QLineEdit_deselect)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->deselect();
}


RING_FUNC(ring_QLineEdit_displayText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->displayText().toStdString().c_str());
}


RING_FUNC(ring_QLineEdit_dragEnabled)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->dragEnabled());
}


RING_FUNC(ring_QLineEdit_echoMode)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->echoMode());
}


RING_FUNC(ring_QLineEdit_end)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->end( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_getTextMargins)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getTextMargins(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QLineEdit_hasAcceptableInput)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->hasAcceptableInput());
}


RING_FUNC(ring_QLineEdit_hasFrame)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->hasFrame());
}


RING_FUNC(ring_QLineEdit_hasSelectedText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->hasSelectedText());
}


RING_FUNC(ring_QLineEdit_home)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->home( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_inputMask)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->inputMask().toStdString().c_str());
}


RING_FUNC(ring_QLineEdit_insert)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insert(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_isModified)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->isModified());
}


RING_FUNC(ring_QLineEdit_isReadOnly)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->isReadOnly());
}


RING_FUNC(ring_QLineEdit_isRedoAvailable)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->isRedoAvailable());
}


RING_FUNC(ring_QLineEdit_isUndoAvailable)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->isUndoAvailable());
}


RING_FUNC(ring_QLineEdit_maxLength)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->maxLength());
}


RING_FUNC(ring_QLineEdit_placeholderText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->placeholderText().toStdString().c_str());
}


RING_FUNC(ring_QLineEdit_selectedText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->selectedText().toStdString().c_str());
}


RING_FUNC(ring_QLineEdit_selectionStart)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETNUMBER(pObject->selectionStart());
}


RING_FUNC(ring_QLineEdit_setAlignment)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlignment( (Qt::AlignmentFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setCompleter)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCompleter((QCompleter *) RING_API_GETCPOINTER(2,"QCompleter"));
}


RING_FUNC(ring_QLineEdit_setCursorMoveStyle)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCursorMoveStyle( (Qt::CursorMoveStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setCursorPosition)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCursorPosition( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setDragEnabled)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDragEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setEchoMode)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEchoMode( (QLineEdit::EchoMode)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setFrame)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrame( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setInputMask)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInputMask(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_setMaxLength)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaxLength( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setModified)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModified( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setPlaceholderText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlaceholderText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_setReadOnly)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setReadOnly( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QLineEdit_setSelection)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelection( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QLineEdit_setTextMargins)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextMargins( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QLineEdit_setValidator)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setValidator((QValidator *) RING_API_GETCPOINTER(2,"QValidator"));
}


RING_FUNC(ring_QLineEdit_text)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QLineEdit_textMargins)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	{
		QMargins *pValue ; 
		pValue = (QMargins *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMargins)) ;
		*pValue = pObject->textMargins();
		RING_API_RETCPOINTER(pValue,"QMargins");
	}
}


RING_FUNC(ring_QLineEdit_validator)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETCPOINTER(pObject->validator(),"QValidator");
}


RING_FUNC(ring_QLineEdit_clear)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->clear();
}


RING_FUNC(ring_QLineEdit_copy)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->copy();
}


RING_FUNC(ring_QLineEdit_cut)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->cut();
}


RING_FUNC(ring_QLineEdit_paste)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->paste();
}


RING_FUNC(ring_QLineEdit_redo)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->redo();
}


RING_FUNC(ring_QLineEdit_selectAll)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->selectAll();
}


RING_FUNC(ring_QLineEdit_setText)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_undo)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	pObject->undo();
}


RING_FUNC(ring_QLineEdit_setTextChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_setcursorPositionChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcursorPositionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_seteditingFinishedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->seteditingFinishedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_setreturnPressedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreturnPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_setselectionChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setselectionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_settextEditedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settextEditedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QLineEdit_getTextChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->getTextChangedEvent());
}


RING_FUNC(ring_QLineEdit_getcursorPositionChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->getcursorPositionChangedEvent());
}


RING_FUNC(ring_QLineEdit_geteditingFinishedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->geteditingFinishedEvent());
}


RING_FUNC(ring_QLineEdit_getreturnPressedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->getreturnPressedEvent());
}


RING_FUNC(ring_QLineEdit_getselectionChangedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->getselectionChangedEvent());
}


RING_FUNC(ring_QLineEdit_gettextEditedEvent)
{
	GLineEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GLineEdit *) RING_API_GETCPOINTER(1,"QLineEdit");
	RING_API_RETSTRING(pObject->gettextEditedEvent());
}


RING_FUNC(ring_QVBoxLayout_addWidget)
{
	QVBoxLayout *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVBoxLayout *) RING_API_GETCPOINTER(1,"QVBoxLayout");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QVBoxLayout_addLayout)
{
	QVBoxLayout *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QVBoxLayout *) RING_API_GETCPOINTER(1,"QVBoxLayout");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addLayout((QLayout *) RING_API_GETCPOINTER(2,"QLayout"));
}


RING_FUNC(ring_QHBoxLayout_addWidget)
{
	QHBoxLayout *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QHBoxLayout *) RING_API_GETCPOINTER(1,"QHBoxLayout");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QHBoxLayout_addLayout)
{
	QHBoxLayout *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QHBoxLayout *) RING_API_GETCPOINTER(1,"QHBoxLayout");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addLayout((QLayout *) RING_API_GETCPOINTER(2,"QLayout"));
}


RING_FUNC(ring_QTextEdit_acceptRichText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->acceptRichText());
}


RING_FUNC(ring_QTextEdit_alignment)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->alignment());
}


RING_FUNC(ring_QTextEdit_anchorAt)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->anchorAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QTextEdit_canPaste)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->canPaste());
}


RING_FUNC(ring_QTextEdit_currentCharFormat)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QTextCharFormat *pValue ; 
		pValue = new QTextCharFormat() ;
		*pValue = pObject->currentCharFormat();
		RING_API_RETCPOINTER(pValue,"QTextCharFormat");
	}
}


RING_FUNC(ring_QTextEdit_currentFont)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->currentFont();
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QTextEdit_cursorForPosition)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QTextCursor *pValue ; 
		pValue = new QTextCursor() ;
		*pValue = pObject->cursorForPosition(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QTextCursor");
	}
}


RING_FUNC(ring_QTextEdit_cursorRect)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->cursorRect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QTextEdit_cursorWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->cursorWidth());
}


RING_FUNC(ring_QTextEdit_document)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETCPOINTER(pObject->document(),"QTextDocument");
}


RING_FUNC(ring_QTextEdit_documentTitle)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->documentTitle().toStdString().c_str());
}


RING_FUNC(ring_QTextEdit_ensureCursorVisible)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->ensureCursorVisible();
}


RING_FUNC(ring_QTextEdit_find)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->find(RING_API_GETSTRING(2), (QTextDocument::FindFlag)  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QTextEdit_fontFamily)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->fontFamily().toStdString().c_str());
}


RING_FUNC(ring_QTextEdit_fontItalic)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->fontItalic());
}


RING_FUNC(ring_QTextEdit_fontPointSize)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->fontPointSize());
}


RING_FUNC(ring_QTextEdit_fontUnderline)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->fontUnderline());
}


RING_FUNC(ring_QTextEdit_fontWeight)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->fontWeight());
}


RING_FUNC(ring_QTextEdit_isReadOnly)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->isReadOnly());
}


RING_FUNC(ring_QTextEdit_isUndoRedoEnabled)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->isUndoRedoEnabled());
}


RING_FUNC(ring_QTextEdit_lineWrapColumnOrWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->lineWrapColumnOrWidth());
}


RING_FUNC(ring_QTextEdit_loadResource)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->loadResource( (int) RING_API_GETNUMBER(2),* (QUrl *) RING_API_GETCPOINTER(3,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QUrl"));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QTextEdit_mergeCurrentCharFormat)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->mergeCurrentCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextEdit_moveCursor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->moveCursor( (QTextCursor::MoveOperation )  (int) RING_API_GETNUMBER(2), (QTextCursor::MoveMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTextEdit_overwriteMode)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->overwriteMode());
}


RING_FUNC(ring_QTextEdit_print)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->print((QPrinter *) RING_API_GETCPOINTER(2,"QPrinter"));
}


RING_FUNC(ring_QTextEdit_setAcceptRichText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAcceptRichText( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setCurrentCharFormat)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->setCurrentCharFormat(* (QTextCharFormat *) RING_API_GETCPOINTER(2,"QTextCharFormat"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCharFormat"));
}


RING_FUNC(ring_QTextEdit_setCursorWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCursorWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setDocument)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocument((QTextDocument *) RING_API_GETCPOINTER(2,"QTextDocument"));
}


RING_FUNC(ring_QTextEdit_setDocumentTitle)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocumentTitle(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setLineWrapColumnOrWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLineWrapColumnOrWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setLineWrapMode)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLineWrapMode( (QTextEdit::LineWrapMode)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setOverwriteMode)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOverwriteMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setReadOnly)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setReadOnly( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setTabChangesFocus)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabChangesFocus( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setTabStopWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabStopWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setTextCursor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->setTextCursor(* (QTextCursor *) RING_API_GETCPOINTER(2,"QTextCursor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTextCursor"));
}


RING_FUNC(ring_QTextEdit_setTextInteractionFlags)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextInteractionFlags( (Qt::TextInteractionFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setUndoRedoEnabled)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUndoRedoEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setWordWrapMode)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordWrapMode( (QTextOption::WrapMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_tabChangesFocus)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->tabChangesFocus());
}


RING_FUNC(ring_QTextEdit_tabStopWidth)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->tabStopWidth());
}


RING_FUNC(ring_QTextEdit_textBackgroundColor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->textBackgroundColor();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QTextEdit_textColor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->textColor();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QTextEdit_textCursor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	{
		QTextCursor *pValue ; 
		pValue = new QTextCursor() ;
		*pValue = pObject->textCursor();
		RING_API_RETCPOINTER(pValue,"QTextCursor");
	}
}


RING_FUNC(ring_QTextEdit_textInteractionFlags)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->textInteractionFlags());
}


RING_FUNC(ring_QTextEdit_toHtml)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->toHtml().toStdString().c_str());
}


RING_FUNC(ring_QTextEdit_toPlainText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->toPlainText().toStdString().c_str());
}


RING_FUNC(ring_QTextEdit_wordWrapMode)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETNUMBER(pObject->wordWrapMode());
}


RING_FUNC(ring_QTextEdit_append)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->append(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_clear)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->clear();
}


RING_FUNC(ring_QTextEdit_copy)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->copy();
}


RING_FUNC(ring_QTextEdit_cut)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->cut();
}


RING_FUNC(ring_QTextEdit_insertHtml)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertHtml(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_insertPlainText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertPlainText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_paste)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->paste();
}


RING_FUNC(ring_QTextEdit_redo)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->redo();
}


RING_FUNC(ring_QTextEdit_scrollToAnchor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollToAnchor(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_selectAll)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->selectAll();
}


RING_FUNC(ring_QTextEdit_setAlignment)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlignment( (Qt::AlignmentFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setCurrentFont)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->setCurrentFont(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QTextEdit_setFontFamily)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontFamily(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setFontItalic)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontItalic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setFontPointSize)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontPointSize( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setFontUnderline)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontUnderline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setFontWeight)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontWeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setHtml)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHtml(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setPlainText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlainText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setText)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setTextBackgroundColor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->setTextBackgroundColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QTextEdit_setTextColor)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->setTextColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QTextEdit_undo)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	pObject->undo();
}


RING_FUNC(ring_QTextEdit_zoomIn)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->zoomIn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_zoomOut)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->zoomOut( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTextEdit_setcopyAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcopyAvailableEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setcurrentCharFormatChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentCharFormatChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setcursorPositionChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcursorPositionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setredoAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setredoAvailableEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setselectionChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setselectionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_settextChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settextChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_setundoAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setundoAvailableEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTextEdit_getcopyAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getcopyAvailableEvent());
}


RING_FUNC(ring_QTextEdit_getcurrentCharFormatChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getcurrentCharFormatChangedEvent());
}


RING_FUNC(ring_QTextEdit_getcursorPositionChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getcursorPositionChangedEvent());
}


RING_FUNC(ring_QTextEdit_getredoAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getredoAvailableEvent());
}


RING_FUNC(ring_QTextEdit_getselectionChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getselectionChangedEvent());
}


RING_FUNC(ring_QTextEdit_gettextChangedEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->gettextChangedEvent());
}


RING_FUNC(ring_QTextEdit_getundoAvailableEvent)
{
	GTextEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit");
	RING_API_RETSTRING(pObject->getundoAvailableEvent());
}

RING_FUNC(ring_QTextEdit_cyanline)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}

	QTextEdit *editor;
	editor = (QTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit *");

	QTextEdit::ExtraSelection highlight;
	highlight.cursor = editor->textCursor();
	highlight.format.setProperty(QTextFormat::FullWidthSelection, true);
	highlight.format.setBackground( Qt::cyan );

	QList<QTextEdit::ExtraSelection> extras;
	extras << highlight;
	editor->setExtraSelections( extras );
}
RING_FUNC(ring_QTextEdit_setactivelinecolor)
{
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}

	QTextEdit *editor;
	editor = (QTextEdit *) RING_API_GETCPOINTER(1,"QTextEdit *");

	QTextEdit::ExtraSelection highlight;
	highlight.cursor = editor->textCursor();
	highlight.format.setProperty(QTextFormat::FullWidthSelection, true);
	highlight.format.setBackground( * (QColor *) RING_API_GETCPOINTER(2,"QColor") );

	QList<QTextEdit::ExtraSelection> extras;
	extras << highlight;
	editor->setExtraSelections( extras );
}

RING_FUNC(ring_QListWidget_addItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addItem(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_count)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QListWidget_currentRow)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETNUMBER(pObject->currentRow());
}


RING_FUNC(ring_QListWidget_editItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->editItem((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"));
}


RING_FUNC(ring_QListWidget_insertItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertItem( (int) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QListWidget_isSortingEnabled)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETNUMBER(pObject->isSortingEnabled());
}


RING_FUNC(ring_QListWidget_item)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->item( (int ) RING_API_GETNUMBER(2)),"QListWidgetItem");
}


RING_FUNC(ring_QListWidget_itemAt)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemAt( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QListWidgetItem");
}


RING_FUNC(ring_QListWidget_itemWidget)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemWidget((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem")),"QWidget");
}


RING_FUNC(ring_QListWidget_openPersistentEditor)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->openPersistentEditor((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"));
}


RING_FUNC(ring_QListWidget_removeItemWidget)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeItemWidget((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"));
}


RING_FUNC(ring_QListWidget_row)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->row((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem")));
}


RING_FUNC(ring_QListWidget_setCurrentItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentItem((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"), (QItemSelectionModel::SelectionFlag )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QListWidget_setCurrentRow)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentRow( (int ) RING_API_GETNUMBER(2), (QItemSelectionModel::SelectionFlag )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QListWidget_setItemWidget)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemWidget((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"));
}


RING_FUNC(ring_QListWidget_setSortingEnabled)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSortingEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QListWidget_sortItems)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortItems( (Qt::SortOrder )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QListWidget_takeItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeItem( (int ) RING_API_GETNUMBER(2)),"QListWidgetItem");
}


RING_FUNC(ring_QListWidget_visualItemRect)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->visualItemRect((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QListWidget_clear)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	pObject->clear();
}


RING_FUNC(ring_QListWidget_scrollToItem)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollToItem((QListWidgetItem *) RING_API_GETCPOINTER(2,"QListWidgetItem"), (QAbstractItemView::ScrollHint )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QListWidget_setcurrentItemChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentItemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setcurrentRowChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentRowChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setcurrentTextChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentTextChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemActivatedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemActivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemClickedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemDoubleClickedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemDoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemEnteredEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemPressedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_setitemSelectionChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemSelectionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QListWidget_getcurrentItemChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getcurrentItemChangedEvent());
}


RING_FUNC(ring_QListWidget_getcurrentRowChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getcurrentRowChangedEvent());
}


RING_FUNC(ring_QListWidget_getcurrentTextChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getcurrentTextChangedEvent());
}


RING_FUNC(ring_QListWidget_getitemActivatedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemActivatedEvent());
}


RING_FUNC(ring_QListWidget_getitemChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemChangedEvent());
}


RING_FUNC(ring_QListWidget_getitemClickedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemClickedEvent());
}


RING_FUNC(ring_QListWidget_getitemDoubleClickedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemDoubleClickedEvent());
}


RING_FUNC(ring_QListWidget_getitemEnteredEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemEnteredEvent());
}


RING_FUNC(ring_QListWidget_getitemPressedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemPressedEvent());
}


RING_FUNC(ring_QListWidget_getitemSelectionChangedEvent)
{
	GListWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GListWidget *) RING_API_GETCPOINTER(1,"QListWidget");
	RING_API_RETSTRING(pObject->getitemSelectionChangedEvent());
}


RING_FUNC(ring_QTreeView_allColumnsShowFocus)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->allColumnsShowFocus());
}


RING_FUNC(ring_QTreeView_autoExpandDelay)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->autoExpandDelay());
}


RING_FUNC(ring_QTreeView_columnAt)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnAt( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeView_columnViewportPosition)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnViewportPosition( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeView_columnWidth)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnWidth( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeView_expandsOnDoubleClick)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->expandsOnDoubleClick());
}


RING_FUNC(ring_QTreeView_header)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETCPOINTER(pObject->header(),"QHeaderView");
}


RING_FUNC(ring_QTreeView_indentation)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->indentation());
}


RING_FUNC(ring_QTreeView_indexAbove)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->indexAbove(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QTreeView_indexBelow)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->indexBelow(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QTreeView_isAnimated)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->isAnimated());
}


RING_FUNC(ring_QTreeView_isColumnHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isColumnHidden( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeView_isExpanded)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->isExpanded(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_isFirstColumnSpanned)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isFirstColumnSpanned( (int ) RING_API_GETNUMBER(2),* (QModelIndex *) RING_API_GETCPOINTER(3,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_isHeaderHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->isHeaderHidden());
}


RING_FUNC(ring_QTreeView_isRowHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isRowHidden( (int ) RING_API_GETNUMBER(2),* (QModelIndex *) RING_API_GETCPOINTER(3,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_isSortingEnabled)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->isSortingEnabled());
}


RING_FUNC(ring_QTreeView_itemsExpandable)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->itemsExpandable());
}


RING_FUNC(ring_QTreeView_rootIsDecorated)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->rootIsDecorated());
}


RING_FUNC(ring_QTreeView_setAllColumnsShowFocus)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAllColumnsShowFocus( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setAnimated)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAnimated( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setAutoExpandDelay)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoExpandDelay( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setColumnHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnHidden( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeView_setColumnWidth)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnWidth( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeView_setExpanded)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setExpanded(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"), (bool ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_setExpandsOnDoubleClick)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setExpandsOnDoubleClick( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setFirstColumnSpanned)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFirstColumnSpanned( (int ) RING_API_GETNUMBER(2),* (QModelIndex *) RING_API_GETCPOINTER(3,"QModelIndex"), (bool ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_setHeader)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeader((QHeaderView *) RING_API_GETCPOINTER(2,"QHeaderView"));
}


RING_FUNC(ring_QTreeView_setHeaderHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeaderHidden( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setIndentation)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIndentation( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setItemsExpandable)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemsExpandable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setRootIsDecorated)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRootIsDecorated( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setRowHidden)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRowHidden( (int ) RING_API_GETNUMBER(2),* (QModelIndex *) RING_API_GETCPOINTER(3,"QModelIndex"), (bool ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_setSortingEnabled)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSortingEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setUniformRowHeights)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUniformRowHeights( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setWordWrap)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordWrap( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_sortByColumn)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortByColumn( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeView_uniformRowHeights)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->uniformRowHeights());
}


RING_FUNC(ring_QTreeView_wordWrap)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETNUMBER(pObject->wordWrap());
}


RING_FUNC(ring_QTreeView_dataChanged)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->dataChanged(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"),* (QModelIndex *) RING_API_GETCPOINTER(3,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_indexAt)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->indexAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QTreeView_keyboardSearch)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->keyboardSearch(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_reset)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->reset();
}


RING_FUNC(ring_QTreeView_scrollTo)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollTo(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"), (QAbstractItemView::ScrollHint)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_selectAll)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->selectAll();
}


RING_FUNC(ring_QTreeView_setModel)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModel((QAbstractItemModel *) RING_API_GETCPOINTER(2,"QAbstractItemModel"));
}


RING_FUNC(ring_QTreeView_setRootIndex)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->setRootIndex(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_setSelectionModel)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectionModel((QItemSelectionModel *) RING_API_GETCPOINTER(2,"QItemSelectionModel"));
}


RING_FUNC(ring_QTreeView_visualRect)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->visualRect(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QTreeView_collapse)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->collapse(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_collapseAll)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->collapseAll();
}


RING_FUNC(ring_QTreeView_expand)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->expand(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTreeView_expandAll)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	pObject->expandAll();
}


RING_FUNC(ring_QTreeView_expandToDepth)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->expandToDepth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_hideColumn)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->hideColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_resizeColumnToContents)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resizeColumnToContents( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_showColumn)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->showColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeView_setcollapsedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcollapsedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setexpandedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setexpandedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setactivatedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setclickedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setclickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setdoubleClickedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setdoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setenteredEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setenteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setpressedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setpressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_setviewportEnteredEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setviewportEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeView_getcollapsedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getcollapsedEvent());
}


RING_FUNC(ring_QTreeView_getexpandedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getexpandedEvent());
}


RING_FUNC(ring_QTreeView_getactivatedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getactivatedEvent());
}


RING_FUNC(ring_QTreeView_getclickedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getclickedEvent());
}


RING_FUNC(ring_QTreeView_getdoubleClickedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getdoubleClickedEvent());
}


RING_FUNC(ring_QTreeView_getenteredEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getenteredEvent());
}


RING_FUNC(ring_QTreeView_getpressedEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getpressedEvent());
}


RING_FUNC(ring_QTreeView_getviewportEnteredEvent)
{
	GTreeView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeView *) RING_API_GETCPOINTER(1,"QTreeView");
	RING_API_RETSTRING(pObject->getviewportEnteredEvent());
}


RING_FUNC(ring_QDir_currentPath)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	RING_API_RETSTRING(pObject->currentPath().toStdString().c_str());
}


RING_FUNC(ring_QDir_setNameFilters)
{
	QDir *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDir *) RING_API_GETCPOINTER(1,"QDir");
	pObject->setNameFilters(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QFileSystemModel_fileIcon)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->fileIcon(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QFileSystemModel_fileInfo)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QFileInfo *pValue ; 
		pValue = new QFileInfo() ;
		*pValue = pObject->fileInfo(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QFileInfo");
	}
}


RING_FUNC(ring_QFileSystemModel_fileName)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETSTRING(pObject->fileName(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_filePath)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETSTRING(pObject->filePath(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_filter)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->filter());
}


RING_FUNC(ring_QFileSystemModel_iconProvider)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETCPOINTER(pObject->iconProvider(),"QFileIconProvider");
}


RING_FUNC(ring_QFileSystemModel_index)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->index(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QFileSystemModel_isDir)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->isDir(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_isReadOnly)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->isReadOnly());
}


RING_FUNC(ring_QFileSystemModel_lastModified)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->lastModified(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QDateTime");
	}
}


RING_FUNC(ring_QFileSystemModel_mkdir)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->mkdir(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"),RING_API_GETSTRING(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QFileSystemModel_myComputer)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->myComputer( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QFileSystemModel_nameFilterDisables)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->nameFilterDisables());
}


RING_FUNC(ring_QFileSystemModel_nameFilters)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->nameFilters();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileSystemModel_permissions)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->permissions(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_remove)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->remove(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_resolveSymlinks)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->resolveSymlinks());
}


RING_FUNC(ring_QFileSystemModel_rmdir)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->rmdir(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_rootDirectory)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->rootDirectory();
		RING_API_RETCPOINTER(pValue,"QDir");
	}
}


RING_FUNC(ring_QFileSystemModel_rootPath)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETSTRING(pObject->rootPath().toStdString().c_str());
}


RING_FUNC(ring_QFileSystemModel_setFilter)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFilter( (QDir::Filter )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileSystemModel_setIconProvider)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIconProvider((QFileIconProvider *) RING_API_GETCPOINTER(2,"QFileIconProvider"));
}


RING_FUNC(ring_QFileSystemModel_setNameFilterDisables)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNameFilterDisables( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileSystemModel_setNameFilters)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	pObject->setNameFilters(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QFileSystemModel_setReadOnly)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setReadOnly( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileSystemModel_setResolveSymlinks)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setResolveSymlinks( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileSystemModel_setRootPath)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->setRootPath(RING_API_GETSTRING(2));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QFileSystemModel_size)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->size(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_type)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETSTRING(pObject->type(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")).toStdString().c_str());
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_canFetchMore)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->canFetchMore(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_columnCount)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->columnCount());
}


RING_FUNC(ring_QFileSystemModel_data)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->data(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex"), (int ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QFileSystemModel_dropMimeData)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->dropMimeData((QMimeData *) RING_API_GETCPOINTER(2,"QMimeData"), (Qt::DropAction )  (int) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5),* (QModelIndex  *) RING_API_GETCPOINTER(6,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_fetchMore)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	pObject->fetchMore(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_flags)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->flags(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_hasChildren)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->hasChildren(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_headerData)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->headerData( (int ) RING_API_GETNUMBER(2), (Qt::Orientation )  (int) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QFileSystemModel_mimeData)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETCPOINTER(pObject->mimeData(* (QModelIndexList  *) RING_API_GETCPOINTER(2,"QModelIndexList")),"QMimeData");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndexList"));
}


RING_FUNC(ring_QFileSystemModel_mimeTypes)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->mimeTypes();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileSystemModel_parent)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->parent(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QFileSystemModel_rowCount)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->rowCount(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QFileSystemModel_setData)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->setData(* (QModelIndex  *) RING_API_GETCPOINTER(2,"QModelIndex"),* (QVariant  *) RING_API_GETCPOINTER(3,"QVariant"), (int ) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QVariant"));
}


RING_FUNC(ring_QFileSystemModel_sort)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sort( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFileSystemModel_supportedDropActions)
{
	QFileSystemModel *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileSystemModel *) RING_API_GETCPOINTER(1,"QFileSystemModel");
	RING_API_RETNUMBER(pObject->supportedDropActions());
}


RING_FUNC(ring_QTreeWidget_addTopLevelItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addTopLevelItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidget_closePersistentEditor)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->closePersistentEditor((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_columnCount)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETNUMBER(pObject->columnCount());
}


RING_FUNC(ring_QTreeWidget_currentColumn)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETNUMBER(pObject->currentColumn());
}


RING_FUNC(ring_QTreeWidget_currentItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETCPOINTER(pObject->currentItem(),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_editItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->editItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_headerItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETCPOINTER(pObject->headerItem(),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_indexOfTopLevelItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOfTopLevelItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem")));
}


RING_FUNC(ring_QTreeWidget_insertTopLevelItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertTopLevelItem( (int ) RING_API_GETNUMBER(2),(QTreeWidgetItem *) RING_API_GETCPOINTER(3,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidget_invisibleRootItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETCPOINTER(pObject->invisibleRootItem(),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_isFirstItemColumnSpanned)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isFirstItemColumnSpanned((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem")));
}


RING_FUNC(ring_QTreeWidget_itemAbove)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemAbove((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem")),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_itemAt)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemAt( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_itemBelow)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemBelow((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem")),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_itemWidget)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemWidget((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3)),"QWidget");
}


RING_FUNC(ring_QTreeWidget_openPersistentEditor)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->openPersistentEditor((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_removeItemWidget)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeItemWidget((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_setColumnCount)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidget_setCurrentItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (QItemSelectionModel::SelectionFlag )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_setFirstItemColumnSpanned)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFirstItemColumnSpanned((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_setHeaderItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeaderItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidget_setHeaderLabel)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHeaderLabel(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setHeaderLabels)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	pObject->setHeaderLabels(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QTreeWidget_setItemWidget)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemWidget((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (int ) RING_API_GETNUMBER(3),(QWidget *) RING_API_GETCPOINTER(4,"QWidget"));
}


RING_FUNC(ring_QTreeWidget_sortColumn)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETNUMBER(pObject->sortColumn());
}


RING_FUNC(ring_QTreeWidget_sortItems)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortItems( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_takeTopLevelItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeTopLevelItem( (int ) RING_API_GETNUMBER(2)),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_topLevelItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->topLevelItem( (int ) RING_API_GETNUMBER(2)),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidget_topLevelItemCount)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETNUMBER(pObject->topLevelItemCount());
}


RING_FUNC(ring_QTreeWidget_visualItemRect)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->visualItemRect((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QTreeWidget_setSelectionModel)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectionModel((QItemSelectionModel *) RING_API_GETCPOINTER(2,"QItemSelectionModel"));
}


RING_FUNC(ring_QTreeWidget_clear)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	pObject->clear();
}


RING_FUNC(ring_QTreeWidget_collapseItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->collapseItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidget_expandItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->expandItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidget_scrollToItem)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollToItem((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"), (QAbstractItemView::ScrollHint )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidget_setcollapsedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcollapsedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setexpandedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setexpandedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setactivatedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setclickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setclickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setdoubleClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setdoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setenteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setenteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setpressedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setpressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setviewportEnteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setviewportEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setcurrentItemChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentItemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemActivatedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemActivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemCollapsedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemCollapsedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemDoubleClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemDoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemEnteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemExpandedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemExpandedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemPressedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_setitemSelectionChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemSelectionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTreeWidget_getcollapsedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getcollapsedEvent());
}


RING_FUNC(ring_QTreeWidget_getexpandedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getexpandedEvent());
}


RING_FUNC(ring_QTreeWidget_getactivatedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getactivatedEvent());
}


RING_FUNC(ring_QTreeWidget_getclickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getclickedEvent());
}


RING_FUNC(ring_QTreeWidget_getdoubleClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getdoubleClickedEvent());
}


RING_FUNC(ring_QTreeWidget_getenteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getenteredEvent());
}


RING_FUNC(ring_QTreeWidget_getpressedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getpressedEvent());
}


RING_FUNC(ring_QTreeWidget_getviewportEnteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getviewportEnteredEvent());
}


RING_FUNC(ring_QTreeWidget_getcurrentItemChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getcurrentItemChangedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemActivatedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemActivatedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemChangedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemClickedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemCollapsedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemCollapsedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemDoubleClickedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemDoubleClickedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemEnteredEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemEnteredEvent());
}


RING_FUNC(ring_QTreeWidget_getitemExpandedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemExpandedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemPressedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemPressedEvent());
}


RING_FUNC(ring_QTreeWidget_getitemSelectionChangedEvent)
{
	GTreeWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTreeWidget *) RING_API_GETCPOINTER(1,"QTreeWidget");
	RING_API_RETSTRING(pObject->getitemSelectionChangedEvent());
}


RING_FUNC(ring_QTreeWidgetItem_addChild)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addChild((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidgetItem_background)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->background( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QTreeWidgetItem_checkState)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->checkState( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeWidgetItem_child)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->child( (int ) RING_API_GETNUMBER(2)),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidgetItem_childCount)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->childCount());
}


RING_FUNC(ring_QTreeWidgetItem_childIndicatorPolicy)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->childIndicatorPolicy());
}


RING_FUNC(ring_QTreeWidgetItem_clone)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETCPOINTER(pObject->clone(),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidgetItem_columnCount)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->columnCount());
}


RING_FUNC(ring_QTreeWidgetItem_data)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->data( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QTreeWidgetItem_flags)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->flags());
}


RING_FUNC(ring_QTreeWidgetItem_font)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QTreeWidgetItem_foreground)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->foreground( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QTreeWidgetItem_icon)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QTreeWidgetItem_indexOfChild)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOfChild((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem")));
}


RING_FUNC(ring_QTreeWidgetItem_insertChild)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertChild( (int ) RING_API_GETNUMBER(2),(QTreeWidgetItem *) RING_API_GETCPOINTER(3,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidgetItem_isDisabled)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->isDisabled());
}


RING_FUNC(ring_QTreeWidgetItem_isExpanded)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->isExpanded());
}


RING_FUNC(ring_QTreeWidgetItem_isFirstColumnSpanned)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->isFirstColumnSpanned());
}


RING_FUNC(ring_QTreeWidgetItem_isHidden)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->isHidden());
}


RING_FUNC(ring_QTreeWidgetItem_isSelected)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->isSelected());
}


RING_FUNC(ring_QTreeWidgetItem_parent)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETCPOINTER(pObject->parent(),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidgetItem_read)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	pObject->read(* (QDataStream *) RING_API_GETCPOINTER(2,"QDataStream"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDataStream"));
}


RING_FUNC(ring_QTreeWidgetItem_removeChild)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeChild((QTreeWidgetItem *) RING_API_GETCPOINTER(2,"QTreeWidgetItem"));
}


RING_FUNC(ring_QTreeWidgetItem_setBackground)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBackground( (int ) RING_API_GETNUMBER(2),* (QBrush *) RING_API_GETCPOINTER(3,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QBrush"));
}


RING_FUNC(ring_QTreeWidgetItem_setCheckState)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCheckState( (int ) RING_API_GETNUMBER(2), (Qt::CheckState )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidgetItem_setChildIndicatorPolicy)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setChildIndicatorPolicy( (QTreeWidgetItem::ChildIndicatorPolicy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setData)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setData( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QVariant *) RING_API_GETCPOINTER(4,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QVariant"));
}


RING_FUNC(ring_QTreeWidgetItem_setDisabled)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDisabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setExpanded)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setExpanded( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setFirstColumnSpanned)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFirstColumnSpanned( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setFlags)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFlags( (Qt::ItemFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setFont)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFont( (int ) RING_API_GETNUMBER(2),* (QFont *) RING_API_GETCPOINTER(3,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QFont"));
}


RING_FUNC(ring_QTreeWidgetItem_setForeground)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setForeground( (int ) RING_API_GETNUMBER(2),* (QBrush *) RING_API_GETCPOINTER(3,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QBrush"));
}


RING_FUNC(ring_QTreeWidgetItem_setHidden)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHidden( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setIcon)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIcon( (int ) RING_API_GETNUMBER(2),* (QIcon *) RING_API_GETCPOINTER(3,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QIcon"));
}


RING_FUNC(ring_QTreeWidgetItem_setSelected)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelected( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTreeWidgetItem_setSizeHint)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSizeHint( (int ) RING_API_GETNUMBER(2),* (QSize *) RING_API_GETCPOINTER(3,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QSize"));
}


RING_FUNC(ring_QTreeWidgetItem_setStatusTip)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatusTip( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTreeWidgetItem_setText)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTreeWidgetItem_setTextAlignment)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextAlignment( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidgetItem_setToolTip)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolTip( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTreeWidgetItem_setWhatsThis)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWhatsThis( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTreeWidgetItem_sizeHint)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QTreeWidgetItem_sortChildren)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortChildren( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTreeWidgetItem_statusTip)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->statusTip( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTreeWidgetItem_takeChild)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeChild( (int ) RING_API_GETNUMBER(2)),"QTreeWidgetItem");
}


RING_FUNC(ring_QTreeWidgetItem_text)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->text( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTreeWidgetItem_textAlignment)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->textAlignment( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTreeWidgetItem_toolTip)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->toolTip( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTreeWidgetItem_treeWidget)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETCPOINTER(pObject->treeWidget(),"QTreeWidget");
}


RING_FUNC(ring_QTreeWidgetItem_type)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QTreeWidgetItem_whatsThis)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->whatsThis( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTreeWidgetItem_write)
{
	QTreeWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTreeWidgetItem *) RING_API_GETCPOINTER(1,"QTreeWidgetItem");
	pObject->write(* (QDataStream *) RING_API_GETCPOINTER(2,"QDataStream"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDataStream"));
}

RING_FUNC(ring_QComboBox_addItem)
{
	QComboBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addItem(RING_API_GETSTRING(2),QVariant(RING_API_GETNUMBER(3)));
}

RING_FUNC(ring_QComboBox_completer)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->completer(),"QCompleter");
}


RING_FUNC(ring_QComboBox_count)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QComboBox_currentIndex)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->currentIndex());
}


RING_FUNC(ring_QComboBox_currentText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETSTRING(pObject->currentText().toStdString().c_str());
}


RING_FUNC(ring_QComboBox_duplicatesEnabled)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->duplicatesEnabled());
}


RING_FUNC(ring_QComboBox_findData)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->findData(* (QVariant *) RING_API_GETCPOINTER(2,"QVariant"), (int ) RING_API_GETNUMBER(3), (Qt::MatchFlag )  (int) RING_API_GETNUMBER(4)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
}


RING_FUNC(ring_QComboBox_findText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->findText(RING_API_GETSTRING(2), (Qt::MatchFlag )  (int) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QComboBox_hasFrame)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->hasFrame());
}


RING_FUNC(ring_QComboBox_hidePopup)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->hidePopup();
}


RING_FUNC(ring_QComboBox_iconSize)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QComboBox_insertItem)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertItem( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3),* (QVariant *) RING_API_GETCPOINTER(4,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QVariant"));
}


RING_FUNC(ring_QComboBox_insertSeparator)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertSeparator( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_isEditable)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->isEditable());
}


RING_FUNC(ring_QComboBox_itemData)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->itemData( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QComboBox_itemDelegate)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->itemDelegate(),"QAbstractItemDelegate");
}


RING_FUNC(ring_QComboBox_itemIcon)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->itemIcon( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QComboBox_itemText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->itemText( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QComboBox_lineEdit)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->lineEdit(),"QLineEdit");
}


RING_FUNC(ring_QComboBox_maxCount)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->maxCount());
}


RING_FUNC(ring_QComboBox_maxVisibleItems)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->maxVisibleItems());
}


RING_FUNC(ring_QComboBox_minimumContentsLength)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->minimumContentsLength());
}


RING_FUNC(ring_QComboBox_model)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->model(),"QAbstractItemModel");
}


RING_FUNC(ring_QComboBox_modelColumn)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETNUMBER(pObject->modelColumn());
}


RING_FUNC(ring_QComboBox_removeItem)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeItem( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_rootModelIndex)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->rootModelIndex();
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QComboBox_setCompleter)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCompleter((QCompleter *) RING_API_GETCPOINTER(2,"QCompleter"));
}


RING_FUNC(ring_QComboBox_setDuplicatesEnabled)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDuplicatesEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setEditable)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEditable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setFrame)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrame( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setIconSize)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QComboBox_setItemData)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemData( (int ) RING_API_GETNUMBER(2),* (QVariant *) RING_API_GETCPOINTER(3,"QVariant"), (int ) RING_API_GETNUMBER(4));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QVariant"));
}


RING_FUNC(ring_QComboBox_setItemDelegate)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemDelegate((QAbstractItemDelegate *) RING_API_GETCPOINTER(2,"QAbstractItemDelegate"));
}


RING_FUNC(ring_QComboBox_setItemIcon)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemIcon( (int ) RING_API_GETNUMBER(2),* (QIcon *) RING_API_GETCPOINTER(3,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QIcon"));
}


RING_FUNC(ring_QComboBox_setItemText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemText( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QComboBox_setLineEdit)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLineEdit((QLineEdit *) RING_API_GETCPOINTER(2,"QLineEdit"));
}


RING_FUNC(ring_QComboBox_setMaxCount)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaxCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setMaxVisibleItems)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaxVisibleItems( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setMinimumContentsLength)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimumContentsLength( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setModel)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModel((QAbstractItemModel *) RING_API_GETCPOINTER(2,"QAbstractItemModel"));
}


RING_FUNC(ring_QComboBox_setModelColumn)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModelColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setRootModelIndex)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->setRootModelIndex(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QComboBox_setValidator)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setValidator((QValidator *) RING_API_GETCPOINTER(2,"QValidator"));
}


RING_FUNC(ring_QComboBox_setView)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setView((QAbstractItemView *) RING_API_GETCPOINTER(2,"QAbstractItemView"));
}


RING_FUNC(ring_QComboBox_showPopup)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->showPopup();
}


RING_FUNC(ring_QComboBox_validator)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->validator(),"QValidator");
}


RING_FUNC(ring_QComboBox_view)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETCPOINTER(pObject->view(),"QAbstractItemView");
}


RING_FUNC(ring_QComboBox_clear)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->clear();
}


RING_FUNC(ring_QComboBox_clearEditText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	pObject->clearEditText();
}


RING_FUNC(ring_QComboBox_setCurrentIndex)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentIndex( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QComboBox_setEditText)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEditText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QComboBox_setactivatedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QComboBox_setcurrentIndexChangedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentIndexChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QComboBox_seteditTextChangedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->seteditTextChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QComboBox_sethighlightedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sethighlightedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QComboBox_getactivatedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETSTRING(pObject->getactivatedEvent());
}


RING_FUNC(ring_QComboBox_getcurrentIndexChangedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETSTRING(pObject->getcurrentIndexChangedEvent());
}


RING_FUNC(ring_QComboBox_geteditTextChangedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETSTRING(pObject->geteditTextChangedEvent());
}


RING_FUNC(ring_QComboBox_gethighlightedEvent)
{
	GComboBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GComboBox *) RING_API_GETCPOINTER(1,"QComboBox");
	RING_API_RETSTRING(pObject->gethighlightedEvent());
}


RING_FUNC(ring_QMenuBar_actionAt)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	RING_API_RETCPOINTER(pObject->actionAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint")),"QAction");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QMenuBar_actionGeometry)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->actionGeometry((QAction *) RING_API_GETCPOINTER(2,"QAction"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QMenuBar_activeAction)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	RING_API_RETCPOINTER(pObject->activeAction(),"QAction");
}


RING_FUNC(ring_QMenuBar_addAction)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addAction(RING_API_GETSTRING(2)),"QAction");
}


RING_FUNC(ring_QMenuBar_addMenu)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addMenu(RING_API_GETSTRING(2)),"QMenu");
}


RING_FUNC(ring_QMenuBar_addSeparator)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	RING_API_RETCPOINTER(pObject->addSeparator(),"QAction");
}


RING_FUNC(ring_QMenuBar_clear)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	pObject->clear();
}


RING_FUNC(ring_QMenuBar_cornerWidget)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->cornerWidget( (Qt::Corner)  (int) RING_API_GETNUMBER(2)),"QWidget");
}


RING_FUNC(ring_QMenuBar_insertMenu)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertMenu((QAction *) RING_API_GETCPOINTER(2,"QAction"),(QMenu *) RING_API_GETCPOINTER(3,"QMenu")),"QAction");
}


RING_FUNC(ring_QMenuBar_insertSeparator)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertSeparator((QAction *) RING_API_GETCPOINTER(2,"QAction")),"QAction");
}


RING_FUNC(ring_QMenuBar_isDefaultUp)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	RING_API_RETNUMBER(pObject->isDefaultUp());
}


RING_FUNC(ring_QMenuBar_isNativeMenuBar)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	RING_API_RETNUMBER(pObject->isNativeMenuBar());
}


RING_FUNC(ring_QMenuBar_setActiveAction)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setActiveAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QMenuBar_setCornerWidget)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCornerWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"), (Qt::Corner)  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QMenuBar_setDefaultUp)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultUp( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMenuBar_setNativeMenuBar)
{
	QMenuBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenuBar *) RING_API_GETCPOINTER(1,"QMenuBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNativeMenuBar( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMenu_actionAt)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->actionAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint")),"QAction");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QMenu_actionGeometry)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->actionGeometry((QAction *) RING_API_GETCPOINTER(2,"QAction"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QMenu_activeAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->activeAction(),"QAction");
}


RING_FUNC(ring_QMenu_addAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QMenu_addMenu)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addMenu(RING_API_GETSTRING(2)),"QMenu");
}


RING_FUNC(ring_QMenu_addSeparator)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->addSeparator(),"QAction");
}


RING_FUNC(ring_QMenu_clear)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	pObject->clear();
}


RING_FUNC(ring_QMenu_defaultAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->defaultAction(),"QAction");
}


RING_FUNC(ring_QMenu_exec)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->exec(* (const QPoint  *) RING_API_GETCPOINTER(2,"const QPoint")),"QAction");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QMenu_exec_2)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->exec(),"QAction");
}


RING_FUNC(ring_QMenu_exec_3)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->exec(* (const QPoint  *) RING_API_GETCPOINTER(2,"const QPoint"),(QAction *) RING_API_GETCPOINTER(3,"QAction")),"QAction");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QMenu_hideTearOffMenu)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	pObject->hideTearOffMenu();
}


RING_FUNC(ring_QMenu_icon)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon();
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QMenu_insertMenu)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertMenu((QAction *) RING_API_GETCPOINTER(2,"QAction"),(QMenu *) RING_API_GETCPOINTER(3,"QMenu")),"QAction");
}


RING_FUNC(ring_QMenu_insertSeparator)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertSeparator((QAction *) RING_API_GETCPOINTER(2,"QAction")),"QAction");
}


RING_FUNC(ring_QMenu_isEmpty)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QMenu_isTearOffEnabled)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETNUMBER(pObject->isTearOffEnabled());
}


RING_FUNC(ring_QMenu_isTearOffMenuVisible)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETNUMBER(pObject->isTearOffMenuVisible());
}


RING_FUNC(ring_QMenu_menuAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETCPOINTER(pObject->menuAction(),"QAction");
}


RING_FUNC(ring_QMenu_popup)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->popup(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"),(QAction *) RING_API_GETCPOINTER(3,"QAction"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
}


RING_FUNC(ring_QMenu_separatorsCollapsible)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETNUMBER(pObject->separatorsCollapsible());
}


RING_FUNC(ring_QMenu_setActiveAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setActiveAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QMenu_setDefaultAction)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultAction((QAction *) RING_API_GETCPOINTER(2,"QAction"));
}


RING_FUNC(ring_QMenu_setIcon)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	pObject->setIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QMenu_setSeparatorsCollapsible)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSeparatorsCollapsible( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMenu_setTearOffEnabled)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTearOffEnabled( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMenu_setTitle)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTitle(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMenu_title)
{
	QMenu *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMenu *) RING_API_GETCPOINTER(1,"QMenu");
	RING_API_RETSTRING(pObject->title().toStdString().c_str());
}


RING_FUNC(ring_QToolBar_actionAt)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->actionAt( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QAction");
}


RING_FUNC(ring_QToolBar_addAction)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addAction(RING_API_GETSTRING(2)),"QAction");
}


RING_FUNC(ring_QToolBar_addSeparator)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETCPOINTER(pObject->addSeparator(),"QAction");
}


RING_FUNC(ring_QToolBar_addWidget)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget")),"QAction");
}


RING_FUNC(ring_QToolBar_allowedAreas)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->allowedAreas());
}


RING_FUNC(ring_QToolBar_clear)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	pObject->clear();
}


RING_FUNC(ring_QToolBar_iconSize)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QToolBar_insertSeparator)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertSeparator((QAction *) RING_API_GETCPOINTER(2,"QAction")),"QAction");
}


RING_FUNC(ring_QToolBar_insertWidget)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->insertWidget((QAction *) RING_API_GETCPOINTER(2,"QAction"),(QWidget *) RING_API_GETCPOINTER(3,"QWidget")),"QAction");
}


RING_FUNC(ring_QToolBar_isAreaAllowed)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isAreaAllowed( (Qt::ToolBarArea )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QToolBar_isFloatable)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->isFloatable());
}


RING_FUNC(ring_QToolBar_isFloating)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->isFloating());
}


RING_FUNC(ring_QToolBar_isMovable)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->isMovable());
}


RING_FUNC(ring_QToolBar_orientation)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->orientation());
}


RING_FUNC(ring_QToolBar_setAllowedAreas)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAllowedAreas( (Qt::ToolBarArea )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QToolBar_setFloatable)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFloatable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QToolBar_setMovable)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMovable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QToolBar_setOrientation)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOrientation( (Qt::Orientation )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QToolBar_toggleViewAction)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETCPOINTER(pObject->toggleViewAction(),"QAction");
}


RING_FUNC(ring_QToolBar_toolButtonStyle)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	RING_API_RETNUMBER(pObject->toolButtonStyle());
}


RING_FUNC(ring_QToolBar_widgetForAction)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->widgetForAction((QAction *) RING_API_GETCPOINTER(2,"QAction")),"QWidget");
}


RING_FUNC(ring_QToolBar_setIconSize)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QToolBar_setToolButtonStyle)
{
	QToolBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QToolBar *) RING_API_GETCPOINTER(1,"QToolBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolButtonStyle( (Qt::ToolButtonStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_addDockWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addDockWidget( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2),(QDockWidget *) RING_API_GETCPOINTER(3,"QDockWidget"), (Qt::Orientation )  (int) RING_API_GETNUMBER(4));
}


RING_FUNC(ring_QMainWindow_addToolBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->addToolBar(RING_API_GETSTRING(2)),"QToolBar");
}


RING_FUNC(ring_QMainWindow_addToolBar_2)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addToolBar( (Qt::ToolBarArea )  (int) RING_API_GETNUMBER(2),(QToolBar *) RING_API_GETCPOINTER(3,"QToolBar"));
}


RING_FUNC(ring_QMainWindow_addToolBarBreak)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addToolBarBreak( (Qt::ToolBarArea)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_centralWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETCPOINTER(pObject->centralWidget(),"QWidget");
}


RING_FUNC(ring_QMainWindow_corner)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->corner( (Qt::Corner )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QMainWindow_createPopupMenu)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETCPOINTER(pObject->createPopupMenu(),"QMenu");
}


RING_FUNC(ring_QMainWindow_dockOptions)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->dockOptions());
}


RING_FUNC(ring_QMainWindow_dockWidgetArea)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->dockWidgetArea((QDockWidget *) RING_API_GETCPOINTER(2,"QDockWidget")));
}


RING_FUNC(ring_QMainWindow_documentMode)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->documentMode());
}


RING_FUNC(ring_QMainWindow_iconSize)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QMainWindow_insertToolBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertToolBar((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar"),(QToolBar *) RING_API_GETCPOINTER(3,"QToolBar"));
}


RING_FUNC(ring_QMainWindow_insertToolBarBreak)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertToolBarBreak((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar"));
}


RING_FUNC(ring_QMainWindow_isAnimated)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->isAnimated());
}


RING_FUNC(ring_QMainWindow_isDockNestingEnabled)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->isDockNestingEnabled());
}


RING_FUNC(ring_QMainWindow_menuBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETCPOINTER(pObject->menuBar(),"QMenuBar");
}


RING_FUNC(ring_QMainWindow_menuWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETCPOINTER(pObject->menuWidget(),"QWidget");
}


RING_FUNC(ring_QMainWindow_removeDockWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeDockWidget((QDockWidget *) RING_API_GETCPOINTER(2,"QDockWidget"));
}


RING_FUNC(ring_QMainWindow_removeToolBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeToolBar((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar"));
}


RING_FUNC(ring_QMainWindow_removeToolBarBreak)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeToolBarBreak((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar"));
}


RING_FUNC(ring_QMainWindow_restoreDockWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->restoreDockWidget((QDockWidget *) RING_API_GETCPOINTER(2,"QDockWidget")));
}


RING_FUNC(ring_QMainWindow_restoreState)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->restoreState(* (QByteArray  *) RING_API_GETCPOINTER(2,"QByteArray"), (int ) RING_API_GETNUMBER(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QMainWindow_saveState)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->saveState( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QByteArray");
	}
}


RING_FUNC(ring_QMainWindow_setCentralWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCentralWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QMainWindow_setCorner)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCorner( (Qt::Corner )  (int) RING_API_GETNUMBER(2), (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QMainWindow_setDockOptions)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDockOptions( (QMainWindow::DockOption )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_setDocumentMode)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocumentMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_setIconSize)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QMainWindow_setMenuBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMenuBar((QMenuBar *) RING_API_GETCPOINTER(2,"QMenuBar"));
}


RING_FUNC(ring_QMainWindow_setMenuWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMenuWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QMainWindow_setStatusBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatusBar((QStatusBar *) RING_API_GETCPOINTER(2,"QStatusBar"));
}


RING_FUNC(ring_QMainWindow_setTabPosition)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabPosition( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2), (QTabWidget::TabPosition )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QMainWindow_setTabShape)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabShape( (QTabWidget::TabShape )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_setToolButtonStyle)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolButtonStyle( (Qt::ToolButtonStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_setUnifiedTitleAndToolBarOnMac)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUnifiedTitleAndToolBarOnMac( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMainWindow_splitDockWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->splitDockWidget((QDockWidget *) RING_API_GETCPOINTER(2,"QDockWidget"),(QDockWidget *) RING_API_GETCPOINTER(3,"QDockWidget"), (Qt::Orientation )  (int) RING_API_GETNUMBER(4));
}


RING_FUNC(ring_QMainWindow_statusBar)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETCPOINTER(pObject->statusBar(),"QStatusBar");
}


RING_FUNC(ring_QMainWindow_tabPosition)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->tabPosition( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QMainWindow_tabShape)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->tabShape());
}


RING_FUNC(ring_QMainWindow_tabifyDockWidget)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->tabifyDockWidget((QDockWidget *) RING_API_GETCPOINTER(2,"QDockWidget"),(QDockWidget *) RING_API_GETCPOINTER(3,"QDockWidget"));
}


RING_FUNC(ring_QMainWindow_toolBarArea)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toolBarArea((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar")));
}


RING_FUNC(ring_QMainWindow_toolBarBreak)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->toolBarBreak((QToolBar *) RING_API_GETCPOINTER(2,"QToolBar")));
}


RING_FUNC(ring_QMainWindow_toolButtonStyle)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->toolButtonStyle());
}


RING_FUNC(ring_QMainWindow_unifiedTitleAndToolBarOnMac)
{
	QMainWindow *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMainWindow *) RING_API_GETCPOINTER(1,"QMainWindow");
	RING_API_RETNUMBER(pObject->unifiedTitleAndToolBarOnMac());
}


RING_FUNC(ring_QStatusBar_addPermanentWidget)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addPermanentWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QStatusBar_addWidget)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QStatusBar_currentMessage)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	RING_API_RETSTRING(pObject->currentMessage().toStdString().c_str());
}


RING_FUNC(ring_QStatusBar_insertPermanentWidget)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->insertPermanentWidget( (int ) RING_API_GETNUMBER(2),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QStatusBar_insertWidget)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->insertWidget( (int ) RING_API_GETNUMBER(2),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"), (int ) RING_API_GETNUMBER(4)));
}


RING_FUNC(ring_QStatusBar_isSizeGripEnabled)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	RING_API_RETNUMBER(pObject->isSizeGripEnabled());
}


RING_FUNC(ring_QStatusBar_removeWidget)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QStatusBar_setSizeGripEnabled)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSizeGripEnabled( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QStatusBar_clearMessage)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	pObject->clearMessage();
}


RING_FUNC(ring_QStatusBar_showMessage)
{
	QStatusBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QStatusBar *) RING_API_GETCPOINTER(1,"QStatusBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->showMessage(RING_API_GETSTRING(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QDockWidget_allowedAreas)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETNUMBER(pObject->allowedAreas());
}


RING_FUNC(ring_QDockWidget_features)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETNUMBER(pObject->features());
}


RING_FUNC(ring_QDockWidget_isAreaAllowed)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isAreaAllowed( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QDockWidget_isFloating)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETNUMBER(pObject->isFloating());
}


RING_FUNC(ring_QDockWidget_setAllowedAreas)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAllowedAreas( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_setFeatures)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFeatures( (QDockWidget::DockWidgetFeature )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_setFloating)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFloating( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_setTitleBarWidget)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTitleBarWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QDockWidget_setWidget)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QDockWidget_titleBarWidget)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETCPOINTER(pObject->titleBarWidget(),"QWidget");
}


RING_FUNC(ring_QDockWidget_toggleViewAction)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETCPOINTER(pObject->toggleViewAction(),"QAction");
}


RING_FUNC(ring_QDockWidget_widget)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	RING_API_RETCPOINTER(pObject->widget(),"QWidget");
}


RING_FUNC(ring_QDockWidget_allowedAreasChanged)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->allowedAreasChanged( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_dockLocationChanged)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->dockLocationChanged( (Qt::DockWidgetArea )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_featuresChanged)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->featuresChanged( (QDockWidget::DockWidgetFeature )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_topLevelChanged)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->topLevelChanged( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDockWidget_visibilityChanged)
{
	QDockWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDockWidget *) RING_API_GETCPOINTER(1,"QDockWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->visibilityChanged( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_addTab)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->addTab((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QTabWidget_clear)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	pObject->clear();
}


RING_FUNC(ring_QTabWidget_cornerWidget)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->cornerWidget( (Qt::Corner )  (int) RING_API_GETNUMBER(2)),"QWidget");
}


RING_FUNC(ring_QTabWidget_count)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->count());
}


RING_FUNC(ring_QTabWidget_currentIndex)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->currentIndex());
}


RING_FUNC(ring_QTabWidget_currentWidget)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETCPOINTER(pObject->currentWidget(),"QWidget");
}


RING_FUNC(ring_QTabWidget_documentMode)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->documentMode());
}


RING_FUNC(ring_QTabWidget_elideMode)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->elideMode());
}


RING_FUNC(ring_QTabWidget_iconSize)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QTabWidget_indexOf)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->indexOf((QWidget *) RING_API_GETCPOINTER(2,"QWidget")));
}


RING_FUNC(ring_QTabWidget_insertTab)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->insertTab( (int ) RING_API_GETNUMBER(2),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"),RING_API_GETSTRING(4)));
}


RING_FUNC(ring_QTabWidget_isMovable)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->isMovable());
}


RING_FUNC(ring_QTabWidget_isTabEnabled)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isTabEnabled( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTabWidget_removeTab)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeTab( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setCornerWidget)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCornerWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"), (Qt::Corner )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTabWidget_setDocumentMode)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocumentMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setElideMode)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setElideMode( (Qt::TextElideMode)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setIconSize)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QTabWidget_setMovable)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMovable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setTabEnabled)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabEnabled( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTabWidget_setTabIcon)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabIcon( (int ) RING_API_GETNUMBER(2),* (QIcon *) RING_API_GETCPOINTER(3,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QIcon"));
}


RING_FUNC(ring_QTabWidget_setTabText)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabText( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTabWidget_setTabToolTip)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabToolTip( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTabWidget_setTabWhatsThis)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabWhatsThis( (int ) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QTabWidget_setTabsClosable)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabsClosable( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setUsesScrollButtons)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUsesScrollButtons( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_tabIcon)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->tabIcon( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QTabWidget_tabText)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->tabText( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTabWidget_tabToolTip)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->tabToolTip( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTabWidget_tabWhatsThis)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->tabWhatsThis( (int ) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QTabWidget_tabsClosable)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->tabsClosable());
}


RING_FUNC(ring_QTabWidget_usesScrollButtons)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETNUMBER(pObject->usesScrollButtons());
}


RING_FUNC(ring_QTabWidget_widget)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->widget( (int ) RING_API_GETNUMBER(2)),"QWidget");
}


RING_FUNC(ring_QTabWidget_heightForWidth)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->heightForWidth( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTabWidget_minimumSizeHint)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QTabWidget_sizeHint)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QTabWidget_setCurrentIndex)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentIndex( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTabWidget_setCurrentWidget)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QTabWidget_setcurrentChangedEvent)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTabWidget_settabCloseRequestedEvent)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settabCloseRequestedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTabWidget_getcurrentChangedEvent)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETSTRING(pObject->getcurrentChangedEvent());
}


RING_FUNC(ring_QTabWidget_gettabCloseRequestedEvent)
{
	GTabWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTabWidget *) RING_API_GETCPOINTER(1,"QTabWidget");
	RING_API_RETSTRING(pObject->gettabCloseRequestedEvent());
}


RING_FUNC(ring_QTableWidgetItem_background)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->background();
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QTableWidgetItem_checkState)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->checkState());
}


RING_FUNC(ring_QTableWidgetItem_clone)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETCPOINTER(pObject->clone(),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidgetItem_column)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->column());
}


RING_FUNC(ring_QTableWidgetItem_data)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->data( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QTableWidgetItem_flags)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->flags());
}


RING_FUNC(ring_QTableWidgetItem_font)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QTableWidgetItem_foreground)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->foreground();
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QTableWidgetItem_icon)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon();
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QTableWidgetItem_isSelected)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->isSelected());
}


RING_FUNC(ring_QTableWidgetItem_read)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->read(* (QDataStream *) RING_API_GETCPOINTER(2,"QDataStream"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDataStream"));
}


RING_FUNC(ring_QTableWidgetItem_row)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->row());
}


RING_FUNC(ring_QTableWidgetItem_setBackground)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->setBackground(* (QBrush *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QTableWidgetItem_setCheckState)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCheckState( (Qt::CheckState )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidgetItem_setData)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setData( (int ) RING_API_GETNUMBER(2),* (QVariant *) RING_API_GETCPOINTER(3,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QVariant"));
}


RING_FUNC(ring_QTableWidgetItem_setFlags)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFlags( (Qt::ItemFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidgetItem_setFont)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->setFont(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QTableWidgetItem_setForeground)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->setForeground(* (QBrush *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QTableWidgetItem_setIcon)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->setIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QTableWidgetItem_setSelected)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelected( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidgetItem_setSizeHint)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->setSizeHint(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QTableWidgetItem_setStatusTip)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatusTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidgetItem_setText)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidgetItem_setTextAlignment)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextAlignment( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidgetItem_setToolTip)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidgetItem_setWhatsThis)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWhatsThis(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidgetItem_sizeHint)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QTableWidgetItem_statusTip)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETSTRING(pObject->statusTip().toStdString().c_str());
}


RING_FUNC(ring_QTableWidgetItem_tableWidget)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETCPOINTER(pObject->tableWidget(),"QTableWidget");
}


RING_FUNC(ring_QTableWidgetItem_text)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QTableWidgetItem_textAlignment)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->textAlignment());
}


RING_FUNC(ring_QTableWidgetItem_toolTip)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETSTRING(pObject->toolTip().toStdString().c_str());
}


RING_FUNC(ring_QTableWidgetItem_type)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QTableWidgetItem_whatsThis)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	RING_API_RETSTRING(pObject->whatsThis().toStdString().c_str());
}


RING_FUNC(ring_QTableWidgetItem_write)
{
	QTableWidgetItem *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableWidgetItem *) RING_API_GETCPOINTER(1,"QTableWidgetItem");
	pObject->write(* (QDataStream *) RING_API_GETCPOINTER(2,"QDataStream"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDataStream"));
}


RING_FUNC(ring_QFrame_frameRect)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->frameRect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QFrame_frameShadow)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->frameShadow());
}


RING_FUNC(ring_QFrame_frameShape)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->frameShape());
}


RING_FUNC(ring_QFrame_frameStyle)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->frameStyle());
}


RING_FUNC(ring_QFrame_frameWidth)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->frameWidth());
}


RING_FUNC(ring_QFrame_lineWidth)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->lineWidth());
}


RING_FUNC(ring_QFrame_midLineWidth)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	RING_API_RETNUMBER(pObject->midLineWidth());
}


RING_FUNC(ring_QFrame_setFrameRect)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	pObject->setFrameRect(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
}


RING_FUNC(ring_QFrame_setFrameShadow)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrameShadow( (QFrame::Shadow)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFrame_setFrameShape)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrameShape( (QFrame::Shape)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFrame_setFrameStyle)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrameStyle( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFrame_setLineWidth)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLineWidth( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFrame_setMidLineWidth)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMidLineWidth( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFrame_sizeHint)
{
	QFrame *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFrame *) RING_API_GETCPOINTER(1,"QFrame");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QAbstractScrollArea_addScrollBarWidget)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addScrollBarWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"), (Qt::AlignmentFlag )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QAbstractScrollArea_cornerWidget)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETCPOINTER(pObject->cornerWidget(),"QWidget");
}


RING_FUNC(ring_QAbstractScrollArea_horizontalScrollBar)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETCPOINTER(pObject->horizontalScrollBar(),"QScrollBar");
}


RING_FUNC(ring_QAbstractScrollArea_horizontalScrollBarPolicy)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETNUMBER(pObject->horizontalScrollBarPolicy());
}


RING_FUNC(ring_QAbstractScrollArea_maximumViewportSize)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->maximumViewportSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QAbstractScrollArea_scrollBarWidgets)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QWidgetList *pValue ; 
		pValue = (QWidgetList *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QWidgetList)) ;
		*pValue = pObject->scrollBarWidgets( (Qt::AlignmentFlag)  (int) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QWidgetList");
	}
}


RING_FUNC(ring_QAbstractScrollArea_setCornerWidget)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCornerWidget((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QAbstractScrollArea_setHorizontalScrollBar)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHorizontalScrollBar((QScrollBar *) RING_API_GETCPOINTER(2,"QScrollBar"));
}


RING_FUNC(ring_QAbstractScrollArea_setHorizontalScrollBarPolicy)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHorizontalScrollBarPolicy( (Qt::ScrollBarPolicy)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractScrollArea_setVerticalScrollBar)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalScrollBar((QScrollBar *) RING_API_GETCPOINTER(2,"QScrollBar"));
}


RING_FUNC(ring_QAbstractScrollArea_setVerticalScrollBarPolicy)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalScrollBarPolicy( (Qt::ScrollBarPolicy)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractScrollArea_setViewport)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewport((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QAbstractScrollArea_verticalScrollBar)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETCPOINTER(pObject->verticalScrollBar(),"QScrollBar");
}


RING_FUNC(ring_QAbstractScrollArea_verticalScrollBarPolicy)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETNUMBER(pObject->verticalScrollBarPolicy());
}


RING_FUNC(ring_QAbstractScrollArea_viewport)
{
	QAbstractScrollArea *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractScrollArea *) RING_API_GETCPOINTER(1,"QAbstractScrollArea");
	RING_API_RETCPOINTER(pObject->viewport(),"QWidget");
}


RING_FUNC(ring_QAbstractItemView_alternatingRowColors)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->alternatingRowColors());
}


RING_FUNC(ring_QAbstractItemView_autoScrollMargin)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->autoScrollMargin());
}


RING_FUNC(ring_QAbstractItemView_closePersistentEditor)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->closePersistentEditor(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_currentIndex)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->currentIndex();
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QAbstractItemView_defaultDropAction)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->defaultDropAction());
}


RING_FUNC(ring_QAbstractItemView_dragDropMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->dragDropMode());
}


RING_FUNC(ring_QAbstractItemView_dragDropOverwriteMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->dragDropOverwriteMode());
}


RING_FUNC(ring_QAbstractItemView_dragEnabled)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->dragEnabled());
}


RING_FUNC(ring_QAbstractItemView_editTriggers)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->editTriggers());
}


RING_FUNC(ring_QAbstractItemView_hasAutoScroll)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->hasAutoScroll());
}


RING_FUNC(ring_QAbstractItemView_horizontalScrollMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->horizontalScrollMode());
}


RING_FUNC(ring_QAbstractItemView_iconSize)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QAbstractItemView_indexAt)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->indexAt(* (QPoint *) RING_API_GETCPOINTER(2,"QPoint"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPoint"));
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QAbstractItemView_indexWidget)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETCPOINTER(pObject->indexWidget(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")),"QWidget");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_itemDelegate)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETCPOINTER(pObject->itemDelegate(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex")),"QAbstractItemDelegate");
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_itemDelegateForColumn)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemDelegateForColumn( (int ) RING_API_GETNUMBER(2)),"QAbstractItemDelegate");
}


RING_FUNC(ring_QAbstractItemView_itemDelegateForRow)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemDelegateForRow( (int ) RING_API_GETNUMBER(2)),"QAbstractItemDelegate");
}


RING_FUNC(ring_QAbstractItemView_keyboardSearch)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->keyboardSearch(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAbstractItemView_model)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETCPOINTER(pObject->model(),"QAbstractItemModel");
}


RING_FUNC(ring_QAbstractItemView_openPersistentEditor)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->openPersistentEditor(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_rootIndex)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QModelIndex *pValue ; 
		pValue = (QModelIndex *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QModelIndex)) ;
		*pValue = pObject->rootIndex();
		RING_API_RETCPOINTER(pValue,"QModelIndex");
	}
}


RING_FUNC(ring_QAbstractItemView_scrollTo)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollTo(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"), (QAbstractItemView::ScrollHint)  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_selectionBehavior)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->selectionBehavior());
}


RING_FUNC(ring_QAbstractItemView_selectionMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->selectionMode());
}


RING_FUNC(ring_QAbstractItemView_selectionModel)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETCPOINTER(pObject->selectionModel(),"QItemSelectionModel");
}


RING_FUNC(ring_QAbstractItemView_setAlternatingRowColors)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlternatingRowColors( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setAutoScroll)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoScroll( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setAutoScrollMargin)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoScrollMargin( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setDefaultDropAction)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultDropAction( (Qt::DropAction )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setDragDropMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDragDropMode( (QAbstractItemView::DragDropMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setDragDropOverwriteMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDragDropOverwriteMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setDragEnabled)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDragEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setDropIndicatorShown)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDropIndicatorShown( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setEditTriggers)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEditTriggers( (QAbstractItemView::EditTrigger )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setHorizontalScrollMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHorizontalScrollMode( (QAbstractItemView::ScrollMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setIconSize)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QAbstractItemView_setIndexWidget)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIndexWidget(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"),(QWidget *) RING_API_GETCPOINTER(3,"QWidget"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_setItemDelegate)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemDelegate((QAbstractItemDelegate *) RING_API_GETCPOINTER(2,"QAbstractItemDelegate"));
}


RING_FUNC(ring_QAbstractItemView_setItemDelegateForColumn)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemDelegateForColumn( (int ) RING_API_GETNUMBER(2),(QAbstractItemDelegate *) RING_API_GETCPOINTER(3,"QAbstractItemDelegate"));
}


RING_FUNC(ring_QAbstractItemView_setItemDelegateForRow)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemDelegateForRow( (int ) RING_API_GETNUMBER(2),(QAbstractItemDelegate *) RING_API_GETCPOINTER(3,"QAbstractItemDelegate"));
}


RING_FUNC(ring_QAbstractItemView_setModel)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setModel((QAbstractItemModel *) RING_API_GETCPOINTER(2,"QAbstractItemModel"));
}


RING_FUNC(ring_QAbstractItemView_setSelectionBehavior)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectionBehavior( (QAbstractItemView::SelectionBehavior )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setSelectionMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectionMode( (QAbstractItemView::SelectionMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setSelectionModel)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectionModel((QItemSelectionModel *) RING_API_GETCPOINTER(2,"QItemSelectionModel"));
}


RING_FUNC(ring_QAbstractItemView_setTabKeyNavigation)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTabKeyNavigation( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setTextElideMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextElideMode( (Qt::TextElideMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_setVerticalScrollMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalScrollMode( (QAbstractItemView::ScrollMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractItemView_showDropIndicator)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->showDropIndicator());
}


RING_FUNC(ring_QAbstractItemView_sizeHintForColumn)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->sizeHintForColumn( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QAbstractItemView_sizeHintForIndex)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHintForIndex(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QAbstractItemView_sizeHintForRow)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->sizeHintForRow( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QAbstractItemView_tabKeyNavigation)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->tabKeyNavigation());
}


RING_FUNC(ring_QAbstractItemView_textElideMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->textElideMode());
}


RING_FUNC(ring_QAbstractItemView_verticalScrollMode)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	RING_API_RETNUMBER(pObject->verticalScrollMode());
}


RING_FUNC(ring_QAbstractItemView_visualRect)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->visualRect(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QAbstractItemView_clearSelection)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->clearSelection();
}


RING_FUNC(ring_QAbstractItemView_edit)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->edit(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_scrollToBottom)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->scrollToBottom();
}


RING_FUNC(ring_QAbstractItemView_scrollToTop)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->scrollToTop();
}


RING_FUNC(ring_QAbstractItemView_setCurrentIndex)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->setCurrentIndex(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QAbstractItemView_update)
{
	QAbstractItemView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractItemView *) RING_API_GETCPOINTER(1,"QAbstractItemView");
	pObject->update(* (QModelIndex *) RING_API_GETCPOINTER(2,"QModelIndex"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QModelIndex"));
}


RING_FUNC(ring_QTableView_clearSpans)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	pObject->clearSpans();
}


RING_FUNC(ring_QTableView_columnAt)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnAt( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_columnSpan)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnSpan( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QTableView_columnViewportPosition)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnViewportPosition( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_columnWidth)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->columnWidth( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_gridStyle)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETNUMBER(pObject->gridStyle());
}


RING_FUNC(ring_QTableView_horizontalHeader)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETCPOINTER(pObject->horizontalHeader(),"QHeaderView");
}


RING_FUNC(ring_QTableView_isColumnHidden)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isColumnHidden( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_isCornerButtonEnabled)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETNUMBER(pObject->isCornerButtonEnabled());
}


RING_FUNC(ring_QTableView_isRowHidden)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isRowHidden( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_isSortingEnabled)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETNUMBER(pObject->isSortingEnabled());
}


RING_FUNC(ring_QTableView_rowAt)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rowAt( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_rowHeight)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rowHeight( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_rowSpan)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rowSpan( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QTableView_rowViewportPosition)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->rowViewportPosition( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableView_setColumnHidden)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnHidden( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableView_setColumnWidth)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnWidth( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableView_setCornerButtonEnabled)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCornerButtonEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_setGridStyle)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGridStyle( (Qt::PenStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_setHorizontalHeader)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHorizontalHeader((QHeaderView *) RING_API_GETCPOINTER(2,"QHeaderView"));
}


RING_FUNC(ring_QTableView_setRowHeight)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRowHeight( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableView_setRowHidden)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRowHidden( (int ) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableView_setSortingEnabled)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSortingEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_setSpan)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSpan( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QTableView_setVerticalHeader)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalHeader((QHeaderView *) RING_API_GETCPOINTER(2,"QHeaderView"));
}


RING_FUNC(ring_QTableView_setWordWrap)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordWrap( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_showGrid)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETNUMBER(pObject->showGrid());
}


RING_FUNC(ring_QTableView_sortByColumn)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortByColumn( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableView_verticalHeader)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETCPOINTER(pObject->verticalHeader(),"QHeaderView");
}


RING_FUNC(ring_QTableView_wordWrap)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	RING_API_RETNUMBER(pObject->wordWrap());
}


RING_FUNC(ring_QTableView_hideColumn)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->hideColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_hideRow)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->hideRow( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_resizeColumnToContents)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resizeColumnToContents( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_resizeColumnsToContents)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	pObject->resizeColumnsToContents();
}


RING_FUNC(ring_QTableView_resizeRowToContents)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->resizeRowToContents( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_resizeRowsToContents)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	pObject->resizeRowsToContents();
}


RING_FUNC(ring_QTableView_selectColumn)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_selectRow)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectRow( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_setShowGrid)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShowGrid( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_showColumn)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->showColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableView_showRow)
{
	QTableView *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QTableView *) RING_API_GETCPOINTER(1,"QTableView");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->showRow( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_cellWidget)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->cellWidget( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QWidget");
}


RING_FUNC(ring_QTableWidget_closePersistentEditor)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->closePersistentEditor((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_column)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->column((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem")));
}


RING_FUNC(ring_QTableWidget_columnCount)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETNUMBER(pObject->columnCount());
}


RING_FUNC(ring_QTableWidget_currentColumn)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETNUMBER(pObject->currentColumn());
}


RING_FUNC(ring_QTableWidget_currentItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETCPOINTER(pObject->currentItem(),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_currentRow)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETNUMBER(pObject->currentRow());
}


RING_FUNC(ring_QTableWidget_editItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->editItem((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_horizontalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->horizontalHeaderItem( (int ) RING_API_GETNUMBER(2)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_item)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->item( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_itemAt)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->itemAt( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_itemPrototype)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETCPOINTER(pObject->itemPrototype(),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_openPersistentEditor)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->openPersistentEditor((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_removeCellWidget)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeCellWidget( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableWidget_row)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->row((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem")));
}


RING_FUNC(ring_QTableWidget_rowCount)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETNUMBER(pObject->rowCount());
}


RING_FUNC(ring_QTableWidget_selectedItems)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	{
		QList<QTableWidgetItem *> *pValue ; 
		pValue = (QList<QTableWidgetItem *> *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QList<QTableWidgetItem *>)) ;
		*pValue = pObject->selectedItems();
		RING_API_RETCPOINTER(pValue,"QList<QTableWidgetItem *>");
	}
}


RING_FUNC(ring_QTableWidget_selectedRanges)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	{
		QList<QTableWidgetSelectionRange> *pValue ; 
		pValue = (QList<QTableWidgetSelectionRange> *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QList<QTableWidgetSelectionRange>)) ;
		*pValue = pObject->selectedRanges();
		RING_API_RETCPOINTER(pValue,"QList<QTableWidgetSelectionRange>");
	}
}


RING_FUNC(ring_QTableWidget_setCellWidget)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCellWidget( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),(QWidget *) RING_API_GETCPOINTER(4,"QWidget"));
}


RING_FUNC(ring_QTableWidget_setColumnCount)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColumnCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_setCurrentCell)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentCell( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableWidget_setCurrentItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentItem((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_setHorizontalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHorizontalHeaderItem( (int ) RING_API_GETNUMBER(2),(QTableWidgetItem *) RING_API_GETCPOINTER(3,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_setHorizontalHeaderLabels)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	pObject->setHorizontalHeaderLabels(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QTableWidget_setItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItem( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),(QTableWidgetItem *) RING_API_GETCPOINTER(4,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_setItemPrototype)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemPrototype((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_setRowCount)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRowCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_setVerticalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVerticalHeaderItem( (int ) RING_API_GETNUMBER(2),(QTableWidgetItem *) RING_API_GETCPOINTER(3,"QTableWidgetItem"));
}


RING_FUNC(ring_QTableWidget_sortItems)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sortItems( (int ) RING_API_GETNUMBER(2), (Qt::SortOrder )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableWidget_takeHorizontalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeHorizontalHeaderItem( (int ) RING_API_GETNUMBER(2)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_takeItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeItem( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_takeVerticalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->takeVerticalHeaderItem( (int ) RING_API_GETNUMBER(2)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_verticalHeaderItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->verticalHeaderItem( (int ) RING_API_GETNUMBER(2)),"QTableWidgetItem");
}


RING_FUNC(ring_QTableWidget_visualColumn)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->visualColumn( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableWidget_visualItemRect)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->visualItemRect((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QTableWidget_visualRow)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->visualRow( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QTableWidget_clear)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	pObject->clear();
}


RING_FUNC(ring_QTableWidget_clearContents)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	pObject->clearContents();
}


RING_FUNC(ring_QTableWidget_insertColumn)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_insertRow)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->insertRow( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_removeColumn)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeColumn( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_removeRow)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeRow( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTableWidget_scrollToItem)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scrollToItem((QTableWidgetItem *) RING_API_GETCPOINTER(2,"QTableWidgetItem"), (QAbstractItemView::ScrollHint )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QTableWidget_setcellActivatedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellActivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcellChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcellClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcellDoubleClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellDoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcellEnteredEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcellPressedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcellPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcurrentCellChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentCellChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setcurrentItemChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcurrentItemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemActivatedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemActivatedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemDoubleClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemDoubleClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemEnteredEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemEnteredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemPressedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_setitemSelectionChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setitemSelectionChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTableWidget_getcellActivatedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellActivatedEvent());
}


RING_FUNC(ring_QTableWidget_getcellChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellChangedEvent());
}


RING_FUNC(ring_QTableWidget_getcellClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellClickedEvent());
}


RING_FUNC(ring_QTableWidget_getcellDoubleClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellDoubleClickedEvent());
}


RING_FUNC(ring_QTableWidget_getcellEnteredEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellEnteredEvent());
}


RING_FUNC(ring_QTableWidget_getcellPressedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcellPressedEvent());
}


RING_FUNC(ring_QTableWidget_getcurrentCellChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcurrentCellChangedEvent());
}


RING_FUNC(ring_QTableWidget_getcurrentItemChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getcurrentItemChangedEvent());
}


RING_FUNC(ring_QTableWidget_getitemActivatedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemActivatedEvent());
}


RING_FUNC(ring_QTableWidget_getitemChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemChangedEvent());
}


RING_FUNC(ring_QTableWidget_getitemClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemClickedEvent());
}


RING_FUNC(ring_QTableWidget_getitemDoubleClickedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemDoubleClickedEvent());
}


RING_FUNC(ring_QTableWidget_getitemEnteredEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemEnteredEvent());
}


RING_FUNC(ring_QTableWidget_getitemPressedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemPressedEvent());
}


RING_FUNC(ring_QTableWidget_getitemSelectionChangedEvent)
{
	GTableWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTableWidget *) RING_API_GETCPOINTER(1,"QTableWidget");
	RING_API_RETSTRING(pObject->getitemSelectionChangedEvent());
}


RING_FUNC(ring_QProgressBar_alignment)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->alignment());
}


RING_FUNC(ring_QProgressBar_format)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETSTRING(pObject->format().toStdString().c_str());
}


RING_FUNC(ring_QProgressBar_invertedAppearance)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->invertedAppearance());
}


RING_FUNC(ring_QProgressBar_isTextVisible)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->isTextVisible());
}


RING_FUNC(ring_QProgressBar_maximum)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->maximum());
}


RING_FUNC(ring_QProgressBar_minimum)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->minimum());
}


RING_FUNC(ring_QProgressBar_orientation)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->orientation());
}


RING_FUNC(ring_QProgressBar_resetFormat)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	pObject->resetFormat();
}


RING_FUNC(ring_QProgressBar_setAlignment)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlignment( (Qt::AlignmentFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setFormat)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFormat(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProgressBar_setInvertedAppearance)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInvertedAppearance( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setTextDirection)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextDirection( (QProgressBar::Direction )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setTextVisible)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextVisible( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_text)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QProgressBar_textDirection)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->textDirection());
}


RING_FUNC(ring_QProgressBar_value)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETNUMBER(pObject->value());
}


RING_FUNC(ring_QProgressBar_reset)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	pObject->reset();
}


RING_FUNC(ring_QProgressBar_setMaximum)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximum( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setMinimum)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimum( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setOrientation)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOrientation( (Qt::Orientation)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setRange)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRange( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QProgressBar_setValue)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setValue( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QProgressBar_setvalueChangedEvent)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvalueChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QProgressBar_getvalueChangedEvent)
{
	GProgressBar *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GProgressBar *) RING_API_GETCPOINTER(1,"QProgressBar");
	RING_API_RETSTRING(pObject->getvalueChangedEvent());
}


RING_FUNC(ring_QSpinBox_cleanText)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETSTRING(pObject->cleanText().toStdString().c_str());
}


RING_FUNC(ring_QSpinBox_displayIntegerBase)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETNUMBER(pObject->displayIntegerBase());
}


RING_FUNC(ring_QSpinBox_maximum)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETNUMBER(pObject->maximum());
}


RING_FUNC(ring_QSpinBox_minimum)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETNUMBER(pObject->minimum());
}


RING_FUNC(ring_QSpinBox_prefix)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETSTRING(pObject->prefix().toStdString().c_str());
}


RING_FUNC(ring_QSpinBox_setDisplayIntegerBase)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDisplayIntegerBase( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSpinBox_setMaximum)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximum( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSpinBox_setMinimum)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimum( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSpinBox_setPrefix)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPrefix(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSpinBox_setRange)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRange( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QSpinBox_setSingleStep)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSingleStep( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSpinBox_setSuffix)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSuffix(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSpinBox_singleStep)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETNUMBER(pObject->singleStep());
}


RING_FUNC(ring_QSpinBox_suffix)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETSTRING(pObject->suffix().toStdString().c_str());
}


RING_FUNC(ring_QSpinBox_value)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETNUMBER(pObject->value());
}


RING_FUNC(ring_QSpinBox_setValue)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setValue( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSpinBox_setvalueChangedEvent)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvalueChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSpinBox_getvalueChangedEvent)
{
	GSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSpinBox *) RING_API_GETCPOINTER(1,"QSpinBox");
	RING_API_RETSTRING(pObject->getvalueChangedEvent());
}


RING_FUNC(ring_QAbstractSlider_hasTracking)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->hasTracking());
}


RING_FUNC(ring_QAbstractSlider_invertedAppearance)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->invertedAppearance());
}


RING_FUNC(ring_QAbstractSlider_invertedControls)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->invertedControls());
}


RING_FUNC(ring_QAbstractSlider_isSliderDown)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->isSliderDown());
}


RING_FUNC(ring_QAbstractSlider_maximum)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->maximum());
}


RING_FUNC(ring_QAbstractSlider_minimum)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->minimum());
}


RING_FUNC(ring_QAbstractSlider_orientation)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->orientation());
}


RING_FUNC(ring_QAbstractSlider_pageStep)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->pageStep());
}


RING_FUNC(ring_QAbstractSlider_setInvertedAppearance)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInvertedAppearance( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setInvertedControls)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInvertedControls( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setMaximum)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMaximum( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setMinimum)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMinimum( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setPageStep)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPageStep( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setSingleStep)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSingleStep( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setSliderDown)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSliderDown( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setSliderPosition)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSliderPosition( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setTracking)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTracking( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_singleStep)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->singleStep());
}


RING_FUNC(ring_QAbstractSlider_sliderPosition)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->sliderPosition());
}


RING_FUNC(ring_QAbstractSlider_triggerAction)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->triggerAction( (QAbstractSlider::SliderAction )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_value)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	RING_API_RETNUMBER(pObject->value());
}


RING_FUNC(ring_QAbstractSlider_setOrientation)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOrientation( (Qt::Orientation)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSlider_setRange)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRange( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QAbstractSlider_setValue)
{
	QAbstractSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSlider *) RING_API_GETCPOINTER(1,"QAbstractSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setValue( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSlider_setTickInterval)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTickInterval( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSlider_setTickPosition)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTickPosition( (QSlider::TickPosition )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QSlider_tickInterval)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETNUMBER(pObject->tickInterval());
}


RING_FUNC(ring_QSlider_tickPosition)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETNUMBER(pObject->tickPosition());
}


RING_FUNC(ring_QSlider_minimumSizeHint)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QSlider_sizeHint)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QSlider_setactionTriggeredEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactionTriggeredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_setrangeChangedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setrangeChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_setsliderMovedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderMovedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_setsliderPressedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_setsliderReleasedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderReleasedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_setvalueChangedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvalueChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QSlider_getactionTriggeredEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getactionTriggeredEvent());
}


RING_FUNC(ring_QSlider_getrangeChangedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getrangeChangedEvent());
}


RING_FUNC(ring_QSlider_getsliderMovedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getsliderMovedEvent());
}


RING_FUNC(ring_QSlider_getsliderPressedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getsliderPressedEvent());
}


RING_FUNC(ring_QSlider_getsliderReleasedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getsliderReleasedEvent());
}


RING_FUNC(ring_QSlider_getvalueChangedEvent)
{
	GSlider *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GSlider *) RING_API_GETCPOINTER(1,"QSlider");
	RING_API_RETSTRING(pObject->getvalueChangedEvent());
}


RING_FUNC(ring_QDateTimeEdit_calendarPopup)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->calendarPopup());
}


RING_FUNC(ring_QDateTimeEdit_calendarWidget)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETCPOINTER(pObject->calendarWidget(),"QCalendarWidget");
}


RING_FUNC(ring_QDateTimeEdit_clearMaximumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMaximumDate();
}


RING_FUNC(ring_QDateTimeEdit_clearMaximumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMaximumDateTime();
}


RING_FUNC(ring_QDateTimeEdit_clearMaximumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMaximumTime();
}


RING_FUNC(ring_QDateTimeEdit_clearMinimumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMinimumDate();
}


RING_FUNC(ring_QDateTimeEdit_clearMinimumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMinimumDateTime();
}


RING_FUNC(ring_QDateTimeEdit_clearMinimumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->clearMinimumTime();
}


RING_FUNC(ring_QDateTimeEdit_currentSection)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->currentSection());
}


RING_FUNC(ring_QDateTimeEdit_currentSectionIndex)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->currentSectionIndex());
}


RING_FUNC(ring_QDateTimeEdit_date)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->date();
		RING_API_RETCPOINTER(pValue,"QDate");
	}
}


RING_FUNC(ring_QDateTimeEdit_dateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->dateTime();
		RING_API_RETCPOINTER(pValue,"QDateTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_displayFormat)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETSTRING(pObject->displayFormat().toStdString().c_str());
}


RING_FUNC(ring_QDateTimeEdit_displayedSections)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->displayedSections());
}


RING_FUNC(ring_QDateTimeEdit_maximumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->maximumDate();
		RING_API_RETCPOINTER(pValue,"QDate");
	}
}


RING_FUNC(ring_QDateTimeEdit_maximumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->maximumDateTime();
		RING_API_RETCPOINTER(pValue,"QDateTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_maximumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->maximumTime();
		RING_API_RETCPOINTER(pValue,"QTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_minimumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDate *pValue ; 
		pValue = new QDate() ;
		*pValue = pObject->minimumDate();
		RING_API_RETCPOINTER(pValue,"QDate");
	}
}


RING_FUNC(ring_QDateTimeEdit_minimumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QDateTime *pValue ; 
		pValue = new QDateTime() ;
		*pValue = pObject->minimumDateTime();
		RING_API_RETCPOINTER(pValue,"QDateTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_minimumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->minimumTime();
		RING_API_RETCPOINTER(pValue,"QTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_sectionAt)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->sectionAt( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QDateTimeEdit_sectionCount)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->sectionCount());
}


RING_FUNC(ring_QDateTimeEdit_sectionText)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->sectionText( (QDateTimeEdit::Section )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QDateTimeEdit_setCalendarPopup)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCalendarPopup( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTimeEdit_setCalendarWidget)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCalendarWidget((QCalendarWidget *) RING_API_GETCPOINTER(2,"QCalendarWidget"));
}


RING_FUNC(ring_QDateTimeEdit_setCurrentSection)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentSection( (QDateTimeEdit::Section )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTimeEdit_setCurrentSectionIndex)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentSectionIndex( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTimeEdit_setDateRange)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setDateRange(* (QDate *) RING_API_GETCPOINTER(2,"QDate"),* (QDate *) RING_API_GETCPOINTER(3,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QDate"));
}


RING_FUNC(ring_QDateTimeEdit_setDateTimeRange)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setDateTimeRange(* (QDateTime *) RING_API_GETCPOINTER(2,"QDateTime"),* (QDateTime *) RING_API_GETCPOINTER(3,"QDateTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QDateTime"));
}


RING_FUNC(ring_QDateTimeEdit_setDisplayFormat)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDisplayFormat(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDateTimeEdit_setMaximumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMaximumDate(* (QDate *) RING_API_GETCPOINTER(2,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
}


RING_FUNC(ring_QDateTimeEdit_setMaximumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMaximumDateTime(* (QDateTime *) RING_API_GETCPOINTER(2,"QDateTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTimeEdit_setMaximumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMaximumTime(* (QTime *) RING_API_GETCPOINTER(2,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QDateTimeEdit_setMinimumDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMinimumDate(* (QDate *) RING_API_GETCPOINTER(2,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
}


RING_FUNC(ring_QDateTimeEdit_setMinimumDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMinimumDateTime(* (QDateTime *) RING_API_GETCPOINTER(2,"QDateTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTimeEdit_setMinimumTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setMinimumTime(* (QTime *) RING_API_GETCPOINTER(2,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QDateTimeEdit_setSelectedSection)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSelectedSection( (QDateTimeEdit::Section )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTimeEdit_setTimeRange)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setTimeRange(* (QTime *) RING_API_GETCPOINTER(2,"QTime"),* (QTime *) RING_API_GETCPOINTER(3,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QTime"));
}


RING_FUNC(ring_QDateTimeEdit_setTimeSpec)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTimeSpec( (Qt::TimeSpec )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDateTimeEdit_time)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	{
		QTime *pValue ; 
		pValue = new QTime() ;
		*pValue = pObject->time();
		RING_API_RETCPOINTER(pValue,"QTime");
	}
}


RING_FUNC(ring_QDateTimeEdit_timeSpec)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	RING_API_RETNUMBER(pObject->timeSpec());
}


RING_FUNC(ring_QDateTimeEdit_setDate)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setDate(* (QDate *) RING_API_GETCPOINTER(2,"QDate"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDate"));
}


RING_FUNC(ring_QDateTimeEdit_setDateTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setDateTime(* (QDateTime *) RING_API_GETCPOINTER(2,"QDateTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QDateTime"));
}


RING_FUNC(ring_QDateTimeEdit_setTime)
{
	QDateTimeEdit *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QDateTimeEdit *) RING_API_GETCPOINTER(1,"QDateTimeEdit");
	pObject->setTime(* (QTime *) RING_API_GETCPOINTER(2,"QTime"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTime"));
}


RING_FUNC(ring_QAbstractSpinBox_alignment)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->alignment());
}


RING_FUNC(ring_QAbstractSpinBox_buttonSymbols)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->buttonSymbols());
}


RING_FUNC(ring_QAbstractSpinBox_correctionMode)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->correctionMode());
}


RING_FUNC(ring_QAbstractSpinBox_hasAcceptableInput)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->hasAcceptableInput());
}


RING_FUNC(ring_QAbstractSpinBox_hasFrame)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->hasFrame());
}


RING_FUNC(ring_QAbstractSpinBox_interpretText)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	pObject->interpretText();
}


RING_FUNC(ring_QAbstractSpinBox_isAccelerated)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->isAccelerated());
}


RING_FUNC(ring_QAbstractSpinBox_isReadOnly)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->isReadOnly());
}


RING_FUNC(ring_QAbstractSpinBox_keyboardTracking)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->keyboardTracking());
}


RING_FUNC(ring_QAbstractSpinBox_setAccelerated)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAccelerated( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setAlignment)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlignment( (Qt::AlignmentFlag )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setButtonSymbols)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setButtonSymbols( (QAbstractSpinBox::ButtonSymbols )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setCorrectionMode)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCorrectionMode( (QAbstractSpinBox::CorrectionMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setFrame)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFrame( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setKeyboardTracking)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setKeyboardTracking( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setReadOnly)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setReadOnly( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_setSpecialValueText)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSpecialValueText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAbstractSpinBox_setWrapping)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWrapping( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_specialValueText)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETSTRING(pObject->specialValueText().toStdString().c_str());
}


RING_FUNC(ring_QAbstractSpinBox_stepBy)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->stepBy( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractSpinBox_text)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QAbstractSpinBox_wrapping)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	RING_API_RETNUMBER(pObject->wrapping());
}


RING_FUNC(ring_QAbstractSpinBox_clear)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	pObject->clear();
}


RING_FUNC(ring_QAbstractSpinBox_selectAll)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	pObject->selectAll();
}


RING_FUNC(ring_QAbstractSpinBox_stepDown)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	pObject->stepDown();
}


RING_FUNC(ring_QAbstractSpinBox_stepUp)
{
	QAbstractSpinBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractSpinBox *) RING_API_GETCPOINTER(1,"QAbstractSpinBox");
	pObject->stepUp();
}


RING_FUNC(ring_QDial_notchSize)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETNUMBER(pObject->notchSize());
}


RING_FUNC(ring_QDial_notchTarget)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETNUMBER(pObject->notchTarget());
}


RING_FUNC(ring_QDial_notchesVisible)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETNUMBER(pObject->notchesVisible());
}


RING_FUNC(ring_QDial_setNotchTarget)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNotchTarget( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDial_wrapping)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETNUMBER(pObject->wrapping());
}


RING_FUNC(ring_QDial_minimumSizeHint)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QDial_sizeHint)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QDial_setNotchesVisible)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNotchesVisible( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDial_setWrapping)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWrapping( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QDial_setactionTriggeredEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setactionTriggeredEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_setrangeChangedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setrangeChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_setsliderMovedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderMovedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_setsliderPressedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_setsliderReleasedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsliderReleasedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_setvalueChangedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setvalueChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QDial_getactionTriggeredEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getactionTriggeredEvent());
}


RING_FUNC(ring_QDial_getrangeChangedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getrangeChangedEvent());
}


RING_FUNC(ring_QDial_getsliderMovedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getsliderMovedEvent());
}


RING_FUNC(ring_QDial_getsliderPressedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getsliderPressedEvent());
}


RING_FUNC(ring_QDial_getsliderReleasedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getsliderReleasedEvent());
}


RING_FUNC(ring_QDial_getvalueChangedEvent)
{
	GDial *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GDial *) RING_API_GETCPOINTER(1,"QDial");
	RING_API_RETSTRING(pObject->getvalueChangedEvent());
}


RING_FUNC(ring_QUrl_authority)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->authority( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_clear)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	pObject->clear();
}


RING_FUNC(ring_QUrl_errorString)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QUrl_fileName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->fileName( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_fragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->fragment( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_hasFragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->hasFragment());
}


RING_FUNC(ring_QUrl_hasQuery)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->hasQuery());
}


RING_FUNC(ring_QUrl_host)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->host( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_isEmpty)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QUrl_isLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isLocalFile());
}


RING_FUNC(ring_QUrl_isParentOf)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isParentOf(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QUrl_isRelative)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isRelative());
}


RING_FUNC(ring_QUrl_isValid)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QUrl_password)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->password( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_path)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->path( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_port)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->port( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QUrl_query)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->query( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_resolved)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->resolved(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QUrl_scheme)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->scheme().toStdString().c_str());
}


RING_FUNC(ring_QUrl_setAuthority)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAuthority(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setFragment)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFragment(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setHost)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHost(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPassword)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPassword(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPath)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPath(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setPort)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPort( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QUrl_setQuery)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setQuery(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setScheme)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setScheme(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QUrl_setUrl)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUrl(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setUserInfo)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserInfo(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_setUserName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUserName(RING_API_GETSTRING(2), (QUrl::ParsingMode )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QUrl_swap)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	pObject->swap(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QUrl_toLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	RING_API_RETSTRING(pObject->toLocalFile().toStdString().c_str());
}


RING_FUNC(ring_QUrl_topLevelDomain)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->topLevelDomain( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_userInfo)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->userInfo( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_userName)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->userName( (QUrl::ComponentFormattingOption )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QUrl_fromLocalFile)
{
	QUrl *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QUrl *) RING_API_GETCPOINTER(1,"QUrl");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->fromLocalFile(RING_API_GETSTRING(2));
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QCheckBox_checkState)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETNUMBER(pObject->checkState());
}


RING_FUNC(ring_QCheckBox_isTristate)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETNUMBER(pObject->isTristate());
}


RING_FUNC(ring_QCheckBox_setCheckState)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCheckState( (Qt::CheckState )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCheckBox_setTristate)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTristate( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QCheckBox_minimumSizeHint)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QCheckBox_sizeHint)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QCheckBox_setstateChangedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setstateChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCheckBox_setclickedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setclickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCheckBox_setpressedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setpressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCheckBox_setreleasedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreleasedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCheckBox_settoggledEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settoggledEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QCheckBox_getstateChangedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETSTRING(pObject->getstateChangedEvent());
}


RING_FUNC(ring_QCheckBox_getclickedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETSTRING(pObject->getclickedEvent());
}


RING_FUNC(ring_QCheckBox_getpressedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETSTRING(pObject->getpressedEvent());
}


RING_FUNC(ring_QCheckBox_getreleasedEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETSTRING(pObject->getreleasedEvent());
}


RING_FUNC(ring_QCheckBox_gettoggledEvent)
{
	GCheckBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GCheckBox *) RING_API_GETCPOINTER(1,"QCheckBox");
	RING_API_RETSTRING(pObject->gettoggledEvent());
}


RING_FUNC(ring_QAbstractButton_autoExclusive)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->autoExclusive());
}


RING_FUNC(ring_QAbstractButton_autoRepeat)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->autoRepeat());
}


RING_FUNC(ring_QAbstractButton_autoRepeatDelay)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->autoRepeatDelay());
}


RING_FUNC(ring_QAbstractButton_autoRepeatInterval)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->autoRepeatInterval());
}


RING_FUNC(ring_QAbstractButton_group)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETCPOINTER(pObject->group(),"QButtonGroup");
}


RING_FUNC(ring_QAbstractButton_icon)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon();
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QAbstractButton_iconSize)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->iconSize();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QAbstractButton_isCheckable)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->isCheckable());
}


RING_FUNC(ring_QAbstractButton_isChecked)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->isChecked());
}


RING_FUNC(ring_QAbstractButton_isDown)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETNUMBER(pObject->isDown());
}


RING_FUNC(ring_QAbstractButton_setAutoExclusive)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoExclusive( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setAutoRepeat)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoRepeat( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setAutoRepeatDelay)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoRepeatDelay( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setAutoRepeatInterval)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoRepeatInterval( (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setCheckable)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCheckable( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setDown)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDown( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setIcon)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	pObject->setIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QAbstractButton_setShortcut)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	pObject->setShortcut(* (QKeySequence *) RING_API_GETCPOINTER(2,"QKeySequence"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QKeySequence"));
}


RING_FUNC(ring_QAbstractButton_setText)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAbstractButton_shortcut)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	{
		QKeySequence *pValue ; 
		pValue = new QKeySequence() ;
		*pValue = pObject->shortcut();
		RING_API_RETCPOINTER(pValue,"QKeySequence");
	}
}


RING_FUNC(ring_QAbstractButton_text)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QAbstractButton_animateClick)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->animateClick( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_click)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	pObject->click();
}


RING_FUNC(ring_QAbstractButton_setChecked)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setChecked( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAbstractButton_setIconSize)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	pObject->setIconSize(* (QSize *) RING_API_GETCPOINTER(2,"QSize"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSize"));
}


RING_FUNC(ring_QAbstractButton_toggle)
{
	QAbstractButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QAbstractButton *) RING_API_GETCPOINTER(1,"QAbstractButton");
	pObject->toggle();
}


RING_FUNC(ring_QRadioButton_minimumSizeHint)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->minimumSizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QRadioButton_sizeHint)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	{
		QSize *pValue ; 
		pValue = new QSize() ;
		*pValue = pObject->sizeHint();
		RING_API_RETCPOINTER(pValue,"QSize");
	}
}


RING_FUNC(ring_QRadioButton_setclickedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setclickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QRadioButton_setpressedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setpressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QRadioButton_setreleasedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setreleasedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QRadioButton_settoggledEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settoggledEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QRadioButton_getclickedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	RING_API_RETSTRING(pObject->getclickedEvent());
}


RING_FUNC(ring_QRadioButton_getpressedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	RING_API_RETSTRING(pObject->getpressedEvent());
}


RING_FUNC(ring_QRadioButton_getreleasedEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	RING_API_RETSTRING(pObject->getreleasedEvent());
}


RING_FUNC(ring_QRadioButton_gettoggledEvent)
{
	GRadioButton *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GRadioButton *) RING_API_GETCPOINTER(1,"QRadioButton");
	RING_API_RETSTRING(pObject->gettoggledEvent());
}


RING_FUNC(ring_QButtonGroup_addButton)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QButtonGroup_button)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->button( (int ) RING_API_GETNUMBER(2)),"QAbstractButton");
}


RING_FUNC(ring_QButtonGroup_checkedButton)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETCPOINTER(pObject->checkedButton(),"QAbstractButton");
}


RING_FUNC(ring_QButtonGroup_checkedId)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETNUMBER(pObject->checkedId());
}


RING_FUNC(ring_QButtonGroup_exclusive)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETNUMBER(pObject->exclusive());
}


RING_FUNC(ring_QButtonGroup_id)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->id((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton")));
}


RING_FUNC(ring_QButtonGroup_removeButton)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"));
}


RING_FUNC(ring_QButtonGroup_setExclusive)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setExclusive( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QButtonGroup_setId)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setId((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QButtonGroup_setbuttonClickedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setbuttonClickedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QButtonGroup_setbuttonPressedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setbuttonPressedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QButtonGroup_setbuttonReleasedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setbuttonReleasedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QButtonGroup_getbuttonClickedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETSTRING(pObject->getbuttonClickedEvent());
}


RING_FUNC(ring_QButtonGroup_getbuttonPressedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETSTRING(pObject->getbuttonPressedEvent());
}


RING_FUNC(ring_QButtonGroup_getbuttonReleasedEvent)
{
	GButtonGroup *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GButtonGroup *) RING_API_GETCPOINTER(1,"QButtonGroup");
	RING_API_RETSTRING(pObject->getbuttonReleasedEvent());
}


RING_FUNC(ring_QMediaPlayer_bufferStatus)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->bufferStatus());
}


RING_FUNC(ring_QMediaPlayer_currentMedia)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	{
		QMediaContent *pValue ; 
		pValue = (QMediaContent *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMediaContent)) ;
		*pValue = pObject->currentMedia();
		RING_API_RETCPOINTER(pValue,"QMediaContent");
	}
}


RING_FUNC(ring_QMediaPlayer_currentNetworkConfiguration)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	{
		QNetworkConfiguration *pValue ; 
		pValue = (QNetworkConfiguration *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QNetworkConfiguration)) ;
		*pValue = pObject->currentNetworkConfiguration();
		RING_API_RETCPOINTER(pValue,"QNetworkConfiguration");
	}
}


RING_FUNC(ring_QMediaPlayer_duration)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->duration());
}


RING_FUNC(ring_QMediaPlayer_error)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->error());
}


RING_FUNC(ring_QMediaPlayer_errorString)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QMediaPlayer_isAudioAvailable)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->isAudioAvailable());
}


RING_FUNC(ring_QMediaPlayer_isMuted)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->isMuted());
}


RING_FUNC(ring_QMediaPlayer_isSeekable)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->isSeekable());
}


RING_FUNC(ring_QMediaPlayer_isVideoAvailable)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->isVideoAvailable());
}


RING_FUNC(ring_QMediaPlayer_media)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	{
		QMediaContent *pValue ; 
		pValue = (QMediaContent *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMediaContent)) ;
		*pValue = pObject->media();
		RING_API_RETCPOINTER(pValue,"QMediaContent");
	}
}


RING_FUNC(ring_QMediaPlayer_mediaStatus)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->mediaStatus());
}


RING_FUNC(ring_QMediaPlayer_mediaStream)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETCPOINTER(pObject->mediaStream(),"QIODevice");
}


RING_FUNC(ring_QMediaPlayer_playbackRate)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->playbackRate());
}


RING_FUNC(ring_QMediaPlayer_playlist)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETCPOINTER(pObject->playlist(),"QMediaPlaylist");
}


RING_FUNC(ring_QMediaPlayer_position)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->position());
}


RING_FUNC(ring_QMediaPlayer_setVideoOutput)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVideoOutput((QVideoWidget *) RING_API_GETCPOINTER(2,"QVideoWidget"));
}


RING_FUNC(ring_QMediaPlayer_state)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->state());
}


RING_FUNC(ring_QMediaPlayer_volume)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	RING_API_RETNUMBER(pObject->volume());
}


RING_FUNC(ring_QMediaPlayer_pause)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	pObject->pause();
}


RING_FUNC(ring_QMediaPlayer_play)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	pObject->play();
}


RING_FUNC(ring_QMediaPlayer_setMedia)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	pObject->setMedia(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QMediaPlayer_setMuted)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMuted( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlayer_setPlaybackRate)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlaybackRate( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlayer_setPlaylist)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlaylist((QMediaPlaylist *) RING_API_GETCPOINTER(2,"QMediaPlaylist"));
}


RING_FUNC(ring_QMediaPlayer_setPosition)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPosition( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlayer_setVolume)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVolume( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlayer_stop)
{
	QMediaPlayer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlayer *) RING_API_GETCPOINTER(1,"QMediaPlayer");
	pObject->stop();
}


RING_FUNC(ring_QMediaPlaylist_addMedia)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->addMedia(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QMediaPlaylist_clear)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->clear());
}


RING_FUNC(ring_QMediaPlaylist_currentIndex)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->currentIndex());
}


RING_FUNC(ring_QMediaPlaylist_currentMedia)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	{
		QMediaContent *pValue ; 
		pValue = (QMediaContent *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMediaContent)) ;
		*pValue = pObject->currentMedia();
		RING_API_RETCPOINTER(pValue,"QMediaContent");
	}
}


RING_FUNC(ring_QMediaPlaylist_error)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->error());
}


RING_FUNC(ring_QMediaPlaylist_errorString)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETSTRING(pObject->errorString().toStdString().c_str());
}


RING_FUNC(ring_QMediaPlaylist_insertMedia)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->insertMedia( (int ) RING_API_GETNUMBER(2),* (QMediaContent *) RING_API_GETCPOINTER(3,"QMediaContent")));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QMediaContent"));
}


RING_FUNC(ring_QMediaPlaylist_isEmpty)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->isEmpty());
}


RING_FUNC(ring_QMediaPlaylist_isReadOnly)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->isReadOnly());
}


RING_FUNC(ring_QMediaPlaylist_load)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->load(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"),RING_API_GETSTRING(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QMediaPlaylist_media)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QMediaContent *pValue ; 
		pValue = (QMediaContent *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QMediaContent)) ;
		*pValue = pObject->media( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QMediaContent");
	}
}


RING_FUNC(ring_QMediaPlaylist_mediaCount)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->mediaCount());
}


RING_FUNC(ring_QMediaPlaylist_nextIndex)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->nextIndex( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QMediaPlaylist_playbackMode)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	RING_API_RETNUMBER(pObject->playbackMode());
}


RING_FUNC(ring_QMediaPlaylist_previousIndex)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->previousIndex( (int ) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QMediaPlaylist_removeMedia)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->removeMedia( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3)));
}


RING_FUNC(ring_QMediaPlaylist_save)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"),RING_API_GETSTRING(3)));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QMediaPlaylist_setPlaybackMode)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPlaybackMode( (QMediaPlaylist::PlaybackMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlaylist_next)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	pObject->next();
}


RING_FUNC(ring_QMediaPlaylist_previous)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	pObject->previous();
}


RING_FUNC(ring_QMediaPlaylist_setCurrentIndex)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCurrentIndex( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMediaPlaylist_shuffle)
{
	QMediaPlaylist *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMediaPlaylist *) RING_API_GETCPOINTER(1,"QMediaPlaylist");
	pObject->shuffle();
}


RING_FUNC(ring_QVideoWidget_aspectRatioMode)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->aspectRatioMode());
}


RING_FUNC(ring_QVideoWidget_brightness)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->brightness());
}


RING_FUNC(ring_QVideoWidget_contrast)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->contrast());
}


RING_FUNC(ring_QVideoWidget_hue)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->hue());
}


RING_FUNC(ring_QVideoWidget_isFullScreen)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->isFullScreen());
}


RING_FUNC(ring_QVideoWidget_saturation)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETNUMBER(pObject->saturation());
}


RING_FUNC(ring_QVideoWidget_setAspectRatioMode)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAspectRatioMode( (Qt::AspectRatioMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setBrightness)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBrightness( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setContrast)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setContrast( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setFullScreen)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFullScreen( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setHue)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHue( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setSaturation)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSaturation( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QVideoWidget_setbrightnessChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setbrightnessChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QVideoWidget_setcontrastChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setcontrastChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QVideoWidget_setfullScreenChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setfullScreenChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QVideoWidget_sethueChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->sethueChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QVideoWidget_setsaturationChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setsaturationChangedEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QVideoWidget_getbrightnessChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETSTRING(pObject->getbrightnessChangedEvent());
}


RING_FUNC(ring_QVideoWidget_getcontrastChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETSTRING(pObject->getcontrastChangedEvent());
}


RING_FUNC(ring_QVideoWidget_getfullScreenChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETSTRING(pObject->getfullScreenChangedEvent());
}


RING_FUNC(ring_QVideoWidget_gethueChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETSTRING(pObject->gethueChangedEvent());
}


RING_FUNC(ring_QVideoWidget_getsaturationChangedEvent)
{
	GVideoWidget *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GVideoWidget *) RING_API_GETCPOINTER(1,"QVideoWidget");
	RING_API_RETSTRING(pObject->getsaturationChangedEvent());
}


RING_FUNC(ring_QAction_actionGroup)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETCPOINTER(pObject->actionGroup(),"QActionGroup");
}


RING_FUNC(ring_QAction_activate)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->activate( (QAction::ActionEvent )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_autoRepeat)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->autoRepeat());
}


RING_FUNC(ring_QAction_data)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	{
		QVariant *pValue ; 
		pValue = new QVariant() ;
		*pValue = pObject->data();
		RING_API_RETCPOINTER(pValue,"QVariant");
	}
}


RING_FUNC(ring_QAction_font)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QAction_icon)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	{
		QIcon *pValue ; 
		pValue = new QIcon() ;
		*pValue = pObject->icon();
		RING_API_RETCPOINTER(pValue,"QIcon");
	}
}


RING_FUNC(ring_QAction_iconText)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->iconText().toStdString().c_str());
}


RING_FUNC(ring_QAction_isCheckable)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isCheckable());
}


RING_FUNC(ring_QAction_isChecked)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isChecked());
}


RING_FUNC(ring_QAction_isEnabled)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isEnabled());
}


RING_FUNC(ring_QAction_isIconVisibleInMenu)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isIconVisibleInMenu());
}


RING_FUNC(ring_QAction_isSeparator)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isSeparator());
}


RING_FUNC(ring_QAction_isVisible)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->isVisible());
}


RING_FUNC(ring_QAction_menu)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETCPOINTER(pObject->menu(),"QMenu");
}


RING_FUNC(ring_QAction_menuRole)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->menuRole());
}


RING_FUNC(ring_QAction_parentWidget)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETCPOINTER(pObject->parentWidget(),"QWidget");
}


RING_FUNC(ring_QAction_priority)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->priority());
}


RING_FUNC(ring_QAction_setActionGroup)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setActionGroup((QActionGroup *) RING_API_GETCPOINTER(2,"QActionGroup"));
}


RING_FUNC(ring_QAction_setAutoRepeat)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAutoRepeat( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setCheckable)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCheckable( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setData)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->setData(* (QVariant *) RING_API_GETCPOINTER(2,"QVariant"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QVariant"));
}


RING_FUNC(ring_QAction_setFont)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->setFont(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QAction_setIcon)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->setIcon(* (QIcon *) RING_API_GETCPOINTER(2,"QIcon"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QIcon"));
}


RING_FUNC(ring_QAction_setIconText)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIconText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_setIconVisibleInMenu)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIconVisibleInMenu( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setMenu)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMenu((QMenu *) RING_API_GETCPOINTER(2,"QMenu"));
}


RING_FUNC(ring_QAction_setMenuRole)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMenuRole( (QAction::MenuRole )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setPriority)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPriority( (QAction::Priority )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setSeparator)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSeparator( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setShortcut)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->setShortcut(* (QKeySequence *) RING_API_GETCPOINTER(2,"QKeySequence"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QKeySequence"));
}


RING_FUNC(ring_QAction_setShortcutContext)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShortcutContext( (Qt::ShortcutContext )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setShortcuts)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setShortcuts( (QKeySequence::StandardKey )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setStatusTip)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStatusTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_setText)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_setToolTip)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setToolTip(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_setWhatsThis)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWhatsThis(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_shortcut)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	{
		QKeySequence *pValue ; 
		pValue = new QKeySequence() ;
		*pValue = pObject->shortcut();
		RING_API_RETCPOINTER(pValue,"QKeySequence");
	}
}


RING_FUNC(ring_QAction_shortcutContext)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETNUMBER(pObject->shortcutContext());
}


RING_FUNC(ring_QAction_showStatusText)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->showStatusText((QWidget *) RING_API_GETCPOINTER(2,"QWidget")));
}


RING_FUNC(ring_QAction_statusTip)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->statusTip().toStdString().c_str());
}


RING_FUNC(ring_QAction_text)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QAction_toolTip)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->toolTip().toStdString().c_str());
}


RING_FUNC(ring_QAction_whatsThis)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->whatsThis().toStdString().c_str());
}


RING_FUNC(ring_QAction_hover)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->hover();
}


RING_FUNC(ring_QAction_setChecked)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setChecked( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setDisabled)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDisabled( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setEnabled)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEnabled( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_setVisible)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setVisible( (bool) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QAction_toggle)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->toggle();
}


RING_FUNC(ring_QAction_trigger)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	pObject->trigger();
}


RING_FUNC(ring_QAction_setClickEvent)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClickEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QAction_getClickEvent)
{
	GAction *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GAction *) RING_API_GETCPOINTER(1,"QAction");
	RING_API_RETSTRING(pObject->getClickEvent());
}


RING_FUNC(ring_QEvent_accept)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	pObject->accept();
}


RING_FUNC(ring_QEvent_ignore)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	pObject->ignore();
}


RING_FUNC(ring_QEvent_isAccepted)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->isAccepted());
}


RING_FUNC(ring_QEvent_setAccepted)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAccepted( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QEvent_spontaneous)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->spontaneous());
}


RING_FUNC(ring_QEvent_type)
{
	QEvent *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QEvent *) RING_API_GETCPOINTER(1,"QEvent");
	RING_API_RETNUMBER(pObject->type());
}


RING_FUNC(ring_QMessageBox_addButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->addButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"), (QMessageBox::ButtonRole )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QMessageBox_button)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETCPOINTER(pObject->button( (QMessageBox::StandardButton )  (int) RING_API_GETNUMBER(2)),"QAbstractButton");
}


RING_FUNC(ring_QMessageBox_buttonRole)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->buttonRole((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton")));
}


RING_FUNC(ring_QMessageBox_clickedButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETCPOINTER(pObject->clickedButton(),"QAbstractButton");
}


RING_FUNC(ring_QMessageBox_defaultButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETCPOINTER(pObject->defaultButton(),"QPushButton");
}


RING_FUNC(ring_QMessageBox_detailedText)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETSTRING(pObject->detailedText().toStdString().c_str());
}


RING_FUNC(ring_QMessageBox_escapeButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETCPOINTER(pObject->escapeButton(),"QAbstractButton");
}


RING_FUNC(ring_QMessageBox_iconPixmap)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	{
		QPixmap *pValue ; 
		pValue = new QPixmap() ;
		*pValue = pObject->iconPixmap();
		RING_API_RETCPOINTER(pValue,"QPixmap");
	}
}


RING_FUNC(ring_QMessageBox_informativeText)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETSTRING(pObject->informativeText().toStdString().c_str());
}


RING_FUNC(ring_QMessageBox_open)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->open((QObject *) RING_API_GETCPOINTER(2,"QObject"),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QMessageBox_removeButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->removeButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"));
}


RING_FUNC(ring_QMessageBox_setDefaultButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultButton((QPushButton *) RING_API_GETCPOINTER(2,"QPushButton"));
}


RING_FUNC(ring_QMessageBox_setDetailedText)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDetailedText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMessageBox_setEscapeButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setEscapeButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton"));
}


RING_FUNC(ring_QMessageBox_setIconPixmap)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	pObject->setIconPixmap(* (QPixmap *) RING_API_GETCPOINTER(2,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPixmap"));
}


RING_FUNC(ring_QMessageBox_setInformativeText)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInformativeText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMessageBox_setStandardButtons)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStandardButtons( (QMessageBox::StandardButton )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMessageBox_setText)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setText(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMessageBox_setTextFormat)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTextFormat( (Qt::TextFormat )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMessageBox_setWindowModality)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowModality( (Qt::WindowModality )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QMessageBox_setWindowTitle)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindowTitle(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QMessageBox_standardButton)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->standardButton((QAbstractButton *) RING_API_GETCPOINTER(2,"QAbstractButton")));
}


RING_FUNC(ring_QMessageBox_standardButtons)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETNUMBER(pObject->standardButtons());
}


RING_FUNC(ring_QMessageBox_text)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETSTRING(pObject->text().toStdString().c_str());
}


RING_FUNC(ring_QMessageBox_textFormat)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETNUMBER(pObject->textFormat());
}


RING_FUNC(ring_QMessageBox_exec)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	RING_API_RETNUMBER(pObject->exec());
}


RING_FUNC(ring_QMessageBox_about)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->about((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QMessageBox_aboutQt)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->aboutQt((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QMessageBox_critical)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->critical((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6)));
}


RING_FUNC(ring_QMessageBox_information)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->information((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6)));
}


RING_FUNC(ring_QMessageBox_question)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->question((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5), (int  ) RING_API_GETNUMBER(6)));
}


RING_FUNC(ring_QMessageBox_warning)
{
	QMessageBox *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QMessageBox *) RING_API_GETCPOINTER(1,"QMessageBox");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->warning((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6)));
}


RING_FUNC(ring_QTimer_interval)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->interval());
}


RING_FUNC(ring_QTimer_isActive)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->isActive());
}


RING_FUNC(ring_QTimer_isSingleShot)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->isSingleShot());
}


RING_FUNC(ring_QTimer_setInterval)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setInterval( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTimer_setSingleShot)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setSingleShot( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QTimer_timerId)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETNUMBER(pObject->timerId());
}


RING_FUNC(ring_QTimer_start)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	pObject->start();
}


RING_FUNC(ring_QTimer_stop)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	pObject->stop();
}


RING_FUNC(ring_QTimer_settimeoutEvent)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->settimeoutEvent(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QTimer_gettimeoutEvent)
{
	GTimer *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (GTimer *) RING_API_GETCPOINTER(1,"QTimer");
	RING_API_RETSTRING(pObject->gettimeoutEvent());
}


RING_FUNC(ring_QFileDialog_acceptMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->acceptMode());
}


RING_FUNC(ring_QFileDialog_defaultSuffix)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETSTRING(pObject->defaultSuffix().toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_directory)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QDir *pValue ; 
		pValue = new QDir() ;
		*pValue = pObject->directory();
		RING_API_RETCPOINTER(pValue,"QDir");
	}
}


RING_FUNC(ring_QFileDialog_directoryUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->directoryUrl();
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QFileDialog_fileMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->fileMode());
}


RING_FUNC(ring_QFileDialog_filter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->filter());
}


RING_FUNC(ring_QFileDialog_history)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->history();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileDialog_iconProvider)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETCPOINTER(pObject->iconProvider(),"QFileIconProvider");
}


RING_FUNC(ring_QFileDialog_itemDelegate)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETCPOINTER(pObject->itemDelegate(),"QAbstractItemDelegate");
}


RING_FUNC(ring_QFileDialog_labelText)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->labelText( (QFileDialog::DialogLabel )  (int) RING_API_GETNUMBER(2)).toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_mimeTypeFilters)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->mimeTypeFilters();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileDialog_nameFilters)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->nameFilters();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileDialog_open)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->open((QObject *) RING_API_GETCPOINTER(2,"QObject"),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QFileDialog_options)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->options());
}


RING_FUNC(ring_QFileDialog_proxyModel)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETCPOINTER(pObject->proxyModel(),"QAbstractProxyModel");
}


RING_FUNC(ring_QFileDialog_restoreState)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->restoreState(* (QByteArray *) RING_API_GETCPOINTER(2,"QByteArray")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QByteArray"));
}


RING_FUNC(ring_QFileDialog_saveState)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QByteArray *pValue ; 
		pValue = new QByteArray() ;
		*pValue = pObject->saveState();
		RING_API_RETCPOINTER(pValue,"QByteArray");
	}
}


RING_FUNC(ring_QFileDialog_selectFile)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectFile(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_selectMimeTypeFilter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectMimeTypeFilter(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_selectNameFilter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->selectNameFilter(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_selectUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	pObject->selectUrl(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QFileDialog_selectedFiles)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->selectedFiles();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QFileDialog_selectedNameFilter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETSTRING(pObject->selectedNameFilter().toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_setAcceptMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAcceptMode( (QFileDialog::AcceptMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileDialog_setDefaultSuffix)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDefaultSuffix(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_setDirectory)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDirectory(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_setDirectoryUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	pObject->setDirectoryUrl(* (QUrl *) RING_API_GETCPOINTER(2,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QUrl"));
}


RING_FUNC(ring_QFileDialog_setFileMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFileMode( (QFileDialog::FileMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileDialog_setFilter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFilter( (QDir::Filter )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileDialog_setHistory)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	pObject->setHistory(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QFileDialog_setIconProvider)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setIconProvider((QFileIconProvider *) RING_API_GETCPOINTER(2,"QFileIconProvider"));
}


RING_FUNC(ring_QFileDialog_setItemDelegate)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItemDelegate((QAbstractItemDelegate *) RING_API_GETCPOINTER(2,"QAbstractItemDelegate"));
}


RING_FUNC(ring_QFileDialog_setLabelText)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLabelText( (QFileDialog::DialogLabel )  (int) RING_API_GETNUMBER(2),RING_API_GETSTRING(3));
}


RING_FUNC(ring_QFileDialog_setMimeTypeFilters)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	pObject->setMimeTypeFilters(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QFileDialog_setNameFilter)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNameFilter(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFileDialog_setNameFilters)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	pObject->setNameFilters(* (QStringList *) RING_API_GETCPOINTER(2,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QStringList"));
}


RING_FUNC(ring_QFileDialog_setOption)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOption( (QFileDialog::Option )  (int) RING_API_GETNUMBER(2), (bool) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFileDialog_setOptions)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOptions( (QFileDialog::Option )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileDialog_setProxyModel)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setProxyModel((QAbstractProxyModel *) RING_API_GETCPOINTER(2,"QAbstractProxyModel"));
}


RING_FUNC(ring_QFileDialog_setViewMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewMode( (QFileDialog::ViewMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFileDialog_testOption)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->testOption( (QFileDialog::Option )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QFileDialog_viewMode)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	RING_API_RETNUMBER(pObject->viewMode());
}


RING_FUNC(ring_QFileDialog_getExistingDirectory)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->getExistingDirectory((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4), (QFileDialog::Option)  (int) RING_API_GETNUMBER(5)).toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_getExistingDirectoryUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->getExistingDirectoryUrl((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),* (QUrl *) RING_API_GETCPOINTER(4,"QUrl"), (QFileDialog::Option)  (int) RING_API_GETNUMBER(5),* (QStringList *) RING_API_GETCPOINTER(6,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QStringList"));
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QFileDialog_getOpenFileName)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->getOpenFileName((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4),RING_API_GETSTRING(5)).toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_getOpenFileUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->getOpenFileUrl((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),* (QUrl *) RING_API_GETCPOINTER(4,"QUrl"),RING_API_GETSTRING(5),(QString *) RING_API_GETCPOINTER(6,"QString"), (QFileDialog::Option )  (int) RING_API_GETNUMBER(7),* (QStringList *) RING_API_GETCPOINTER(8,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(7))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(7,"QStringList"));
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QFileDialog_getSaveFileName)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETSTRING(pObject->getSaveFileName((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),RING_API_GETSTRING(4),RING_API_GETSTRING(5)).toStdString().c_str());
}


RING_FUNC(ring_QFileDialog_getSaveFileUrl)
{
	QFileDialog *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFileDialog *) RING_API_GETCPOINTER(1,"QFileDialog");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QUrl *pValue ; 
		pValue = new QUrl() ;
		*pValue = pObject->getSaveFileUrl((QWidget *) RING_API_GETCPOINTER(2,"QWidget"),RING_API_GETSTRING(3),* (QUrl *) RING_API_GETCPOINTER(4,"QUrl"),RING_API_GETSTRING(5),(QString *) RING_API_GETCPOINTER(6,"QString"), (QFileDialog::Option )  (int) RING_API_GETNUMBER(7),* (QStringList *) RING_API_GETCPOINTER(8,"QStringList"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QUrl"));
	if (RING_API_ISCPOINTERNOTASSIGNED(7))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(7,"QStringList"));
		RING_API_RETCPOINTER(pValue,"QUrl");
	}
}


RING_FUNC(ring_QPainter_background)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->background();
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QPainter_backgroundMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->backgroundMode());
}


RING_FUNC(ring_QPainter_begin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->begin((QPaintDevice *) RING_API_GETCPOINTER(2,"QPaintDevice")));
}


RING_FUNC(ring_QPainter_beginNativePainting)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->beginNativePainting();
}


RING_FUNC(ring_QPainter_boundingRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6),RING_API_GETSTRING(7));
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QPainter_brush)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->brush();
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QPainter_brushOrigin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPoint *pValue ; 
		pValue = new QPoint() ;
		*pValue = pObject->brushOrigin();
		RING_API_RETCPOINTER(pValue,"QPoint");
	}
}


RING_FUNC(ring_QPainter_clipBoundingRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->clipBoundingRect();
		RING_API_RETCPOINTER(pValue,"QRectF");
	}
}


RING_FUNC(ring_QPainter_clipPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPainterPath *pValue ; 
		pValue = new QPainterPath() ;
		*pValue = pObject->clipPath();
		RING_API_RETCPOINTER(pValue,"QPainterPath");
	}
}


RING_FUNC(ring_QPainter_clipRegion)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRegion *pValue ; 
		pValue = (QRegion *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRegion)) ;
		*pValue = pObject->clipRegion();
		RING_API_RETCPOINTER(pValue,"QRegion");
	}
}


RING_FUNC(ring_QPainter_combinedTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->combinedTransform();
		RING_API_RETCPOINTER(pValue,"QTransform");
	}
}


RING_FUNC(ring_QPainter_compositionMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->compositionMode());
}


RING_FUNC(ring_QPainter_device)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETCPOINTER(pObject->device(),"QPaintDevice");
}


RING_FUNC(ring_QPainter_deviceTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform *pValue ; 
		pValue = (QTransform *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform)) ;
		*pValue = pObject->deviceTransform();
		RING_API_RETCPOINTER(pValue,"QTransform");
	}
}


RING_FUNC(ring_QPainter_drawArc)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawArc( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawChord)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawChord( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawConvexPolygon)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawConvexPolygon((QPoint *) RING_API_GETCPOINTER(2,"QPoint"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawEllipse)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawEllipse( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawGlyphRun)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->drawGlyphRun(* (QPointF   *) RING_API_GETCPOINTER(2,"QPointF"),* (QGlyphRun   *) RING_API_GETCPOINTER(3,"QGlyphRun"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPointF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QGlyphRun"));
}


RING_FUNC(ring_QPainter_drawImage)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawImage( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QImage  *) RING_API_GETCPOINTER(4,"QImage"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QImage"));
}


RING_FUNC(ring_QPainter_drawLine)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawLine( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawLines)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawLines((QLine *) RING_API_GETCPOINTER(2,"QLine"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->drawPath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainter_drawPicture)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPicture( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QPicture   *) RING_API_GETCPOINTER(4,"QPicture"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QPicture"));
}


RING_FUNC(ring_QPainter_drawPie)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 7 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPie( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6), (int ) RING_API_GETNUMBER(7));
}


RING_FUNC(ring_QPainter_drawPixmap)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPixmap( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QPixmap *) RING_API_GETCPOINTER(4,"QPixmap"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QPixmap"));
}


RING_FUNC(ring_QPainter_drawPoint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPoint( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawPoints)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPoints((QPointF *) RING_API_GETCPOINTER(2,"QPointF"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawPolyline)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawPolyline((QPointF *) RING_API_GETCPOINTER(2,"QPointF"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_drawRects)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRects((QRectF *) RING_API_GETCPOINTER(2,"QRectF"), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_drawRoundedRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawRoundedRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (qreal ) RING_API_GETNUMBER(6), (qreal ) RING_API_GETNUMBER(7), (Qt::SizeMode )  (int) RING_API_GETNUMBER(8));
}


RING_FUNC(ring_QPainter_drawStaticText)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawStaticText( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),* (QStaticText   *) RING_API_GETCPOINTER(4,"QStaticText"));
	if (RING_API_ISCPOINTERNOTASSIGNED(3))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(3,"QStaticText"));
}


RING_FUNC(ring_QPainter_drawText)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 4 ) {
		RING_API_ERROR(RING_API_MISS4PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawText( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3),RING_API_GETSTRING(4));
}


RING_FUNC(ring_QPainter_drawTiledPixmap)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 8 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(7) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(8) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->drawTiledPixmap( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5),* (QPixmap   *) RING_API_GETCPOINTER(6,"QPixmap"), (int ) RING_API_GETNUMBER(7), (int ) RING_API_GETNUMBER(8));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QPixmap"));
}


RING_FUNC(ring_QPainter_end)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->end());
}


RING_FUNC(ring_QPainter_endNativePainting)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->endNativePainting();
}


RING_FUNC(ring_QPainter_eraseRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->eraseRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_fillPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->fillPath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"),* (QBrush   *) RING_API_GETCPOINTER(3,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QBrush"));
}


RING_FUNC(ring_QPainter_fillRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->fillRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5),* (QBrush *) RING_API_GETCPOINTER(6,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(5))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(5,"QBrush"));
}


RING_FUNC(ring_QPainter_font)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->font();
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QPainter_fontInfo)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QFontInfo *pValue ; 
		pValue = (QFontInfo *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QFontInfo)) ;
		*pValue = pObject->fontInfo();
		RING_API_RETCPOINTER(pValue,"QFontInfo");
	}
}


RING_FUNC(ring_QPainter_hasClipping)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->hasClipping());
}


RING_FUNC(ring_QPainter_initFrom)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->initFrom((QWidget *) RING_API_GETCPOINTER(2,"QWidget"));
}


RING_FUNC(ring_QPainter_isActive)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->isActive());
}


RING_FUNC(ring_QPainter_layoutDirection)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->layoutDirection());
}


RING_FUNC(ring_QPainter_opacity)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->opacity());
}


RING_FUNC(ring_QPainter_paintEngine)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETCPOINTER(pObject->paintEngine(),"QPaintEngine");
}


RING_FUNC(ring_QPainter_pen)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QPen *pValue ; 
		pValue = new QPen() ;
		*pValue = pObject->pen();
		RING_API_RETCPOINTER(pValue,"QPen");
	}
}


RING_FUNC(ring_QPainter_renderHints)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->renderHints());
}


RING_FUNC(ring_QPainter_resetTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->resetTransform();
}


RING_FUNC(ring_QPainter_restore)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->restore();
}


RING_FUNC(ring_QPainter_rotate)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->rotate( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_save)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->save();
}


RING_FUNC(ring_QPainter_scale)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->scale( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setBackground)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setBackground(* (QBrush   *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPainter_setBackgroundMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBackgroundMode( (Qt::BGMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setBrush)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setBrush(* (QBrush  *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPainter_setBrushOrigin)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBrushOrigin( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setClipPath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipPath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
}


RING_FUNC(ring_QPainter_setClipRect)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipRect( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QPainter_setClipRegion)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipRegion(* (QRegion   *) RING_API_GETCPOINTER(2,"QRegion"), (Qt::ClipOperation )  (int) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRegion"));
}


RING_FUNC(ring_QPainter_setClipping)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setClipping( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setCompositionMode)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCompositionMode( (QPainter::CompositionMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setFont)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setFont(* (QFont   *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QPainter_setLayoutDirection)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLayoutDirection( (Qt::LayoutDirection )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setOpacity)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOpacity( (qreal ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setPen)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->setPen(* (QPen   *) RING_API_GETCPOINTER(2,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPen"));
}


RING_FUNC(ring_QPainter_setRenderHint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRenderHint( (QPainter::RenderHint )  (int) RING_API_GETNUMBER(2), (bool ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_setTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setTransform(* (QTransform   *) RING_API_GETCPOINTER(2,"QTransform"), (bool ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
}


RING_FUNC(ring_QPainter_setViewTransformEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewTransformEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setViewport)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setViewport( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_setWindow)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWindow( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QPainter_setWorldMatrixEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWorldMatrixEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPainter_setWorldTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWorldTransform(* (QTransform   *) RING_API_GETCPOINTER(2,"QTransform"), (bool ) RING_API_GETNUMBER(3));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QTransform"));
}


RING_FUNC(ring_QPainter_shear)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->shear( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_strokePath)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pObject->strokePath(* (QPainterPath   *) RING_API_GETCPOINTER(2,"QPainterPath"),* (QPen   *) RING_API_GETCPOINTER(3,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPainterPath"));
	if (RING_API_ISCPOINTERNOTASSIGNED(2))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(2,"QPen"));
}


RING_FUNC(ring_QPainter_testRenderHint)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->testRenderHint( (QPainter::RenderHint )  (int) RING_API_GETNUMBER(2)));
}


RING_FUNC(ring_QPainter_transform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform  *pValue ; 
		pValue = (QTransform  *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform )) ;
		*pValue = pObject->transform();
		RING_API_RETCPOINTER(pValue,"QTransform");
	}
}


RING_FUNC(ring_QPainter_translate)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->translate( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPainter_viewTransformEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->viewTransformEnabled());
}


RING_FUNC(ring_QPainter_viewport)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->viewport();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QPainter_window)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->window();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QPainter_worldMatrixEnabled)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	RING_API_RETNUMBER(pObject->worldMatrixEnabled());
}


RING_FUNC(ring_QPainter_worldTransform)
{
	QPainter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	{
		QTransform  *pValue ; 
		pValue = (QTransform  *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QTransform )) ;
		*pValue = pObject->worldTransform();
		RING_API_RETCPOINTER(pValue,"QTransform");
	}
}

RING_FUNC(ring_QPainter_drawPolygon)
{
	QPainter *pObject;
	List *pList,*pList2;
	int x,nSize;
	RING_API_IGNORECPOINTERTYPE ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPainter *) RING_API_GETCPOINTER(1,"QPainter");
	pList = (List *) RING_API_GETLIST(2);
	nSize = ring_list_getsize(pList);
	QPointF *points = new QPointF[nSize];
	for (x=0 ; x < nSize ; x++) {
		pList2 = ring_list_getlist(pList,x+1);
		points[x].setX((float) ring_list_getdouble(pList2,1));
		points[x].setY((float) ring_list_getdouble(pList2,2));
	}
	pObject->drawPolygon(points, nSize, (Qt::FillRule )  (int) RING_API_GETNUMBER(3));	
	delete [] points;
}

RING_FUNC(ring_QPicture_boundingRect)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	{
		QRect *pValue ; 
		pValue = new QRect() ;
		*pValue = pObject->boundingRect();
		RING_API_RETCPOINTER(pValue,"QRect");
	}
}


RING_FUNC(ring_QPicture_data)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETSTRING(pObject->data());
}


RING_FUNC(ring_QPicture_isNull)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETNUMBER(pObject->isNull());
}


RING_FUNC(ring_QPicture_load)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->load(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QPicture_play)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->play((QPainter *) RING_API_GETCPOINTER(2,"QPainter")));
}


RING_FUNC(ring_QPicture_save)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->save(RING_API_GETSTRING(2),RING_API_GETSTRING(3)));
}


RING_FUNC(ring_QPicture_setBoundingRect)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	pObject->setBoundingRect(* (QRect *) RING_API_GETCPOINTER(2,"QRect"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRect"));
}


RING_FUNC(ring_QPicture_size)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	RING_API_RETNUMBER(pObject->size());
}


RING_FUNC(ring_QPicture_swap)
{
	QPicture *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPicture *) RING_API_GETCPOINTER(1,"QPicture");
	pObject->swap(* (QPicture *) RING_API_GETCPOINTER(2,"QPicture"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPicture"));
}


RING_FUNC(ring_QPen_brush)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	{
		QBrush *pValue ; 
		pValue = new QBrush() ;
		*pValue = pObject->brush();
		RING_API_RETCPOINTER(pValue,"QBrush");
	}
}


RING_FUNC(ring_QPen_capStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->capStyle());
}


RING_FUNC(ring_QPen_color)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->color();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QPen_dashOffset)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->dashOffset());
}


RING_FUNC(ring_QPen_isCosmetic)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->isCosmetic());
}


RING_FUNC(ring_QPen_isSolid)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->isSolid());
}


RING_FUNC(ring_QPen_joinStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->joinStyle());
}


RING_FUNC(ring_QPen_miterLimit)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->miterLimit());
}


RING_FUNC(ring_QPen_setBrush)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->setBrush(* (QBrush *) RING_API_GETCPOINTER(2,"QBrush"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QBrush"));
}


RING_FUNC(ring_QPen_setCapStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCapStyle( (Qt::PenCapStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setColor)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->setColor(* (QColor *) RING_API_GETCPOINTER(2,"QColor"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QColor"));
}


RING_FUNC(ring_QPen_setCosmetic)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCosmetic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setDashOffset)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDashOffset( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setJoinStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setJoinStyle( (Qt::PenJoinStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setMiterLimit)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setMiterLimit( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setStyle)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle( (Qt::PenStyle )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setWidth)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidth( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_setWidthF)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWidthF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPen_style)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->style());
}


RING_FUNC(ring_QPen_swap)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	pObject->swap(* (QPen *) RING_API_GETCPOINTER(2,"QPen"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QPen"));
}


RING_FUNC(ring_QPen_width)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->width());
}


RING_FUNC(ring_QPen_widthF)
{
	QPen *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPen *) RING_API_GETCPOINTER(1,"QPen");
	RING_API_RETNUMBER(pObject->widthF());
}


RING_FUNC(ring_QColor_alpha)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->alpha());
}


RING_FUNC(ring_QColor_alphaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->alphaF());
}


RING_FUNC(ring_QColor_black)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->black());
}


RING_FUNC(ring_QColor_blackF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blackF());
}


RING_FUNC(ring_QColor_blue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blue());
}


RING_FUNC(ring_QColor_blueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->blueF());
}


RING_FUNC(ring_QColor_convertTo)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->convertTo( (QColor::Spec )  (int) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_cyan)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->cyan());
}


RING_FUNC(ring_QColor_cyanF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->cyanF());
}


RING_FUNC(ring_QColor_darker)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->darker( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_getCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getCmyk(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5),RING_API_GETINTPOINTER(6));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
	RING_API_ACCEPTINTVALUE(5) ;
}


RING_FUNC(ring_QColor_getCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getCmykF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"),(qreal *) RING_API_GETCPOINTER(6,"qreal"));
}


RING_FUNC(ring_QColor_getHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsl(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHslF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_getHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsv(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getHsvF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_getRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISSTRING(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getRgb(RING_API_GETINTPOINTER(2),RING_API_GETINTPOINTER(3),RING_API_GETINTPOINTER(4),RING_API_GETINTPOINTER(5));
	RING_API_ACCEPTINTVALUE(1) ;
	RING_API_ACCEPTINTVALUE(2) ;
	RING_API_ACCEPTINTVALUE(3) ;
	RING_API_ACCEPTINTVALUE(4) ;
}


RING_FUNC(ring_QColor_getRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISPOINTER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISPOINTER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->getRgbF((qreal *) RING_API_GETCPOINTER(2,"qreal"),(qreal *) RING_API_GETCPOINTER(3,"qreal"),(qreal *) RING_API_GETCPOINTER(4,"qreal"),(qreal *) RING_API_GETCPOINTER(5,"qreal"));
}


RING_FUNC(ring_QColor_green)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->green());
}


RING_FUNC(ring_QColor_greenF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->greenF());
}


RING_FUNC(ring_QColor_hslHue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslHue());
}


RING_FUNC(ring_QColor_hslHueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslHueF());
}


RING_FUNC(ring_QColor_hslSaturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslSaturation());
}


RING_FUNC(ring_QColor_hslSaturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hslSaturationF());
}


RING_FUNC(ring_QColor_hsvHue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvHue());
}


RING_FUNC(ring_QColor_hsvHueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvHueF());
}


RING_FUNC(ring_QColor_hsvSaturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvSaturation());
}


RING_FUNC(ring_QColor_hsvSaturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hsvSaturationF());
}


RING_FUNC(ring_QColor_hue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hue());
}


RING_FUNC(ring_QColor_hueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->hueF());
}


RING_FUNC(ring_QColor_isValid)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QColor_lighter)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->lighter( (int ) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_lightness)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->lightness());
}


RING_FUNC(ring_QColor_lightnessF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->lightnessF());
}


RING_FUNC(ring_QColor_magenta)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->magenta());
}


RING_FUNC(ring_QColor_magentaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->magentaF());
}


RING_FUNC(ring_QColor_name)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETSTRING(pObject->name().toStdString().c_str());
}


RING_FUNC(ring_QColor_red)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->red());
}


RING_FUNC(ring_QColor_redF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->redF());
}


RING_FUNC(ring_QColor_rgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->rgb();
		RING_API_RETCPOINTER(pValue,"QRgb");
	}
}


RING_FUNC(ring_QColor_rgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QRgb *pValue ; 
		pValue = (QRgb *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRgb)) ;
		*pValue = pObject->rgba();
		RING_API_RETCPOINTER(pValue,"QRgb");
	}
}


RING_FUNC(ring_QColor_saturation)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->saturation());
}


RING_FUNC(ring_QColor_saturationF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->saturationF());
}


RING_FUNC(ring_QColor_setAlpha)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlpha( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setAlphaF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setAlphaF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setBlue)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBlue( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setBlueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBlueF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCmyk( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QColor_setCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCmykF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5), (double ) RING_API_GETNUMBER(6));
}


RING_FUNC(ring_QColor_setGreen)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGreen( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setGreenF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setGreenF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsl( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHslF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsv( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHsvF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setNamedColor)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setNamedColor(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QColor_setRed)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRed( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setRedF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRedF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QColor_setRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRgb( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRgbF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
}


RING_FUNC(ring_QColor_setRgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	pObject->setRgba(* (QRgb  *) RING_API_GETCPOINTER(2,"QRgb"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRgb"));
}


RING_FUNC(ring_QColor_spec)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->spec());
}


RING_FUNC(ring_QColor_toCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toCmyk();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_toHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toHsl();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_toHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toHsv();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_toRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->toRgb();
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_value)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->value());
}


RING_FUNC(ring_QColor_valueF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->valueF());
}


RING_FUNC(ring_QColor_yellow)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->yellow());
}


RING_FUNC(ring_QColor_yellowF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	RING_API_RETNUMBER(pObject->yellowF());
}


RING_FUNC(ring_QColor_colorNames)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QStringList *pValue ; 
		pValue = new QStringList() ;
		*pValue = pObject->colorNames();
		RING_API_RETCPOINTER(pValue,"QStringList");
	}
}


RING_FUNC(ring_QColor_fromCmyk)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromCmyk( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5), (int ) RING_API_GETNUMBER(6));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromCmykF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 6 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(6) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromCmykF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5), (double ) RING_API_GETNUMBER(6));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromHsl)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsl( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromHslF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHslF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromHsv)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsv( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromHsvF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromHsvF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromRgb)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgb( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3), (int ) RING_API_GETNUMBER(4), (int ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromRgbF)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 5 ) {
		RING_API_ERROR(RING_API_BADPARACOUNT);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(4) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(5) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgbF( (double ) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3), (double ) RING_API_GETNUMBER(4), (double ) RING_API_GETNUMBER(5));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_fromRgba)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	{
		QColor *pValue ; 
		pValue = new QColor() ;
		*pValue = pObject->fromRgba(* (QRgb  *) RING_API_GETCPOINTER(2,"QRgb"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QRgb"));
		RING_API_RETCPOINTER(pValue,"QColor");
	}
}


RING_FUNC(ring_QColor_isValidColor)
{
	QColor *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QColor *) RING_API_GETCPOINTER(1,"QColor");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->isValidColor(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QPrinter_abort)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->abort());
}


RING_FUNC(ring_QPrinter_collateCopies)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->collateCopies());
}


RING_FUNC(ring_QPrinter_colorMode)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->colorMode());
}


RING_FUNC(ring_QPrinter_copyCount)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->copyCount());
}


RING_FUNC(ring_QPrinter_creator)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->creator().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_docName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->docName().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_duplex)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->duplex());
}


RING_FUNC(ring_QPrinter_fontEmbeddingEnabled)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->fontEmbeddingEnabled());
}


RING_FUNC(ring_QPrinter_fromPage)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->fromPage());
}


RING_FUNC(ring_QPrinter_fullPage)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->fullPage());
}


RING_FUNC(ring_QPrinter_isValid)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->isValid());
}


RING_FUNC(ring_QPrinter_outputFileName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->outputFileName().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_outputFormat)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->outputFormat());
}


RING_FUNC(ring_QPrinter_pageOrder)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->pageOrder());
}


RING_FUNC(ring_QPrinter_pageRect)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->pageRect( (QPrinter::Unit )  (int) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QRectF");
	}
}


RING_FUNC(ring_QPrinter_paperRect)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	{
		QRectF *pValue ; 
		pValue = (QRectF *) ring_state_malloc(((VM *) pPointer)->pRingState,sizeof(QRectF)) ;
		*pValue = pObject->paperRect( (QPrinter::Unit )  (int) RING_API_GETNUMBER(2));
		RING_API_RETCPOINTER(pValue,"QRectF");
	}
}


RING_FUNC(ring_QPrinter_paperSource)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->paperSource());
}


RING_FUNC(ring_QPrinter_printEngine)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETCPOINTER(pObject->printEngine(),"QPrintEngine");
}


RING_FUNC(ring_QPrinter_printProgram)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->printProgram().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_printRange)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->printRange());
}


RING_FUNC(ring_QPrinter_printerName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->printerName().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_printerSelectionOption)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETSTRING(pObject->printerSelectionOption().toStdString().c_str());
}


RING_FUNC(ring_QPrinter_printerState)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->printerState());
}


RING_FUNC(ring_QPrinter_resolution)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->resolution());
}


RING_FUNC(ring_QPrinter_setCollateCopies)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCollateCopies( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setColorMode)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setColorMode( (QPrinter::ColorMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setCopyCount)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCopyCount( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setCreator)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCreator(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setDocName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDocName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setDuplex)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setDuplex( (QPrinter::DuplexMode )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setFontEmbeddingEnabled)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFontEmbeddingEnabled( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setFromTo)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFromTo( (int ) RING_API_GETNUMBER(2), (int ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QPrinter_setFullPage)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFullPage( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setOutputFileName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOutputFileName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setOutputFormat)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOutputFormat( (QPrinter::OutputFormat )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setPageOrder)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPageOrder( (QPrinter::PageOrder )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setPaperSource)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPaperSource( (QPrinter::PaperSource )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setPrintProgram)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPrintProgram(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setPrintRange)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPrintRange( (QPrinter::PrintRange)  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_setPrinterName)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPrinterName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setPrinterSelectionOption)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPrinterSelectionOption(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QPrinter_setResolution)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setResolution( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QPrinter_supportsMultipleCopies)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->supportsMultipleCopies());
}


RING_FUNC(ring_QPrinter_toPage)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->toPage());
}


RING_FUNC(ring_QPrinter_newPage)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETNUMBER(pObject->newPage());
}


RING_FUNC(ring_QPrinter_paintEngine)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	RING_API_RETCPOINTER(pObject->paintEngine(),"QPaintEngine");
}


RING_FUNC(ring_QPrinter_setPageSizeMM)
{
	QPrinter *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QPrinter *) RING_API_GETCPOINTER(1,"QPrinter");
	pObject->setPageSizeMM(* (QSizeF *) RING_API_GETCPOINTER(2,"QSizeF"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QSizeF"));
}


RING_FUNC(ring_QFont_bold)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->bold());
}


RING_FUNC(ring_QFont_capitalization)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->capitalization());
}


RING_FUNC(ring_QFont_defaultFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->defaultFamily().toStdString().c_str());
}


RING_FUNC(ring_QFont_exactMatch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->exactMatch());
}


RING_FUNC(ring_QFont_family)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->family().toStdString().c_str());
}


RING_FUNC(ring_QFont_fixedPitch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->fixedPitch());
}


RING_FUNC(ring_QFont_fromString)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	RING_API_RETNUMBER(pObject->fromString(RING_API_GETSTRING(2)));
}


RING_FUNC(ring_QFont_hintingPreference)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->hintingPreference());
}


RING_FUNC(ring_QFont_isCopyOf)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->isCopyOf(* (QFont *) RING_API_GETCPOINTER(2,"QFont")));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
}


RING_FUNC(ring_QFont_italic)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->italic());
}


RING_FUNC(ring_QFont_kerning)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->kerning());
}


RING_FUNC(ring_QFont_key)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->key().toStdString().c_str());
}


RING_FUNC(ring_QFont_lastResortFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->lastResortFamily().toStdString().c_str());
}


RING_FUNC(ring_QFont_lastResortFont)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->lastResortFont().toStdString().c_str());
}


RING_FUNC(ring_QFont_letterSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->letterSpacing());
}


RING_FUNC(ring_QFont_letterSpacingType)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->letterSpacingType());
}


RING_FUNC(ring_QFont_overline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->overline());
}


RING_FUNC(ring_QFont_pixelSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pixelSize());
}


RING_FUNC(ring_QFont_pointSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pointSize());
}


RING_FUNC(ring_QFont_pointSizeF)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->pointSizeF());
}


RING_FUNC(ring_QFont_rawMode)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->rawMode());
}


RING_FUNC(ring_QFont_rawName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->rawName().toStdString().c_str());
}


RING_FUNC(ring_QFont_resolve)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	{
		QFont *pValue ; 
		pValue = new QFont() ;
		*pValue = pObject->resolve(* (QFont *) RING_API_GETCPOINTER(2,"QFont"));
	if (RING_API_ISCPOINTERNOTASSIGNED(1))
		ring_state_free(((VM *) pPointer)->pRingState,RING_API_GETCPOINTER(1,"QFont"));
		RING_API_RETCPOINTER(pValue,"QFont");
	}
}


RING_FUNC(ring_QFont_setBold)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setBold( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setCapitalization)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setCapitalization( (QFont::Capitalization )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setFamily)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFamily(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setFixedPitch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setFixedPitch( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setHintingPreference)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setHintingPreference( (QFont::HintingPreference )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setItalic)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setItalic( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setKerning)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setKerning( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setLetterSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setLetterSpacing( (QFont::SpacingType )  (int) RING_API_GETNUMBER(2), (double ) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFont_setOverline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setOverline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPixelSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPixelSize( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPointSize)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPointSize( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setPointSizeF)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setPointSizeF( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setRawMode)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRawMode( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setRawName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setRawName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setStretch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStretch( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStrikeOut)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStrikeOut( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStyle)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyle( (QFont::Style )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setStyleHint)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 3 ) {
		RING_API_ERROR(RING_API_MISS3PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	if ( ! RING_API_ISNUMBER(3) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleHint( (QFont::StyleHint )  (int) RING_API_GETNUMBER(2), (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(3));
}


RING_FUNC(ring_QFont_setStyleName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISSTRING(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleName(RING_API_GETSTRING(2));
}


RING_FUNC(ring_QFont_setStyleStrategy)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setStyleStrategy( (QFont::StyleStrategy )  (int) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setUnderline)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setUnderline( (bool ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setWeight)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWeight( (int ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_setWordSpacing)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 2 ) {
		RING_API_ERROR(RING_API_MISS2PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	if ( ! RING_API_ISNUMBER(2) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject->setWordSpacing( (double ) RING_API_GETNUMBER(2));
}


RING_FUNC(ring_QFont_stretch)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->stretch());
}


RING_FUNC(ring_QFont_strikeOut)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->strikeOut());
}


RING_FUNC(ring_QFont_style)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->style());
}


RING_FUNC(ring_QFont_styleHint)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->styleHint());
}


RING_FUNC(ring_QFont_styleName)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETSTRING(pObject->styleName().toStdString().c_str());
}


RING_FUNC(ring_QFont_styleStrategy)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RING_API_BADPARATYPE);
		return ;
	}
	pObject = (QFont *) RING_API_GETCPOINTER(1,"QFont");
	RING_API_RETNUMBER(pObject->styleStrategy());
}


RING_FUNC(ring_QFont_toString)
{
	QFont *pObject ;
	if ( RING_API_PARACOUNT != 1 ) {
		RING_API_ERROR(RING_API_MISS1PARA);
		return ;
	}
	RING_API_IGNORECPOINTERTYPE ;
	if ( ! RING_API_ISPOINTER(1) ) {
		RING_API_ERROR(RIN