<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {rkt_pager} function plugin
 *
 * Type:     function<br>
 * Name:     rkt_pager<br>
 * Date:     Nov 26, 2005<br>
 * Purpose:  make an pager links from an array of data<br>
 * Input:<br>
 *         - links = array of link data
 *         - request = string of request data
 *         - separator = string of separator
 *
 *
 * Examples:
 * <pre>
 * {rkt_pager links=$links}
 * {rkt_pager links=$links request=$request}
 * {rkt_pager links=$links request='t=9&amp;i=2' separator='&nbsp;'}
 * </pre>
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @version  1.1
 * @link none
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_rkt_pager($params, &$smarty)
{
    $_html_result = '';
    if (!is_array($params)){
        return $_html_result;
    }
    extract($params);
    $request = empty($request)?'':$request;
    $separator = empty($separator)?'&nbsp;':$separator;

    $pager_func = array(
        'curr'=> 'rkt_pager_focus_page',
        'pager'=> 'rkt_pager_blur_page'
    );    

    $pager = array();
    foreach ($links as $link){
        $pager[] = call_user_func($pager_func[$link['class']], $link, $request);
    }

    $_html_result = implode($separator,$pager); 

    return $_html_result;
}

/**
 * ݂̃y[WHTML ̐
 *
 * @access private
 * @param array $link N
 * @param string $request NGXg
 * @param string $separator ؂蕶
 * @return string
 */
function rkt_pager_focus_page($link, $request)
{
	return '<strong>'.$link['page'].'</strong>';
}

/**
 * y[WNHTML ̐
 *
 * @access private
 * @param array $link N
 * @param string $request NGXg
 * @param string $separator ؂蕶
 * @return string
 */
function rkt_pager_blur_page($link, $request)
{
    $self = $_SERVER['REQUEST_URI'];
    $needle = array(
        'QUERY_STRING'=>   '/',
        'PATH_INFO'=>      '?',
        'ORIG_PATH_INFO'=> '?',
    );
    $addstr = array(
        'QUERY_STRING'=>   '/',
        'PATH_INFO'=>      '',
        'ORIG_PATH_INFO'=> '',
    );

    $pos = strrpos($self, $needle[PATH_INFO_KEY]);
    if (!empty($pos)){
        $self = substr($self,0,$pos);
    }
    $self = $self.$addstr[PATH_INFO_KEY];

	return '<a href="'.$self.WAP_URI_SEPARATOR.'offset='.$link['offset'].'&amp;'.$request.'">'.$link['page'].'</a>';
}

/* vim: set expandtab: */

?>
