<?php
/* ========================================================================
 - [modules/community/show/calendar.php]
 -      コミュニティイベントカレンダー
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/28] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_community.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_community
{
    /**
     * 表示対象年月日
     * @var string
     */
    var $date = '';

    /**
     * カレンダーオブジェクト
     * @var object
     */
    var $objcal = null;

    /**
     * 誕生日格納用
     * @var array
     */
    var $birthdays = array();

    /**
     * イベント格納用
     * @var array
     */
    var $events = array();

    /**
     * 日付の参照範囲
     * @var array
     */
    var $limitday = array();

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('community/show/calendar.tpl');

        /* 表示対象日付 */
        $this->setSafety('date', '_REQUEST', 'string');

        /* カレンダーオブジェクトの生成 */
        $this->objcal = new RKT_calendar($this->date);
        
        $this->set_calendar();        
        $this->set_event();
    }

    /**
     * カレンダーの設定
     *
     * @access private
     * @return void
     */
    function set_calendar()
    {
        $id2yobi = array(    // idから曜日に変換
            RKT_SUN => "sun",
            RKT_MON => "mon",
            RKT_TUE => "tue",
            RKT_WED => "wed",
            RKT_THU => "thu",
            RKT_FRI => "fri",
            RKT_SAT => "sat"
        );

        $id2style = array(    // idからcssクラス名に変換
            RKT_WEEKDAY => "calendar",
            RKT_HOLIDAY => "holiday",
            RKT_SATURDAY =>"saturday",
            RKT_TODAY =>   "today"
        );
        $cals   = $this->objcal->getCalendar();
        $infos  = $this->objcal->getInformation();
        $dates  = $this->objcal->getDates();
        $last   = $this->objcal->getLastday();

        $weeks = array();
        $yobi = "";
        $style = "";

        $calendars = array();
        foreach ($cals as $weekly=>$weeks){
            $cal[$weekly] = array();
            foreach ($weeks as $week=>$day){
                $style = $id2style[$infos[$weekly][$week]];
                if (!empty($this->weeks[$weekly][$week]) && !empty($day)){
                    $this->schedule[$day] = $this->weeks[$weekly][$week];
                }
        
                $calendars[$weekly]['week'][$week] = array('day'=>$day,'style'=>$style);                
            }
        } // foreach ($cals as $weekly=>$weeks)
        $this->month = sprintf('%04d-%02d',$dates[RKT_YEAR],$dates[RKT_MONTH]);

        $this->limitday['start'] =  sprintf('%04d-%02d-01',$dates[RKT_YEAR],$dates[RKT_MONTH]);
        $this->limitday['last']  =  sprintf('%04d-%02d-%d',$dates[RKT_YEAR],$dates[RKT_MONTH],$last);
        $this->limitday['month'] =  sprintf('%02d',$dates[RKT_MONTH]);

        $this->Assign('calendars', $calendars);
        $this->Assign('date', $dates);
        $this->Assign('month', $dates[RKT_MONTH]);
    }


    /**
     * イベントリストの設定
     *
     * @access private
     * @return void
     **/
    function set_event()
    {
        $date_format  = sql_query::dateFormat('tpc.start_date','%d');
        $month_format = sql_query::dateFormat('tpc.start_date','%m'); 
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.ref_community as ref_community,'.
                'tpc.topic as topic,'.
                $date_format.'day '.
            'FROM '.
                DB_PREFIX.'com_topic tpc '.
            'WHERE '.
                'tpc.status = '.STATUS_TOPIC_EVENT.' AND '.
                'tpc.ref_community = '.$this->ref_community.' AND '.
                $month_format." = '".$this->limitday['month']."' ".
            'ORDER BY '.
                'tpc.start_date';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if(empty($result)){
            return ;
        }
        $this->Assign('events', $result);
    }
} // webapp
?>
