<?php
/* ========================================================================
 - [modules/admin/environment/account.php]
 -      管理者情報の編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/29] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_admin.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_admin
{
    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objvld = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN));

        $this->setTemplateFile('admin/environment/account.tpl');        

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'admin/environment/account/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objvld = new RKT_validate('_POST');
        if ($this->do_query()){
            $_SESSION['complete'] = true;
            header('Location: '.HTTP_ACTION.'admin/environment/account/');
            exit();
        }
        
        if (!empty($_SESSION['complete'])){
            $this->Assign('complete', true);
            unset($_SESSION['complete']);
        }
        $this->set_logname();
    }

    /**
     * ログイン名の設定
     *
     * @access private
     * @return void
     */
    function set_logname()
    {
        $sql=
            'SELECT '.
                'email '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'id = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $logname = sql_query::decrypt($result['email']);

        $this->Assign('logname', $logname);
    }


    /**
     * 既存パスワードが適正か判定
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_match()
    {
        $password = $this->objvld->getRequest('cur_passwd');
        $password = RKT_auth::passwdHash($password);

        $sql=
            'SELECT '.
                'password '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                'id = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        
        $match = strstr($password, $result['password']);

        return !empty($match);
    }

    /**
     * 入力されたe-mailがユニークか
     *
     * @access private
     * @return boolean 正常時：真
     */
    function is_unique()
    {
        if (empty($_POST['email'])){
            return true;
        }
        $email_hash = sql_query::hash($_POST['email']);
        $sql=
            'SELECT '.
                'count(email_hash) as ct '.
            'FROM '.
                DB_PREFIX.'act_account '.
            'WHERE '.
                "email_hash = '".$email_hash."' AND ".
                'id != '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);

        return empty($result['ct']);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return boolean 正常時：真
     */
    function do_validate()
    {
        if (empty($_POST['manip'])){
            return false;
        }
        $option = array(
            'format'=> '\w+',
            'min_length'=>4,
            'max_length'=>32
        );

        $this->objvld->validate('string', 'logname', null, true);
        $this->objvld->validate('string', 'cur_passwd', $option, true);
        $this->objvld->validate('string', 'password', $option, true);
        $this->objvld->validate('string', 'confirm', $option, true);

        /* 入力値の取得 */
        $values = array(
            'cur_passwd'=>$this->objvld->getRequest('cur_passwd'),
            'password'=>$this->objvld->getRequest('password'),
            'confirm'=>$this->objvld->getRequest('confirm'),
        );
        $this->Assign('value', $values);

        // 確認用パスワードが一致しているか
        if (!empty($values['confirm'])){
            $confirm = strstr($values['password'], $values['confirm']);
        }
        if(empty($confirm)){
            $this->objvld->setAlert('confirm');
        }

        // 既存パスワードが適正か判定
        if (!$this->is_match()){
            $this->objvld->setAlert('cur_passwd');
        }

        // ログイン名のユニークチェック
        if (!$this->is_unique()){
            $this->objvld->setAlert('unique');
        }

        $check = $this->objvld->getValidate();
        if (!$check){
            $this->objvld->displayAlert($this);
            return false;
        }

        return true;
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        if (!$this->do_validate()){
            return false;
        }
        $password = $this->objvld->getRequest('password');
        $password = RKT_auth::passwdHash($password);
        $password = $this->objdb->quote($password);

        $logname    = $this->objvld->getRequest('logname');
        $email_hash = sql_query::hash($logname);
        $logname    = sql_query::encrypt($logname);
        $logname    = $this->objdb->quote($logname);
        $email_hash = $this->objdb->quote($email_hash);

        $this->Assign('noupdate', true);

        $sql=
            'UPDATE '.
                DB_PREFIX.'act_account '.
            'SET '.
                'password = '.$password.','.
                'email = '.$logname.','.
                'email_hash = '.$email_hash.' '.
            'WHERE '.
                'id = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }
} // webapp
?>
