<?php
/* ========================================================================
 - [modules/friend/diary/result.php]
 -      日記検索結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/13] 公開レベルをビットフラグに対応
 -      [2006/07/28] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/diary/result.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'friend/diary/result/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }
        
        $this->order = 'ORDER BY ent.regist_date DESC';

        $this->set_sort();
        $this->set_condition();
        $this->set_topic();
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_DIARY.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * 記事リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();

        /* 絞込条件の取得 */
        $validates = array(
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );
        $conditions = $this->catchCondition($validates);

        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "ent.subject like '%".$keyword."%'".' OR '.
                    "ent.body like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }

        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }
        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * トピックの設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_DIARY);    // クラスの生成
        $sql=
            'SELECT '.
                'ent.id as id,'.
                'ent.ref_account as ref_account,'.
                'ent.modify as modify,'.
                'ent.regist_date as regist_date,'.
                'ent.visibility as visibility,'.
                'ent.subject as subject,'.
                'ent.body as body,'.
                'count(cmt.id) as comments,'.
                'pro.nickname as nickname,'.
                'sex.sex as sex '.
            'FROM '.
                DB_PREFIX.'dia_entry ent '.
                'LEFT JOIN '.DB_PREFIX.'dia_comment cmt '.
                    'ON ent.id = cmt.ref_entry,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = ent.ref_account AND '.
                'act.id = pro.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('ent.visibility & '.VISIBILITY_OPEN).' '.
                $this->where.
            'GROUP BY '.
                'ent.id,'.
                'act.id '.
            $this->order;
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        if (empty($result)){
            return ;
        }
        foreach ($result as $key=>$value){
            $result[$key]['picture'] = $this->get_picture($value['id']);
        }

        $this->Assign('topics', $result);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_entry
     * @return array
     */
    function get_picture($ref_entry)
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$ref_entry;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        return $result;
    }
} // webapp
?>
