<?php
/* ========================================================================
 - [modules/private/diary/upload.php]
 -      写真編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_upload.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 画像ID
     * @var integer
     */
    var $id = null;

    /**
     * 日記記事ID
     * @var integer
     */
    var $ref_entry = null;

    /**
     * 画像削除フラグ
     * @var integer
     */
    var $delete = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateBase('base/xml.tpl');
        $this->setTemplateFile('private/diary/upload.tpl');
        $this->addJavas('prototype.js');

        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM); 
        $this->objfile->setUID($this->account['id']);

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_entry');
        $this->ref_entry = empty($this->ref_entry)?0:$this->ref_entry;

        /* URL引数の設定 */
        $this->setSafety('id');
        $this->setSafety('delete');

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb, DB_PREFIX.'dia_picture');
        $this->do_query();
        $this->delete_picture();

        $this->set_pictures();
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_pictures()
    {
        $sql=
            'SELECT '.
                'id,'.
                'filename href,'.
                'thumbnail src,'.
                't_width width,'.
                't_height height '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'ref_entry = '.$this->ref_entry.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        $row = 0;
        $html = '<table width="100%" class="border" align="center" cellpadding="4" cellspacing="0"><tr>';
        foreach ($result as $value){
            $html .= 
                '<td style="text-align:center;"><img src="'.BASE_URL.$value['src'].'" width="'.$value['width'].'" height="'.$value['height'].'"><br />'.
                '<a href="javascript:insertImg(\\\''.BASE_URL.$value['href'].'\\\')">'.
                '<img src="'.BASE_URL.'resource/img/icons/picture_add.gif" width="16" height="16" alt="原寸表示" /></a>&nbsp;&nbsp;'.
                '<a href="javascript:void(0)" onclick="insertImgLink(\\\''.BASE_URL.$value['href'].'\\\',\\\''.BASE_URL.$value['src'].'\\\')">'.
                '<img src="'.BASE_URL.'resource/img/icons/picture_delete.gif" width="16" height="16" alt="縮小表示" /></a>&nbsp;&nbsp;'.
                '<a href="'.HTTP_ACTION.'private/diary/upload/'.$this->ref_entry.'/'.WAP_URI_SEPARATOR.'id='.$value['id'].'&amp;delete=1" '.
                'onclick="deleteImgs(\\\''.BASE_URL.$value['href'].'\\\',\\\''.BASE_URL.$value['src'].'\\\')" target="imgframe">'.
                '<img src="'.BASE_URL.'resource/img/icons/cross.gif" width="16" height="16" alt="削除" /></a>'.
                '<input type="hidden" name="ref_pictures[]" value="'.$value['id'].'" />'.
                '</td>';
            $row ++;
            if ($row >= 3){
                $row = 0;
                $html .= '</tr><tr>';
            }
        }
        $html .= '</tr></table>';

        $this->Assign('pictures', $html);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        /* 一覧用画像 */
        if (!$this->objfile->catchFile('image')) {
            return false;
        }
        if (!$this->objfile->isImage()){
            return false;
        }
        $title = $this->objfile->getName();
        $extension = $this->objfile->getExtension();

        // 直接入力
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_entry', $this->ref_entry);
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('title', $title);

        /* データベース操作実行 */
        $result = $this->objmnp->doManip($this);
        $id = $this->objmnp->getCurID();
        $name = $id.time();

        // ファイルの保存先
        $large_src = ARCHIVES_MEMBER_PATH.$this->account['id'].'/large/'.$name.'.'.$extension;
        $small_src = ARCHIVES_MEMBER_PATH.$this->account['id'].'/small/'.$name.'.'.$extension;

        // ファイルの保存
        $large = $this->objfile->saveResize($large_src,PHOTO_MAX_SIZE,PHOTO_MAX_SIZE);
        $small = $this->objfile->saveResize($small_src,PHOTO_SMALL_SIZE,PHOTO_SMALL_SIZE);

        $sql =
            'UPDATE '.
                DB_PREFIX.'dia_picture '.
            'SET '.
                "filename = '".$large_src."',".
                'width = '.$large['width'].','.
                'height = '.$large['height'].','.
                "thumbnail = '".$small_src."',".
                't_width = '.$small['width'].','.
                't_height = '.$small['height'].' '.
            'WHERE '.
                'id ='.$id .' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_picture()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql=
            'SELECT '.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        $this->objfile->unlink($result['thumbnail']);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'dia_picture '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $return = $this->objdb->exec($sql);
        
        return $return;
    }
} // webapp
?>
