<?php
/* ========================================================================
 - [modules/public/community/member.php]
 -      メンバー一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/02/12] コミュニティメンバーステータスをビットフラグに変更
 -      [2006/08/29] 表示整形の不具合修正
 -      [2006/08/13] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * コミュニティID
     * @var integer
     */
    var $ref_community = 0;

    /**
     * オフセット
     * @var integer
     */
    var $offset = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/community/member.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_community');
        $this->setPathInfo('offset', 1);
        $this->Assign('ref_community', $this->ref_community);


        if (!empty($_SESSION['updated_names'])){
            unset ($_SESSION['updated_names']);
            $this->Assign('updated_names', true);
        }

        $this->set_community();
        $this->set_member();
        $this->set_uri();
    }

    /**
     * コミュニティ情報の設定
     *
     * @access private
     * @return void
     */
    function set_community()
    {
        $sql=
            'SELECT '.
                'com.community as community,'.
                'pic.thumbnail as src,'.
                'pic.t_width as width,'.
                'pic.t_height as height '.
            'FROM '.
                DB_PREFIX.'com_community com '.
                    'LEFT JOIN '.DB_PREFIX.'com_picture pic '.
                    'ON com.id = pic.ref_community AND '.
                       'pic.status = '.STATUS_PICTURE_COMMUNITY.' '.
            'WHERE '.
                'com.avail = '.AVAIL_ENABLE.' AND '.
                'com.visibility = '.VISIBILITY_PUBLIC.' AND '.
                'com.id = '.$this->ref_community;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('community',$result);
    }

    /**
     * 友達の設定
     *
     * @access private
     * @return void
     */
    function set_member()
    {
        $visibility = '';
        if (!WAP_SNS_VISIBILITY){
            $visibility = 'pro.visibility = '.VISIBILITY_PUBLIC.' AND ';
        }

        $objpgr = new RKT_pager($this->objdb, $this->offset, LIMIT_TILE);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                        'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'com_names nam '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = nam.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'nam.ref_community = '.$this->ref_community .' AND '.
                $visibility.
                sql_query::bitFlag('nam.status & '.STATUS_COMMUNITY_MEMBERS).' '.
            'ORDER BY '.
                'nam.modify ';

        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        
        $list=array();
        $row=0;
        foreach ($result as $value){
            $value['src'] = empty($value['src'])?BASE_URL.NOPHOTO_SMALL:BASE_URL.$value['src'];
            $value['width'] = empty($value['width'])?PHOTO_SMALL_SIZE:$value['width'];
            $value['height'] = empty($value['height'])?PHOTO_SMALL_SIZE:$value['height'];

            $list[] = array(
                'id'=>            $value['id'],
                'nickname'=>      $value['nickname'],
                'friend_number'=> $value['friend_number'],
                'src'=>           $value['src'],
                'width'=>         $value['width'],
                'height'=>        $value['height']
            );
            $row++;
        }
        
        $inits = array (0,4,3,2,1);
        for ($row=$inits[$row%5]; $row; $row--){
            $list[] = array(
                'id'=> 0,
                'nickname'=> '',
                'friend_number'=>0,
                'src'=>    '',
                'width'=>  0,
                'height'=> 0
            );
        }
        $this->Assign('members', $this->shape_member($list));
    }

    /**
     * 会員情報の成形
     *
     * @access private
     * @return void
     */
    function shape_member($friends)
    {
        $list = array();
        $row = 0;
        $column = 0;
        foreach ($friends as $value){
            // 改行処理
            if ($column >= 5){
                $column = 0;
                $row++;
            }
            $list[$row][$column] = $value;
            $column++;
        } // foreach ($result as $value)
        
        return $list;
    }

    /**
     * ページャー用URIの設定
     *
     * @access private
     * @return void
     */
    function set_uri()
    {
        $pager_uri  = HTTP_ACTION.'public/community/member/';
        $pager_uri .= $this->ref_community.'/';
        $pager_uri .= '%offset%/';

        $this->Assign('pager_uri', $pager_uri);
    }    
} // webapp
?>
