<?php
/**
 * Smarty plugin
 * @package Smarty
 * @subpackage plugins
 */


/**
 * Smarty {rkt_checked} function plugin
 *
 * Type:     function<br>
 * Name:     rkt_checked<br>
 * Purpose:  If[^̏o<br>
 * Input:<br>
 *         - links = array of link data
 *         - request = string of request data
 *         - separator = string of separator
 *
 *
 * Examples:
 * <pre>
 * {rkt_checked options=$options checked=$checked}
 * {rkt_checked options=$options checked=$checked separator='&nbsp;'}
 * </pre>
 * @author   Yujiro Takahashi <yujiro@rakuto.net>
 * @version  1.0
 * @link none
 * @param array
 * @param Smarty
 * @return string
 */
function smarty_function_rkt_checked($params, &$smarty)
{
    $_html_result = '';
    if (!is_array($params)){
        return $_html_result;
    }
    extract($params);
    $separator = empty($separator)?'&nbsp;':$separator;

    $list = array();
    $checked = is_array($checked)?$checked:array($checked);
    foreach ($checked as $key){
        if (!empty($options[$key])){
            $list[] = $options[$key];
        }
    } // foreach ($checked as $key)

    $_html_result = implode($separator,$list); 

    return $_html_result;
}

/* vim: set expandtab: */

?>
