<?php
/* ========================================================================
 - [modules/friend/edit/message.php]
 -      メッセージを送る
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/30] 画像添付時の送信先IDを格納
 -      [2007/08/30] メッセージの更新処理にrkt_manipクラスを使用
 -      [2007/08/19] メールによる画像添付機能追加
 -      [2007/03/08] 下書き時にも自動通知メールが送信されるエラーを修正
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_friend.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_friend
{
    /**
     * メッセージID
     * @var integer
     */
    var $id = null;

    /**
     * relation状況
     * @var integer
     */
    var $relation = 0;

    /**
     * 送信先メッセージID
     * @var integer
     */
    var $to_message_id = 0;

    /**
     * 添付画像を送信
     * @var integer
     */
    var $attach = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/edit/message.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('relation');
        $this->Assign('relation', $this->relation);
        
        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'friend/edit/message/'.$this->sid.'/'.$this->ref_friend.'/again/');
            exit();
        }

        $this->set_attach();            // 画像添付フラグの設定

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'fri_message');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->do_send_message();

            $this->mail_action();
            unset($_SESSION['attach']);

            $id = $this->objmnp->getCurID();
            header('Location: '.HTTP_ACTION.'friend/edit/message/'.$this->sid.'/'.$this->ref_friend.'/complete/'.WAP_URI_SEPARATOR.'id='.$id.'&attach='.$this->attach);
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            $_SESSION['attach'] = $this->attach;
            header('Location: '.HTTP_ACTION.'friend/edit/message/'.$this->sid.'/'.$this->ref_friend.'/confirm/');
            exit();
        }
        $this->Assign('attach', $this->attach);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        $statuses = array(
            'manip'=> MESSAGE_SENT,
            'draft'=> MESSAGE_DRAFT,
            'validate'=> MESSAGE_DRAFT
        );
        $status = empty($_POST['manip'])?'validate':'manip';
        $status = empty($_POST['draft'])?$status:'draft';

        // 直接入力
        $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('ref_account', $this->account['id']);
        $this->objmnp->setValue('ref_to',  $this->ref_friend);
        $this->objmnp->setValue('ref_from',$this->account['id']);
        $this->objmnp->setValue('status', $statuses[$status]);
        $this->objmnp->setValue('flag', MESSAGE_FLAG_READ);

        $this->objmnp->setInputEffect('body', array('func'=>array('webapp', 'emojiConvert')));

        // 更新しない項目名
        $skip = array(
            'ref_account',
            'ref_message',
        );
        return $this->objmnp->execute($this, $skip);
    }

    /**
     * メッセージの送信
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_send_message()
    {
        if ($this->objmnp->getValue('status') != MESSAGE_SENT){
            return false;
        }
        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'fri_message');

        $objmnp->setValue('modify',      date('Y-m-d H:i:s'));
        $objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        $objmnp->setValue('status',      MESSAGE_INBOX);
        $objmnp->setValue('ref_account', $this->objmnp->getValue('ref_to'));
        $objmnp->setValue('ref_to',      $this->objmnp->getValue('ref_to'));
        $objmnp->setValue('ref_from',    $this->objmnp->getValue('ref_from'));
        $objmnp->setValue('flag',        MESSAGE_FLAG_UNREAD);
        $objmnp->setValue('subject',     $this->objmnp->getValue('subject'));
        $objmnp->setValue('body',        $this->objmnp->getValue('body'));

        $result = $objmnp->manip();
        if ($result){
            $this->send_mail();
            $this->to_message_id = $objmnp->getCurID();
        }
        return $result;
    }

    /**
     * 自動通知メール
     *
     * @access private
     * @return void
     */
    function send_mail()
    {
        $sql=
            'SELECT '.
                'nickname '.
            'FROM '.
                DB_PREFIX.'act_profile '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $infos = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $objmail = new sendmail('message');

        $objmail->Assign('user_name', $this->friend['nickname']);
        $objmail->Assign('friend', $infos['nickname']);
        $objmail->Assign('url', HTTP_ACTION.'private/message/list/');

        $to = sql_query::decrypt($this->friend['email']);
        $objmail->send($to);
    }

    /******************************************************/
    /**************    メールアクション     ***************/
    /******************************************************/
    /**
     * 画像添付フラグの設定
     *
     * @access private
     * @return array
     */
    function set_attach()
    {
        if (isSet($_POST['attach'])){
            $this->attach = empty($_POST['attach'])?array():$_POST['attach'];
            return ;
        }
        if (isSet($_SESSION['attach'])){
            $this->attach = empty($_SESSION['attach'])?array():$_SESSION['attach'];
            return ;
        }
        if (isSet($_GET['attach'])){
            $this->attach = empty($_GET['attach'])?array():$_GET['attach'];
            return ;
        }
        if (preg_match('/(manip|confirm|edit)/i',$_SERVER['REQUEST_URI'])){
            return ;
        }
    }

    /**
     * メールアクション設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function mail_action()
    {
        if (empty($this->attach)){
            return false;
        }
        $ref_relation = $this->objmnp->getCurID();

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_mailaction');

        $objmnp->setValue('modify',        date('Y-m-d H:i:s'));
        $objmnp->setValue('ref_table',     ACTION_FRI_MESSAGE);
        $objmnp->setValue('ref_relation',  $ref_relation);
        $objmnp->setValue('ref_account',   $this->account['id']);
        $objmnp->setValue('ref_addition',  $this->to_message_id);

        return $objmnp->manip();
    }
} // webapp
?>
