<?php
/* ========================================================================
 - [modules/private/content/inquire.php]
 -      問合せフォーム
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/08/12] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 暗号化オブジェクト
     * @var object
     */
    var $crypt = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->crypt = RKT_crypt::getInstance();

        $this->setTemplateFile('private/content/inquire.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->Assign('id', $this->id);
        $this->setSafety('date', '_GET', 'date');
        /* カレンダーオブジェクトの生成 */
        $this->objcal = new RKT_calendar($this->date);

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/content/inquire/'.$this->sid.'/again/');
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'inq_inquire');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            $this->aes_encrypt();
            $this->sendmail();
            header('Location: '.HTTP_ACTION.'private/content/inquire/'.$this->sid.'/complete/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/content/inquire/'.$this->sid.'/confirm/');
            exit();
        }

        $this->set_category();
    }

    /**
     * カテゴリの設定
     *
     * @access private
     * @return void
     */
    function set_category()
    {
        $sql=
            'SELECT '.
                'id,'.
                'category '.
            'FROM '.
                DB_PREFIX.'inq_category '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['category'];
        }
        
        $this->Assign('categorys',$list);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('regist_date', date('Y-m-d H:i:s'));
        $this->objmnp->setValue('status', 1);

        /* 入力データの加工設定 */
        $func = array('sql_query', 'encrypt');
        $this->objmnp->setInputEffect('name', array('func'=>$func));
        $this->objmnp->setInputEffect('email', array('func'=>$func));

        // 更新しない項目名
        $skip = array(
            'id',
            'modify',
            'regist_date',
            'ref_account',
            'status',
            'subject',
            'body',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * 確認メール送信
     *
     * @access private
     * @return void
     **/
    function sendmail()
    {
        $sql = 
            'SELECT '.
                'name,'.
                'email,'.
                'comment '.
            'FROM '.
                DB_PREFIX.'inq_inquire '.
            'WHERE '.
                'id = '.$this->objmnp->getCurID();
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['email'])){
            return ;
        }

        $objmail = new sendmail('inquire');
        $to = $this->crypt->decrypt($result['email']);
        $name = $this->crypt->decrypt($result['name']);

        $objmail->Assign('user_name', $name);
        $objmail->Assign('email', $to);
        $objmail->Assign('comment', $result['comment']."\r\n");
        
        $objmail->send($to);
    }
} // webapp
?>
