<?php
/* ========================================================================
 - [modules/private/edit/photo.php]
 -      写真編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/19] メールによる画像添付機能追加
 -      [2006/08/29] ファイルパスの定数名を変更
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_upload.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 画像ID
     * @var integer
     */
    var $id = null;

    /**
     * 添付画像を送信
     * @var integer
     */
    var $attach = 0;

    /**
     * 画像削除フラグ
     * @var integer
     */
    var $delete = 0;

    /**
     * メイン画像設定
     * @var integer
     */
    var $main = 0;

    /**
     * データ操作オブジェクト
     * @var object
     */
    var $objmnp = null;

    /**
     * BLOB操作オブジェクト
     * @var object
     */
    var $objfile = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));
        
        $this->objfile = RKT_upload::getInstance(BLOB_DRIVER,BLOB_PARAM); 
        $this->objfile->setUID($this->account['id']);

        $this->setTemplateFile('private/edit/photo.tpl');       

        /* PathInfo引数の設定 */
        $this->setPathInfo('id');
        $this->setSafety('delete');
        $this->setSafety('main');

        if ($this->delete_photo()){
            header('Location: '.HTTP_ACTION.'private/edit/photo/'.$this->sid.'/');
            exit();
        }
        $this->main_photo();

        $this->set_photo();
        $this->mail_action();
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'id,'.
                'status,'.
                'subject,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        $list = array();
        $row = 0;
        foreach ($result as $value){
            $list[] = $value;
            $row ++;
        }

        $this->Assign('photos',$list);
    }

    /**
     * メイン写真の取得
     *
     * @access private
     * @return void
     */
    function get_main_photo($id)
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_MAIN.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])) {
            return 1;
        }
        
        if ($result['id'] != $id){
            return 0;
        }
        return 1;
    }

    /**
     * 画像が追加できるか
     *
     * @access private
     * @return boolean
     */
    function is_add_photo()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if ($result['ct'] >= 3){
            $this->Assign('alert_orver', true);
            return false;
        }

        return true;
    }

    /**
     * ファイルの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_photo()
    {
        if (empty($this->delete)){
            return false;
        }

        $sql=
            'SELECT '.
                'status,'.
                'filename,'.
                'thumbnail '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return 0;
        }

        $this->objfile->unlink($result['filename']);
        $this->objfile->unlink($result['thumbnail']);

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        $return = $this->objdb->exec($sql);
        
        if (!empty($result['status'])){
            $this->set_main_photo();
        }
        
        return $return;
    }

    /**
     * メイン画像の設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function set_main_photo()
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_SUB.' AND '.
                'ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'id '.
            'LIMIT 1';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        if (empty($result['id'])) {
            return ;
        }
        $this->main = 1;
        $this->id = $result['id'];
    }

    /**
     * メイン画像の設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function main_photo()
    {
        if (empty($this->main)){
            return false;
        }

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_photo '.
            'SET '.
                'status = '.STATUS_PHOTO_SUB.' '.
            'WHERE '.
                'ref_account = '.$this->account['id'];
        $this->objdb->exec($sql);

        $sql =
            'UPDATE '.
                DB_PREFIX.'act_photo '.
            'SET '.
                'status = '.STATUS_PHOTO_MAIN.' '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

    /**
     * メールアクション設定
     *
     * @access private
     * @return integer  データ操作結果
     */
    function mail_action()
    {
        if (empty($_POST['attach'])){
            return false;
        }

        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_mailaction');

        $objmnp->setValue('modify',        date('Y-m-d H:i:s'));
        $objmnp->setValue('ref_table',     ACTION_ACT_PHOTO);
        $objmnp->setValue('ref_relation',  0);
        $objmnp->setValue('ref_account',   $this->account['id']);

        $this->Assign('attach', true);

        return $objmnp->manip();
    }
} // webapp
?>
