<?php
/* ========================================================================
 - [modules/private/show/footprint.php]
 -      あしあと
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/show/footprint.tpl');

        $this->set_footprint();
        $this->set_number();
    }

    /**
     * あしあとの設定
     *
     * @access private
     * @return void
     */
    function set_footprint()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_ROWS);    // クラスの生成
        $sql=
            'SELECT '.
                'act.id as id,'.
                'pro.nickname as nickname,'.
                'ftp.modify as modify '.
            'FROM '.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'fri_footprint ftp '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = ftp.ref_friend AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'ftp.ref_account = '.$this->account['id'].' '.
            'ORDER BY '.
                'ftp.modify DESC '.
            'LIMIT '.LIMIT_FOOTPRINT;
        $objpgr->setSql($sql);
        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('footprints', $result);
    }

    /**
     * あしあと数の設定
     *
     * @access private
     * @return void
     */
    function set_number()
    {
        $sql = 
            'SELECT '.
                'act.total as total,'.
                'count(acc.id) as ct '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'fri_accesslog acc '.
                    'ON act.id = acc.ref_account AND '.
                    'acc.unique_flag = 1 '.
            'WHERE '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'act.id = '.$this->account['id'].' '.
            'GROUP BY '.
                'act.total';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $total = 0;
        if (!empty($result)){
            $total = $result['total'] + $result['ct'];
        }

        $this->Assign('number', $total);
    }
} // webapp
?>
