<?php
/* ========================================================================
 - [modules/private/show/profile.php]
 -      プロフィール確認
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'private/act_enquete.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/show/profile.tpl');

        $this->set_friend_number();
        $this->set_photo();
        $this->set_profile();
        $this->set_enquete();
    }

    /**
     * 友達数の設定
     *
     * @access private
     * @return void
     */
    function set_friend_number()
    {
        $sql=
            'SELECT '.
                'count(id) as ct '.
            'FROM '.
                DB_PREFIX.'fri_friends '.
            'WHERE '.
                'avail = '.AVAIL_ENABLE.' AND '.
                'status = '.STATUS_FRIEND_CONNECT.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $this->Assign('friend_num',$result['ct']);
    }

    /**
     * 写真の設定
     *
     * @access private
     * @return void
     */
    function set_photo()
    {
        $sql=
            'SELECT '.
                'subject,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'act_photo '.
            'WHERE '.
                'status = '.STATUS_PHOTO_MAIN.' AND '.
                'ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            $result = array(
                'subject'=> 'no photo',
                'src'=>    'resource/img/common/nophoto.gif',
                'width'=>  PHOTO_LARGE_SIZE,
                'height'=> PHOTO_LARGE_SIZE
            );
        }

        $this->Assign('photo',$result);
    }

    /**
     * プロフィールの設定
     *
     * @access private
     * @return void
     */
    function set_profile()
    {
        $sql=
            'SELECT '.
                'pro.id as id,'.
                'pro.ref_account as ref_account,'.
                'pro.modify as modify,'.
                'pro.first_name as first_name,'.
                'pro.second_name as second_name,'.
                'pro.nickname as nickname,'.
                'pro.visibility as visibility,'.
                'pro.prefecture_flag as prefecture_flag,'.
                'pro.ref_blood as ref_blood,'.
                'pro.blood_flag as blood_flag,'.
                'pro.birthday as birthday,'.
                'pro.birthday_flag as birthday_flag,'.
                'pro.age_flag as age_flag,'.
                'pro.married_flag as married_flag,'.
                'pro.hometown_flag as hometown_flag,'.
                'pro.publicity as publicity,'.
                'prf.prefecture as prefecture,'.
                'lcl.local as local,'.
                'sex.sex as sex,'.
                'bld.blood as blood,'.
                'mrd.married as married,'.
                'htn.prefecture as hometown,'.
                'hlc.local as homelocal '.
            'FROM '.
                DB_PREFIX.'act_profile pro '.
                    'LEFT JOIN '.DB_PREFIX.'act_blood bld '.
                    'ON bld.id = pro.ref_blood '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture prf '.
                    'ON prf.id = pro.ref_prefecture '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local lcl '.
                    'ON lcl.id = pro.ref_local '.
                    'LEFT JOIN '.DB_PREFIX.'ara_prefecture htn '.
                    'ON htn.id = pro.ref_hometown '.
                    'LEFT JOIN '.DB_PREFIX.'ara_local hlc '.
                    'ON hlc.id = pro.ref_homelocal,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_married mrd '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'mrd.id = pro.ref_married AND '.                
                'pro.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        $result['first_name'] = sql_query::decrypt($result['first_name']);
        $result['second_name'] = sql_query::decrypt($result['second_name']);

        $this->Assign('profile',$result);
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'form_type,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        $list = array();
        foreach ($result as $value){
            if ($value['form_type'] == FORM_TYPE_CHECKBOX){
                $value['value'] = $this->get_select($value['id']);
            } else {
                $value['value'] = $this->get_item($value['id'],$value['form_type']);
            }
            $list[] = $value;
        }

        $this->Assign('enquetes', $list);
    }

    /**
     * 回答したアンケートの取得
     *
     * @access private
     * @param integer $ref_enquete
     * @param integer $form_type
     * @return array
     */
    function get_item($ref_enquete, $form_type)
    {        
        $sql=
            'SELECT '.
                'con.ref_enquete as ref_enquete,'.
                'itm.item as item,'.
                'con.content as content '.
            'FROM '.
                DB_PREFIX.'act_content con '.
                    'LEFT JOIN '.DB_PREFIX.'act_item itm '.
                    'ON itm.id = con.ref_item '.
            'WHERE '.
                'con.visibility != '.VISIBILITY_HIDDEN.' AND '.
                'con.ref_enquete = '.$ref_enquete.' AND '.
                'con.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        if (empty($result)){
            return null;
        }

        if ($form_type == FORM_TYPE_SELECT || $form_type == FORM_TYPE_RADIO){
            return $result['item'];
        }
        
        return $result['content'];
    }

    /**
     * 選択肢の取得
     *
     * @access private
     * @param integer $ref_enquete
     * @return void
     */
    function get_select($ref_enquete)
    {
        $sql=
            'SELECT '.
                'itm.item as item '.
            'FROM '.
                DB_PREFIX.'act_item itm,'.
                DB_PREFIX.'act_select sel '.
            'WHERE '.
                'itm.id = sel.ref_item AND '.
                'sel.ref_enquete = '.$ref_enquete.' AND '.
                'sel.visibility != '.VISIBILITY_HIDDEN.' AND '.
                'sel.ref_account = '.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }
        $list = array();
        foreach ($result as $row){
            $list[] = $row['item'];
        }
        
        return  implode(',&nbsp;',$list);
    }

} // webapp
?>
