<?php
/* ========================================================================
 - [webapp/libs/admin/sys_mail.php]
 -      システムからのメール配信
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/09/29] プログレスバーの修正
 -      [2006/09/26] execute/からwebapp/libs/admin/に変更
 -      [2006/09/11] wap_config.phpの読み込み忘れ
 -      [2006/08/29] 設定ファイル名の変更に伴う修正
 -      [2006/08/20] 作成
 - ======================================================================== */


/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_db.php';
require_once WEBAPP_LIB_DIR.'sendmail.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';

/**
 * 日次処理：デイリー配信クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package cal_schedule
 * @access public
 * @version 1.1
 */
class sys_mail
{
    /**
     * メール配信ID
     * @var string
     */
    var $id = '';

    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * メール配信情報
     * @var array
     */
    var $mails = array();

    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * メールオブジェクト
     * @var object
     */
    var $objmail = null;

    /**
     * コンストラクタ
     *
     * @access public
     * @pram integer id
     */
    function sys_mail($id)
    {
        set_time_limit (WAP_TIME_LIMIT);

        $this->id = $id;

        $this->objdb = RKT_db::getInstance();
        $this->objmail = new sendmail('mailing');
    }

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $sql = 
            'SELECT '.
                'id,'.
                'mailing,'.
                'from_mail,'.
                'from_name,'.
                'subject,'.
                'body,'.
                'condition '.
            'FROM '.
                DB_PREFIX.'sys_mail '.
            'WHERE '.
                'id = '.$this->id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result)){
            echo '<script type="text/javascript">setProgress(100,50);</script>'."\r\n";
            echo '<script type="text/javascript">setComplete();</script>'."\r\n";
            return ;
        }

        $this->mail = $result;
        $this->set_condition($result['condition']);
        $this->send_account();
        $this->__update($result['id']);

        flush();
        ob_flush();
        echo '<script type="text/javascript">setProgress(100,50);</script>'."\r\n";
        echo '<script type="text/javascript">setComplete();</script>'."\r\n";
    }

    /**
     * 友達リストの絞込み
     *
     * @access private
     * @param string $condition
     * @return string   絞込み句
     **/
    function set_condition($condition)
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = unserialize($condition);

        /* 状態 */
        if (isSet($conditions['avail'])){
            if ($conditions['avail'] !== ''){
                $where[] = 'act.avail='.$conditions['avail'];
            }
        }
        /* メール配信 */
        if (empty($this->mails['mailing'])){
            $where[] = 'act.mailing='.$this->mail['mailing'];
        }

        /* 性別 */
        if (!empty($conditions['ref_sex'])){
            $where[] = 'pro.ref_sex='.$conditions['ref_sex'];
        }
        /* 年齢 */
        $age = sql_query::age('pro.birthday');
        if (!empty($conditions['left_age'])){
            $left_age = $conditions['left_age'];
        }
        if (!empty($conditions['right_age'])){
            $right_age = $conditions['right_age'];
        }
        if (!empty($conditions['left_age']) && !empty($conditions['right_age'])){
            $left_age  = ($conditions['left_age'] < $conditions['right_age'])?$conditions['left_age']:$conditions['right_age'];
            $right_age = ($conditions['left_age'] < $conditions['right_age'])?$conditions['right_age']:$conditions['left_age'];
        }
        if (!empty($left_age)){
            $where[] = $age.' >= '.$left_age;
        }
        if (!empty($right_age)){
            $right_age += 1;
            $where[] = $age.' < '.$right_age;
        }

        /* 血液型 */
        if (!empty($conditions['ref_blood'])){
            $where[] = 'pro.ref_blood='.$conditions['ref_blood'];
        }
        /* 現住所 */
        if (!empty($conditions['ref_prefecture'])){
            $where[] = 'pro.ref_prefecture='.$conditions['ref_prefecture'];
        }
        if (!empty($conditions['local'])){
            $where[] = "pro.local='".$conditions['local']."'";
        }
        /* 出身地 */
        if (!empty($conditions['ref_hometown'])){
            $where[] = 'pro.ref_hometown='.$conditions['ref_hometown'];
        }
        if (!empty($conditions['homelocal'])){
            $where[] = "pro.homelocal='".$conditions['homelocal']."'";
        }
        /* 未婚/既婚 */
        if (!empty($conditions['ref_married'])){
            $where[] = 'pro.ref_married='.$conditions['ref_married'];
        }
        /* アンケート */
        if (!empty($conditions['ref_item'])){
            if (is_array($conditions['ref_item'])){
                $where[] = 'con.ref_item in('.implode(',',$conditions['ref_item']).')';
            } else {
                $where[] = 'con.ref_item='.$conditions['ref_item'];
            }
        }
        if (!empty($conditions['ref_select'])){
            if (is_array($conditions['enq_select'])){
                $where[] = 'sel.ref_item in('.implode(',',$conditions['ref_select']).')';
            } else {
                $where[] = 'sel.ref_item='.$conditions['ref_select'];
            }
        }
        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "pro.nickname like '%".$keyword."%'".' OR '.
                    "pro.publicity like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }
        /* 写真の有無 */
        if (!empty($conditions['photo'])){
            $where[] = 'pht.id >= 1';
        }

        /* 名        前 */
        $crypt = RKT_crypt::getInstance();
        if (!empty($conditions['first_name'])){
            $crypted = $crypt->encrypt($conditions['first_name']);
            $where[] = "pro.first_name = '".$crypted."'";
        }
        if (!empty($conditions['second_name'])){
            $crypted = $crypt->encrypt($conditions['second_name']);
            $where[] = "pro.second_name = '".$crypted."'";
        }
        /* ニックネーム */
        if (!empty($conditions['nickname'])){
            $nickname = trim($conditions['nickname']);
            $where[] = "pro.nickname like '%".$nickname."%'";
        }
        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * 会員リストの設定
     *
     * @access private
     * @return void
     */
    function send_account()
    {
        $sql=
            'SELECT '.
                'act.id as id,'.
                'act.avail as avail,'.
                'act.email as email,'.
                'act.regist_date as regist_date,'.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'act.friend_number as friend_number,'.
                'sex.sex as sex,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height,'.
                'pro.publicity as publicity '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.' '.
                    'LEFT JOIN '.DB_PREFIX.'act_content con '.
                    'ON act.id = con.ref_account '.
                    'LEFT JOIN '.DB_PREFIX.'act_select sel '.
                    'ON act.id = sel.ref_account,'.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.id != '.SNS_ACC_GHOST.' '.
                $this->where.
            'GROUP BY '.
                'act.id,'.
                'act.avail,'.
                'act.email,'.
                'act.regist_date,'.
                'act.last_login,'.
                'pro.nickname,'.
                'act.friend_number,'.
                'sex.sex,'.
                'pht.thumbnail,'.
                'pht.t_width,'.
                'pht.t_height,'.
                'pro.publicity';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        
        if (empty($result)){
            return ;
        }

        $number = count($result) + 1;
        $number = 50/$number;
        $row = 0;
        $oldstep = 0;

        foreach ($result as $value){
            $this->send_mail($value);

            $row++;
            $progress_id = intval($row * $number);
            $percent = $progress_id * 2;

            if ($oldstep != $step){
                flush();
                ob_flush();
                echo '<script type="text/javascript">setProgress('.$percent.','.$progress_id.');</script>'."\r\n";
                echo '<script type="text/javascript">setEcho("'.$values['nickname'].'さんへ");</script>'."\r\n";
                $oldstep = $step;
            }
        }

        flush();
        ob_flush();
        echo '<script type="text/javascript">setEcho("該当者全員へ");</script>'."\r\n";
    }

    /**
     * メールの配信
     *
     * @access private
     * @param array $values
     * @return void
     **/
    function send_mail($values)
    {
        $email = sql_query::decrypt($values['email']);

        $this->objmail->Assign('user_name', $values['nickname']);
        $this->objmail->Assign('body', $this->mail['body']);

        $this->objmail->send($email,$this->mail['subject']);
    }

    /**
     * 更新処理
     *
     * @access private
     * @param integer $id
     * @return boolean
     */
    function __update($id)
    {
        $sql = 
            'UPDATE '.
                DB_PREFIX.'sys_mail '.
            'SET '.
                'status = '.STATAS_MAIL_SENT.' '.
            'WHERE '.
                'id = '.$id;
        return $this->objdb->exec($sql);
    }
} // cal_schedule
?>
