<?php
/* ========================================================================
 - [webapp/libs/private/act_enquete.php]
 -      アンケートクラス
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/08/30] アンケートの回答の更新処理にrkt_manipクラスを使用
 -      [2007/02/02] リスト選択時のデフォルト値エラー修正
 -      [2006/07/31] 作成
 - ======================================================================== */

require_once LIB_DIR.'rkt_db.php';
require_once LIB_DIR.'rkt_manip.php';

/**
 * アンケートクラス
 *
 * @author 高橋 裕志郎 <yujiro@stepone.tv>
 * @package act_enquete
 * @access public
 * @version 1.0
 */
class act_enquete extends RKT_validate
{
    /**
     * DB接続オジェクト
     * @var object
     */
    var $objdb = null;

    /**
     * WebAppオジェクト
     * @var object
     */
    var $objhtml = null;

    /**
     * アカウントID
     * @var integer
     */
    var $ref_account = 0;

    /**
     * アンケート情報
     * @var array
     */
    var $enquetes = array();

    /**
     * 公開設定
     * @var array
     */
    var $visibility = array();

    /**
     * 条件格納
     * @var array
     */
    var $conditions = array();

    /**
     * コンストラクタ
     *
     * @access public
     * @param integer $ref_entry
     * @return void
     */
    function act_enquete(&$objdb,&$objhtml)
    {
        $this->RKT_validate();
        $this->objdb =& $objdb;
        $this->objhtml =& $objhtml;

        $objact = account::getInstance();
        $this->ref_account = $objact->getInfo('id');

        $this->set_enquete();
    }

    /**
     * 初期値の設定
     *
     * @access private
     * @return boolean 成功時：真
     */
    function display_values()
    {
        if (!is_array($this->requests)){
            return false;
        }
        $this->objhtml->Assign('enquete', $this->requests);

        return true;
    }

    /**
     * 選択肢の設定
     *
     * @access private
     * @param integer $ref_enquete
     * @return void
     */
    function get_option($ref_enquete)
    {
        $sql=
            'SELECT '.
                'id,'.
                'item '.
            'FROM '.
                DB_PREFIX.'act_item '.
            'WHERE '.
                'ref_enquete = '.$ref_enquete.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['item'];
        }
        
        return $list;
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition($value)
    {
        $option = array();
        $type = 'number';
        if ($value['form_type'] == FORM_TYPE_TEXT
         || $value['form_type'] == FORM_TYPE_TEXTAREA){
            $type = $value['validate'];
        }
        
        if ($type === 'number'){                            // 数値入力
            if (!empty($value['min_length'])){
                $option['min'] = $value['min_length'];
            }

            if (!empty($value['max_length'])){
                $option['max'] = $value['max_length'];
            }
        } elseif ($type === 'string'){                      // 文字列入力
            if (!empty($value['format'])){
                $option['format'] = $value['format'];
            }

            if (!empty($value['min_length'])){
                $option['min_length'] = $value['min_length'];
            }

            if (!empty($value['max_length'])){
                $option['max_length'] = $value['max_length'];
            }
        } elseif ($value['form_type'] === FORM_TYPE_DATE){  // 日付入力
            $type = 'date';
            $option['format'] = '%Y-%n-%d';
        }
        
        return array(
            'key'=> $value['key'],
            'type'=> $type,
            'option'=> $option,
            'required'=>!empty($value['required']),
        );
    }

    /**
     * アンケートの設定
     *
     * @access private
     * @return void
     */
    function set_enquete()
    {
        $sql=
            'SELECT '.
                'id,'.
                'required,'.
                'form_type,'.
                'visibility,'.
                'validate,'.
                'format,'.
                'max_length,'.
                'min_length,'.
                'enquete '.
            'FROM '.
                DB_PREFIX.'act_enquete '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        foreach ($result as $value){
            $value['key']     = 'enquete_'.$value['id'];
            $value['flag']    = $value['key'].'_flag';
            $value['options'] = $this->get_option($value['id']);

            $this->conditions[] = $this->get_condition($value);
            $this->conditions[] = array(
                'key'=> $value['flag'],
                'type'=> 'number',
                'option'=> null,
                'required'=>(($value['visibility'] == VISIBILITY_VISIBLE)?false:true),
            );

            $this->enquetes[$value['id']] = $value;
        }
    }

    /**
     * 初期値を取得するSELECT文の設定
     *
     * @access public
     * @param string $init_sql 初期値を取得するSELECT文
     */
    function execute()
    {
        $is_manip   = preg_match('/manip/i',$_SERVER['REQUEST_URI']);
        $is_confirm = preg_match('/confirm/i',$_SERVER['REQUEST_URI']);
        $is_complete = preg_match('/complete/i',$_SERVER['REQUEST_URI']);
        
        $this->objhtml->Assign('enquetes',$this->enquetes);
        $this->objhtml->Assign('enquete_flag',$this->visibility);

        if ($is_manip){
            $this->setRequestType("_SESSION['".DB_PREFIX.'act_content'."']");
        }

        /* 入力内容判定 */
        foreach ($this->conditions as $validate){
            $this->validate($validate['type'], $validate['key'], 
                        $validate['option'], $validate['required']);
        }


        $result = RKT_MANIP_INIT;
        if ($is_manip){
            $_SESSION[DB_PREFIX.'act_content']['manip'] = true;
            $result = $this->do_manip();
        } else {
            $result = $this->do_validate();
        }

        if ($result == RKT_MANIP_COMPLETE){
            unset($_SESSION[DB_PREFIX.'act_content']);
        }
        return $result;
    }

    /**
     * 操作の実行
     *
     * @access private
     * @param string $trigger きっかけキーワード
     * @return integer 影響を与えたテーブル行数
     */
    function do_manip($trigger='manip')
    {
        /* 入力チェック判定 */
        $check = $this->getValidate();
        if (!$check){
            $this->displayAlert($this->objhtml,'enq_alert');
            $this->objhtml->Assign('value', $this->requests);
            return RKT_MANIP_ALERT;
        }
        
        $this->display_values();
        if (!$this->do_query()){
            return RKT_MANIP_ERROR;
        }
    
        return RKT_MANIP_COMPLETE;
    }

    /**
     * 外部入力の設定
     *
     * @access private
     * @param string $key グローバルスコープの添え字
     * @param mixed $validate_info 整合性情報
     *      ['type'] = string
     *      ['option'] = array()
     *      ['required'] = boolean
     * @return void
     */
    function do_validate($trigger='validate')
    {
        $is_edit = false;
        $is_again = preg_match('/again/i',$_SERVER['REQUEST_URI']);
        $is_confirm = preg_match('/confirm/i',$_SERVER['REQUEST_URI']);
        if (empty($is_again) && empty($is_confirm)){
            $is_edit = true;
        }

        /* 状態判定 */
        $is_init = true;
        eval('$is_init = empty($'.$this->request_type.'[$trigger]);');
        if ($is_init){
            if (isSet($_SESSION[DB_PREFIX.'act_content']) && $is_edit==false){
                $this->requests = $_SESSION[DB_PREFIX.'act_content'];
            } else {
                $this->act_content();
                $this->act_select();
            }

            $this->display_values();
            return RKT_MANIP_INIT;
        }

        /* 入力チェック判定 */
        $check = $this->getValidate();
        if ($check){
            $_SESSION[DB_PREFIX.'act_content'] = $this->requests;
        } else {
            $this->displayAlert($this->objhtml,'enq_alert');
            $this->display_values();
            return RKT_MANIP_ALERT;
        }
    
        return RKT_MANIP_VALIDATED;
    }

    /**
     * 初期値を取得する
     *
     * @access private
     * $return void
     */
    function act_content()
    {
        $sql = 
            'SELECT '.
                'ref_enquete,'.
                'ref_item,'.
                'visibility,'.
                'content '.
            'FROM '.
                DB_PREFIX.'act_content '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        foreach ($result as $value) {
            $key = 'enquete_'.$value['ref_enquete'];
            $form_type = $this->enquetes[$value['ref_enquete']]['form_type'];

            if ($form_type == FORM_TYPE_TEXT || $form_type == FORM_TYPE_TEXTAREA){
                $this->requests[$key] = $value['content'];
            } elseif ($form_type == FORM_TYPE_SELECT || $form_type == FORM_TYPE_RADIO){
                $this->requests[$key] = $value['ref_item'];
            } else {
                $date = explode('-', $value['content']);
                $this->requests[$key] = array(
                                            'year'=> $date[0],
                                            'month'=>$date[1],
                                            'day'=>  $date[2]
                                        );
            } // if ($form_type == FORM_TYPE_TEXT || $form_type == FORM_TYPE_TEXTAREA)
            $this->requests[$flag]  = $value['visibility'];
            $this->visibility[$key] = $value['visibility'];            
        } // foreach ($result as $value)
    }

    /**
     * チェックボックス用の初期値
     *
     * @access private
     * $return void
     */
    function act_select()
    {
        $sql = 
            'SELECT '.
                'ref_enquete,'.
                'ref_item,'.
                'visibility '.
            'FROM '.
                DB_PREFIX.'act_select '.
            'WHERE '.
                'ref_account = '.$this->ref_account;
        $stmt = $this->objdb->prepare($sql);
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);
        if (empty($result)){
            return ;
        }

        foreach ($result as $value) {
            $key = 'enquete_'.$value['ref_enquete'];
            
            $this->requests[$key][] = $value['ref_item'];            
            $this->visibility[$key] = $value['visibility'];
            
        } // foreach ($result as $value)
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return interger     データ操作結果
     */
    function do_query()
    {
        foreach ($this->enquetes as $row){
            $visibility = $this->objdb->quote($this->requests[$row['flag']]);
            $visibility = trim($visibility, "'");
            $visibility = empty($visibility)?VISIBILITY_PROTECTED:$visibility;

            if ($row['form_type'] == FORM_TYPE_TEXT
             || $row['form_type'] == FORM_TYPE_TEXTAREA){
                $ref_item = 0;
                $content  = $this->objdb->quote($this->requests[$row['key']]);
                $content  = trim($content, "'");
            } elseif ($row['form_type'] == FORM_TYPE_SELECT
             || $row['form_type'] == FORM_TYPE_RADIO){
                $ref_item = $this->objdb->quote($this->requests[$row['key']]);
                $ref_item  = trim($ref_item, "'");
                $content  = '';
            } elseif ($row['form_type'] == FORM_TYPE_CHECKBOX){
                $ref_item = 0;
                $content  = $this->requests[$row['key']];
            } else {
                $ref_item = 0;
                $content = implode('-', $this->requests[$row['key']]); 
                $content  = $this->objdb->quote($content);
                $content  = trim($content, "'");
            }

            $value = array(
                'ref_enquete'=> $row['id'],
                'ref_item'=>    $ref_item,
                'ref_account'=> $this->ref_account,
                'visibility'=>  $visibility,
                'content'=>     $content
            );

            if ($row['form_type'] == FORM_TYPE_CHECKBOX){
                $this->do_query_select($value);
            } else {
                $result = $this->manip_content($value);
            }
        } // foreach ($this->enquetes as $row)

        return true;
    }

    /**
     * アンケートの回答を更新
     *
     * @access private
     * @param array $value
     * @return boolean  真偽値
     */
    function manip_content($value)
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'act_content '.
            'WHERE '.
                'ref_enquete = '.$value['ref_enquete'].' AND '.
                'ref_account = '.$value['ref_account'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        /* テーブルの更新処理 */
        $objmnp = new RKT_manip($this->objdb, DB_PREFIX.'act_content');
        if (!empty($result['id'])){
            $objmnp->setCurID($result['id']);
        }
        $objmnp->setValue('ref_enquete',    $value['ref_enquete']);
        $objmnp->setValue('ref_item',       $value['ref_item']);
        $objmnp->setValue('ref_account',    $value['ref_account']); 
        $objmnp->setValue('visibility',     $value['visibility']);
        $objmnp->setValue('content',        $value['content']);

        return $objmnp->manip();
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return interger     データ操作結果
     */
    function do_query_select($value)
    {
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'act_item '.
            'WHERE '.
                'ref_enquete = '.$value['ref_enquete'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $this->delete_select($value['ref_enquete']);
        foreach ($value['content'] as $ref_item){
            $value['ref_item'] = $this->objdb->quote($ref_item);
            $value['ref_item'] = trim($value['ref_item'], "'");
            $this->insert_select($value);
        }

        return true;
    }

    /**
     * アンケートの回答を新規登録
     *
     * @access private
     * @param integer $ref_item   選択肢ID
     * @return boolean  真偽値
     */
    function insert_select($value)
    {
        $sql =
            'INSERT INTO '.
                DB_PREFIX.'act_select('.
                    'ref_enquete,'.
                    'ref_item,'.
                    'ref_account,'.
                    'visibility'.
                ') VALUES ('.
                    $value['ref_enquete'].','.
                    $value['ref_item'].','.
                    $this->ref_account.','.
                    $value['visibility'].
                ')';
        return $this->objdb->exec($sql);
    }

    /**
     * アンケートの回答を削除
     *
     * @access private
     * @param integer $ref_enquete   選択肢ID
     * @return boolean  真偽値
     */
    function delete_select($ref_enquete)
    {
        $sql =
            'DELETE FROM '.
                DB_PREFIX.'act_select '.
            'WHERE '.
                'ref_enquete ='.$ref_enquete.' AND '.
                'ref_account ='.$this->ref_account;
        return $this->objdb->exec($sql);
    }
}
// act_enqueteの終了
?>
