<?php
/* ========================================================================
 - [modules/friend/forum/result.php]
 -      トピック検索結果
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2007/07/05] LEFT JOIN での条件指定を通常結合へ
 -      [2007/02/13] 公開レベルをビットフラグに対応
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'sql_query.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * Table名
     * @var string
     */
    var $table = '';

    /**
     * WHERE句
     * @var string
     */
    var $where = '';

    /**
     * Group By句
     * @var string
     */
    var $group = '';

    /**
     * ORDER句
     * @var string
     */
    var $order = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('friend/forum/result.tpl');

        if (!empty($_POST['search'])){
            header('Location: '.HTTP_ACTION.'friend/forum/result/'.WAP_URI_SEPARATOR.http_build_query($_POST));
            exit();
        }
        
        $this->order = 'ORDER BY tpc.modify DESC';

        $this->set_sort();
        $this->set_condition();
        $this->set_topic();
    }

    /**
     * 並び替えの設定
     *
     * @access private
     * @return void
     */
    function set_sort()
    {
        $sql=
            'SELECT '.
                'id,'.
                'label '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'ref_category = '.SORT_FORUM.' '.
            'ORDER BY '.
                'sort';
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetchAll(PDO_FETCH_ASSOC);

        $list = array();
        foreach ($result as $value){
            $list[$value['id']] = $value['label'];
        }
        
        $this->Assign('sorts', $list);
    }

    /**
     * 条件データの取得
     *
     * @access private
     * @return string   絞込み句
     **/
    function get_condition()
    {
        /* 絞込条件の取得 */
        $validates = array(
            'ref_sex'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'age'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_blood'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_prefecture'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_hometown'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'ref_married'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'frm_select'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
            'keyword'=> array(
                'type'=> 'string',
                'option'=> array()
            ),
            'ref_sort'=> array(
                'type'=> 'number',
                'option'=> array()
            ),
        );

        return $this->catchCondition($validates);
    }

    /**
     * 記事リストの絞込み
     *
     * @access private
     * @return string   絞込み句
     **/
    function set_condition()
    {
        // 絞込み条件の初期化
        $where = array();
        $conditions = $this->get_condition();


        /* 性別 */
        if (!empty($conditions['ref_sex'])){
            $where[] = 'tpc.ref_sex='.$conditions['ref_sex'];
        }
        /* 年齢 */
        if (!empty($conditions['age'])){
            $age_left  = empty($conditions['age'][0])?0:$conditions['age'][0];
            $age_right = empty($conditions['age'][1])?130:$conditions['age'][1];
            $where[] = 
                '((tpc.low_age >= '.$age_left.' AND tpc.low_age <='.$age_right.') OR '.
                ' (tpc.high_age >= '.$age_left.' AND tpc.high_age <='.$age_right.') )';
        }
        /* 血液型 */
        if (!empty($conditions['ref_blood'])){
            $where[] = 'tpc.ref_blood='.$conditions['ref_blood'];
        }
        /* 現住所 */
        if (!empty($conditions['ref_prefecture'])){
            $where[] = 'tpc.ref_prefecture='.$conditions['ref_prefecture'];
        }
        /* 出身地 */
        if (!empty($conditions['ref_hometown'])){
            $where[] = 'tpc.ref_hometown='.$conditions['ref_hometown'];
        }
        /* 未婚/既婚 */
        if (!empty($conditions['ref_married'])){
            $where[] = 'tpc.ref_married='.$conditions['ref_married'];
        }
        /* アンケート */
        if (!empty($conditions['frm_select'])){
            if (is_array($conditions['frm_select'])){
                $where[] = 'sel.ref_category in('.implode(',',$conditions['frm_select']).')';
            } else {
                $where[] = 'sel.ref_category='.$conditions['frm_select'];
            }
            $this->table = DB_PREFIX.'frm_select sel,';
            $where[] = 'tpc.id = sel.ref_topic';
        }
        /* キーワード検索 */
        $keys = array();
        if (!empty($conditions['keyword'])){
            $keywords = explode(' ',$conditions['keyword']);
            foreach ($keywords as $keyword){
                $keys[] = '('.
                    "tpc.topic like '%".$keyword."%'".' OR '.
                    "tpc.comment like '%".$keyword."%'".')';
            }
            $where[] = '('.implode(' OR ',$keys) .') ';
        }

        /* GROUP BY */
        if (!empty($this->table)){
            $this->group = 'GROUP BY '.
                'tpc.id,'.
                'tpc.regist_date,'.
                'tpc.topic,'.
                'tpc.post,'.
                'tpc.comment,'.
                'tpc.ref_account,'.
                'pro.nickname,'.
                'sex.sex ';
        }

        /* 並び替え */
        if (!empty($conditions['ref_sort'])){
            $this->set_order($conditions['ref_sort']);
        }

        
        if (!count($where)){
            return '';
        }
        $this->where = 'AND '. implode(' AND ',$where) .' ';
    }

    /**
     * ORDER句の設定
     *
     * @access private
     * @pram integer $id
     * @return void
     */
    function set_order($id)
    {
        $sql=
            'SELECT '.
                'direction '.
            'FROM '.
                DB_PREFIX.'sys_sort '.
            'WHERE '.
                'id = '.$id;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        $this->order = empty($result['direction'])?
                        '':'ORDER BY '.$result['direction'];
    }

    /**
     * トピックの設定
     *
     * @access private
     * @return void
     */
    function set_topic()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_FORUM);    // クラスの生成
        $sql=
            'SELECT '.
                'tpc.id as id,'.
                'tpc.regist_date as regist_date,'.
                'tpc.topic as topic,'.
                'tpc.post as post,'.
                'tpc.comment as comment,'.
                'tpc.ref_account as ref_account,'.
                'pro.nickname as nickname,'.
                'sex.sex as sex '.
            'FROM '.
                DB_PREFIX.'frm_topic tpc,'.
                $this->table.
                DB_PREFIX.'act_sex sex,'.
                DB_PREFIX.'act_account act,'.
                DB_PREFIX.'act_profile pro '.
            'WHERE '.
                'act.id = tpc.ref_account AND '.
                'sex.id = pro.ref_sex AND '.
                'act.id = pro.ref_account AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                sql_query::bitFlag('tpc.visibility & '.VISIBILITY_OPEN).' '.
                $this->where.' '.
                $this->group.' '.
                $this->order;
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();
        foreach ($result as $key=>$value){
            $result[$key]['picture'] = $this->get_picture($value['id']);
        }

        $this->Assign('topics', $result);
    }

    /**
     * 添付画像の取得
     *
     * @access private
     * @param integer $ref_topic
     * @param integer $status
     * @return mixed
     */
    function get_picture($ref_topic)
    {
        $sql=
            'SELECT '.
                'filename as href,'.
                'thumbnail as src,'.
                't_width as width,'.
                't_height as height '.
            'FROM '.
                DB_PREFIX.'frm_picture '.
            'WHERE '.
                'status = '.STATUS_PICTURE_TOPIC.' AND '.
                'ref_relation = '.$ref_topic;
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();

        return $result;
    }
} // webapp
?>
