<?php
/* ========================================================================
 - [modules/private/edit/schedule.php]
 -      スケジュール編集
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/10] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_manip.php';
require_once LIB_DIR.'rkt_calendar.php';
require_once WEBAPP_LIB_DIR.'wap_private.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_private
{
    /**
     * スケジュールID
     * @var integer
     */
    var $id = null;

    /**
     * 表示対象年月日
     * @var string
     */
    var $date = '';

    /**
     * カレンダーオブジェクト
     * @var object
     */
    var $objcal = null;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        RKT_auth::Authenticate(array(WAP_ACC_ADMIN,WAP_ACC_MEMBER));

        $this->setTemplateFile('private/edit/schedule.tpl');

        /* URL引数の取得 */
        $this->setSafety('id');
        $this->permission();
        $this->Assign('id', $this->id);
        $this->setSafety('date', '_REQUEST', 'date');
        /* カレンダーオブジェクトの生成 */
        $this->objcal = new RKT_calendar($this->date);

        /* アクション処理 */
        if (!empty($_REQUEST['again'])){
            header('Location: '.HTTP_ACTION.'private/edit/schedule/again/'.WAP_URI_SEPARATOR.'id='.$this->id.'&date='.$this->date);
            exit();
        }

        // データ操作クラスの生成
        $this->objmnp = new RKT_manip($this->objdb,  DB_PREFIX.'cal_schedule');
        $result = $this->do_query();
        if ($result == RKT_MANIP_COMPLETE){
            header('Location: '.HTTP_ACTION.'private/show/calendar/');
            exit();
        } elseif($result == RKT_MANIP_VALIDATED) {
            header('Location: '.HTTP_ACTION.'private/edit/schedule/confirm/'.WAP_URI_SEPARATOR.'id='.$this->id);
            exit();
        }

        /* 削除 */
        if ($this->delete_schedule()){
            header('Location: '.HTTP_ACTION.'private/show/calendar/');
            exit();
        }

        $this->set_date();
    }

    /**
     * 対象IDに編集権限があるか
     *
     * @access private
     * @return void
     */
    function permission()
    {
        if (empty($this->id)){
            return ;        
        }
        $sql=
            'SELECT '.
                'id '.
            'FROM '.
                DB_PREFIX.'cal_schedule '.
            'WHERE '.
                'id = '.$this->id.' AND '.
                'ref_account ='.$this->account['id'];
        $stmt = $this->objdb->prepare($sql); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO_FETCH_ASSOC);
        $stmt->closeCursor();
        
        if (empty($result['id'])){
            $this->id = null;        
        }
    }

    /**
     * 日付の設定
     *
     * @return void
     **/
    function set_date()
    {
        $timestamp  = $this->objcal->getTimestamp();

    	$years = array();
    	$months = array();
    	$days = array();

    	$max_year = date('Y',$timestamp) + 2;
    	for ($num=$max_year;$num>1967;$num--) {
    		$years[$num] = $num;
    	}
    	for ($num=1;$num<=12;$num++) {
            $num = sprintf('%02d',$num);
    		$months[$num] = $num;
    	}
    	for ($num=1;$num<=31;$num++) {
            $num = sprintf('%02d',$num);
    		$days[$num] = $num;
    	}
    	for ($num=0;$num<=23;$num++) {
            $num = sprintf('%02d',$num);
    		$hours[$num] = $num;
    	}
        $sixty = array(
            '00'=>'00',
            '15'=>'15',
            '30'=>'30',
            '45'=>'45',
        );

        $this->Assign('years', $years);
        $this->Assign('months', $months);
        $this->Assign('days', $days);
        $this->Assign('hours', $hours);
        $this->Assign('sixty', $sixty);

        
        $now_date = date('Y-m-d H:i:s',$timestamp);

        /* 開始年月日: */
        $date = $this->objmnp->getValue('start_date');
        $date = empty($date)?$this->objmnp->getInitValue('start_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('start_date', $init_date);

        /* 終了年月日: */
        $date = $this->objmnp->getValue('end_date');
        $date = empty($date)?$this->objmnp->getInitValue('end_date'):$date;
        $date = empty($date)?$now_date:$date;

        $init_date = RKT_calendar::splitDate($date);
        $this->Assign('end_date', $init_date);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function check_date()
    {
        if (empty($_POST['start_date'])){
            return true;
        }
        $start_date   = implode('',$_POST['start_date']);
        $start_hour   = (ereg('--',$_POST['start_hour']))?'00':$_POST['start_hour'];
        $start_minute = (ereg('--',$_POST['start_minute']))?'00':$_POST['start_minute'];

        $end_date   = implode('',$_POST['end_date']);
        $end_hour   = (ereg('--',$_POST['end_hour']))?'23':$_POST['end_hour'];
        $end_minute = (ereg('--',$_POST['end_minute']))?'59':$_POST['end_minute'];
        
        $start = $start_date.$start_hour.$start_minute;
        $end   = $end_date.$end_hour.$end_minute;

        return ($start < $end);
    }

    /**
     * データ操作設定・実行
     *
     * @access private
     * @return integer  データ操作結果
     */
    function do_query()
    {
        // 新規登録以外の処理
        if (!empty($this->id)){
            $this->objmnp->setCurID($this->id);
        } else {
            $this->objmnp->setValue('ref_account', $this->account['id']);
        }

        // 直接入力
        $this->objmnp->setValue('modify', date('Y-m-d H:i:s'));

        // 日付のチェック
        if (!$this->check_date()){
            $this->objmnp->setAlert('warp_date');
        }

        // 更新しない項目名
        $skip = array(
            'ref_account',
        );
        return $this->objmnp->execute($this,$skip);
    }

    /**
     * スケジュールの削除
     *
     * @access private
     * @return integer  データ操作結果
     */
    function delete_schedule()
    {
        if (empty($_GET['delete'])){
            return false;
        }

        $sql =
            'DELETE FROM '.
                DB_PREFIX.'cal_schedule '.
            'WHERE '.
                'id ='.$this->id .' AND '.
                'ref_account = '.$this->account['id'];
        return $this->objdb->exec($sql);
    }

} // webapp
?>
