<?php
/* ========================================================================
 - [modules/public/diary/comments.php]
 -      コメント一覧
 -      Copyright (c) 2006 Yujiro Takahashi
 - ライセンス:
 -      This program is free software; you can redistribute it and/or
 -      modify it under the terms of the GNU General Public License
 -      as published by the Free Software Foundation; either version 2
 -      of the License, or (at your option) any later version.
 -
 -      This program is distributed in the hope that it will be useful,
 -      but WITHOUT ANY WARRANTY; without even the implied warranty of
 -      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 -      GNU General Public License for more details.
 -
 -      You should have received a copy of the GNU General Public License
 -      along with this program; if not, write to the Free Software
 -      Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://rakuto.net/rktSNS/
 - 更新履歴：
 -      [2006/07/27] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once LIB_DIR.'rkt_pager.php';
require_once WEBAPP_LIB_DIR.'dia_menu.php';
require_once WEBAPP_LIB_DIR.'wap_public.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends WAP_public
{
    /**
     * 友達ID
     * @var integer
     */
    var $ref_friend = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    function execute()
    {
        $this->setTemplateFile('public/diary/comments.tpl');

        /* PathInfo引数の設定 */
        $this->setPathInfo('ref_friend');
        $this->Assign('ref_friend', $this->ref_friend);

        /* メニューオブジェクトの生成 */
        $objmenu = new dia_menu($this,$this->ref_friend);
        $objmenu->setMenuGuest();

        $this->set_comment();
    }

    /**
     * 日記の設定
     *
     * @access private
     * @return void
     */
    function set_comment()
    {
        $offset = RKT_validate::getSafety('number', 'offset');
        $_SESSION['offset'] = $offset;

        $objpgr = new RKT_pager($this->objdb, $offset, LIMIT_DIARY);    // クラスの生成
        $sql=
            'SELECT '.
                'act.last_login as last_login,'.
                'pro.nickname as nickname,'.
                'cmt.id as id,'.
                'cmt.modify as modify,'.
                'cmt.ref_account as ref_account,'.
                'cmt.ref_entry as ref_entry,'.
                'cmt.subject as subject,'.
                'cmt.body as body,'.
                'pht.thumbnail as src,'.
                'pht.t_width as width,'.
                'pht.t_height as height '.
            'FROM '.
                DB_PREFIX.'act_account act '.
                    'LEFT JOIN '.DB_PREFIX.'act_photo pht '.
                    'ON act.id = pht.ref_account AND '.
                       'pht.status = '.STATUS_PHOTO_MAIN.','.
                DB_PREFIX.'act_profile pro,'.
                DB_PREFIX.'dia_diary dia,'.
                DB_PREFIX.'dia_comment cmt '.
            'WHERE '.
                'act.id = pro.ref_account AND '.
                'act.id = cmt.ref_account AND '.
                'dia.id = cmt.ref_diary AND '.
                'act.avail = '.AVAIL_ENABLE.' AND '.
                'dia.ref_account = '.$this->ref_friend.' '.
            'ORDER BY '.
                'cmt.modify ';
        $objpgr->setSql($sql);

        $page = array(
            'infos'=> $objpgr->getInfo(),
            'links'=> $objpgr->getPager()
        );
        $this->Assign('page', $page);

        $result = $objpgr->getValues();

        $this->Assign('comments', $result);
    }
} // webapp
?>
