<?php
/* ========================================================================
 - [database/dump.php]
 - 内容：データベースのダンプ
 - 作成：高橋 裕志郎 
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2005/01/21] テーブル選択機能追加、完全なINSERT、DROPを追加
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0.05.1.21
 */
class webapp extends RSL_webapp
{
    /**
     * テンプレート引数
     * @var array
     */
    private $arg = array();

    /**
     * 完全なインサート文発行フラグ
     * @var integer
     */
    private $full_insert = 0;

    /**
     * ダンプデータの取得方法
     * @var integer
     */
    private $file = 1;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'database/dump.tpl';
        $this->addCss('common.css');

        $this->Assign('dbname',$this->dbinfo->getDbName());

        $this->full_insert = empty($_REQUEST['full_insert'])?0:1;
        $this->arg['drop'] = empty($_REQUEST['drop'])?FALSE:TRUE;

        $this->file = empty($_REQUEST['file'])?1:$_REQUEST['file'];
        if ($this->file == '1'){
            $this->Assign('dump',$this->get_dump());
        } else {
            $this->output_download();
        }

    }

    /**
     * ダウンロード用に出力
     *
     * @access private
     * @return void
     **/
    private function output_download()
    {
        $dump = $this->get_dump();
        $date = date('Ymd',time());
        $filename = 'dump'.$date.'.sql';

        header('Accept-Ranges: none');
        header('Content-Disposition: attachment; filename='.$filename);
        header('Content-Transfer-Encoding: binary');
        header('Content-Length: '. strlen($dump) );
        header('Content-Type: text/octet-stream');
        echo $dump;
        exit();
    }

    /**
     * ダンプ結果の取得
     *
     * @access private
     * @return string
     **/
    private function get_dump()
    {
        $this->set_info();
        $this->set_table();
        $this->set_view();
        $this->set_trigger();

        return HtmlTemplate::t_Buffer(TEMPLATE_DIR.'database/dump.tpl.sql',$this->arg);
    }

    /**
     * データベース情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_info()
    {
        $type = array(
            '1'=> array('create'=>true, 'insert'=>true),
            '2'=> array('create'=>true, 'insert'=>false),
            '3'=> array('create'=>false,'insert'=>true),
        );

        $this->arg['create'] = $type[$_REQUEST['type']]['create'];
        $this->arg['insert'] = $type[$_REQUEST['type']]['insert'];

        $this->arg['version'] = RSL_VERSION;
        $this->arg['access'] = RSL_ACCESS;
        $this->arg['host'] = $_SERVER['HTTP_HOST'];
        $this->arg['dbname'] = $this->dbinfo->getDbName();
        $this->arg['timestamp'] = date("Y/m/d H:i:s",time());
    }

    /**
     * テーブル情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_table()
    {
        if (empty($_REQUEST['tables'])){
            return ;
        }
        $where = "name in('".implode("','",$_REQUEST['tables'])."')";
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name,sql FROM sqlite_master WHERE type='table' AND ".$where." ORDER BY name"); 
        $stmt->execute(); 

        $cols = array();
        $list = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $inserts = $this->get_value($cols['name']);
            $list[] = array(
                    'name'=>   $cols['name'],
                    'sql'=>    $cols['sql'],
                    'insert'=> $inserts
                );
        } 
        
        $this->arg['table'] = $list;
    }

    /**
     * インサート情報の取得
     *
     * @access private
     * @param string $name
     * @return array
     **/
    private function get_value($name)
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT * FROM ".$name);
        $stmt->execute();
        
        $left  = $this->full_insert?'column':'empty';
        $right = $this->full_insert?'empty':'column';

        $cols = array();
        $list = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $column = '('. implode(',',array_keys($cols)) .')';
            $value = "'". implode("','",$cols) ."'";
            $value = mb_convert_encoding($value, 'UTF-8', $this->dbinfo->getEncode());
            $list[] = array($left=>$column, 'value'=>$value, $right=>'');
        } 

        return $list;
    }

    /**
     * ビュー情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_view()
    {
        if (empty($_REQUEST['views'])){
            return ;
        }
        $where = "name in('".implode("','",$_REQUEST['views'])."')";
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name,sql FROM sqlite_master WHERE type='view' AND ".$where." ORDER BY name"); 
        $stmt->execute(); 

        $cols = array();
        $list = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $list[] = array(
                    'name'=>   $cols['name'],
                    'sql'=>    $cols['sql']
                );
        } 
        
        $this->arg['view'] = $list;
    }

    /**
     * トリガー情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_trigger()
    {
        if (empty($_REQUEST['triggers'])){
            return ;
        }
        $where = "name in('".implode("','",$_REQUEST['triggers'])."')";
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name,sql FROM sqlite_master WHERE type='trigger' AND ".$where." ORDER BY name"); 
        $stmt->execute(); 

        $cols = array();
        $list = array();
        while ($cols = $stmt->fetch(PDO_FETCH_ASSOC)) {
            $list[] = array(
                    'name'=>   $cols['name'],
                    'sql'=>    $cols['sql']
                );
        } 
        
        $this->arg['trigger'] = $list;
    }

} // webapp
?>
