<?php
/* ========================================================================
 - [rsl_config.php]
 - 内容：各種定義
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2004 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] バージョンアップ  2.1.06.3.5
 -      [2005/01/04] 作成
 - ======================================================================== */

if (!defined('_RSL_CONFIG_PHP_')){
define('_RSL_CONFIG_PHP_',true);

/* 環境設定：セッション */
ini_set('session.use_cookies',1);
ini_set('session.save_handler', 'files');

/* マルチバイト設定 */
ini_set('default_charset', 'UTF-8');
mb_language('Japanese');
mb_internal_encoding('UTF-8');

/* rktSQLite */
define('RSL_VERSION','2.1.06.3.5');
define('RSL_ACCESS','http://www.rakuto.net/study/');
define('RSL_HELP','http://rktsqlite.sourceforge.jp/sqlite/command.html');

/* デバッグモード */
define("DEBUG_ENV", FALSE);

/* 基本設定 */
if (DEBUG_ENV){
    error_reporting (E_ALL);
} else {
    error_reporting (E_ALL ^ E_NOTICE);
}

/* rktSQLite設置パス(絶対パス) */
// define('BASE_DIR', '');
if (!defined('BASE_DIR')) {
    define('BASE_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);
}

/* ライブラリパス */
define('LIB_DIR',BASE_DIR.'libs'. DIRECTORY_SEPARATOR);

/* ウェブアプリケーションパス */
define('WEBAPP_DIR',BASE_DIR.'webapp'. DIRECTORY_SEPARATOR);

/* ウェブアプリケーションパス */
define('WEBAPP_LIB_DIR',WEBAPP_DIR.'libs'. DIRECTORY_SEPARATOR);

/* モジュールパス */
define('MODULE_DIR',WEBAPP_DIR.'modules'. DIRECTORY_SEPARATOR);

/* デフォルトDBパス */
define('DEFAULT_DB_DIR', BASE_DIR.'dbs'. DIRECTORY_SEPARATOR);

/* テンプレートパス */
define('TEMPLATE_DIR', WEBAPP_DIR.'templates'. DIRECTORY_SEPARATOR);

/* セッションセーブパス */
define('SESSION_DIR', WEBAPP_DIR.'works'. DIRECTORY_SEPARATOR.'session'. DIRECTORY_SEPARATOR);

/* セッションID */
define('DEF_SESSION_ID', 'rktSQLite2');

/* 制作著作 */
define('COPYRIGHT', "Copyright (C) 2004-2006 `rakuto.net'. All Rights Reserved.");
define('MCOPYRIGHT', "(C)`rakuto.net'");

} // (!defined('_RSL_CONFIG_PHP_'));
?>