<?php
/* ========================================================================
 - [browse/detail.php]
 - 内容：テーブルの詳細
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * テーブル名
     * @var string
     */
    private $name = '';

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'browse/detail.tpl';
        $this->addCss('common.css');

        $this->name = empty($_REQUEST['name'])?'':$_REQUEST['name'];
        $this->Assign('name', $this->name);

        $this->set_tableinfo();
        $this->set_index();
    }

    /**
     * テーブル情報の設定
     *
     * @access private
     * @return void
     **/
    private function set_tableinfo()
    {
        /* PRIMARYなどのキーを取得 */
        $keys = array();
        $sql = $this->get_sql();
        $keys = $this->parse_sql($sql);

        $stmt = $this->objdb->prepare("PRAGMA table_info(".$this->name.")"); 
        $stmt->execute(); 
        $list = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $key = empty($keys[$cols['name']])?'':$keys[$cols['name']];

            $list[] = array(
                    'cid'=> $cols['cid'],
                    'name'=> $cols['name'],
                    'type'=> $cols['type'],
                    'notnull'=> !empty($cols['notnull']),
                    'default'=> $cols['dflt_value'],
                    'key'=> $key
                );
        }
        $this->Assign('sql', $sql);
        $this->Assign('list', $list);
    }

    /**
     * SQL文の取得
     *
     * @access private
     * @return string SQL文
     **/
    private function get_sql()
    {
        $stmt = $this->objdb->prepare("SELECT sql FROM sqlite_master WHERE name='".$this->name."'"); 
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        return $result['sql'];
    }

    /**
     * SQL文を解析しPRIMARYなどのキーを取得
     *
     * @access private
     * @param $sql   解析対象のSQL文
     * @return array
     **/
    private function parse_sql($sql)
    {
        $sql = preg_replace("/\((.+)\)/is",",\\1,",$sql);
        $sql = preg_replace('/"/i','',$sql);
        $sqls = explode(',', $sql);

        $keys = array();
        $cmd = "";
        foreach ($sqls as $sql){
            if (preg_match("/PRIMARY/i", $sql)){
                $sql = trim($sql);
                $cmd .= '/*';
                $cmd .= preg_replace("/\((.+)\)|(^\S+)/is","*/\$keys['\\1\\2']='PRIMARY';/*",$sql);
                $cmd .= '*/';
            } else if (preg_match("/UNIQUE/i", $sql)){
                $sql = trim($sql);
                $cmd .= '/*';
                $cmd .= preg_replace("/\((.+)\)|(^\S+)/is","*/\$keys['\\1\\2']='UNIQUE';/*",$sql);
                $cmd .= '*/';
            } else if (preg_match("/CHECK/i", $sql)){
                $sql = trim($sql);
                $cmd .= '/*';
                $cmd .= preg_replace("/(^\S+)/is","*/\$keys['\\1']='CHECK';/*",$sql);
                $cmd .= '*/';
            }
        }
        @eval($cmd);

        return ($keys);
    }

    /**
     * SQL文の取得
     *
     * @access private
     * @return void
     **/
    private function set_index()
    {
        $stmt = $this->objdb->prepare("SELECT name FROM sqlite_master WHERE tbl_name='".$this->name."' AND type='index'"); 
        $stmt->execute(); 

        $list = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $infos = $this->get_indexinfo($cols['name']);
            $list[] = array(
                    'name'=> $cols['name'],
                    'seqno'=> $infos['seqno'],
                    'cid'=>   $infos['cid'],
                    'field'=> $infos['name']
                );
        }

        if (count($list) > 0){
            $this->Assign('index', true);
            $this->Assign('indexs', $list);
        }
    }

    /**
     * インデックス情報の取得
     *
     * @access private
     * @param string $name
     * @return array
     **/
    private function get_indexinfo($name)
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("PRAGMA index_info(".$name.")"); 
        $stmt->execute();

        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

} // webapp
?>
