<?php
/* ========================================================================
 - [create/trigger.php]
 - 内容：トリガーの作成
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://www.rakuto.net/study/htdocs/
 -      Copyright (C) 2005 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * トリガー名
     * @var string
     */
    private $name = '';

    /**
     * トリガーが存在するか
     * @var integer
     */
    private $exist = 0;

    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'create/trigger.tpl';
        $this->addCss('common.css');

        $this->name = empty($_REQUEST['name'])?'':$_REQUEST['name'];
        $this->Assign('name', $this->name);

        $this->set_exist();
        if (!empty($_REQUEST['send_query'])){
            $this->dbinfo->setQuery($this->get_query());
            header("Location: ".$_SERVER['PHP_SELF']."?m=query&do_query=".$this->dbinfo->getAutoQuery());
            exit();
        }

        $this->set_trigger();
    }

    /**
     * トリガーが存在するか
     *
     * @access private
     * @return void
     **/
    private function set_exist()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT count(name) as ct FROM sqlite_master WHERE type='trigger' AND name='".$this->name."'");
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $this->exist = $result['ct'];
    }

    /**
     * トリガーの解析
     *
     * @access private
     * @return array
     **/
    private function parse_trigger()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT sql FROM sqlite_master WHERE name='".$this->name."'");
        $stmt->execute(); 
        $result = $stmt->fetch(PDO::FETCH_ASSOC);

        $trgs = array(
                'name'=>  '',
                'timing'=>'',
                'event'=> '',
                'target'=>'',
                'action'=>'',
                'when'=>  '',
                'tstep'=> ''
            );

        $cmd = $result['sql'];
        $cmd = preg_replace( "/TRIGGER/i", "*/\$trgs['name']=trim(\"", $cmd, 1);
        $cmd = preg_replace( "/(BEFORE|AFTER)/i", "\");\$trgs['timing']=trim(\"\\1", $cmd, 1);
        $cmd = preg_replace( "/(DELETE|INSERT|UPDATE)/i", "\");\$trgs['event']=trim(\"\\1", $cmd, 1);
        $cmd = preg_replace( "/ON/i", "\");\$trgs['target']=trim(\"", $cmd, 1);
        $cmd = preg_replace( "/(FOR)/i", "\");\$trgs['action']=trim(\"\\1", $cmd, 1);
        $cmd = preg_replace( "/(WHEN)/i", "\");\$trgs['when']=trim(\"\\1", $cmd, 1);
        $cmd = preg_replace( "/BEGIN/i", "\");\$trgs['tstep']=trim(\"\\1", $cmd, 1);
        $cmd = preg_replace( "/END/i", "\");/*\"", $cmd, 1);
        $cmd = "/*".$cmd."*/";
    
        @eval($cmd);

        return $trgs;
    }

    /**
     * トリガーの設定
     *
     * @access private
     * @return void
     **/
    private function set_trigger()
    {
        $trgs = $this->parse_trigger();

        $this->Assign('name',  $trgs['name']);
        $this->Assign('timing',$this->get_timing($trgs['timing']));
        $this->Assign('event', $this->get_event($trgs['event']));
        $this->Assign('target',$this->get_target($trgs['target']));
        $this->Assign('action',$this->get_action($trgs['action']));
        $this->Assign('when',  $trgs['when']);
        $this->Assign('tstep', $trgs['tstep']);
    }

    /**
     * SELECTオプション用タイミングの取得
     *
     * @access private
     * @param mixed $selected
     * @return array
     **/
    private function get_timing($selected)
    {
        $notnulls = array(
            ''=>'',
            'BEFORE'=>'BEFORE',
            'AFTER'=>'AFTER'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($notnulls,$selected);
    }

    /**
     * SELECTオプション用イベントの取得
     *
     * @access private
     * @param mixed $selected
     * @return array
     **/
    private function get_event($selected)
    {
        $notnulls = array(
            ''=>'',
            'DELETE'=>'DELETE',
            'INSERT'=>'INSERT',
            'UPDATE'=>'UPDATE',
            'UPDATE OF'=>'UPDATE OF'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($notnulls,$selected);
    }

    /**
     * SELECTオプション用ターゲットの取得
     *
     * @access private
     * @param mixed $selected
     * @return array
     **/
    private function get_target($selected)
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name FROM sqlite_master WHERE type='table' ORDER BY name"); 
        $stmt->execute(); 

        $list = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $list[$cols['name']] = $cols['name'];
        } 
        return $this->getSelectList($list,$selected);
    }

    /**
     * SELECTオプション用アクションの取得
     *
     * @access private
     * @param mixed $selected
     * @return array
     **/
    private function get_action($selected)
    {
        $notnulls = array(
            ''=>'',
            'FOR EACH ROW'=>'FOR EACH ROW',
            'FOR EACH STATEMENT'=>'FOR EACH STATEMENT'
        );
        $selected = strtoupper($selected);
        return $this->getSelectList($notnulls,$selected);
    }

    /**
     * 生成したクエリの取得
     *
     * @access private
     * @return string
     **/
    private function get_query()
    {
        $name   = trim($_POST['name']);
        $timing = empty($_POST['timing'])? "":$_POST['timing']." ";
        $event  = empty($_POST['event'])? "":$_POST['event']." ";
        $target = $_POST['target'];
        $action = empty($_POST['action'])? "":$_POST['action']." \n";
        $when   = empty($_POST['when'])? "":"WHEN ".$_POST['when']." \n";
        $step   = trim($_POST['tstep']);
    
        if (";" != substr($step,-1)){
            $step .= ";";
        }

        $query = "";
        if ($this->exist){
            $query = "DROP TRIGGER ".$this->name.";\n";
        }

        $query .=
            "CREATE TRIGGER \n".
            "    ".$this->name." \n".
            $timing.$event.
            "ON \n".
            "    ".$target." \n".
            $action.
            $when.
            "BEGIN \n".
            "    ".$step."\n".
            "END;";

        return $query;
    }
} // webapp
?>
