<?php
/* ========================================================================
 - [browse/view.php]
 - 内容：ビューの閲覧
 - 作成：高橋 裕志郎
 - ライセンス:
 -      This source file is subject to version 3.0 of the PHP license,
 -      that is available at http://www.php.net/license/3_0.txt
 -      If you did not receive a copy of the PHP license and are unable 
 -      to obtain it through the world-wide-web, please send a note to 
 -      license@php.net so we can mail you a copy immediately.  
 - 問い合わせ先：
 -      yujiro@rakuto.net
 -      http://study.rakuto.net/
 -      Copyright (C) 2005-2006 `rakuto.net'. All Rights Reserved.
 - 更新履歴：
 -      [2006/03/05] PDO1.0以降に対応
 -      [2005/01/08] 作成
 - ======================================================================== */

/* =-=- モジュール等の読み込み -=-= */
require_once WEBAPP_LIB_DIR.'rsl_webapp.php';

/**
 * WebApplication実装クラス
 *
 * @author 高橋 裕志郎 <yujiro@rakuto.net>
 * @package webapp
 * @access public
 * @version 1.0
 */
class webapp extends RSL_webapp
{
    /**
     * 実行処理
     *
     * @access public
     * @return void
     **/
    public function execute()
    {
        $this->template_file = 'browse/view.tpl';
        $this->addCss('common.css');

        $this->set_list();
    }

    /**
     * ディレクトリファイルリストの設定
     *
     * @access private
     * @return void
     **/
    private function set_list()
    {
        /* データの取得 */
        $stmt = $this->objdb->prepare("SELECT name FROM sqlite_master WHERE type='view' ORDER BY name"); 
        $stmt->execute(); 

        $list = array();
        $cols = array();
        while ($cols = $stmt->fetch(PDO::FETCH_ASSOC)) { 
            $list[] = array(
                    'name'=> $cols['name']
                );
        } 

        $this->Assign('list', $list);
    }
} // webapp
?>
